/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.util.io.lipid;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.poi.ss.util.CellRangeAddress;
import org.grits.toolbox.tools.gsl.database.IonizationType;
import org.grits.toolbox.tools.gsl.database.lipid.LipidData;
import org.grits.toolbox.tools.gsl.database.lipid.LipidDatabase;
import org.grits.toolbox.tools.gsl.database.lipid.LipidParameters;
import org.grits.toolbox.tools.gsl.structure.LipidFragmentInfo;
import org.grits.toolbox.tools.gsl.structure.lipid.Ceramide;
import org.grits.toolbox.tools.gsl.structure.lipid.ILipid;
import org.grits.toolbox.tools.gsl.structure.lipid.Lipid;
import org.grits.toolbox.tools.gsl.util.LipidGeneratorUtils;
import org.grits.toolbox.tools.gsl.util.generator.structure.LipidFragmenter;
import org.grits.toolbox.tools.gsl.util.io.excel.ExporterXLSXAbstract;
import org.grits.toolbox.tools.gsl.util.mass.CeramideChemicalComposition;
import org.grits.toolbox.tools.gsl.util.mass.ChemicalComposition;
import org.grits.toolbox.tools.gsl.util.mass.LipidChemicalComposition;

public class LipidDatabaseExporterXLSX
extends ExporterXLSXAbstract {
    private LipidDatabase m_ldOutput;
    private boolean m_bOutPH;
    private boolean m_bOutMH;
    private boolean m_bOutPNa;
    private boolean m_bOutPHMH2O;

    public LipidDatabaseExporterXLSX(LipidDatabase a_ldOutput, String a_strOutputFile) throws IOException {
        super(a_strOutputFile);
        this.m_ldOutput = a_ldOutput;
        this.m_bOutPH = true;
        this.m_bOutMH = true;
        this.m_bOutPNa = true;
        this.m_bOutPHMH2O = true;
    }

    public boolean isOutputPlusH() {
        return this.m_bOutPH;
    }

    public boolean isOutputMinusH() {
        return this.m_bOutMH;
    }

    public boolean isOutputPlusNa() {
        return this.m_bOutPNa;
    }

    public boolean isOutputPlusHMinusH2O() {
        return this.m_bOutPHMH2O;
    }

    public void setOutputPlusH(boolean a_bOutPH) {
        this.m_bOutPH = a_bOutPH;
    }

    public void setOutputMinusH(boolean a_bOutMH) {
        this.m_bOutMH = a_bOutMH;
    }

    public void setOutputPlusNa(boolean a_bOutPNa) {
        this.m_bOutPNa = a_bOutPNa;
    }

    public void setOutputPlusHMinusH2O(boolean a_bOutPHMH2O) {
        this.m_bOutPHMH2O = a_bOutPHMH2O;
    }

    @Override
    public boolean createBook() {
        if (!this.createSheetForDatabaseInformation()) {
            System.err.println("cannot create sheet for information");
            this.closeBook();
            return false;
        }
        if (!this.createSheetForDatabase(false)) {
            System.err.println("cannot create sheet for database");
            this.closeBook();
            return false;
        }
        if (!this.createSheetForDatabase(true)) {
            System.err.println("cannot create sheet for permethylated database");
            this.closeBook();
            return false;
        }
        return true;
    }

    protected boolean createSheetForDatabaseInformation() {
        throw new Error("Unresolved compilation problems: \n\tCELL_TYPE_STRING cannot be resolved or is not a field\n\tCELL_TYPE_STRING cannot be resolved or is not a field\n\tVERTICAL_TOP cannot be resolved or is not a field\n");
    }

    private void addRowsForParameters(LipidParameters a_params) {
        this.createRow(Arrays.asList("Carbon length:", a_params.getCarbonLengths()));
        if (!a_params.getNumberOfHydroxylGroups().isEmpty()) {
            this.createRow(Arrays.asList("# of Hydroxyl groups:", a_params.getNumberOfHydroxylGroups()));
        }
        if (!a_params.getNumberOfOAcetylGroups().isEmpty()) {
            this.createRow(Arrays.asList("# of O-acetyl groups:", a_params.getNumberOfOAcetylGroups()));
        }
        if (!a_params.getNumberOfDoubleBonds().isEmpty()) {
            this.createRow(Arrays.asList("# of unsaturations:", a_params.getNumberOfDoubleBonds()));
        }
        if (a_params.getIsAllowedOnlyEvenNumbers()) {
            this.createRow(Arrays.asList("Only allow even carbon length"));
        }
    }

    protected boolean createSheetForDatabase(boolean a_bPerMe) {
        this.m_sheetCurent = this.createSheet("Lipid Database" + (a_bPerMe ? " PerMe" : ""));
        this.m_nRowCurrent = 0;
        int t_nSubsts = 0;
        for (LipidData t_ld : this.m_ldOutput.getLipidData()) {
            if (t_ld.getSubstructures().isEmpty() || t_nSubsts >= t_ld.getSubstructures().size()) continue;
            t_nSubsts = t_ld.getSubstructures().size();
        }
        this.createRowForDataHeader(t_nSubsts, a_bPerMe);
        for (LipidData t_ld : this.m_ldOutput.getLipidData()) {
            if (this.createRowForDataLine(t_ld, t_nSubsts, a_bPerMe)) continue;
            return false;
        }
        this.m_sheetCurent.createFreezePane(1, 2);
        this.m_sheetCurent.setAutoFilter(new CellRangeAddress(1, 1, 0, 7 + t_nSubsts));
        if (t_nSubsts > 0) {
            this.m_sheetCurent.addMergedRegion(new CellRangeAddress(0, 0, 2, 1 + t_nSubsts));
        }
        int t_nRange = 1;
        if (this.m_bOutPH) {
            ++t_nRange;
        }
        if (this.m_bOutMH) {
            ++t_nRange;
        }
        if (this.m_bOutPNa) {
            ++t_nRange;
        }
        if (this.m_bOutPHMH2O) {
            ++t_nRange;
        }
        this.m_sheetCurent.addMergedRegion(new CellRangeAddress(0, 0, 3 + t_nSubsts, 2 + t_nSubsts + t_nRange));
        this.autoSizeAllColumn(this.m_sheetCurent);
        return true;
    }

    protected boolean createRowForDataHeader(int a_nSubsts, boolean a_bPerMe) {
        String t_strMassTitle = a_bPerMe ? "Permethylated Mass" : "Mass";
        ArrayList<String> t_listHeaders1 = new ArrayList<String>();
        Collections.addAll(t_listHeaders1, "", "", "", t_strMassTitle);
        ArrayList<String> t_listHeaders2 = new ArrayList<String>();
        Collections.addAll(t_listHeaders2, "Common Name", "Type", "Composition", "M", a_bPerMe ? "M - MeOH" : "M - H2O");
        if (this.m_bOutPH) {
            t_listHeaders1.add("");
            t_listHeaders2.add("[M + H]+");
        }
        if (this.m_bOutMH) {
            t_listHeaders1.add("");
            t_listHeaders2.add("[M - H]-");
        }
        if (this.m_bOutPNa) {
            t_listHeaders1.add("");
            t_listHeaders2.add("[M + Na]+");
        }
        if (this.m_bOutPHMH2O) {
            t_listHeaders1.add("");
            t_listHeaders2.add(a_bPerMe ? "[M + H - MeOH]+" : "[M + H - H2O]+");
        }
        int i = 0;
        while (i < a_nSubsts) {
            t_listHeaders1.add(2 + i, i == 0 ? "Substructures" : "");
            t_listHeaders2.add(2 + i, "" + (i + 1));
            ++i;
        }
        t_listHeaders1.addAll(Arrays.asList("", "Fragments"));
        t_listHeaders2.addAll(Arrays.asList("", ""));
        this.createRow(t_listHeaders1);
        this.createRow(t_listHeaders2);
        return true;
    }

    protected boolean createRowForDataLine(LipidData a_ld, int a_nSubsts, boolean a_bPerMe) {
        ArrayList<String> t_listMasses = new ArrayList<String>();
        Collections.addAll(t_listMasses, a_ld.getCommonName(), a_ld.getLipidClass().getAbbreviation());
        ILipid t_lipid = LipidGeneratorUtils.parseLipidName(a_ld.getCommonName());
        ChemicalComposition t_calcMass = t_lipid instanceof Ceramide ? new CeramideChemicalComposition((Ceramide)t_lipid) : new LipidChemicalComposition((Lipid)t_lipid);
        if (a_bPerMe) {
            t_calcMass.derivatize();
        }
        t_listMasses.add(t_calcMass.getFormula());
        t_listMasses.add(t_calcMass.getMonoisotopicMass());
        t_listMasses.add(t_calcMass.getMonoisotopicMass(IonizationType.NOIONMH2O));
        if (this.m_bOutPH) {
            t_listMasses.add(t_calcMass.getMonoisotopicMass(IonizationType.PH));
        }
        if (this.m_bOutMH) {
            t_listMasses.add(t_calcMass.getMonoisotopicMass(IonizationType.MH));
        }
        if (this.m_bOutPNa) {
            t_listMasses.add(t_calcMass.getMonoisotopicMass(IonizationType.PNA));
        }
        if (this.m_bOutPHMH2O) {
            t_listMasses.add(t_calcMass.getMonoisotopicMass(IonizationType.PHMH2O));
        }
        int i = 0;
        while (i < a_nSubsts) {
            String t_strSubst = "";
            if (i < a_ld.getSubstructures().size()) {
                t_strSubst = a_ld.getSubstructures().get(i);
            }
            t_listMasses.add(2 + i, t_strSubst);
            ++i;
        }
        LipidFragmenter t_genFrags = new LipidFragmenter();
        List<LipidFragmentInfo> t_listFrags = t_genFrags.fragment(t_lipid);
        if (t_listFrags != null && !t_listFrags.isEmpty()) {
            t_listMasses.add("");
            for (LipidFragmentInfo t_lipInfo : t_listFrags) {
                ILipid t_lip = t_lipInfo.getFragment();
                t_listMasses.add(t_lip.getName());
                t_calcMass = t_lip instanceof Ceramide ? new CeramideChemicalComposition((Ceramide)t_lip) : new LipidChemicalComposition((Lipid)t_lip);
                if (a_bPerMe) {
                    t_calcMass.derivatize();
                }
                t_listMasses.add(t_calcMass.getMonoisotopicMass(IonizationType.PH));
            }
        }
        this.createRow(t_listMasses);
        return true;
    }
}

