/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.view;

import java.util.List;
import javax.annotation.PostConstruct;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.grits.toolbox.entry.qrtpcr.IColorsConstants;
import org.grits.toolbox.entry.qrtpcr.model.ChartData;
import org.swtchart.Chart;
import org.swtchart.IAxis;
import org.swtchart.IAxisSet;
import org.swtchart.IAxisTick;
import org.swtchart.IBarSeries;
import org.swtchart.IErrorBar;
import org.swtchart.ISeries;
import org.swtchart.ext.InteractiveChart;

public class HistogramView {
    public static final String ID = "qrtPCR-histogram";
    private Chart chart;
    IBarSeries series;
    IAxis xAxis;
    String partLabel;
    IBarSeries[] allSeries;

    @PostConstruct
    public void createPartControl(Composite parent) {
        this.chart = new InteractiveChart(parent, 0);
    }

    @Focus
    public void setFocus() {
        this.chart.setFocus();
    }

    public String getPartName() {
        return this.partLabel;
    }

    public void setPartName(String partName) {
        this.partLabel = partName;
    }

    public void initializeChart(List<ChartData> dataList) {
        this.chart.getTitle().setText("");
        this.chart.getAxisSet().getXAxis(0).getTitle().setText("Genes");
        this.chart.getAxisSet().getYAxis(0).getTitle().setText("Average");
        IAxisSet axisSet = this.chart.getAxisSet();
        this.xAxis = axisSet.getXAxis(0);
        this.xAxis.enableCategory(true);
        IAxisTick xTick = axisSet.getXAxis(0).getTick();
        xTick.setTickLabelAngle(90);
        this.series = (IBarSeries)this.chart.getSeriesSet().createSeries(ISeries.SeriesType.BAR, this.getPartName());
        this.series.setBarColor(Display.getCurrent().getSystemColor(9));
        this.setInput(dataList);
        ChartData[][] newDataList = new ChartData[1][dataList.size()];
        int i = 0;
        for (ChartData data : dataList) {
            newDataList[0][i++] = data;
        }
        this.addMouseOver(newDataList);
    }

    public void initializeChart(String[] aliasList, ChartData[][] dataList, String yAxisTitle, boolean showErrorBar) {
        ISeries[] existing = this.chart.getSeriesSet().getSeries();
        if (existing != null) {
            ISeries[] iSeriesArray = existing;
            int n = existing.length;
            int n2 = 0;
            while (n2 < n) {
                ISeries iSeries = iSeriesArray[n2];
                this.chart.getSeriesSet().deleteSeries(iSeries.getId());
                ++n2;
            }
        }
        this.chart.getTitle().setText("");
        this.chart.getAxisSet().getXAxis(0).getTitle().setText("Genes");
        this.chart.getAxisSet().getYAxis(0).getTitle().setText(yAxisTitle);
        IAxisSet axisSet = this.chart.getAxisSet();
        this.xAxis = axisSet.getXAxis(0);
        this.xAxis.enableCategory(true);
        IAxisTick xTick = axisSet.getXAxis(0).getTick();
        xTick.setTickLabelAngle(90);
        this.allSeries = new IBarSeries[aliasList.length];
        int i = 0;
        while (i < aliasList.length) {
            IBarSeries series = (IBarSeries)this.chart.getSeriesSet().createSeries(ISeries.SeriesType.BAR, aliasList[i]);
            if (i < IColorsConstants.COLORS.length) {
                series.setBarColor(new Color((Device)Display.getCurrent(), IColorsConstants.COLORS[i]));
            } else {
                series.setBarColor(Display.getCurrent().getSystemColor(2));
            }
            this.allSeries[i] = series;
            ++i;
        }
        this.setInput(dataList, showErrorBar);
        this.addMouseOver(dataList);
    }

    private void setInput(List<ChartData> dataList) {
        String[] xAxisValues = new String[dataList.size()];
        int i = 0;
        if (dataList != null) {
            for (ChartData data : dataList) {
                xAxisValues[i++] = data.getGeneSymbol() != null ? data.getGeneSymbol() : data.getGeneIdentifier();
            }
        }
        this.xAxis.setCategorySeries(xAxisValues);
        double[] yAxisValues = new double[dataList.size()];
        i = 0;
        if (dataList != null) {
            for (ChartData data : dataList) {
                if (data == null) continue;
                yAxisValues[i++] = data.getValue();
            }
        }
        this.series.setYSeries(yAxisValues);
        IAxis yAxis = this.chart.getAxisSet().getYAxis(0);
        yAxis.enableLogScale(true);
        IErrorBar yErrorBar = this.series.getYErrorBar();
        yErrorBar.setType(IErrorBar.ErrorBarType.PLUS);
        double[] errorValues = new double[dataList.size()];
        i = 0;
        if (dataList != null) {
            for (ChartData data : dataList) {
                if (data == null) continue;
                errorValues[i++] = data.getError();
            }
        }
        yErrorBar.setPlusErrors(errorValues);
        yErrorBar.setVisible(true);
        yErrorBar.setLineWidth(2);
        this.chart.getAxisSet().adjustRange();
        this.chart.redraw();
    }

    private void setInput(ChartData[][] dataList, boolean showErrorBar) {
        int i = 0;
        String[] xAxisValues = new String[dataList.length];
        ChartData[][] chartDataArray = dataList;
        int n = dataList.length;
        int n2 = 0;
        while (n2 < n) {
            ChartData[] chartDataList = chartDataArray[n2];
            if (chartDataList[0] != null && chartDataList[0].getGeneSymbol() != null) {
                xAxisValues[i++] = chartDataList[0].getGeneSymbol();
            } else if (chartDataList[0] != null) {
                xAxisValues[i++] = chartDataList[0].getGeneIdentifier();
            }
            ++n2;
        }
        this.xAxis.setCategorySeries(xAxisValues);
        IAxis yAxis = this.chart.getAxisSet().getYAxis(0);
        yAxis.enableLogScale(true);
        double[][] yAxisValues = new double[dataList[0].length][dataList.length];
        double[][] errorValues = new double[dataList[0].length][dataList.length];
        i = 0;
        ChartData[][] chartDataArray2 = dataList;
        int n3 = dataList.length;
        int n4 = 0;
        while (n4 < n3) {
            ChartData[] chartDataList = chartDataArray2[n4];
            if (chartDataList != null) {
                int j = 0;
                ChartData[] chartDataArray3 = chartDataList;
                int n5 = chartDataList.length;
                int n6 = 0;
                while (n6 < n5) {
                    ChartData data = chartDataArray3[n6];
                    if (data != null) {
                        yAxisValues[j][i] = data.getValue();
                        errorValues[j][i] = data.getError();
                        ++j;
                    }
                    ++n6;
                }
                ++i;
            }
            ++n4;
        }
        int j = 0;
        while (j < this.allSeries.length) {
            this.allSeries[j].setYSeries(yAxisValues[j]);
            if (showErrorBar) {
                IErrorBar yErrorBar = this.allSeries[j].getYErrorBar();
                yErrorBar.setType(IErrorBar.ErrorBarType.PLUS);
                yErrorBar.setPlusErrors(errorValues[j]);
                yErrorBar.setVisible(true);
                yErrorBar.setLineWidth(2);
            }
            ++j;
        }
        this.chart.getAxisSet().adjustRange();
        this.chart.redraw();
    }

    public void addMouseOver(ChartData[][] dataList) {
        Composite plotArea = this.chart.getPlotArea();
        plotArea.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                ISeries[] iSeriesArray = HistogramView.this.chart.getSeriesSet().getSeries();
                int n = iSeriesArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ISeries series = iSeriesArray[n2];
                    Rectangle[] rs = ((IBarSeries)series).getBounds();
                    int i = 0;
                    while (i < rs.length) {
                        if (rs[i] != null && rs[i].x < e.x && e.x < rs[i].x + rs[i].width && rs[i].y < e.y && e.y < rs[i].y + rs[i].height) {
                            double xValue = HistogramView.this.xAxis.getDataCoordinate(rs[i].x);
                            this.setToolTipText(series, i, xValue);
                            return;
                        }
                        ++i;
                    }
                    ++n2;
                }
                HistogramView.this.chart.getPlotArea().setToolTipText(null);
            }

            private void setToolTipText(ISeries series, int index, double xValue) {
                HistogramView.this.chart.getPlotArea().setToolTipText("Series: " + series.getId() + "\nValue: " + series.getYSeries()[index]);
            }
        });
    }
}

