/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.manager.pages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.grits.toolbox.entry.qrtpcr.model.Gene;

public class GeneSelectionListContentProvider
implements IStructuredContentProvider {
    List<Gene> genes;

    public GeneSelectionListContentProvider(List<Gene> elements) {
        this.genes = elements;
    }

    public Object[] getElements(Object inputElement) {
        return this.genes.toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public boolean canMoveDown(List<?> selectedElements) {
        int nSelected = selectedElements.size();
        int index = this.genes.size() - 1;
        while (index >= 0 && nSelected > 0) {
            if (!selectedElements.contains(this.genes.get(index))) {
                return true;
            }
            --nSelected;
            --index;
        }
        return false;
    }

    public boolean canMoveUp(List<?> selected) {
        int nSelected = selected.size();
        int index = 0;
        while (index < this.genes.size() && nSelected > 0) {
            if (!selected.contains(this.genes.get(index))) {
                return true;
            }
            --nSelected;
            ++index;
        }
        return false;
    }

    private List<Gene> moveUp(List<Gene> elements, List<?> move) {
        ArrayList<Gene> result = new ArrayList<Gene>(elements.size());
        Gene floating = null;
        int index = 0;
        while (index < elements.size()) {
            Gene current = elements.get(index);
            if (move.contains(current)) {
                result.add(current);
            } else {
                if (floating != null) {
                    result.add(floating);
                }
                floating = current;
            }
            ++index;
        }
        if (floating != null) {
            result.add(floating);
        }
        return result;
    }

    private List<Gene> reverse(List<Gene> list) {
        ArrayList<Gene> reverse = new ArrayList<Gene>(list.size());
        int index = list.size() - 1;
        while (index >= 0) {
            reverse.add(list.get(index));
            --index;
        }
        return reverse;
    }

    public void setElements(List<Gene> elements, TableViewer table) {
        this.genes = new ArrayList<Gene>(elements);
        if (table != null) {
            table.refresh();
        }
    }

    public void up(List<?> checked, TableViewer table) {
        if (checked.size() > 0) {
            this.setElements(this.moveUp(this.genes, checked), table);
            table.reveal(checked.get(0));
        }
        table.setSelection((ISelection)new StructuredSelection(checked));
    }

    public void down(List<?> checked, TableViewer table) {
        if (checked.size() > 0) {
            this.setElements(this.reverse(this.moveUp(this.reverse(this.genes), checked)), table);
            table.reveal(checked.get(checked.size() - 1));
        }
        table.setSelection((ISelection)new StructuredSelection(checked));
    }

    public List<Gene> getGenes() {
        return this.genes;
    }
}

