/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.manager.pages;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.entry.qrtpcr.ImageRegistry;
import org.grits.toolbox.entry.qrtpcr.editor.IQrtPCRPart;
import org.grits.toolbox.entry.qrtpcr.manager.GeneListManagerEditor;
import org.grits.toolbox.entry.qrtpcr.manager.actions.SaveGeneListDialog;
import org.grits.toolbox.entry.qrtpcr.manager.pages.MasterGeneListPage;
import org.grits.toolbox.entry.qrtpcr.manager.pages.TextEditingSupport;
import org.grits.toolbox.entry.qrtpcr.model.Gene;
import org.grits.toolbox.entry.qrtpcr.model.GeneList;
import org.grits.toolbox.entry.qrtpcr.util.FileUtils;

public class GeneListOverviewPage
implements IQrtPCRPart {
    private static final Logger logger = Logger.getLogger(GeneListOverviewPage.class);
    private List<GeneList> masterLists;
    private List<GeneList> masterSubLists;
    private TableViewer masterTableViewer;
    private TableViewer subListTableViewer;
    private CTabItem cTabItem;

    @Inject
    public GeneListOverviewPage(@Named(value="masterList") List<GeneList> masterLists, @Named(value="masterSubList") List<GeneList> masterSubLists, CTabItem cTabItem) {
        this.cTabItem = cTabItem;
        this.masterLists = masterLists;
        this.masterSubLists = masterSubLists;
    }

    @PostConstruct
    public void postConstruct(MPart part) {
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this.cTabItem.getParent(), 768);
        new GridData();
        scrolledComposite.setLayout((Layout)new GridLayout());
        Composite parent = new Composite((Composite)scrolledComposite, 4);
        parent.setLayout((Layout)new GridLayout(1, false));
        Action downloadAction = new Action("Download file"){

            public String getToolTipText() {
                return "Download the selected master gene list file";
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageRegistry.getImageDescriptor(ImageRegistry.QrtPCRImage.DOWNLOAD_ICON);
            }

            public void run() {
                TableItem[] items = GeneListOverviewPage.this.masterTableViewer.getTable().getSelection();
                if (items.length > 0) {
                    TableItem selected = items[0];
                    String filename = selected.getText(2);
                    GeneListOverviewPage.this.downloadAction(Display.getCurrent().getActiveShell(), filename, false);
                } else {
                    MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"No selection", (String)"Please select a master list to download");
                }
            }
        };
        Action addAction = new Action("Add"){

            public String getToolTipText() {
                return "Create a new (empty) master gene list";
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageRegistry.getImageDescriptor(ImageRegistry.QrtPCRImage.ADD_ICON);
            }

            public void run() {
                SaveGeneListDialog dialog = new SaveGeneListDialog(Display.getCurrent().getActiveShell(), GeneListOverviewPage.this.masterLists);
                dialog.create();
                dialog.getShell().setSize(550, 300);
                if (dialog.open() == 0) {
                    GeneList newGeneList = new GeneList();
                    newGeneList.setListName(dialog.getName());
                    newGeneList.setDescription(dialog.getDescription());
                    newGeneList.setOrganism(dialog.getOrganism());
                    newGeneList.setDateCreated(new Date());
                    newGeneList.setGenes(new ArrayList<Gene>());
                    try {
                        String filename = FileUtils.saveMasterGeneListFile(newGeneList);
                        newGeneList.setFilename(filename);
                    }
                    catch (IOException | JAXBException e) {
                        logger.error((Object)"Error saving the new master list to a file", e);
                        ErrorUtils.createErrorMessageBox((Shell)Display.getCurrent().getActiveShell(), (String)("Error saving the new master list to a file. Reason: " + e.getMessage()));
                    }
                    GeneListOverviewPage.this.masterLists.add(newGeneList);
                    GeneListOverviewPage.this.masterTableViewer.refresh();
                }
            }
        };
        Action deleteAction = new Action("Delete"){

            public ImageDescriptor getImageDescriptor() {
                return ImageRegistry.getImageDescriptor(ImageRegistry.QrtPCRImage.DELETE_ICON);
            }

            public void run() {
                if (GeneListOverviewPage.this.masterTableViewer != null) {
                    TableItem[] selections = GeneListOverviewPage.this.masterTableViewer.getTable().getSelection();
                    if (selections.length == 0) {
                        return;
                    }
                    boolean delete = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"Confirm Delete", (String)("Are you sure you want to delete " + selections.length + " gene list"));
                    if (!delete) {
                        return;
                    }
                    TableItem[] tableItemArray = selections;
                    int n = selections.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem tableItem = tableItemArray[n2];
                        Object selection = tableItem.getData();
                        if (selection instanceof GeneList) {
                            try {
                                FileUtils.deleteFile(((GeneList)selection).getFilename(), false);
                            }
                            catch (IOException e) {
                                logger.error((Object)"Could not delete master list", (Throwable)e);
                                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)("Could not delete the file. Reason: " + e.getMessage()));
                                return;
                            }
                            ((List)GeneListOverviewPage.this.masterTableViewer.getInput()).remove((GeneList)selection);
                        }
                        ++n2;
                    }
                    GeneListOverviewPage.this.masterTableViewer.refresh();
                }
            }

            public String getToolTipText() {
                return "Delete selected items from the list";
            }
        };
        Action importAction = new Action("Import"){

            public String getToolTipText() {
                return "Import a gene list file";
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageRegistry.getImageDescriptor(ImageRegistry.QrtPCRImage.IMPORT_ICON);
            }

            public void run() {
                FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
                dialog.setFilterExtensions(new String[]{"*.xml"});
                String filename = dialog.open();
                if (filename != null) {
                    try {
                        GeneList newGeneList = FileUtils.importAndLoadGeneListFile(filename, false);
                        GeneListOverviewPage.this.masterLists.add(newGeneList);
                        GeneListOverviewPage.this.masterTableViewer.refresh();
                    }
                    catch (JAXBException e) {
                        logger.error((Object)"Error loading the new gene list from the given file. The file is not in valid format", (Throwable)e);
                        ErrorUtils.createErrorMessageBox((Shell)Display.getCurrent().getActiveShell(), (String)("Error loading the new gene list from the given file. Reason: " + e.getMessage()));
                    }
                    catch (IOException e) {
                        logger.error((Object)"Error loading the new gene list from the given file.", (Throwable)e);
                        ErrorUtils.createErrorMessageBox((Shell)Display.getCurrent().getActiveShell(), (String)("Error loading the new gene list from the given file. Reason: " + e.getMessage()));
                    }
                }
            }
        };
        this.masterTableViewer = this.createTable(part, parent, this.masterLists, "Master Gene Lists", new Action[]{importAction, downloadAction, addAction, deleteAction}, false);
        Action downloadAction2 = new Action("Download file"){

            public String getToolTipText() {
                return "Download the selected sub-list file";
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageRegistry.getImageDescriptor(ImageRegistry.QrtPCRImage.DOWNLOAD_ICON);
            }

            public void run() {
                TableItem[] items = GeneListOverviewPage.this.subListTableViewer.getTable().getSelection();
                if (items.length > 0) {
                    TableItem selected = items[0];
                    String filename = selected.getText(2);
                    GeneListOverviewPage.this.downloadAction(Display.getCurrent().getActiveShell(), filename, true);
                } else {
                    MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"No selection", (String)"Please select a sublist to download");
                }
            }
        };
        Action deleteAction2 = new Action("Delete"){

            public ImageDescriptor getImageDescriptor() {
                return ImageRegistry.getImageDescriptor(ImageRegistry.QrtPCRImage.DELETE_ICON);
            }

            public void run() {
                if (GeneListOverviewPage.this.subListTableViewer != null) {
                    TableItem[] selections = GeneListOverviewPage.this.subListTableViewer.getTable().getSelection();
                    if (selections.length == 0) {
                        return;
                    }
                    boolean delete = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"Confirm Delete", (String)("Are you sure you want to delete " + selections.length + " gene list"));
                    if (!delete) {
                        return;
                    }
                    TableItem[] tableItemArray = selections;
                    int n = selections.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem tableItem = tableItemArray[n2];
                        Object selection = tableItem.getData();
                        if (selection instanceof GeneList) {
                            try {
                                FileUtils.deleteFile(((GeneList)selection).getFilename(), true);
                            }
                            catch (IOException e) {
                                logger.error((Object)"Could not delete sub-list", (Throwable)e);
                                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)("Could not delete the file. Reason: " + e.getMessage()));
                                return;
                            }
                            ((List)GeneListOverviewPage.this.subListTableViewer.getInput()).remove((GeneList)selection);
                        }
                        ++n2;
                    }
                    GeneListOverviewPage.this.subListTableViewer.refresh();
                }
            }

            public String getToolTipText() {
                return "Delete selected items from the list";
            }
        };
        Action importAction2 = new Action("Import"){

            public String getToolTipText() {
                return "Import a gene list file";
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageRegistry.getImageDescriptor(ImageRegistry.QrtPCRImage.IMPORT_ICON);
            }

            public void run() {
                FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
                dialog.setFilterExtensions(new String[]{"*.xml"});
                String filename = dialog.open();
                if (filename != null) {
                    try {
                        GeneList newGeneList = FileUtils.importAndLoadGeneListFile(filename, true);
                        GeneListOverviewPage.this.masterSubLists.add(newGeneList);
                        GeneListOverviewPage.this.subListTableViewer.refresh();
                    }
                    catch (JAXBException e) {
                        logger.error((Object)"Error loading the new gene list from the given file. The file is not in valid format", (Throwable)e);
                        ErrorUtils.createErrorMessageBox((Shell)Display.getCurrent().getActiveShell(), (String)("Error loading the new gene list from the given file. Reason: " + e.getMessage()));
                    }
                    catch (IOException e) {
                        logger.error((Object)"Error loading the new gene list from the given file.", (Throwable)e);
                        ErrorUtils.createErrorMessageBox((Shell)Display.getCurrent().getActiveShell(), (String)("Error loading the new gene list from the given file. Reason: " + e.getMessage()));
                    }
                }
            }
        };
        this.subListTableViewer = this.createTable(part, parent, this.masterSubLists, "Sub-Lists", new Action[]{importAction2, downloadAction2, deleteAction2}, true);
        scrolledComposite.setContent((Control)parent);
        scrolledComposite.setMinSize(parent.computeSize(-1, -1));
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        this.cTabItem.setControl((Control)scrolledComposite);
    }

    private TableViewer createTable(final MPart part, Composite parent, List<GeneList> geneList, String title, Action[] actions, final boolean sublist) {
        Composite sectionParentComposite = new Composite(parent, 4);
        sectionParentComposite.setLayout((Layout)new TableWrapLayout());
        Section section = new Section(sectionParentComposite, 320);
        section.setText(title);
        Composite client = new Composite((Composite)section, 64);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        client.setLayout((Layout)layout);
        final TableViewer tableViewer2 = new TableViewer(client, 67584);
        ToolBarManager toolBarManager = new ToolBarManager();
        Action[] actionArray = actions;
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            Action action = actionArray[n2];
            toolBarManager.add((IAction)action);
            ++n2;
        }
        Action openSelectedAction = new Action("Show selected"){

            public String getToolTipText() {
                return "Open selected list";
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageRegistry.getImageDescriptor(ImageRegistry.QrtPCRImage.SHOW_SELECTED_ICON);
            }

            public void run() {
                GeneListOverviewPage.this.openSelectedList(part, tableViewer2, sublist);
            }
        };
        toolBarManager.add((IAction)openSelectedAction);
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        section.setTextClient((Control)toolbar);
        Table table = tableViewer2.getTable();
        GridData gd_table_2 = new GridData(4, 4, true, true, 1, 1);
        gd_table_2.heightHint = 300;
        table.setLayoutData((Object)gd_table_2);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableWrapData sectionLayoutData = new TableWrapData(128, 64);
        sectionLayoutData.grabHorizontal = true;
        sectionLayoutData.grabVertical = true;
        section.setLayoutData((Object)sectionLayoutData);
        section.setClient((Control)client);
        GridData compositeLayoutData = new GridData(1808);
        compositeLayoutData.verticalSpan = 1;
        compositeLayoutData.horizontalSpan = 2;
        sectionParentComposite.setLayoutData((Object)compositeLayoutData);
        TableViewerColumn listNameColumn = new TableViewerColumn(tableViewer2, 0);
        TableColumn listName = listNameColumn.getColumn();
        listName.setWidth(100);
        listName.setText("Name");
        listNameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof GeneList) {
                    return ((GeneList)element).getListName();
                }
                return null;
            }
        });
        listNameColumn.setEditingSupport((EditingSupport)new TextEditingSupport(part, tableViewer2, listName));
        TableViewerColumn descriptionColumn = new TableViewerColumn(tableViewer2, 0);
        TableColumn listDescription = descriptionColumn.getColumn();
        listDescription.setWidth(300);
        listDescription.setText("Description");
        descriptionColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof GeneList) {
                    return ((GeneList)element).getDescription();
                }
                return null;
            }
        });
        descriptionColumn.setEditingSupport((EditingSupport)new TextEditingSupport(part, tableViewer2, listDescription));
        TableViewerColumn fileNameColumn = new TableViewerColumn(tableViewer2, 0);
        TableColumn listFileName = fileNameColumn.getColumn();
        listFileName.setWidth(150);
        listFileName.setText("File Name");
        fileNameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof GeneList) {
                    return ((GeneList)element).getFilename();
                }
                return null;
            }
        });
        TableViewerColumn dateCreatedColumn = new TableViewerColumn(tableViewer2, 0);
        TableColumn dateCreated = dateCreatedColumn.getColumn();
        dateCreated.setWidth(80);
        dateCreated.setText("Date Created");
        dateCreatedColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof GeneList && ((GeneList)element).getDateCreated() != null) {
                    return ((GeneList)element).getDateCreated().toString();
                }
                return null;
            }
        });
        tableViewer2.setContentProvider((IContentProvider)new ArrayContentProvider());
        tableViewer2.setInput(geneList);
        table.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                GeneListOverviewPage.this.openSelectedList(part, tableViewer2, sublist);
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        return tableViewer2;
    }

    private void openSelectedList(MPart part, TableViewer tableViewer2, boolean sublist) {
        GeneListManagerEditor editor = (GeneListManagerEditor)part.getObject();
        TableItem[] tableItemArray = tableViewer2.getTable().getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            String listName = item.getText(0);
            CTabFolder cTabFolder = (CTabFolder)part.getContext().get(CTabFolder.class);
            if (sublist) {
                MasterGeneListPage masterPageTab;
                CTabItem cTabItem;
                GeneList masterList = this.getMasterGeneList(((GeneList)item.getData()).getParentListId());
                if (masterList != null) {
                    cTabItem = new CTabItem(cTabFolder, 0);
                    cTabItem.setText("GeneList-" + listName);
                    cTabItem.setShowClose(true);
                    part.getContext().set(CTabItem.class, (Object)cTabItem);
                    part.getContext().set("geneList", (Object)masterList);
                    part.getContext().set("geneSubList", (Object)((GeneList)item.getData()));
                    masterPageTab = (MasterGeneListPage)ContextInjectionFactory.make(MasterGeneListPage.class, (IEclipseContext)part.getContext());
                    editor.getcTabItemToPartTabMap().put(cTabItem, masterPageTab);
                } else {
                    cTabItem = new CTabItem(cTabFolder, 0);
                    cTabItem.setText("GeneList-" + listName);
                    cTabItem.setShowClose(true);
                    part.getContext().set(CTabItem.class, (Object)cTabItem);
                    part.getContext().set("geneList", (Object)((GeneList)item.getData()));
                    part.getContext().set("geneSubList", null);
                    masterPageTab = (MasterGeneListPage)ContextInjectionFactory.make(MasterGeneListPage.class, (IEclipseContext)part.getContext());
                    editor.getcTabItemToPartTabMap().put(cTabItem, masterPageTab);
                }
            } else {
                CTabItem cTabItem = new CTabItem(cTabFolder, 0);
                cTabItem.setText("GeneList-" + listName);
                cTabItem.setShowClose(true);
                part.getContext().set(CTabItem.class, (Object)cTabItem);
                part.getContext().set("geneList", (Object)((GeneList)item.getData()));
                part.getContext().set("geneSubList", null);
                MasterGeneListPage masterPageTab = (MasterGeneListPage)ContextInjectionFactory.make(MasterGeneListPage.class, (IEclipseContext)part.getContext());
                editor.getcTabItemToPartTabMap().put(cTabItem, masterPageTab);
            }
            cTabFolder.setSelection(cTabFolder.getItemCount() - 1);
            ++n2;
        }
    }

    private void downloadAction(Shell shell, String filename, boolean sublist) {
        FileDialog fd = new FileDialog(shell, 8192);
        fd.setText("Download");
        fd.setFileName(filename);
        fd.setOverwrite(true);
        String selected = fd.open();
        try {
            if (selected != null && selected.trim().length() != 0) {
                FileUtils.downloadFile(filename, selected, sublist);
            }
        }
        catch (IOException e1) {
            logger.error((Object)"Could not download file", (Throwable)e1);
            MessageDialog.openError((Shell)shell, (String)"File Download Error", (String)"Could not download the file. It has been removed from the configuration directory");
        }
    }

    public void addSubList(GeneList newSublist) {
        this.masterSubLists.add(newSublist);
        this.subListTableViewer.refresh();
    }

    GeneList getMasterGeneList(String listName) {
        for (GeneList list : this.masterLists) {
            if (!list.getListName().equals(listName)) continue;
            return list;
        }
        return null;
    }
}

