/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.manager.actions;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.grits.toolbox.entry.qrtpcr.model.Gene;
import org.grits.toolbox.entry.qrtpcr.ncbi.NCBIGeneUtil;

public class AddGeneDialog
extends FormDialog {
    private static Logger logger = Logger.getLogger(AddGeneDialog.class);
    private Text geneIdentifier;
    private Text geneSymbol;
    private Text description;
    private Text group;
    private Text fwPrimer;
    private Text revPrimer;
    private Text refSeq;
    private Gene gene = new Gene();
    private Text secondaryRefSeq;
    private Text location;
    private Text aliases;
    private Text fullName;
    private Text geneId;
    private String organism;
    private List<Gene> geneList;

    public AddGeneDialog(Shell shell, List<Gene> input, String organism) {
        super(shell);
        this.geneList = input;
        this.organism = organism;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    protected void createFormContent(IManagedForm mform) {
        super.createFormContent(mform);
        mform.getForm().getBody().setLayout((Layout)new GridLayout(3, false));
        mform.getForm().setText("Enter Gene Information");
        final NCBIGeneUtil util = new NCBIGeneUtil();
        Label lblGeneIdentifier = new Label(mform.getForm().getBody(), 0);
        lblGeneIdentifier.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        mform.getToolkit().adapt((Control)lblGeneIdentifier, true, true);
        lblGeneIdentifier.setText("Identifier");
        this.geneIdentifier = new Text(mform.getForm().getBody(), 2048);
        this.geneIdentifier.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        mform.getToolkit().adapt((Control)this.geneIdentifier, true, true);
        this.geneIdentifier.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddGeneDialog.this.gene.setGeneIdentifier(AddGeneDialog.this.geneIdentifier.getText());
                if (AddGeneDialog.this.geneIdentifier.getText().trim().length() > 0) {
                    AddGeneDialog.this.getButton(0).setEnabled(true);
                } else {
                    AddGeneDialog.this.getButton(0).setEnabled(false);
                }
            }
        });
        new Label(mform.getForm().getBody(), 0);
        Label lblGeneSymbol = new Label(mform.getForm().getBody(), 0);
        lblGeneSymbol.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        mform.getToolkit().adapt((Control)lblGeneSymbol, true, true);
        lblGeneSymbol.setText("Gene Symbol");
        this.geneSymbol = new Text(mform.getForm().getBody(), 2048);
        this.geneSymbol.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        mform.getToolkit().adapt((Control)this.geneSymbol, true, true);
        this.geneSymbol.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddGeneDialog.this.gene.setGeneSymbol(AddGeneDialog.this.geneSymbol.getText());
            }
        });
        Button btnSearchNcbi = new Button(mform.getForm().getBody(), 0);
        mform.getToolkit().adapt((Control)btnSearchNcbi, true, true);
        btnSearchNcbi.setText("Search NCBI");
        btnSearchNcbi.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String symbol = AddGeneDialog.this.geneSymbol.getText();
                if (symbol != null && symbol.length() > 0) {
                    try {
                        Integer id = util.getGeneIdFromNCBI(symbol, AddGeneDialog.this.organism);
                        if (id == null) {
                            MessageDialog.openInformation((Shell)AddGeneDialog.this.getParentShell(), (String)"Not Found", (String)"Cannot find the information at NCBI gene database");
                        } else {
                            ArrayList<Integer> geneIdList = new ArrayList<Integer>();
                            geneIdList.add(id);
                            AddGeneDialog.this.gene.setGeneIds(geneIdList);
                            AddGeneDialog.this.geneId.setText(AddGeneDialog.this.gene.getGeneIdString());
                            Gene newGene = util.getDetailsFromNCBI(id);
                            if (newGene != null) {
                                AddGeneDialog.this.gene.setFullName(newGene.getFullName());
                                AddGeneDialog.this.fullName.setText(AddGeneDialog.this.gene.getFullName());
                                AddGeneDialog.this.gene.setLocations(newGene.getLocations());
                                AddGeneDialog.this.location.setText(AddGeneDialog.this.gene.getLocationString());
                                AddGeneDialog.this.gene.setAliases(newGene.getAliases());
                                AddGeneDialog.this.aliases.setText(AddGeneDialog.this.gene.getAliasString());
                                AddGeneDialog.this.gene.setRefSeq(newGene.getRefSeq());
                                AddGeneDialog.this.refSeq.setText(AddGeneDialog.this.gene.getRefSeqString());
                                AddGeneDialog.this.gene.setSecondaryRefSeq(newGene.getSecondaryRefSeq());
                                AddGeneDialog.this.secondaryRefSeq.setText(AddGeneDialog.this.gene.getSecondaryRefSeqString());
                            } else {
                                MessageDialog.openInformation((Shell)AddGeneDialog.this.getParentShell(), (String)"Not Found", (String)"Details cannot be retrieved from NCBI gene database");
                            }
                        }
                    }
                    catch (MalformedURLException e1) {
                        logger.error((Object)"NCBI gene search url is wrong.", (Throwable)e1);
                        MessageDialog.openError((Shell)AddGeneDialog.this.getParentShell(), (String)"Error", (String)"NCBI gene search URL is wrong. Please inform the developers!");
                    }
                    catch (Exception e1) {
                        logger.error((Object)"NCBI gene search failed", (Throwable)e1);
                        MessageDialog.openError((Shell)AddGeneDialog.this.getParentShell(), (String)"Error", (String)"NCBI gene search URL failed.");
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label lblGeneId = new Label(mform.getForm().getBody(), 0);
        lblGeneId.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        mform.getToolkit().adapt((Control)lblGeneId, true, true);
        lblGeneId.setText("Gene Id");
        this.geneId = new Text(mform.getForm().getBody(), 2048);
        this.geneId.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        mform.getToolkit().adapt((Control)this.geneId, true, true);
        this.geneId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddGeneDialog.this.gene.setGeneIds(AddGeneDialog.this.geneId.getText());
            }
        });
        Button btnSearchNcbi_1 = new Button(mform.getForm().getBody(), 0);
        mform.getToolkit().adapt((Control)btnSearchNcbi_1, true, true);
        btnSearchNcbi_1.setText("Search NCBI");
        btnSearchNcbi_1.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String id = AddGeneDialog.this.geneId.getText();
                if (id != null && id.length() > 0) {
                    try {
                        Integer idInt = Integer.parseInt(id);
                        Gene newGene = util.getDetailsFromNCBI(idInt);
                        if (newGene != null) {
                            AddGeneDialog.this.gene.setGeneSymbol(newGene.getGeneSymbol());
                            AddGeneDialog.this.geneSymbol.setText(AddGeneDialog.this.gene.getGeneSymbol());
                            AddGeneDialog.this.gene.setFullName(newGene.getFullName());
                            AddGeneDialog.this.fullName.setText(AddGeneDialog.this.gene.getFullName());
                            AddGeneDialog.this.gene.setLocations(newGene.getLocations());
                            AddGeneDialog.this.location.setText(AddGeneDialog.this.gene.getLocationString());
                            AddGeneDialog.this.gene.setAliases(newGene.getAliases());
                            AddGeneDialog.this.aliases.setText(AddGeneDialog.this.gene.getAliasString());
                            AddGeneDialog.this.gene.setRefSeq(newGene.getRefSeq());
                            AddGeneDialog.this.refSeq.setText(AddGeneDialog.this.gene.getRefSeqString());
                            AddGeneDialog.this.gene.setSecondaryRefSeq(newGene.getSecondaryRefSeq());
                            AddGeneDialog.this.secondaryRefSeq.setText(AddGeneDialog.this.gene.getSecondaryRefSeqString());
                        } else {
                            MessageDialog.openInformation((Shell)AddGeneDialog.this.getParentShell(), (String)"Not Found", (String)"Details cannot be retrieved from NCBI gene database");
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        MessageDialog.openError((Shell)AddGeneDialog.this.getParentShell(), (String)"Error", (String)"Gene Id should be an integer!");
                    }
                    catch (MalformedURLException e1) {
                        logger.error((Object)"NCBI gene search url is wrong.", (Throwable)e1);
                        MessageDialog.openError((Shell)AddGeneDialog.this.getParentShell(), (String)"Error", (String)"NCBI gene search URL is wrong. Please inform the developers!");
                    }
                    catch (Exception e1) {
                        logger.error((Object)"NCBI gene search failed", (Throwable)e1);
                        MessageDialog.openError((Shell)AddGeneDialog.this.getParentShell(), (String)"Error", (String)"NCBI gene search URL failed.");
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label lblFullName = new Label(mform.getForm().getBody(), 0);
        lblFullName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        mform.getToolkit().adapt((Control)lblFullName, true, true);
        lblFullName.setText("Full Name");
        this.fullName = new Text(mform.getForm().getBody(), 2048);
        this.fullName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        mform.getToolkit().adapt((Control)this.fullName, true, true);
        new Label(mform.getForm().getBody(), 0);
        this.fullName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddGeneDialog.this.gene.setFullName(AddGeneDialog.this.fullName.getText());
            }
        });
        Label lblAliases = new Label(mform.getForm().getBody(), 0);
        lblAliases.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        mform.getToolkit().adapt((Control)lblAliases, true, true);
        lblAliases.setText("Aliases");
        this.aliases = new Text(mform.getForm().getBody(), 2048);
        this.aliases.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        mform.getToolkit().adapt((Control)this.aliases, true, true);
        new Label(mform.getForm().getBody(), 0);
        this.aliases.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String aliasText = AddGeneDialog.this.aliases.getText();
                if (aliasText != null && aliasText.trim().length() > 0) {
                    AddGeneDialog.this.gene.setAliasString(aliasText);
                }
            }
        });
        Label lblGenomicLocation = new Label(mform.getForm().getBody(), 0);
        lblGenomicLocation.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        mform.getToolkit().adapt((Control)lblGenomicLocation, true, true);
        lblGenomicLocation.setText("Genomic Location");
        this.location = new Text(mform.getForm().getBody(), 2048);
        this.location.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        mform.getToolkit().adapt((Control)this.location, true, true);
        new Label(mform.getForm().getBody(), 0);
        this.location.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String locationText = AddGeneDialog.this.location.getText();
                if (locationText != null && locationText.trim().length() > 0) {
                    AddGeneDialog.this.gene.setLocationString(locationText);
                }
            }
        });
        Label lblDescription = new Label(mform.getForm().getBody(), 0);
        lblDescription.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        mform.getToolkit().adapt((Control)lblDescription, true, true);
        lblDescription.setText("Description");
        this.description = new Text(mform.getForm().getBody(), 2050);
        GridData gd_description = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_description.heightHint = 57;
        this.description.setLayoutData((Object)gd_description);
        mform.getToolkit().adapt((Control)this.description, true, true);
        this.description.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddGeneDialog.this.gene.setDescription(AddGeneDialog.this.description.getText());
            }
        });
        new Label(mform.getForm().getBody(), 0);
        Label lblGroup = new Label(mform.getForm().getBody(), 0);
        lblGroup.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        mform.getToolkit().adapt((Control)lblGroup, true, true);
        lblGroup.setText("Group");
        this.group = new Text(mform.getForm().getBody(), 2048);
        this.group.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        mform.getToolkit().adapt((Control)this.group, true, true);
        this.group.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddGeneDialog.this.gene.setGroup(AddGeneDialog.this.group.getText());
            }
        });
        new Label(mform.getForm().getBody(), 0);
        Label lblForwardPrimer = new Label(mform.getForm().getBody(), 0);
        lblForwardPrimer.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        mform.getToolkit().adapt((Control)lblForwardPrimer, true, true);
        lblForwardPrimer.setText("Forward Primer");
        this.fwPrimer = new Text(mform.getForm().getBody(), 2048);
        this.fwPrimer.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        mform.getToolkit().adapt((Control)this.fwPrimer, true, true);
        this.fwPrimer.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddGeneDialog.this.gene.setForwardPrimer(AddGeneDialog.this.fwPrimer.getText());
            }
        });
        new Label(mform.getForm().getBody(), 0);
        Label lblReversePrimer = new Label(mform.getForm().getBody(), 0);
        lblReversePrimer.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        mform.getToolkit().adapt((Control)lblReversePrimer, true, true);
        lblReversePrimer.setText("Reverse Primer");
        this.revPrimer = new Text(mform.getForm().getBody(), 2048);
        this.revPrimer.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        mform.getToolkit().adapt((Control)this.revPrimer, true, true);
        this.revPrimer.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddGeneDialog.this.gene.setReversePrimer(AddGeneDialog.this.revPrimer.getText());
            }
        });
        new Label(mform.getForm().getBody(), 0);
        Label lblRefseq = new Label(mform.getForm().getBody(), 0);
        lblRefseq.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        mform.getToolkit().adapt((Control)lblRefseq, true, true);
        lblRefseq.setText("RefSeq");
        this.refSeq = new Text(mform.getForm().getBody(), 2048);
        this.refSeq.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        mform.getToolkit().adapt((Control)this.refSeq, true, true);
        Button btnSearchNcbi_2 = new Button(mform.getForm().getBody(), 0);
        mform.getToolkit().adapt((Control)btnSearchNcbi_2, true, true);
        btnSearchNcbi_2.setText("Search NCBI");
        btnSearchNcbi_2.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String refSeqNo = AddGeneDialog.this.refSeq.getText();
                if (refSeqNo != null && refSeqNo.length() > 0) {
                    if (refSeqNo.contains(",")) {
                        refSeqNo = refSeqNo.substring(0, refSeqNo.indexOf(","));
                    }
                    try {
                        Integer id = util.getGeneIdFromNCBIByRefSeq(refSeqNo, AddGeneDialog.this.organism);
                        if (id == null) {
                            MessageDialog.openInformation((Shell)AddGeneDialog.this.getParentShell(), (String)"Not Found", (String)("Cannot find the information at NCBI gene database by this refSeq number: " + refSeqNo));
                        } else {
                            ArrayList<Integer> geneIdList = new ArrayList<Integer>();
                            geneIdList.add(id);
                            AddGeneDialog.this.gene.setGeneIds(geneIdList);
                            AddGeneDialog.this.geneId.setText(AddGeneDialog.this.gene.getGeneIdString());
                            Gene newGene = util.getDetailsFromNCBI(id);
                            if (newGene != null) {
                                AddGeneDialog.this.gene.setGeneSymbol(newGene.getGeneSymbol());
                                AddGeneDialog.this.geneSymbol.setText(AddGeneDialog.this.gene.getGeneSymbol());
                                AddGeneDialog.this.gene.setFullName(newGene.getFullName());
                                AddGeneDialog.this.fullName.setText(AddGeneDialog.this.gene.getFullName());
                                AddGeneDialog.this.gene.setLocations(newGene.getLocations());
                                AddGeneDialog.this.location.setText(AddGeneDialog.this.gene.getLocationString());
                                AddGeneDialog.this.gene.setAliases(newGene.getAliases());
                                AddGeneDialog.this.aliases.setText(AddGeneDialog.this.gene.getAliasString());
                                AddGeneDialog.this.gene.setRefSeq(newGene.getRefSeq());
                                AddGeneDialog.this.refSeq.setText(AddGeneDialog.this.gene.getRefSeqString());
                                AddGeneDialog.this.gene.setSecondaryRefSeq(newGene.getSecondaryRefSeq());
                                AddGeneDialog.this.secondaryRefSeq.setText(AddGeneDialog.this.gene.getSecondaryRefSeqString());
                            } else {
                                MessageDialog.openInformation((Shell)AddGeneDialog.this.getParentShell(), (String)"Not Found", (String)"Details cannot be retrieved from NCBI gene database");
                            }
                        }
                    }
                    catch (MalformedURLException e1) {
                        logger.error((Object)"NCBI gene search url is wrong.", (Throwable)e1);
                        MessageDialog.openError((Shell)AddGeneDialog.this.getParentShell(), (String)"Error", (String)"NCBI gene search URL is wrong. Please inform the developers!");
                    }
                    catch (Exception e1) {
                        logger.error((Object)"NCBI gene search failed", (Throwable)e1);
                        MessageDialog.openError((Shell)AddGeneDialog.this.getParentShell(), (String)"Error", (String)"NCBI gene search URL failed.");
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.refSeq.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String refSeqText = AddGeneDialog.this.refSeq.getText();
                if (refSeqText != null && refSeqText.trim().length() > 0) {
                    AddGeneDialog.this.gene.setRefSeq(refSeqText);
                }
            }
        });
        Label lblProteinRefseq = new Label(mform.getForm().getBody(), 0);
        lblProteinRefseq.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        mform.getToolkit().adapt((Control)lblProteinRefseq, true, true);
        lblProteinRefseq.setText("Protein RefSeq");
        this.secondaryRefSeq = new Text(mform.getForm().getBody(), 2048);
        this.secondaryRefSeq.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        mform.getToolkit().adapt((Control)this.secondaryRefSeq, true, true);
        new Label(mform.getForm().getBody(), 0);
        new Label(mform.getForm().getBody(), 0);
        this.secondaryRefSeq.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String refSeqText = AddGeneDialog.this.secondaryRefSeq.getText();
                if (refSeqText != null && refSeqText.trim().length() > 0) {
                    AddGeneDialog.this.gene.setSecondaryRefSeq(refSeqText);
                }
            }
        });
        Label lblNote = new Label(mform.getForm().getBody(), 0);
        lblNote.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        mform.getToolkit().adapt((Control)lblNote, true, true);
        lblNote.setText("If you are entering multiple values, please separate them with a comma");
    }

    public Gene getGene() {
        return this.gene;
    }

    protected void okPressed() {
        boolean exists = false;
        for (Gene gene2 : this.geneList) {
            if (gene2.getGeneIdentifier().equals(this.gene.getGeneIdentifier())) {
                logger.info((Object)("A gene with identifier " + this.gene.getGeneIdentifier() + " already exists in the list"));
                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Warning", (String)"A gene with this identifier already exists!");
                exists = true;
            }
            if (!gene2.getGeneSymbol().equals(this.gene.getGeneSymbol())) continue;
            logger.info((Object)("A gene with symbol " + this.gene.getGeneSymbol() + " already exists in the list"));
            boolean addDuplicate = MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)"Warning", (String)"A gene with this symbol already exists! Do you still want to add the gene?");
            boolean bl = exists = !addDuplicate;
        }
        if (!exists) {
            super.okPressed();
        }
    }
}

