/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.util.graph.visitor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import org.glycoinfo.WURCSFramework.util.WURCSException;
import org.glycoinfo.WURCSFramework.util.graph.traverser.WURCSGraphTraverser;
import org.glycoinfo.WURCSFramework.util.graph.traverser.WURCSGraphTraverserConnectingGroup;
import org.glycoinfo.WURCSFramework.util.graph.visitor.WURCSVisitor;
import org.glycoinfo.WURCSFramework.util.graph.visitor.WURCSVisitorException;
import org.glycoinfo.WURCSFramework.wurcs.graph.Backbone;
import org.glycoinfo.WURCSFramework.wurcs.graph.Modification;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSEdge;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSGraph;

public class WURCSVisitorCollectConnectingBackboneGroups
implements WURCSVisitor {
    private LinkedList<HashSet<Backbone>> m_aBackboneGroups = new LinkedList();
    private HashSet<Backbone> m_aBackbones;
    private HashSet<Modification> m_aModifications;
    private HashSet<WURCSEdge> m_aEdges;

    public LinkedList<HashSet<Backbone>> getBackboneGroups() {
        return this.m_aBackboneGroups;
    }

    @Override
    public void visit(Backbone a_objBackbone) throws WURCSVisitorException {
        this.m_aBackbones.add(a_objBackbone);
    }

    @Override
    public void visit(Modification a_objModification) throws WURCSVisitorException {
        this.m_aModifications.add(a_objModification);
    }

    @Override
    public void visit(WURCSEdge a_objWURCSEdge) throws WURCSVisitorException {
        this.m_aEdges.add(a_objWURCSEdge);
    }

    @Override
    public void start(WURCSGraph a_objGraph) throws WURCSVisitorException {
        WURCSGraphTraverser t_objTraverser = this.getTraverser(this);
        try {
            ArrayList<Backbone> t_aAllBackbones = a_objGraph.getBackbones();
            for (Backbone t_oStart : t_aAllBackbones) {
                boolean t_bHasContained = false;
                for (HashSet hashSet : this.m_aBackboneGroups) {
                    if (!hashSet.contains(t_oStart)) continue;
                    t_bHasContained = true;
                    break;
                }
                if (t_bHasContained) continue;
                this.clear();
                t_objTraverser.traverse(t_oStart);
                this.m_aBackboneGroups.addLast(this.m_aBackbones);
            }
        }
        catch (WURCSException e) {
            throw new WURCSVisitorException(e.getErrorMessage());
        }
    }

    @Override
    public WURCSGraphTraverser getTraverser(WURCSVisitor a_objVisitor) throws WURCSVisitorException {
        return new WURCSGraphTraverserConnectingGroup(this);
    }

    @Override
    public void clear() {
        this.m_aBackbones = new HashSet();
        this.m_aModifications = new HashSet();
        this.m_aEdges = new HashSet();
    }
}

