/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin.reporting;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.eurocarbdb.application.glycanbuilder.CoreDictionary;
import org.eurocarbdb.application.glycanbuilder.CoreType;
import org.eurocarbdb.application.glycanbuilder.FragmentEntry;
import org.eurocarbdb.application.glycanbuilder.GWSParser;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycanRendererAWT;
import org.eurocarbdb.application.glycanbuilder.Linkage;
import org.eurocarbdb.application.glycanbuilder.MassOptions;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.TerminalDictionary;
import org.eurocarbdb.application.glycanbuilder.TerminalType;
import org.eurocarbdb.application.glycanbuilder.Union;
import org.eurocarbdb.application.glycoworkbench.PeakAnnotation;
import org.eurocarbdb.application.glycoworkbench.PeakAnnotationCollection;
import org.eurocarbdb.application.glycoworkbench.Scan;
import org.eurocarbdb.application.glycoworkbench.plugin.grammar.Grammar;
import org.eurocarbdb.application.glycoworkbench.plugin.grammar.GrammarOptions;
import org.eurocarbdb.application.glycoworkbench.plugin.reporting.ProfilesComparisonReportOptions;

public class ProfilesComparisonReportDocument {
    private ProfilesComparisonReportOptions theOptions;
    private Grammar theGrammar;
    private Vector<String> names;
    private Vector<String> namesFirstGroup;
    private Vector<String> namesSecondGroup;
    private Vector<Row> rows;

    public ProfilesComparisonReportDocument(Vector<Scan> firstGroup, Vector<Scan> secondGroup, Map<Scan, String> scanNameMap, Grammar grammar, ProfilesComparisonReportOptions options) throws Exception {
        this.theOptions = options;
        this.theGrammar = grammar;
        this.rows = ProfilesComparisonReportDocument.collectData(firstGroup, secondGroup);
        this.namesFirstGroup = ProfilesComparisonReportDocument.collectNames(firstGroup, scanNameMap);
        this.namesSecondGroup = ProfilesComparisonReportDocument.collectNames(secondGroup, scanNameMap);
        this.names = new Union(this.namesFirstGroup).and(this.namesSecondGroup);
        ProfilesComparisonReportDocument.normalize(this.rows, options);
        this.rows = ProfilesComparisonReportDocument.deconvolute(this.rows, grammar, options);
        if (options.NORMALIZEBYROW) {
            ProfilesComparisonReportDocument.normalizeByRow(this.rows);
        } else {
            ProfilesComparisonReportDocument.normalizeByTable(this.rows);
        }
    }

    public Vector<String> getNames() {
        return this.names;
    }

    public Vector<String> getNamesFirstGroup() {
        return this.namesFirstGroup;
    }

    public Vector<String> getNamesSecondGroup() {
        return this.namesSecondGroup;
    }

    public Vector<Row> getRows() {
        return this.rows;
    }

    public int getNoRows() {
        return this.rows.size();
    }

    public int getNoColumns() {
        if (this.rows.size() == 0) {
            return 0;
        }
        int fg_size = this.rows.get((int)0).intensities_firstgroup.length;
        int sg_size = this.rows.get((int)0).intensities_secondgroup.length;
        return fg_size + sg_size;
    }

    public int getNoColumnsFirstGroup() {
        if (this.rows.size() == 0) {
            return 0;
        }
        return this.rows.get((int)0).intensities_firstgroup.length;
    }

    public int getNoColumnsSecondGroup() {
        if (this.rows.size() == 0) {
            return 0;
        }
        return this.rows.get((int)0).intensities_secondgroup.length;
    }

    public int size() {
        return this.rows.size();
    }

    private static Vector<Row> collectData(Vector<Scan> firstGroup, Vector<Scan> secondGroup) {
        Row row;
        PeakAnnotationCollection pac;
        Scan s;
        int i;
        int fg_size = firstGroup != null ? firstGroup.size() : 0;
        int sg_size = secondGroup != null ? secondGroup.size() : 0;
        TreeMap<FragmentEntry, Row> ret = new TreeMap<FragmentEntry, Row>();
        for (i = 0; i < fg_size; ++i) {
            s = firstGroup.get(i);
            pac = s.getAnnotatedPeakList().getPeakAnnotationCollection(0);
            for (PeakAnnotation pa : pac.getPeakAnnotations()) {
                if (!pa.isAnnotated()) continue;
                row = (Row)ret.get(pa.getAnnotation().getFragmentEntry());
                if (row == null) {
                    row = new Row(pa.getAnnotation().getFragmentEntry(), fg_size, sg_size);
                    row.name = GlycanRendererAWT.makeCompositionTextPlain((Glycan)row.structure.getComposition(false));
                    ret.put(pa.getAnnotation().getFragmentEntry(), row);
                }
                int n = i;
                row.intensities_firstgroup[n] = row.intensities_firstgroup[n] + pa.getPeak().getIntensity();
            }
        }
        for (i = 0; i < sg_size; ++i) {
            s = secondGroup.get(i);
            pac = s.getAnnotatedPeakList().getPeakAnnotationCollection(0);
            for (PeakAnnotation pa : pac.getPeakAnnotations()) {
                if (!pa.isAnnotated()) continue;
                row = (Row)ret.get(pa.getAnnotation().getFragmentEntry());
                if (row == null) {
                    row = new Row(pa.getAnnotation().getFragmentEntry(), fg_size, sg_size);
                    row.name = GlycanRendererAWT.makeCompositionTextPlain((Glycan)row.structure.getComposition(false));
                    ret.put(pa.getAnnotation().getFragmentEntry(), row);
                }
                int n = i;
                row.intensities_secondgroup[n] = row.intensities_secondgroup[n] + pa.getPeak().getIntensity();
            }
        }
        return new Vector<Row>(ret.values());
    }

    private static Vector<String> collectNames(Vector<Scan> group, Map<Scan, String> scanNameMap) {
        Vector<String> ret = new Vector<String>();
        if (group != null) {
            for (Scan s : group) {
                ret.add(scanNameMap.get(s));
            }
        }
        return ret;
    }

    private static void normalize(Vector<Row> rows, ProfilesComparisonReportOptions options) {
        if (rows.size() == 0) {
            return;
        }
        int fg_size = rows.get((int)0).intensities_firstgroup.length;
        for (int i = 0; i < fg_size; ++i) {
            double div = 0.0;
            for (Row row : rows) {
                if (options.NORMALIZATION == 1) {
                    div = Math.max(div, row.intensities_firstgroup[i]);
                    continue;
                }
                if (options.NORMALIZATION == 2) {
                    div += row.intensities_firstgroup[i];
                    continue;
                }
                if (options.NORMALIZATION != 3) continue;
                div += row.intensities_firstgroup[i] / (double)rows.size();
            }
            for (Row row : rows) {
                int n = i;
                row.intensities_firstgroup[n] = row.intensities_firstgroup[n] / div;
            }
        }
        int sg_size = rows.get((int)0).intensities_secondgroup.length;
        for (int i = 0; i < sg_size; ++i) {
            double div = 0.0;
            for (Row row : rows) {
                if (options.NORMALIZATION == 1) {
                    div = Math.max(div, row.intensities_secondgroup[i]);
                    continue;
                }
                if (options.NORMALIZATION == 2) {
                    div += row.intensities_secondgroup[i];
                    continue;
                }
                if (options.NORMALIZATION != 3) continue;
                div += row.intensities_secondgroup[i] / (double)rows.size();
            }
            for (Row row : rows) {
                int n = i;
                row.intensities_secondgroup[n] = row.intensities_secondgroup[n] / div;
            }
        }
    }

    private static void normalizeByRow(Vector<Row> rows) {
        if (rows.size() == 0) {
            return;
        }
        int fg_size = rows.get((int)0).intensities_firstgroup.length;
        int sg_size = rows.get((int)0).intensities_secondgroup.length;
        for (Row row : rows) {
            int i;
            int i2;
            double min = 0.0;
            double max = 0.0;
            for (i2 = 0; i2 < fg_size; ++i2) {
                max = Math.max(row.intensities_firstgroup[i2], max);
                min = Math.min(row.intensities_firstgroup[i2], min);
            }
            for (i2 = 0; i2 < sg_size; ++i2) {
                max = Math.max(row.intensities_secondgroup[i2], max);
                min = Math.min(row.intensities_secondgroup[i2], min);
            }
            double center = (max + min) / 2.0;
            double deviation = (max - min) / 2.0;
            for (i = 0; i < fg_size; ++i) {
                row.intensities_firstgroup[i] = (row.intensities_firstgroup[i] - center) / deviation;
            }
            for (i = 0; i < sg_size; ++i) {
                row.intensities_secondgroup[i] = (row.intensities_secondgroup[i] - center) / deviation;
            }
        }
    }

    private static void normalizeByTable(Vector<Row> rows) {
        int i;
        int fg_size = rows.get((int)0).intensities_firstgroup.length;
        int sg_size = rows.get((int)0).intensities_secondgroup.length;
        double max = 0.0;
        for (Row row : rows) {
            for (i = 0; i < fg_size; ++i) {
                max = Math.max(Math.abs(row.intensities_firstgroup[i]), max);
            }
            for (i = 0; i < sg_size; ++i) {
                max = Math.max(Math.abs(row.intensities_secondgroup[i]), max);
            }
        }
        for (Row row : rows) {
            i = 0;
            while (i < fg_size) {
                int n = i++;
                row.intensities_firstgroup[n] = row.intensities_firstgroup[n] / max;
            }
            i = 0;
            while (i < sg_size) {
                int n = i++;
                row.intensities_secondgroup[n] = row.intensities_secondgroup[n] / max;
            }
        }
    }

    private static Vector<Row> deconvolute(Vector<Row> rows, Grammar grammar, ProfilesComparisonReportOptions options) throws Exception {
        if (rows.size() == 0 || options.DECONVOLUTION == ProfilesComparisonReportOptions.NONE) {
            return rows;
        }
        int fg_size = rows.get(0).getFirstGroupSize();
        int sg_size = rows.get(0).getSecondGroupSize();
        TreeMap<FragmentEntry, Row> ret = new TreeMap<FragmentEntry, Row>();
        if (options.DECONVOLUTION == 2 || options.DECONVOLUTION == 4) {
            rows = ProfilesComparisonReportDocument.resolveFuzzyStructures(rows, grammar);
        }
        for (Row r : rows) {
            Map<FragmentEntry, Integer> components;
            if (options.DECONVOLUTION == 1) {
                components = ProfilesComparisonReportDocument.getMonosaccharides(r.structure);
            } else if (options.DECONVOLUTION == 2) {
                components = ProfilesComparisonReportDocument.getDisaccharides(r.structure);
            } else if (options.DECONVOLUTION == 3) {
                components = ProfilesComparisonReportDocument.getCore(r.structure);
            } else if (options.DECONVOLUTION == 4) {
                components = ProfilesComparisonReportDocument.getTerminals(r.structure);
            } else {
                throw new Exception("Uknown deconvolution type");
            }
            for (Map.Entry<FragmentEntry, Integer> e : components.entrySet()) {
                Row dest = (Row)ret.get(e.getKey());
                if (dest == null) {
                    dest = new Row(e.getKey(), fg_size, sg_size);
                    ret.put(e.getKey(), dest);
                }
                dest.addIntensities(r, e.getValue().intValue());
            }
        }
        return new Vector<Row>(ret.values());
    }

    private static Vector<Row> resolveFuzzyStructures(Vector<Row> rows, Grammar grammar) throws Exception {
        if (rows.size() == 0) {
            return rows;
        }
        int fg_size = rows.get(0).getFirstGroupSize();
        int sg_size = rows.get(0).getSecondGroupSize();
        Vector<Glycan> nonfuzzy_structures = new Vector<Glycan>();
        for (Row r : rows) {
            if (r.structure.isFuzzy()) continue;
            nonfuzzy_structures.add(r.structure);
        }
        GrammarOptions options = new GrammarOptions();
        options.ADD_LINKAGE_INFO = false;
        options.MAX_LEVEL = 2;
        options.ADD_UNCLES = false;
        options.USE_SEEDS = false;
        options.TAG_CORES = false;
        grammar = Grammar.createGrammar(nonfuzzy_structures, options);
        TreeMap<Glycan, Row> ret = new TreeMap<Glycan, Row>();
        for (Row r : rows) {
            if (!r.structure.isFuzzy()) {
                ret.put(r.structure, r);
                continue;
            }
            if (r.structure.getNoAntennae() > 3) continue;
            Vector all = r.structure.placeAntennae();
            Vector<Glycan> resolved = new Vector<Glycan>();
            for (Glycan g : all) {
                if (!grammar.accept(g)) continue;
                resolved.add(g);
            }
            if (resolved.size() == 0) {
                System.err.println("Cannot resolve some fuzzy structures");
            }
            double weight = 1.0 / (double)resolved.size();
            for (Glycan g : resolved) {
                Row dest = (Row)ret.get(g);
                if (dest == null) {
                    String name = GlycanRendererAWT.makeCompositionTextPlain((Glycan)g.getComposition(false));
                    dest = new Row(g, name, fg_size, sg_size);
                    ret.put(g, dest);
                }
                dest.addIntensities(r, weight);
            }
        }
        return new Vector<Row>(ret.values());
    }

    private static void add(Map<FragmentEntry, Integer> ret, Glycan g, String name, int quantity) {
        FragmentEntry fe = new FragmentEntry(g, name);
        Integer old_count = ret.get(fe);
        if (old_count == null) {
            ret.put(fe, quantity);
        } else {
            ret.put(fe, old_count + quantity);
        }
    }

    private static Map<FragmentEntry, Integer> getMonosaccharides(Glycan structure) {
        HashMap<FragmentEntry, Integer> ret = new HashMap<FragmentEntry, Integer>();
        ProfilesComparisonReportDocument.getMonosaccharides(ret, structure.getRoot());
        return ret;
    }

    private static void getMonosaccharides(Map<FragmentEntry, Integer> ret, Residue node) {
        if (node.isSaccharide() || node.isSubstituent()) {
            Residue r = node.cloneResidue();
            r.setPreferredPlacement(null);
            Glycan g = new Glycan(r, true, new MassOptions());
            String name = node.getTypeName();
            ProfilesComparisonReportDocument.add(ret, g, name, 1);
        }
        for (Linkage l : node.getChildrenLinkages()) {
            ProfilesComparisonReportDocument.getMonosaccharides(ret, l.getChildResidue());
        }
    }

    private static Map<FragmentEntry, Integer> getDisaccharides(Glycan structure) throws Exception {
        if (structure.isFuzzy()) {
            throw new Exception("Cannot get disaccharides from fuzzy structures");
        }
        HashMap<FragmentEntry, Integer> ret = new HashMap<FragmentEntry, Integer>();
        ProfilesComparisonReportDocument.getDisaccharides(ret, structure.getRoot());
        return ret;
    }

    private static void getDisaccharides(Map<FragmentEntry, Integer> ret, Residue node) {
        Residue parent = node.getParent();
        if (parent != null && (parent.isSaccharide() || parent.isSubstituent()) && (node.isSaccharide() || node.isSubstituent())) {
            Residue rp = parent.cloneResidue();
            rp.setPreferredPlacement(null);
            Residue rc = node.cloneResidue();
            rc.setPreferredPlacement(null);
            rp.addChild(rc, (Collection)node.getParentLinkage().getBonds());
            Glycan g = new Glycan(rp, true, new MassOptions());
            String name = rc.getTypeName() + node.getParentLinkage().toIupac() + rp.getTypeName();
            ProfilesComparisonReportDocument.add(ret, g, name, 1);
        }
        for (Linkage l : node.getChildrenLinkages()) {
            ProfilesComparisonReportDocument.getDisaccharides(ret, l.getChildResidue());
        }
    }

    private static Map<FragmentEntry, Integer> getCore(Glycan structure) throws Exception {
        HashMap<FragmentEntry, Integer> ret = new HashMap<FragmentEntry, Integer>();
        GWSParser parser = new GWSParser();
        Vector<FragmentEntry> cores_ordered = new Vector<FragmentEntry>();
        for (CoreType ct : CoreDictionary.getCores()) {
            Glycan core = new Glycan(ct.newCore(), true, new MassOptions());
            cores_ordered.add(new FragmentEntry(core, ct.getDescription()));
        }
        Collections.sort(cores_ordered, new Comparator<FragmentEntry>(){

            @Override
            public int compare(FragmentEntry f1, FragmentEntry f2) {
                if (f1.mz_ratio > f2.mz_ratio) {
                    return -1;
                }
                if (f1.mz_ratio < f2.mz_ratio) {
                    return 1;
                }
                return 0;
            }
        });
        for (FragmentEntry core : cores_ordered) {
            if (!structure.contains(core.fragment, true, false)) continue;
            ret.put(core, 1);
            return ret;
        }
        return ret;
    }

    private static Map<FragmentEntry, Integer> getTerminals(Glycan structure) throws Exception {
        HashMap<FragmentEntry, Integer> ret = new HashMap<FragmentEntry, Integer>();
        GWSParser parser = new GWSParser();
        Vector<FragmentEntry> terminals_ordered = new Vector<FragmentEntry>();
        for (TerminalType tt : TerminalDictionary.getTerminals()) {
            Glycan terminal = new Glycan(tt.newTerminal(), true, new MassOptions());
            terminals_ordered.add(new FragmentEntry(terminal, tt.getDescription()));
        }
        Collections.sort(terminals_ordered, new Comparator<FragmentEntry>(){

            @Override
            public int compare(FragmentEntry f1, FragmentEntry f2) {
                if (f1.mz_ratio > f2.mz_ratio) {
                    return -1;
                }
                if (f1.mz_ratio < f2.mz_ratio) {
                    return 1;
                }
                return 0;
            }
        });
        for (FragmentEntry terminal : terminals_ordered) {
            int count = structure.count(terminal.fragment, false, true);
            if (count <= 0) continue;
            ret.put(terminal, count);
        }
        return ret;
    }

    public static class Row {
        public Glycan structure;
        public String name;
        public double mz_ratio;
        public double[] intensities_firstgroup;
        public double[] intensities_secondgroup;

        public Row(Glycan g, String n, int fg_size, int sg_size) {
            this.structure = g.clone();
            this.name = n;
            this.mz_ratio = g.computeMZ();
            this.intensities_firstgroup = new double[fg_size];
            this.intensities_secondgroup = new double[sg_size];
            Arrays.fill(this.intensities_firstgroup, 0.0);
            Arrays.fill(this.intensities_secondgroup, 0.0);
        }

        public Row(FragmentEntry fe, int fg_size, int sg_size) {
            this(fe.fragment, fe.name, fg_size, sg_size);
        }

        public double getColumn(int ind) {
            if (ind < this.intensities_firstgroup.length) {
                return this.intensities_firstgroup[ind];
            }
            return this.intensities_secondgroup[ind - this.intensities_firstgroup.length];
        }

        public int getFirstGroupSize() {
            return this.intensities_firstgroup.length;
        }

        public int getSecondGroupSize() {
            return this.intensities_secondgroup.length;
        }

        public void addIntensities(Row other) {
            this.addIntensities(other, 1.0);
        }

        public void addIntensities(Row other, double weight) {
            int fg_size = Math.min(this.getFirstGroupSize(), other.getFirstGroupSize());
            for (int i = 0; i < fg_size; ++i) {
                int n = i;
                this.intensities_firstgroup[n] = this.intensities_firstgroup[n] + weight * other.intensities_firstgroup[i];
            }
            int sg_size = Math.min(this.getSecondGroupSize(), other.getSecondGroupSize());
            for (int i = 0; i < sg_size; ++i) {
                int n = i;
                this.intensities_secondgroup[n] = this.intensities_secondgroup[n] + weight * other.intensities_secondgroup[i];
            }
        }
    }
}

