/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractListModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.eurocarbdb.application.glycanbuilder.CustomFocusTraversalPolicy;
import org.eurocarbdb.application.glycanbuilder.EscapeDialog;
import org.eurocarbdb.application.glycanbuilder.ResidueDictionary;
import org.eurocarbdb.application.glycanbuilder.TextUtils;
import org.eurocarbdb.application.glycanbuilder.Union;
import org.eurocarbdb.application.glycoworkbench.plugin.ProfilerOptions;
import org.eurocarbdb.application.glycoworkbench.plugin.ProfilerPlugin;
import org.jdesktop.layout.GroupLayout;

public class ProfilerOptionsDialog
extends EscapeDialog
implements ActionListener {
    private ProfilerPlugin thePlugin = null;
    private ProfilerOptions theProfilerOptions;
    private JButton button_cancel;
    private JButton button_ok;
    private JComboBox field_derivatization;
    private JList field_dictionaries;
    private JTextField field_other_redend_mass;
    private JTextField field_other_redend_name;
    private JComboBox field_reducingend;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel9;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JCheckBox jClearAnnotations;

    public ProfilerOptionsDialog(Frame parent, ProfilerPlugin plugin, ProfilerOptions opt) {
        super(parent, true);
        this.thePlugin = plugin;
        this.theProfilerOptions = opt;
        this.initComponents();
        this.setTraversal();
        this.setData(this.theProfilerOptions);
        this.setActions();
        this.enableItems();
        this.setLocationRelativeTo(parent);
        this.pack();
    }

    private void setTraversal() {
        CustomFocusTraversalPolicy tp = new CustomFocusTraversalPolicy();
        tp.addComponent((Component)this.field_dictionaries);
        tp.addComponent((Component)this.field_derivatization);
        tp.addComponent((Component)this.field_reducingend);
        tp.addComponent((Component)this.field_other_redend_name);
        tp.addComponent((Component)this.field_other_redend_mass);
        tp.addComponent((Component)this.button_ok);
        tp.addComponent((Component)this.button_cancel);
        this.setFocusTraversalPolicy((FocusTraversalPolicy)tp);
        this.getRootPane().setDefaultButton(this.button_ok);
    }

    private void setData(ProfilerOptions opt) {
        Union dict_names = new Union(this.thePlugin.getDictionaryNames());
        this.field_dictionaries.setListData(dict_names);
        for (int i = 0; i < opt.DICTIONARIES.length; ++i) {
            int ind = dict_names.indexOf(opt.DICTIONARIES[i]);
            this.field_dictionaries.addSelectionInterval(ind, ind);
        }
        this.field_derivatization.setModel(new DefaultComboBoxModel<String>(new String[]{"Und", "perMe", "perDMe", "perMe(C^13)", "perAc", "perDAc"}));
        this.field_derivatization.setSelectedItem(opt.DERIVATIZATION);
        this.field_reducingend.setModel(new DefaultComboBoxModel<Object>(new Union().and((Object)"---").and(ResidueDictionary.getReducingEndsString()).and((Object)"Other...").toArray((Object[])new String[0])));
        this.field_reducingend.setSelectedItem(opt.REDUCING_END);
        if (opt.REDUCING_END.equals("XXX")) {
            this.field_reducingend.setSelectedItem("Other...");
            this.field_other_redend_name.setText(opt.OTHER_REDEND_NAME);
            this.field_other_redend_mass.setText("" + opt.OTHER_REDEND_MASS);
        } else {
            this.field_reducingend.setSelectedItem(opt.REDUCING_END);
            this.field_other_redend_name.setText("");
            this.field_other_redend_mass.setText("0");
        }
        this.jClearAnnotations.setSelected(opt.CLEAR_EXISTING_ANNOTATIONS);
    }

    private void setActions() {
        this.field_reducingend.addActionListener(this);
        this.button_ok.addActionListener(this);
        this.button_cancel.addActionListener(this);
    }

    private void enableItems() {
        this.field_other_redend_name.setEnabled(this.field_reducingend.getSelectedItem().equals("Other..."));
        this.field_other_redend_mass.setEnabled(this.field_reducingend.getSelectedItem().equals("Other..."));
    }

    private String[] toStringArray(Object[] a) {
        if (a == null) {
            return null;
        }
        String[] ret = new String[a.length];
        for (int i = 0; i < a.length; ++i) {
            ret[i] = a[i].toString();
        }
        return ret;
    }

    private void retrieveData(ProfilerOptions opt) {
        opt.DICTIONARIES = this.toStringArray(this.field_dictionaries.getSelectedValues());
        opt.DERIVATIZATION = (String)this.field_derivatization.getSelectedItem();
        if (this.field_reducingend.getSelectedItem().equals("Other...")) {
            opt.REDUCING_END = "XXX";
            opt.OTHER_REDEND_NAME = TextUtils.trim((String)this.field_other_redend_name.getText());
            opt.OTHER_REDEND_MASS = Double.valueOf(this.field_other_redend_mass.getText());
            if (opt.OTHER_REDEND_NAME == null || opt.OTHER_REDEND_NAME.length() == 0) {
                opt.OTHER_REDEND_NAME = "XXX";
            }
        } else {
            opt.REDUCING_END = (String)this.field_reducingend.getSelectedItem();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action == "OK") {
            this.retrieveData(this.theProfilerOptions);
            this.return_status = action;
            this.closeDialog();
        } else if (action == "Cancel") {
            this.return_status = action;
            this.closeDialog();
        }
        this.enableItems();
    }

    private void initComponents() {
        this.jLabel9 = new JLabel();
        this.field_derivatization = new JComboBox();
        this.field_reducingend = new JComboBox();
        this.jLabel10 = new JLabel();
        this.button_ok = new JButton();
        this.button_cancel = new JButton();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.field_dictionaries = new JList();
        this.jSeparator1 = new JSeparator();
        this.jLabel2 = new JLabel();
        this.field_other_redend_name = new JTextField();
        this.jLabel3 = new JLabel();
        this.field_other_redend_mass = new JTextField();
        this.jClearAnnotations = new JCheckBox();
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ProfilerOptionsDialog.this.closeDialog();
            }
        });
        this.jLabel9.setText("Derivatization");
        this.field_derivatization.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.field_reducingend.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel10.setText("Reducing end");
        this.button_ok.setText("OK");
        this.button_cancel.setText("Cancel");
        this.jLabel1.setText("Database");
        this.field_dictionaries.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.field_dictionaries.setVisibleRowCount(5);
        this.jScrollPane1.setViewportView(this.field_dictionaries);
        this.jLabel2.setText("name");
        this.field_other_redend_name.setText("jTextField1");
        this.jLabel3.setText("mass");
        this.field_other_redend_mass.setText("jTextField2");
        this.jClearAnnotations.setText("Clear existing annotations");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).add(42, 42, 42).add((Component)this.jScrollPane1, -1, 162, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jLabel10, -1, -1, Short.MAX_VALUE).add((Component)this.jLabel9, -1, -1, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel3).add((Component)this.jLabel2))).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.field_derivatization, 0, 162, Short.MAX_VALUE).add((Component)this.field_reducingend, 0, 162, Short.MAX_VALUE).add((Component)this.field_other_redend_name, -1, 162, Short.MAX_VALUE).add((Component)this.field_other_redend_mass, -1, 162, Short.MAX_VALUE).add((Component)this.jClearAnnotations, -1, 162, Short.MAX_VALUE))).add((Component)this.jSeparator1, -1, 262, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add(57, 57, 57).add((Component)this.button_ok).addPreferredGap(0).add((Component)this.button_cancel))).addContainerGap()));
        layout.linkSize(new Component[]{this.button_cancel, this.button_ok}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jScrollPane1, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.field_derivatization, -2, -1, -2).add((Component)this.jLabel9)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.field_reducingend, -2, -1, -2).add((Component)this.jLabel10)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.field_other_redend_name, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.field_other_redend_mass, -2, -1, -2)).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jClearAnnotations, -2, -1, -2)).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.button_ok).add((Component)this.button_cancel)).addContainerGap()));
        this.pack();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

