/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.util.validation;

import java.util.Iterator;
import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.GlycoGraphAlternative;
import org.eurocarbdb.MolecularFramework.sugar.GlycoNode;
import org.eurocarbdb.MolecularFramework.sugar.Monosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.NonMonosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.Substituent;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitAlternative;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitCyclic;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitRepeat;
import org.eurocarbdb.MolecularFramework.sugar.UnderdeterminedSubTree;
import org.eurocarbdb.MolecularFramework.sugar.UnvalidatedGlycoNode;
import org.eurocarbdb.MolecularFramework.util.traverser.GlycoTraverser;
import org.eurocarbdb.MolecularFramework.util.traverser.GlycoTraverserTreePreOrder;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitor;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;

public class GlycoVisitorContainsNodeBelow
implements GlycoVisitor {
    private int m_iMonosaccharide = 0;
    private int m_iNonMonosaccharide = 0;
    private int m_iSubstituent = 0;
    private int m_iRepeat = 0;
    private int m_iUnvalidated = 0;
    private int m_iUnderdetermined = 0;
    private int m_iAlternative = 0;
    private int m_iCyclic = 0;
    private boolean m_bDescent = true;
    private GlycoNode m_objStartNode = null;

    public void setDescent(boolean a_bDescent) {
        this.m_bDescent = a_bDescent;
    }

    public int getMonosaccharideCount() {
        return this.m_iMonosaccharide;
    }

    public int getNonMonosaccharideCount() {
        return this.m_iNonMonosaccharide;
    }

    public int getSubstituentCount() {
        return this.m_iSubstituent;
    }

    public int getRepeatCount() {
        return this.m_iRepeat;
    }

    public int getUnvalidatedCount() {
        return this.m_iUnvalidated;
    }

    public int getUnderdetermindedCount() {
        return this.m_iUnderdetermined;
    }

    public int getAlternativeCount() {
        return this.m_iAlternative;
    }

    public int getCyclicCount() {
        return this.m_iCyclic;
    }

    public void visit(Monosaccharide arg0) throws GlycoVisitorException {
        if (this.m_objStartNode == arg0) {
            return;
        }
        ++this.m_iMonosaccharide;
    }

    public void visit(NonMonosaccharide arg0) throws GlycoVisitorException {
        if (this.m_objStartNode == arg0) {
            return;
        }
        ++this.m_iNonMonosaccharide;
    }

    public void visit(GlycoEdge arg0) throws GlycoVisitorException {
    }

    public void visit(SugarUnitRepeat a_objRepeat) throws GlycoVisitorException {
        if (this.m_objStartNode == a_objRepeat) {
            return;
        }
        ++this.m_iRepeat;
        this.m_iUnderdetermined += a_objRepeat.getUndeterminedSubTrees().size();
        if (this.m_bDescent) {
            GlycoTraverser t_objTraverser = this.getTraverser(this);
            t_objTraverser.traverseGraph(a_objRepeat);
            Iterator<UnderdeterminedSubTree> t_iterUnder = a_objRepeat.getUndeterminedSubTrees().iterator();
            while (t_iterUnder.hasNext()) {
                t_objTraverser = this.getTraverser(this);
                t_objTraverser.traverseGraph(t_iterUnder.next());
            }
        }
    }

    public GlycoTraverser getTraverser(GlycoVisitor a_objVisitor) throws GlycoVisitorException {
        return new GlycoTraverserTreePreOrder(a_objVisitor);
    }

    public void clear() {
        this.m_iMonosaccharide = 0;
        this.m_iNonMonosaccharide = 0;
        this.m_iRepeat = 0;
        this.m_iSubstituent = 0;
        this.m_iUnvalidated = 0;
        this.m_iUnderdetermined = 0;
        this.m_iAlternative = 0;
        this.m_iCyclic = 0;
        this.m_objStartNode = null;
    }

    public void visit(Substituent a_objSubstituent) throws GlycoVisitorException {
        if (this.m_objStartNode == a_objSubstituent) {
            return;
        }
        ++this.m_iSubstituent;
    }

    public void visit(SugarUnitCyclic a_objCyclic) throws GlycoVisitorException {
        if (this.m_objStartNode == a_objCyclic) {
            return;
        }
        ++this.m_iCyclic;
    }

    public void visit(SugarUnitAlternative a_objAlternative) throws GlycoVisitorException {
        if (this.m_objStartNode == a_objAlternative) {
            return;
        }
        ++this.m_iAlternative;
        if (this.m_bDescent) {
            for (GlycoGraphAlternative t_objAlternative : a_objAlternative.getAlternatives()) {
                GlycoTraverser t_objTraverser = this.getTraverser(this);
                t_objTraverser.traverseGraph(t_objAlternative);
            }
        }
    }

    public void visit(UnvalidatedGlycoNode a_objUnvalidated) throws GlycoVisitorException {
        if (this.m_objStartNode == a_objUnvalidated) {
            return;
        }
        ++this.m_iUnvalidated;
    }

    public void start(Sugar a_objSugar) throws GlycoVisitorException {
        this.clear();
        this.m_iUnderdetermined += a_objSugar.getUndeterminedSubTrees().size();
        GlycoTraverser t_objTraverser = this.getTraverser(this);
        t_objTraverser.traverseGraph(a_objSugar);
        Iterator<UnderdeterminedSubTree> t_iterUnder = a_objSugar.getUndeterminedSubTrees().iterator();
        while (t_iterUnder.hasNext()) {
            t_objTraverser = this.getTraverser(this);
            t_objTraverser.traverseGraph(t_iterUnder.next());
        }
    }

    public void start(GlycoNode a_objNode) throws GlycoVisitorException {
        this.clear();
        this.m_objStartNode = a_objNode;
        GlycoTraverserTreePreOrder t_objTraverser = new GlycoTraverserTreePreOrder(this);
        t_objTraverser.traverseResidue(a_objNode);
    }
}

