/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.wizard.taskexport.pages;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.ProjectProperty;
import org.grits.toolbox.core.preference.share.ProjectPreferenceStore;
import org.grits.toolbox.core.utilShare.CheckboxTableViewer;
import org.grits.toolbox.core.utilShare.provider.EntryLabelProvider;
import org.grits.toolbox.core.utilShare.provider.GenericListContentProvider;

public class TaskFilterPage
extends WizardPage {
    private static String title = "Filter Criteria";
    public static final String DEFAULT_FILENAME = "GRITS_TaskExport.xlsx";
    public CheckboxTableViewer projectTableViewer = null;
    public CheckboxTableViewer statusTableViewer = null;
    public Text locationText = null;

    public TaskFilterPage() {
        super(title);
        this.setTitle(title);
        this.setMessage("Choose Project and Status you want to export task from.");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginBottom = 20;
        layout.verticalSpacing = 10;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText("Projects");
        GridData labelGridData = new GridData(128);
        labelGridData.horizontalSpan = 1;
        label.setLayoutData((Object)labelGridData);
        Table projectsTable = new Table(container, 68356);
        GridData tableLayouData = new GridData(1808);
        tableLayouData.horizontalSpan = 3;
        tableLayouData.heightHint = 100;
        projectsTable.setLayoutData((Object)tableLayouData);
        this.projectTableViewer = new CheckboxTableViewer(projectsTable, "Select");
        TableViewerColumn tableColumn2 = new TableViewerColumn((TableViewer)this.projectTableViewer, 4, 1);
        tableColumn2.getColumn().setText("Projects");
        tableColumn2.getColumn().setWidth(300);
        this.projectTableViewer.getTable().setHeaderVisible(true);
        this.projectTableViewer.getTable().setLinesVisible(true);
        this.projectTableViewer.setContentProvider((IContentProvider)new GenericListContentProvider());
        this.projectTableViewer.setLabelProvider((IBaseLabelProvider)new EntryLabelProvider());
        Entry workspaceEntry = PropertyHandler.getDataModel().getRoot();
        ArrayList<Entry> projectEntries = new ArrayList<Entry>();
        this.projectTableViewer.setInput(projectEntries);
        for (Entry child : workspaceEntry.getChildren()) {
            if (!(child.getProperty() instanceof ProjectProperty)) continue;
            projectEntries.add(child);
            this.projectTableViewer.add(child);
            this.projectTableViewer.setChecked(child, ((ProjectProperty)child.getProperty()).getOpen());
        }
        label = new Label(container, 0);
        label.setText("Status");
        labelGridData = new GridData(128);
        labelGridData.horizontalSpan = 1;
        label.setLayoutData((Object)labelGridData);
        Table statusTable = new Table(container, 68356);
        GridData statusLayouData = new GridData(1808);
        statusLayouData.horizontalSpan = 3;
        statusLayouData.heightHint = 100;
        statusTable.setLayoutData((Object)statusLayouData);
        this.statusTableViewer = new CheckboxTableViewer(statusTable, "Select");
        TableViewerColumn statusColumn2 = new TableViewerColumn((TableViewer)this.statusTableViewer, 4, 1);
        statusColumn2.getColumn().setText("Status");
        statusColumn2.getColumn().setWidth(300);
        this.statusTableViewer.getTable().setHeaderVisible(true);
        this.statusTableViewer.getTable().setLinesVisible(true);
        this.statusTableViewer.setContentProvider((IContentProvider)new GenericListContentProvider());
        this.statusTableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getColumnText(Object element, int columnIndex) {
                if (columnIndex > 0 && element instanceof String) {
                    return (String)element;
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }
        });
        ArrayList<String> status = new ArrayList<String>();
        status.addAll(ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.STATUS).getAllValues());
        Collections.sort(status, String.CASE_INSENSITIVE_ORDER);
        this.statusTableViewer.setInput(status);
        Object[] allStatus = new String[status.size()];
        int i = 0;
        for (String keyword : status) {
            allStatus[i++] = keyword;
        }
        this.statusTableViewer.setCheckedElements(allStatus);
        this.statusTableViewer.refresh();
        this.locationText = new Text(container, 2048);
        GridData textData = new GridData(4, 1, true, false);
        textData.horizontalSpan = 2;
        this.locationText.setLayoutData((Object)textData);
        this.locationText.setText(String.valueOf(System.getProperty("user.home")) + File.separator + DEFAULT_FILENAME);
        this.locationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (TaskFilterPage.this.locationText.getText().isEmpty()) {
                    TaskFilterPage.this.setErrorMessage("Choose a location to Save");
                } else {
                    TaskFilterPage.this.setErrorMessage(null);
                }
            }
        });
        Button browseButton = new Button(container, 8);
        browseButton.setText("Browse Location");
        GridData browseButtonGridData = new GridData(128);
        browseButtonGridData.horizontalSpan = 1;
        browseButton.setLayoutData((Object)browseButtonGridData);
        browseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(TaskFilterPage.this.getShell(), 8192);
                fileDialog.setText("Select File");
                fileDialog.setFilterExtensions(new String[]{"*.xlsx"});
                fileDialog.setFilterNames(new String[]{"Excel (*.xlsx)"});
                fileDialog.setFileName(TaskFilterPage.DEFAULT_FILENAME);
                fileDialog.setOverwrite(true);
                String selected = fileDialog.open();
                if (selected != null) {
                    TaskFilterPage.this.locationText.setText(selected);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        browseButton.setFocus();
        container.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)container);
    }
}

