/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.service.impl;

import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.commands.MBindingContext;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.impl.PerspectiveImpl;
import org.eclipse.e4.ui.model.application.ui.advanced.impl.PerspectiveStackImpl;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.impl.PartStackImpl;
import org.eclipse.e4.ui.workbench.Selector;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.swt.widgets.Display;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.editor.ICancelableEditor;
import org.grits.toolbox.core.service.IGritsUIService;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.osgi.service.event.Event;

public class GritsUIService
implements IGritsUIService {
    private static final Logger logger = Logger.getLogger(GritsUIService.class);
    @Inject
    private EModelService modelService;
    @Inject
    private EPartService partService;
    @Optional
    @Inject
    private MApplication application;
    @Optional
    @Inject
    private IEclipseContext context;

    @Override
    public MPart openEntryInPart(Entry entry) {
        MPart entryPart = null;
        if (entry != null) {
            logger.info((Object)("Opening an entry " + entry.getDisplayName() + " in a part"));
            MPartDescriptor matchedPartDescriptor = this.findPartDescriptorForEntry(entry);
            if (matchedPartDescriptor != null) {
                IEclipseContext projectExplorerContext = this.partService.findPart("org.grits.toolbox.core.part.projectexplorer").getContext();
                if (projectExplorerContext == null) {
                    MPart part = this.partService.showPart("org.grits.toolbox.core.part.projectexplorer", EPartService.PartState.ACTIVATE);
                    projectExplorerContext = part.getContext();
                }
                ESelectionService selectionService = (ESelectionService)projectExplorerContext.get(ESelectionService.class);
                selectionService.setSelection((Object)entry);
                entryPart = this.findPartForEntry(entry);
                if (entryPart == null) {
                    try {
                        logger.info((Object)("Creating a part for the entry from the part descriptor : " + matchedPartDescriptor.getElementId()));
                        entryPart = this.partService.createPart(matchedPartDescriptor.getElementId());
                        entryPart.setLabel(entry.getDisplayName());
                        logger.info((Object)"Setting the current entry as its transient data for this part");
                        entryPart.getTransientData().put("org.grits.toolbox.entry.current", entry);
                    }
                    catch (Exception ex) {
                        logger.error((Object)("Error creating part for the entry\n" + ex.getMessage()), (Throwable)ex);
                        ErrorUtils.createErrorMessageBox(Display.getCurrent().getActiveShell(), "Error creating part for the entry", ex);
                        this.partService.hidePart(entryPart, true);
                    }
                }
                try {
                    logger.info((Object)"Adding part to partstack - e4.primaryDataStack");
                    PartStackImpl partStackImpl = (PartStackImpl)this.modelService.find("org.eclipse.e4.primaryDataStack", (MUIElement)this.application);
                    partStackImpl.getChildren().add(entryPart);
                    MPart openedPart = this.partService.showPart(entryPart, EPartService.PartState.ACTIVATE);
                    if (openedPart != null && openedPart.getObject() != null && openedPart.getObject() instanceof ICancelableEditor) {
                        if (((ICancelableEditor)openedPart.getObject()).isCanceled()) {
                            this.partService.hidePart(openedPart);
                        }
                    } else if (openedPart != null && openedPart.getObject() == null) {
                        logger.error((Object)"Failed to initialize the part for the entry");
                        this.partService.hidePart(openedPart);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to show the part for the entry", (Throwable)e);
                    this.partService.hidePart(entryPart, true);
                }
                logger.info((Object)"Entry opened in a part");
            }
        }
        return entryPart;
    }

    @Override
    public void setPartService(EPartService partService) {
        this.partService = partService;
    }

    @Optional
    @Inject
    protected void resetPerspective(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/bringToTop") Event event) {
        Object element = null;
        if (event != null && (element = event.getProperty("ChangedElement")) instanceof MPart) {
            MPart part = (MPart)element;
            logger.info((Object)("Part brought to top : " + part.getElementId()));
            if ("org.grits.toolbox.core.part.projectexplorer".equals(part.getElementId()) || "org.eclipse.e4.ui.compatibility.editor".equals(part.getElementId())) {
                return;
            }
            MPerspective perspective = this.findPerspectiveForPartDescriptor(part.getElementId());
            if (perspective != null && this.getDefaultPerspectiveStack().getSelectedElement() != perspective) {
                logger.info((Object)("Switching to perspective : " + perspective.getElementId()));
                this.getDefaultPerspectiveStack().setSelectedElement(perspective);
            }
        }
    }

    @Override
    public boolean closePartForEntry(Entry entry) {
        boolean closed = false;
        if (entry != null) {
            MPart part;
            logger.info((Object)("Closing part for the entry : " + entry.getDisplayName()));
            MPartDescriptor partDescriptor = this.findPartDescriptorForEntry(entry);
            if (partDescriptor != null && (part = this.findPartForEntry(entry)) != null) {
                this.partService.hidePart(part);
                closed = true;
                logger.info((Object)("Part closed : " + part.getElementId() + " for entry " + entry.getDisplayName()));
            }
        }
        return closed;
    }

    @Override
    public MPart findPartForEntry(Entry entry) {
        if (entry == null) {
            logger.error((Object)"No part descriptor for a null entry");
            return null;
        }
        logger.info((Object)("Finding part for entry " + entry.getDisplayName()));
        MPart entryPart = null;
        final MPartDescriptor partDescriptor = this.findPartDescriptorForEntry(entry);
        if (entry.getDisplayName() != null && partDescriptor != null && partDescriptor.getElementId() != null) {
            logger.info((Object)("Finding existing part for partDescriptorId : " + partDescriptor.getElementId()));
            List entryParts = this.modelService.findElements((MApplicationElement)this.application, MPart.class, 29, new Selector(){

                public boolean select(MApplicationElement element) {
                    return Objects.equals(element.getElementId(), partDescriptor.getElementId());
                }
            });
            for (MPart ep : entryParts) {
                if (!entry.getDisplayName().equals(ep.getLabel()) || !this.entryEquals(entry, (Entry)ep.getTransientData().get("org.grits.toolbox.entry.current"))) continue;
                entryPart = ep;
                logger.info((Object)("Existing part with label : \"" + entry.getDisplayName() + "\" and partDescriptorId : \"" + partDescriptor.getElementId() + "\" was found for this entry."));
                break;
            }
        }
        return entryPart;
    }

    private boolean entryEquals(Entry entry, Entry other) {
        if (entry == other) {
            return true;
        }
        if (entry == null || other == null) {
            return false;
        }
        boolean bSameType = entry.getProperty().getType().equals(other.getProperty().getType());
        if (!bSameType && entry.getProperty().getParentProperty() != null && entry.getProperty().getParentProperty().getType().equals(other.getProperty().getType())) {
            entry = entry.getParent();
            bSameType = true;
        }
        if (bSameType) {
            if (!entry.getDisplayName().equals(other.getDisplayName())) {
                return false;
            }
            if (entry.getParent() != null) {
                return entry.getParent().equals(other.getParent());
            }
            return true;
        }
        return false;
    }

    @Override
    public MPartDescriptor findPartDescriptorForEntry(Entry entry) {
        MPartDescriptor matchedPartDescriptor = null;
        if (entry != null && entry.getProperty() != null) {
            logger.info((Object)("Finding part descriptor for " + entry.getDisplayName()));
            block0: for (MPartDescriptor descriptor : this.application.getDescriptors()) {
                for (MBindingContext bindingContext : descriptor.getBindingContexts()) {
                    if (!"org.grits.toolbox.core.bindingcontext.entry".equals(bindingContext.getElementId()) || !descriptor.getCategory().equals(entry.getProperty().getType())) continue;
                    logger.info((Object)("A part descriptor for entry found : " + descriptor.getElementId()));
                    matchedPartDescriptor = descriptor;
                    if (!matchedPartDescriptor.getTags().contains("default")) continue;
                    logger.info((Object)("The part descriptor found for the entry has \"default\" tag : " + descriptor.getElementId()));
                    break block0;
                }
            }
        }
        return matchedPartDescriptor;
    }

    @Override
    public void selectPerspective(String perspectiveId) {
        logger.info((Object)("Switching to perspective : " + perspectiveId));
        try {
            MUIElement uiElement = this.modelService.find(perspectiveId, (MUIElement)this.application);
            if (uiElement instanceof PerspectiveImpl) {
                this.getDefaultPerspectiveStack().setSelectedElement((MPerspective)((PerspectiveImpl)uiElement));
                logger.info((Object)("Perspective switched to : " + perspectiveId));
            } else {
                logger.error((Object)("Perspective could not be found : " + perspectiveId));
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error finding/switching perspective\n" + ex.getMessage()), (Throwable)ex);
        }
    }

    private PerspectiveStackImpl getDefaultPerspectiveStack() {
        logger.info((Object)"Retrieving default perspective stack : org.grits.toolbox.core.perspectivestack.0");
        return (PerspectiveStackImpl)this.modelService.find("org.grits.toolbox.core.perspectivestack.0", (MUIElement)this.application);
    }

    @Override
    public MPerspective findPerspectiveForPartDescriptor(String partDescriptorId) {
        logger.info((Object)("Finding perspective for : " + partDescriptorId));
        MPerspective selectedPerspective = null;
        MPartDescriptor partDescriptor = this.modelService.getPartDescriptor(partDescriptorId);
        if (partDescriptor != null) {
            PerspectiveStackImpl perspectiveStackImpl = (PerspectiveStackImpl)this.modelService.find("org.grits.toolbox.core.perspectivestack.0", (MUIElement)this.application);
            for (MPerspective perspective : perspectiveStackImpl.getChildren()) {
                if (partDescriptor.getTags().contains("perspective:" + perspective.getElementId())) {
                    logger.info((Object)("Perspective found for part descriptor " + partDescriptorId + " : " + perspective.getElementId()));
                    selectedPerspective = perspective;
                    break;
                }
                if (!perspective.getElementId().endsWith("." + perspective.getLabel()) || !partDescriptor.getTags().contains("perspective:" + perspective.getElementId().substring(0, perspective.getElementId().indexOf("." + perspective.getLabel())))) continue;
                logger.info((Object)("Perspective found for part descriptor " + partDescriptorId + " : " + perspective.getElementId()));
                selectedPerspective = perspective;
                break;
            }
        }
        return selectedPerspective;
    }
}

