/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.util.oldUtil;

import java.util.ArrayList;
import java.util.HashMap;
import org.glycoinfo.WURCSFramework.util.oldUtil.TrivialNameDescriptor;
import org.glycoinfo.WURCSFramework.util.residuecontainer.ResidueContainer;

public class TrivialNameConverter {
    public static String convertTrivalName(ResidueContainer a_oRC, String a_sSugarName) {
        TrivialNameDescriptor a_enumTrivialDescriptor;
        String tmp = "";
        if (a_oRC.getDLconfiguration().size() == 1 && (a_sSugarName.startsWith("D-") || a_sSugarName.startsWith("L-") || a_sSugarName.startsWith("?-"))) {
            a_sSugarName = a_sSugarName.substring(2);
        }
        if ((a_enumTrivialDescriptor = TrivialNameDescriptor.forIUPAC(a_sSugarName)) == null) {
            a_enumTrivialDescriptor = TrivialNameDescriptor.forIUPAC(String.valueOf(a_oRC.getDLconfiguration().getFirst()) + "-" + a_sSugarName);
        }
        if (a_enumTrivialDescriptor == null) {
            TrivialNameDescriptor[] trivialNameDescriptorArray = TrivialNameDescriptor.values();
            int n = trivialNameDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                TrivialNameDescriptor a_enumTrivial = trivialNameDescriptorArray[n2];
                if (!a_enumTrivial.getIUPAC().equals("") && a_sSugarName.contains(a_enumTrivial.getIUPAC())) {
                    a_enumTrivialDescriptor = a_enumTrivial;
                }
                ++n2;
            }
        }
        if (a_enumTrivialDescriptor == null) {
            tmp = TrivialNameConverter.convertTrivialNamefromSub(a_oRC, a_sSugarName);
            TrivialNameConverter.margeNativeSubstituent(a_oRC);
            return tmp;
        }
        if (TrivialNameConverter.isLegtose(a_enumTrivialDescriptor) && !a_oRC.getNativeSubstituent().contains("5*N") && !a_oRC.getNativeSubstituent().contains("7*N")) {
            TrivialNameConverter.margeNativeSubstituent(a_oRC);
            return a_sSugarName;
        }
        if (a_oRC.getModification().contains("2*ulo")) {
            tmp = TrivialNameConverter.convertDeoxyUlosonic(a_oRC, a_enumTrivialDescriptor);
        }
        if (!a_oRC.getModification().contains("2*ulo") && a_oRC.getBackBoneSize() == 6) {
            tmp = TrivialNameConverter.convertDeoxyHexose(a_oRC, a_enumTrivialDescriptor);
        }
        a_oRC.getCommonName().clear();
        if (tmp.equals("")) {
            a_oRC.addCommonName(a_sSugarName);
            tmp = a_sSugarName;
        } else {
            a_oRC.addCommonName(tmp);
        }
        TrivialNameConverter.margeSubstituent(a_oRC);
        return tmp;
    }

    private static String convertTrivialNamefromSub(ResidueContainer a_oRC, String a_sSugarName) {
        String a_sTrivialName = "";
        if (a_oRC.getCommonName().contains("Ery") && a_oRC.getSubstituent().contains("3*CO")) {
            a_sTrivialName = "Api";
            a_oRC.getSubstituent().remove("3*CO");
        }
        if (a_oRC.getCommonName().contains("Glc")) {
            a_sTrivialName = TrivialNameConverter.convertMUR(a_oRC, a_sSugarName);
        }
        if (a_sTrivialName.equals("")) {
            a_sTrivialName = a_sSugarName;
        } else {
            a_oRC.getCommonName().clear();
            a_oRC.addCommonName(a_sTrivialName);
        }
        return a_sTrivialName;
    }

    private static String convertDeoxyUlosonic(ResidueContainer a_oRC, TrivialNameDescriptor a_enumTrivialDescriptor) {
        if (a_enumTrivialDescriptor == null) {
            return "";
        }
        if (TrivialNameConverter.isKetoDeoxyNonase(a_enumTrivialDescriptor) && a_oRC.getNativeSubstituent().contains("5*N")) {
            if (a_oRC.getDLconfiguration().getLast().equals("D")) {
                a_enumTrivialDescriptor = TrivialNameDescriptor.DNEU;
            }
            if (a_oRC.getDLconfiguration().getLast().equals("L")) {
                a_enumTrivialDescriptor = TrivialNameDescriptor.LNEU;
            }
            if (a_oRC.getDLconfiguration().getLast().equals("?")) {
                a_enumTrivialDescriptor = TrivialNameDescriptor.NEU;
            }
        }
        if (a_oRC.getBackBoneSize() == 9) {
            String a_sCoreConfiguration = a_oRC.getDLconfiguration().isEmpty() ? "?" : a_oRC.getDLconfiguration().getLast();
            a_oRC.getDLconfiguration().clear();
            a_oRC.addDLconfiguration(a_sCoreConfiguration);
        }
        for (String a_sMAP : a_enumTrivialDescriptor.getSubstituent()) {
            a_oRC.getNativeSubstituent().remove(a_sMAP);
        }
        for (String a_sDeoxy : a_enumTrivialDescriptor.getModifications()) {
            a_oRC.getModification().remove(a_sDeoxy);
        }
        a_oRC.setONIC(false);
        a_oRC.setMotif(false);
        return a_enumTrivialDescriptor.getTrivalName();
    }

    private static String convertDeoxyHexose(ResidueContainer a_oRC, TrivialNameDescriptor a_enumTrivialDescriptor) {
        if (a_enumTrivialDescriptor == null) {
            return "";
        }
        if (TrivialNameConverter.isQuinovose(a_enumTrivialDescriptor) && a_oRC.getNativeSubstituent().contains("2*N") && a_oRC.getSubstituent().contains("4*N")) {
            a_enumTrivialDescriptor = TrivialNameDescriptor.BAC;
        }
        for (String a_sDeoxy : a_enumTrivialDescriptor.getModifications()) {
            if (a_oRC.getModification().contains("6*m") && a_sDeoxy.equals("6*d")) {
                a_oRC.getModification().remove("6*m");
                continue;
            }
            a_oRC.getModification().remove(a_sDeoxy);
        }
        for (String a_sMAP : a_enumTrivialDescriptor.getSubstituent()) {
            a_oRC.getNativeSubstituent().remove(a_sMAP);
            a_oRC.getSubstituent().remove(a_sMAP);
        }
        if ((TrivialNameConverter.isQuinovose(a_enumTrivialDescriptor) || TrivialNameConverter.isFucose(a_enumTrivialDescriptor) || TrivialNameConverter.isRhamnose(a_enumTrivialDescriptor)) && a_oRC.getNativeSubstituent().contains("2*N")) {
            a_oRC.getNativeSubstituent().remove("2*N");
            a_oRC.getSubstituent().add("2*N");
        }
        a_oRC.setMotif(false);
        return a_enumTrivialDescriptor.getTrivalName();
    }

    private static String convertMUR(ResidueContainer a_oRC, String a_sSugarName) {
        String tmp = "";
        if (a_oRC.getSubModList().contains("3*OC^RCO/4=O/3C") && !a_oRC.getNativeSubstituent().contains("2*NCC/3=O") && !a_oRC.getNativeSubstituent().contains("2*NCCO/3=O")) {
            a_oRC.getSubstituent().remove("3*OC^RCO/4=O/3C");
            TrivialNameConverter.checkPrefixOxygen(a_oRC, "2*N");
            tmp = "Mur";
        }
        if (a_oRC.getSubModList().contains("3*OC^SCO/4=O/3C") && !a_oRC.getNativeSubstituent().contains("2*NCC/3=O") && !a_oRC.getNativeSubstituent().contains("2*NCCO/3=O")) {
            a_oRC.getSubstituent().remove("3*OC^SCO/4=O/3C");
            TrivialNameConverter.checkPrefixOxygen(a_oRC, "2*N");
            tmp = "Mur";
        }
        if (a_oRC.getSubModList().contains("3*OC^XCO/4=O/3C") && !a_oRC.getNativeSubstituent().contains("2*NCC/3=O") && !a_oRC.getNativeSubstituent().contains("2*NCCO/3=O")) {
            a_oRC.getSubstituent().remove("3*OC^XCO/4=O/3C");
            TrivialNameConverter.checkPrefixOxygen(a_oRC, "2*N");
            tmp = "Mur";
        }
        if (a_oRC.getSubModList().contains("3*OCC^SC/4O/3=O")) {
            System.out.println(a_oRC.getSubstituent());
            if (a_oRC.getNativeSubstituent().contains("2*NCC/3=O")) {
                tmp = "MurNAc";
                a_oRC.getNativeSubstituent().remove("2*NCC/3=O");
                a_oRC.getSubstituent().remove("3*OCC^SC/4O/3=O");
            }
            if (a_oRC.getNativeSubstituent().contains("2*NCCO/3=O")) {
                tmp = "MurNGc";
                a_oRC.getNativeSubstituent().remove("2*NCCO/3=O");
                a_oRC.getSubstituent().remove("3*OCC^SC/4O/3=O");
            }
        }
        if (a_oRC.getSubModList().contains("3*OC^SCO/4=O/3C")) {
            if (a_oRC.getNativeSubstituent().contains("2*NCC/3=O")) {
                tmp = "MurNAc";
                a_oRC.getNativeSubstituent().remove("2*NCC/3=O");
                a_oRC.getSubstituent().remove("3*OC^SCO/4=O/3C");
            }
            if (a_oRC.getNativeSubstituent().contains("2*NCCO/3=O")) {
                tmp = "MurNGc";
                a_oRC.getNativeSubstituent().remove("2*NCCO/3=O");
                a_oRC.getSubstituent().remove("3*OC^SCO/4=O/3C");
            }
        }
        if (a_oRC.getSubModList().contains("3*OCC^RC/4O/3=O")) {
            if (a_oRC.getNativeSubstituent().contains("2*NCC/3=O")) {
                tmp = "MurNAc";
                a_oRC.getNativeSubstituent().remove("2*NCC/3=O");
                a_oRC.getSubstituent().remove("3*OCC^RC/4O/3=O");
            }
            if (a_oRC.getNativeSubstituent().contains("2*NCCO/3=O")) {
                tmp = "MurNGc";
                a_oRC.getNativeSubstituent().remove("2*NCCO/3=O");
                a_oRC.getSubstituent().remove("3*OCC^RC/4O/3=O");
            }
        }
        if (a_oRC.getSubModList().contains("3*OC^RCO/4=O/3C")) {
            if (a_oRC.getNativeSubstituent().contains("2*NCC/3=O")) {
                tmp = "MurNAc";
                a_oRC.getNativeSubstituent().remove("2*NCC/3=O");
                a_oRC.getSubstituent().remove("3*OC^RCO/4=O/3C");
            }
            if (a_oRC.getNativeSubstituent().contains("2*NCCO/3=O")) {
                tmp = "MurNGc";
                a_oRC.getNativeSubstituent().remove("2*NCCO/3=O");
                a_oRC.getSubstituent().remove("3*OC^RCO/4=O/3C");
            }
        }
        if (a_oRC.getSubModList().contains("3*OC^XCO/4=O/3C")) {
            if (a_oRC.getSubModList().contains("2*NCC/3=O")) {
                tmp = "MurNAc";
                a_oRC.getSubstituent().remove("2*NCC/3=O");
                a_oRC.getSubstituent().remove("3*OC^XCO/4=O/3C");
            }
            if (a_oRC.getSubModList().contains("2*NCCO/3=O")) {
                tmp = "MurNGc";
                a_oRC.getSubstituent().remove("2*NCCO/3=O");
                a_oRC.getSubstituent().remove("3*OC^XCO/4=O/3C");
            }
        }
        return tmp;
    }

    private static void checkPrefixOxygen(ResidueContainer a_oRC, String a_sKey) {
        String[] a_sPos = a_sKey.split("\\*");
        for (String a_sMAP : TrivialNameConverter.copy(a_oRC.getNativeSubstituent())) {
            if (a_sMAP.equals(a_sKey)) {
                a_oRC.getNativeSubstituent().remove(a_sKey);
                continue;
            }
            if (!a_sMAP.startsWith(a_sKey)) continue;
            String a_sNewMAP = a_sMAP.replace(a_sKey, String.valueOf(a_sPos[0]) + "*O");
            a_oRC.getNativeSubstituent().remove(a_sMAP);
            a_oRC.getSubstituent().add(a_sNewMAP);
        }
    }

    private static void margeSubstituent(ResidueContainer a_oRC) {
        HashMap<String, String> a_mMAP = new HashMap<String, String>();
        for (String a_sMAP : TrivialNameConverter.copy(a_oRC.getSubstituent())) {
            String[] a_s = a_sMAP.split("\\*");
            if (a_s[0].equals("?")) continue;
            if (a_s.length > 2) {
                String a_sSplited = "";
                int i = 1;
                while (i < a_s.length) {
                    a_sSplited = String.valueOf(a_sSplited) + "*" + a_s[i];
                    ++i;
                }
                a_s[1] = a_sSplited.replaceFirst("\\*", "");
            }
            if (!a_mMAP.containsKey(a_s[0])) {
                a_mMAP.put(a_s[0], "*" + a_s[1]);
            } else if (a_s[1].startsWith("*O")) {
                a_mMAP.put(a_s[0], a_s[1].replaceFirst("\\*O", "*" + (String)a_mMAP.get(a_s[1])));
            } else {
                a_mMAP.put(a_s[0], ((String)a_mMAP.get(a_s[0])).replaceFirst("\\*O", "*" + a_s[1]));
            }
            a_oRC.getSubstituent().remove(a_sMAP);
        }
        for (String a_sKey : a_mMAP.keySet()) {
            a_oRC.addSubstituent(String.valueOf(a_sKey) + (String)a_mMAP.get(a_sKey));
        }
    }

    private static void margeNativeSubstituent(ResidueContainer a_oRC) {
        String[] a_s;
        HashMap<String, String> a_mMAP = new HashMap<String, String>();
        for (String a_sMAP : TrivialNameConverter.copy(a_oRC.getNativeSubstituent())) {
            a_s = a_sMAP.split("\\*");
            if (!a_mMAP.containsKey(a_s[0])) {
                a_mMAP.put(a_s[0], "*" + a_s[1]);
            } else if (a_s[1].startsWith("O")) {
                a_mMAP.put(a_s[0], a_s[1].replaceFirst("O", (String)a_mMAP.get(a_s[0])));
            } else {
                a_mMAP.put(a_s[0], ((String)a_mMAP.get(a_s[0])).replaceFirst("O", a_s[1]));
            }
            a_oRC.getNativeSubstituent().remove(a_sMAP);
        }
        for (String a_sMAP : TrivialNameConverter.copy(a_oRC.getSubstituent())) {
            a_s = a_sMAP.split("\\*");
            if (a_oRC.getBackBoneSize() == 6 && a_s[0].equals("2") || !a_mMAP.containsKey(a_s[0])) continue;
            if (a_s[1].startsWith("O")) {
                a_mMAP.put(a_s[0], a_s[1].replaceFirst("O", (String)a_mMAP.get(a_s[0])));
                a_oRC.getSubstituent().remove(a_sMAP);
                continue;
            }
            a_mMAP.put(a_s[0], ((String)a_mMAP.get(a_s[0])).replaceFirst("O", a_s[1]));
            a_oRC.getSubstituent().remove(a_sMAP);
        }
        for (String a_sKey : a_mMAP.keySet()) {
            a_oRC.addNativeSubstituent(String.valueOf(a_sKey) + (String)a_mMAP.get(a_sKey));
        }
    }

    private static ArrayList<String> copy(ArrayList<String> a_aSUBs) {
        ArrayList<String> a_aMAPs = new ArrayList<String>();
        for (String a_sMAP : a_aSUBs) {
            a_aMAPs.add(a_sMAP);
        }
        return a_aMAPs;
    }

    private static boolean isLegtose(TrivialNameDescriptor a_enumTrivialDescriptor) {
        if (a_enumTrivialDescriptor.equals((Object)TrivialNameDescriptor.DLEG)) {
            return true;
        }
        if (a_enumTrivialDescriptor.equals((Object)TrivialNameDescriptor.LLEG)) {
            return true;
        }
        return a_enumTrivialDescriptor.equals((Object)TrivialNameDescriptor.LEG);
    }

    private static boolean isKetoDeoxyNonase(TrivialNameDescriptor a_enumTrivialDescriptor) {
        if (a_enumTrivialDescriptor.equals((Object)TrivialNameDescriptor.DKDN)) {
            return true;
        }
        if (a_enumTrivialDescriptor.equals((Object)TrivialNameDescriptor.LKDN)) {
            return true;
        }
        return a_enumTrivialDescriptor.equals((Object)TrivialNameDescriptor.KDN);
    }

    private static boolean isQuinovose(TrivialNameDescriptor a_enumTrivialDescriptor) {
        if (a_enumTrivialDescriptor.equals((Object)TrivialNameDescriptor.DQUI)) {
            return true;
        }
        if (a_enumTrivialDescriptor.equals((Object)TrivialNameDescriptor.LQUI)) {
            return true;
        }
        return a_enumTrivialDescriptor.equals((Object)TrivialNameDescriptor.QUI);
    }

    private static boolean isRhamnose(TrivialNameDescriptor a_enumTrivialDescriptor) {
        if (a_enumTrivialDescriptor.equals((Object)TrivialNameDescriptor.DRHA)) {
            return true;
        }
        if (a_enumTrivialDescriptor.equals((Object)TrivialNameDescriptor.LRHA)) {
            return true;
        }
        return a_enumTrivialDescriptor.equals((Object)TrivialNameDescriptor.RHA);
    }

    private static boolean isFucose(TrivialNameDescriptor a_enumTrivialDescriptor) {
        if (a_enumTrivialDescriptor.equals((Object)TrivialNameDescriptor.DFUC)) {
            return true;
        }
        if (a_enumTrivialDescriptor.equals((Object)TrivialNameDescriptor.LFUC)) {
            return true;
        }
        return a_enumTrivialDescriptor.equals((Object)TrivialNameDescriptor.FUC);
    }
}

