/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.io.GlycoCT;

import java.util.ArrayList;
import java.util.LinkedList;
import org.eurocarbdb.MolecularFramework.sugar.Anomer;
import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.GlycoGraph;
import org.eurocarbdb.MolecularFramework.sugar.GlycoconjugateException;
import org.eurocarbdb.MolecularFramework.sugar.Linkage;
import org.eurocarbdb.MolecularFramework.sugar.Modification;
import org.eurocarbdb.MolecularFramework.sugar.ModificationType;
import org.eurocarbdb.MolecularFramework.sugar.Monosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.NonMonosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.Substituent;
import org.eurocarbdb.MolecularFramework.sugar.SubstituentType;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitAlternative;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitCyclic;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitRepeat;
import org.eurocarbdb.MolecularFramework.sugar.UnderdeterminedSubTree;
import org.eurocarbdb.MolecularFramework.sugar.UnvalidatedGlycoNode;
import org.eurocarbdb.MolecularFramework.util.traverser.GlycoTraverser;
import org.eurocarbdb.MolecularFramework.util.traverser.GlycoTraverserValdidation;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitor;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;

public class GlycoVisitorValidationForWURCS
implements GlycoVisitor {
    private ArrayList<String> m_aErrorList = new ArrayList();
    private ArrayList<String> m_aWarningList = new ArrayList();

    public ArrayList<String> getErrors() {
        return this.m_aErrorList;
    }

    public ArrayList<String> getWarnings() {
        return this.m_aWarningList;
    }

    public GlycoTraverser getTraverser(GlycoVisitor a_objVisitor) throws GlycoVisitorException {
        return new GlycoTraverserValdidation(a_objVisitor);
    }

    public void visit(Monosaccharide a_objMonosaccharid) throws GlycoVisitorException {
        int t_numC = a_objMonosaccharid.getSuperclass().getCAtomCount();
        int t_iRingStart = a_objMonosaccharid.getRingStart();
        boolean t_bUnknownRingSize = t_iRingStart == -1;
        boolean t_bOpenChain = t_iRingStart == 0;
        Anomer t_oAnom = a_objMonosaccharid.getAnomer();
        if (t_oAnom == Anomer.OpenChain != t_bOpenChain) {
            this.m_aWarningList.add("Anomeric symbol and ring size are not match. :" + a_objMonosaccharid.getGlycoCTName());
        }
        LinkedList<Integer> t_aAnomPositions = new LinkedList<Integer>();
        boolean t_bAldose = true;
        int t_nTermMod = 0;
        boolean t_bDeoxyC1 = false;
        ArrayList<Modification> t_aEnMods = new ArrayList<Modification>();
        for (Modification modif : a_objMonosaccharid.getModification()) {
            boolean t_bAtTerm;
            String modtype = modif.getName();
            if (modif.hasPositionTwo()) {
                int pos1 = modif.getPositionOne();
                int pos2 = modif.getPositionTwo();
                if (!modtype.equals("en") && !modtype.equals("enx")) continue;
                t_aEnMods.add(modif);
                if (pos1 != 1 && pos1 != t_numC) {
                    ++t_nTermMod;
                }
                if (pos2 == 1 || pos2 == t_numC) continue;
                ++t_nTermMod;
                continue;
            }
            int pos = modif.getPositionOne();
            boolean bl = t_bAtTerm = pos == 1 || pos == t_numC;
            if (modif.getModificationType() == ModificationType.ALDI) {
                if (pos != 1) {
                    this.m_aErrorList.add("Modification \"aldi\" must be set to the C1. :" + a_objMonosaccharid.getGlycoCTName());
                }
                t_bAldose = false;
                continue;
            }
            if (modif.getModificationType() == ModificationType.ACID) {
                if (!t_bAtTerm) {
                    this.m_aErrorList.add("Can not do carboxylation to non-terminal carbon. :" + a_objMonosaccharid.getGlycoCTName());
                }
                if (pos == 1) {
                    t_bAldose = false;
                }
                if (pos != t_iRingStart) continue;
                this.m_aErrorList.add("Carboxylic acid contained in the ring. It must be use a substituent \"lactone\". :" + a_objMonosaccharid.getGlycoCTName());
                continue;
            }
            if (!t_bAtTerm) {
                ++t_nTermMod;
            }
            if (modif.getModificationType() == ModificationType.DEOXY) {
                if (pos != 1) continue;
                t_bDeoxyC1 = true;
                continue;
            }
            if (modif.getModificationType() != ModificationType.KETO) continue;
            t_bAldose = false;
            t_aAnomPositions.add(pos);
        }
        if (t_bAldose) {
            t_aAnomPositions.addFirst(1);
            if (t_bDeoxyC1) {
                this.m_aErrorList.add("Can not be deoxy to aldehyde. :" + a_objMonosaccharid.getGlycoCTName());
            }
        }
        if (t_iRingStart == 0 && a_objMonosaccharid.getParentEdge() != null) {
            int t_iPos = (Integer)((Linkage)a_objMonosaccharid.getParentEdge().getGlycosidicLinkages().get(0)).getChildLinkages().get(0);
            if (!t_aAnomPositions.isEmpty() && t_iPos == (Integer)t_aAnomPositions.getFirst()) {
                this.m_aErrorList.add("Glycosidic linkage must not be aldehyde or ketone position. :" + a_objMonosaccharid.getGlycoCTName());
            }
        }
        if (t_aAnomPositions.size() == 0) {
            if (!t_bOpenChain && t_bUnknownRingSize) {
                this.m_aWarningList.add("There is no anomeric position in the monosaccharide. It should be open chain. :" + a_objMonosaccharid.getGlycoCTName());
            }
            t_bOpenChain = true;
            t_bUnknownRingSize = false;
        }
        if (!(t_bUnknownRingSize || t_bOpenChain || t_aAnomPositions.contains(t_iRingStart))) {
            this.m_aErrorList.add("Ring start must be anomeric position. :" + a_objMonosaccharid.getGlycoCTName());
        }
    }

    public void visit(NonMonosaccharide a_objResidue) throws GlycoVisitorException {
    }

    public void visit(SugarUnitRepeat a_objRepeat) throws GlycoVisitorException {
        GlycoTraverser t_objTraverser = this.getTraverser(this);
        t_objTraverser.traverseGraph((GlycoGraph)a_objRepeat);
        for (UnderdeterminedSubTree t_objTree : a_objRepeat.getUndeterminedSubTrees()) {
            t_objTraverser.traverseGraph((GlycoGraph)t_objTree);
        }
    }

    public void visit(Substituent a_objSubstituent) throws GlycoVisitorException {
        if (a_objSubstituent.getSubstituentType().equals((Object)SubstituentType.R_PYRUVATE) || a_objSubstituent.getSubstituentType().equals((Object)SubstituentType.S_PYRUVATE)) {
            this.m_aErrorList.add("Conversion of \"(r)/(s)-pyruvate\" is not handled now.");
        }
    }

    public void visit(SugarUnitCyclic a_objCyclic) throws GlycoVisitorException {
    }

    public void visit(SugarUnitAlternative a_objAlternative) throws GlycoVisitorException {
    }

    public void visit(UnvalidatedGlycoNode a_objUnvalidated) throws GlycoVisitorException {
    }

    public void visit(GlycoEdge a_objLinkage) throws GlycoVisitorException {
    }

    public void start(Sugar a_objSugar) throws GlycoVisitorException {
        this.clear();
        try {
            a_objSugar.getRootNodes().size();
            GlycoTraverser t_objTraverser = this.getTraverser(this);
            t_objTraverser.traverseGraph((GlycoGraph)a_objSugar);
        }
        catch (GlycoconjugateException e) {
            throw new GlycoVisitorException(e.getMessage(), (Throwable)e);
        }
    }

    public void clear() {
        this.m_aErrorList = new ArrayList();
        this.m_aWarningList = new ArrayList();
    }
}

