/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.util;

import org.glycoinfo.GlycanFormatconverter.Glycan.BaseCrossLinkedTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseSubstituentTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.LinkageType;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.GlycanFormatconverter.Glycan.SubstituentInterface;
import org.glycoinfo.GlycanFormatconverter.util.exchange.WURCSGraphToGlyContainer.MAPAnalyzer;
import org.glycoinfo.WURCSFramework.util.array.WURCSFormatException;
import org.glycoinfo.WURCSFramework.wurcs.graph.Modification;

public class SubstituentUtility {
    public static boolean isNLinkedSubstituent(Substituent _sub) {
        if (_sub.getSubstituent() instanceof BaseCrossLinkedTemplate) {
            return false;
        }
        BaseSubstituentTemplate bsubT = (BaseSubstituentTemplate)_sub.getSubstituent();
        if (bsubT.getIUPACnotation().equals("N")) {
            return false;
        }
        return bsubT.getIUPACnotation().startsWith("N");
    }

    public static boolean isOLinkedSubstituent(Substituent _sub) {
        SubstituentInterface subFace = (SubstituentInterface)((Object)_sub);
        if (subFace instanceof BaseCrossLinkedTemplate) {
            return SubstituentUtility.isOLinkedSubstituent((BaseCrossLinkedTemplate)subFace);
        }
        if (subFace instanceof BaseSubstituentTemplate) {
            return _sub.getHeadAtom().equals("O");
        }
        return false;
    }

    public static boolean isOLinkedSubstituent(BaseCrossLinkedTemplate _crossT) {
        if (_crossT.equals(BaseCrossLinkedTemplate.PHOSPHO_ETHANOLAMINE)) {
            return true;
        }
        return _crossT.getMAP().startsWith("*O") || _crossT.getMAP().startsWith("*1O");
    }

    public static Substituent MAPToSubstituent(Modification _mod) throws GlycanException, WURCSFormatException {
        if (_mod.getMAPCode().equals("")) {
            return null;
        }
        MAPAnalyzer mapAnalyze = new MAPAnalyzer();
        mapAnalyze.start(_mod.getMAPCode());
        Substituent ret = null;
        if (mapAnalyze.getSingleTemplate() != null) {
            ret = new Substituent(mapAnalyze.getSingleTemplate());
            ret.setHeadAtom(mapAnalyze.getHeadAtom());
        }
        if (mapAnalyze.getCrossTemplate() != null) {
            ret = new Substituent(mapAnalyze.getCrossTemplate());
            ret.setHeadAtom(mapAnalyze.getHeadAtom());
            ret.setTailAtom(mapAnalyze.getTailAtom());
        }
        if (mapAnalyze.getSingleTemplate() == null && mapAnalyze.getCrossTemplate() == null) {
            throw new GlycanException("This substituent could not support: " + _mod.getMAPCode());
        }
        return ret;
    }

    public static SubstituentInterface MAPToInterface(String _map) throws GlycanException, WURCSFormatException {
        if (_map.equals("")) {
            return null;
        }
        Enum ret = null;
        MAPAnalyzer mapAnalyze = new MAPAnalyzer();
        mapAnalyze.start(_map);
        if (mapAnalyze.getSingleTemplate() != null) {
            ret = mapAnalyze.getSingleTemplate();
        }
        if (mapAnalyze.getCrossTemplate() != null) {
            ret = mapAnalyze.getCrossTemplate();
        }
        if (ret == null) {
            throw new GlycanException(String.valueOf(_map) + " could not found !");
        }
        return ret;
    }

    public static String optimizeSubstituentNotationWithLinkageType(Substituent _sub) {
        String ret = _sub.getNameWithIUPAC();
        String bracket = "";
        if (ret.startsWith("(")) {
            bracket = ret.substring(0, ret.indexOf(")") + 1);
            String regex = bracket.replace("(", "\\(").replace(")", "\\)");
            ret = ret.replaceFirst(regex, "");
        }
        if (_sub.getFirstPosition() == null) {
            return ret;
        }
        if (_sub.getFirstPosition().getParentLinkageType().equals((Object)LinkageType.H_LOSE)) {
            if (ret.startsWith("O")) {
                ret = ret.replaceFirst("O", "C");
            }
            if (!ret.startsWith("O") && !ret.startsWith("C")) {
                ret = "C" + ret;
            }
            if (!ret.startsWith("O") && !bracket.equals("")) {
                ret = "C" + ret;
            }
        }
        if (_sub.getFirstPosition().getParentLinkageType().equals((Object)LinkageType.DEOXY)) {
            if (ret.startsWith("O") && bracket.equals("")) {
                ret = ret.replaceFirst("O", "");
            }
            if (ret.startsWith("C") && !ret.equals("Cl") && bracket.equals("")) {
                ret = ret.replaceFirst("C", "");
            }
        }
        if (_sub.getFirstPosition().getParentLinkageType().equals((Object)LinkageType.H_AT_OH)) {
            if (ret.startsWith("C") && !ret.equals("Cl") && bracket.equals("")) {
                ret = ret.replaceFirst("C", "O");
            }
            if (!ret.startsWith("C") && !ret.startsWith("O") && bracket.equals("")) {
                ret = "O" + ret;
            }
            if (!bracket.equals("")) {
                ret = "O" + ret;
            }
        }
        return String.valueOf(bracket) + ret;
    }

    public static String optimizeSubstituentNotationWithN_linkage(Substituent _sub) {
        String ret = _sub.getNameWithIUPAC();
        if (SubstituentUtility.isNLinkedSubstituent(_sub)) {
            ret = ret.replaceFirst("N", "");
        }
        return ret;
    }

    public static Substituent changePlaneTemplate(Substituent _sub) {
        String plane = SubstituentUtility.optimizeSubstituentNotationWithN_linkage(_sub);
        BaseSubstituentTemplate bsubT = BaseSubstituentTemplate.forIUPACNotationWithIgnore(plane);
        _sub.setTemplate(bsubT);
        return _sub;
    }
}

