/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.LinearCode;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glycoinfo.GlycanFormatconverter.Glycan.Aglycone;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyContainer;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.io.GlyCoImporterException;
import org.glycoinfo.GlycanFormatconverter.io.LinearCode.LinearCodeLinkageParser;
import org.glycoinfo.GlycanFormatconverter.io.LinearCode.LinearCodeNodeParser;
import org.glycoinfo.GlycanFormatconverter.io.LinearCode.LinearCodeStacker;
import org.glycoinfo.GlycanFormatconverter.util.GlyContainerOptimizer;

public class LinearCodeImporter {
    private LinkedHashMap<LinearCodeStacker, Node> lc2node = new LinkedHashMap();

    public GlyContainer start(String _linearCode) throws GlyCoImporterException, GlycanException {
        int n;
        GlyContainer ret = new GlyContainer();
        HashMap<LinearCodeStacker, LinearCodeStacker> family = new HashMap<LinearCodeStacker, LinearCodeStacker>();
        _linearCode = _linearCode.trim();
        ArrayList<String> notations = new ArrayList<String>();
        String coreNotation = "";
        Aglycone aglycone = new Aglycone(this.extractAglycon(_linearCode));
        ret.setAglycone(aglycone);
        _linearCode = this.modifyFragments(_linearCode);
        if (_linearCode.indexOf("&") != _linearCode.lastIndexOf("&")) {
            String subFragment = _linearCode.substring(_linearCode.indexOf("&"), _linearCode.lastIndexOf("&") + 1);
            coreNotation = _linearCode = _linearCode.replace(subFragment, "");
            subFragment = subFragment.replaceAll("&", "");
            String[] stringArray = subFragment.split(",");
            int n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                String unit = stringArray[n];
                if (unit.matches(".*[A-Z]")) {
                    unit = String.valueOf(unit) + "??=%|";
                }
                if (unit.matches(".*[ab]\\?")) {
                    unit = String.valueOf(unit) + "=%|";
                }
                if (unit.matches(".*[ab]")) {
                    unit = String.valueOf(unit) + "?=%|";
                }
                if (unit.matches(".+[ab?]\\d")) {
                    unit = String.valueOf(unit) + "=%|";
                }
                notations.add(unit);
                ++n;
            }
            Collections.reverse(notations);
        }
        String[] stringArray = _linearCode.split("%\\|");
        n = stringArray.length;
        int n3 = 0;
        while (n3 < n) {
            String unit = stringArray[n3];
            if (unit.matches(".+=\\d")) {
                unit = String.valueOf(unit) + "%|";
                notations.add(unit);
            } else {
                coreNotation = unit;
            }
            ++n3;
        }
        notations.add(coreNotation);
        Collections.reverse(notations);
        for (String fragment : notations) {
            ArrayList<LinearCodeStacker> nodelist = new ArrayList<LinearCodeStacker>();
            for (String unit : this.resolveNotation(fragment)) {
                if (unit.equals("*")) continue;
                LinearCodeStacker lcStacker = new LinearCodeStacker(unit);
                LinearCodeNodeParser nodeParser = new LinearCodeNodeParser();
                this.lc2node.put(lcStacker, nodeParser.start(lcStacker));
                family = this.parseChildren(lcStacker, family);
                nodelist.add(lcStacker);
            }
            LinearCodeLinkageParser lcParser = new LinearCodeLinkageParser(this.lc2node, family);
            ret = lcParser.start(nodelist, ret);
        }
        GlyContainerOptimizer gcOpt = new GlyContainerOptimizer();
        gcOpt.start(ret);
        return ret;
    }

    private HashMap<LinearCodeStacker, LinearCodeStacker> parseChildren(LinearCodeStacker _lcParent, HashMap<LinearCodeStacker, LinearCodeStacker> _family) {
        ArrayList<LinearCodeStacker> nodes = new ArrayList<LinearCodeStacker>();
        nodes.addAll(this.lc2node.keySet());
        if (nodes.size() == 1) {
            return _family;
        }
        Collections.reverse(nodes);
        int childIndex = nodes.indexOf(_lcParent) + 1;
        LinearCodeStacker lcChild = (LinearCodeStacker)nodes.get(childIndex);
        if (this.isRootOfFramgnets(lcChild.getBaseUnit())) {
            _family.put(lcChild, null);
            return _family;
        }
        if (this.haveChild(_lcParent.getBaseUnit())) {
            _family.put(lcChild, _lcParent);
        }
        if (this.isStartOfBranch(_lcParent.getBaseUnit())) {
            _family.put(lcChild, _lcParent);
            for (LinearCodeStacker lc : this.pickChildren(nodes, _lcParent)) {
                _family.put(lc, _lcParent);
            }
        }
        return _family;
    }

    private ArrayList<LinearCodeStacker> pickChildren(ArrayList<LinearCodeStacker> _lcStacks, LinearCodeStacker _branch) {
        ArrayList<LinearCodeStacker> children = new ArrayList<LinearCodeStacker>();
        int count = 0;
        boolean isChild = false;
        if (this.isStartOfBranch(_branch.getBaseUnit())) {
            count = -1;
        }
        for (LinearCodeStacker lcStack : _lcStacks.subList(_lcStacks.indexOf(_branch) + 1, _lcStacks.size())) {
            String notation = lcStack.getBaseUnit();
            if (isChild) {
                children.add(lcStack);
            }
            if (count == 0 && !this.isBisecting(notation) && (this.isStartOfBranch(notation) || this.isEndOfBranch(notation) || this.haveChild(notation))) break;
            if (this.isStartOfBranch(notation)) {
                --count;
            }
            if (this.isEndOfBranch(notation)) {
                ++count;
            }
            if (this.isBisecting(notation)) {
                --count;
            }
            if (count == 0) {
                if (this.isBisecting(notation)) {
                    isChild = true;
                }
                if (!this.isEndOfBranch(notation)) continue;
                isChild = true;
                continue;
            }
            isChild = false;
        }
        return children;
    }

    private String modifyFragments(String _linearCode) {
        if (_linearCode.contains(",") && _linearCode.contains("&")) {
            return _linearCode;
        }
        if (!_linearCode.contains(",") && !_linearCode.contains("&")) {
            return _linearCode;
        }
        boolean isSubstituent = false;
        int fragmentsPos = -1;
        int i = 0;
        while (i < _linearCode.length()) {
            if (_linearCode.charAt(i) == '[') {
                isSubstituent = true;
            }
            if (_linearCode.charAt(i) == ']') {
                isSubstituent = false;
            }
            if (_linearCode.charAt(i) == ',' && !isSubstituent) {
                fragmentsPos = i;
            }
            if (fragmentsPos != -1) break;
            ++i;
        }
        if (fragmentsPos == -1) {
            return _linearCode;
        }
        StringBuilder ret = new StringBuilder(_linearCode);
        ret.replace(fragmentsPos, fragmentsPos + 1, "&");
        ret.append("&");
        return ret.toString();
    }

    private String modifyNotation(String _notation) {
        Matcher matAnchor = Pattern.compile("\\(?(\\d%/?)+\\)?").matcher(_notation);
        if (matAnchor.find()) {
            String temp = matAnchor.group(0);
            if (temp.contains("(") && !temp.contains(")") || !temp.contains("(") && temp.contains(")")) {
                return _notation;
            }
            String replace = temp;
            replace = replace.replace("(", "");
            replace = replace.replace(")", "");
            replace = replace.replace("/", "");
            _notation = _notation.replace(temp, replace);
        }
        return _notation;
    }

    private boolean isBisecting(String _notation) {
        return _notation.endsWith(")");
    }

    private boolean haveChild(String _notation) {
        return _notation.matches("^(\\{[n\\d]+)?([\\d%]+)?[A-Z].*");
    }

    private boolean isStartOfBranch(String _notation) {
        return _notation.startsWith(")");
    }

    private boolean isEndOfBranch(String _notation) {
        return _notation.startsWith("(");
    }

    private boolean isMonosaccharide(String _notation) {
        return _notation.matches("^.*[A-Z]+.*$");
    }

    private boolean isRootOfFramgnets(String _notation) {
        return _notation.lastIndexOf("%|") != -1;
    }

    /*
     * Exception decompiling
     */
    private ArrayList<String> resolveNotation(String _linearCode) throws GlyCoImporterException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String extractAglycon(String _linearCode) {
        if (_linearCode.indexOf(":") != -1) {
            return _linearCode.substring(_linearCode.indexOf(":") + 1);
        }
        if (_linearCode.indexOf(";") != -1) {
            return _linearCode.substring(_linearCode.indexOf(";") + 1);
        }
        if (_linearCode.indexOf("#") != -1) {
            return _linearCode.substring(_linearCode.indexOf("#") + 1);
        }
        return "";
    }
}

