/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin.reporting;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.RepaintManager;
import org.eurocarbdb.application.glycanbuilder.ClipUtils;
import org.eurocarbdb.application.glycanbuilder.GlycanRenderer;
import org.eurocarbdb.application.glycanbuilder.GraphicOptions;
import org.eurocarbdb.application.glycanbuilder.GraphicUtils;
import org.eurocarbdb.application.glycanbuilder.SVGUtils;
import org.eurocarbdb.application.glycoworkbench.GlycoWorkbench;
import org.eurocarbdb.application.glycoworkbench.plugin.reporting.ProfilesComparisonReportDocument;
import org.eurocarbdb.application.glycoworkbench.plugin.reporting.ProfilesComparisonReportOptions;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LevelRenderer;
import org.jfree.chart.renderer.category.ScatterRenderer;
import org.jfree.chart.renderer.category.StatisticalBarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.statistics.DefaultMultiValueCategoryDataset;
import org.jfree.data.statistics.DefaultStatisticalCategoryDataset;
import org.jfree.ui.TextAnchor;

public class ProfilesComparisonReportChartCanvas
extends JComponent
implements SVGUtils.Renderable,
Printable {
    private static final int DRAW_X_MARGIN = 20;
    private static final int DRAW_Y_MARGIN = 20;
    private static final int CHART_X_MARGIN = 20;
    private static final int CHART_Y_MARGIN = 20;
    private static final int CHART_WIDTH = 800;
    private static final int CHART_WIDTH_TICK = 15;
    private static final int CHART_HEIGHT = 600;
    private GlycoWorkbench theApplication;
    private ProfilesComparisonReportDocument theDocument;
    private GlycanRenderer theGlycanRenderer;
    private JScrollPane theScrollPane = null;
    private ProfilesComparisonReportOptions theOptions;
    private GraphicOptions theGraphicOptions;
    private CategoryDataset theDataset;
    private CategoryPlot thePlot;
    private JFreeChart theChart;
    private double scale;
    private boolean is_printing;
    private Rectangle view_area;
    private Rectangle draw_area;
    private Rectangle chart_area;
    private Rectangle2D data_area;

    public ProfilesComparisonReportChartCanvas(GlycoWorkbench application, ProfilesComparisonReportDocument doc, ProfilesComparisonReportOptions opt) {
        this.theApplication = application;
        this.theDocument = doc;
        this.theOptions = opt;
        this.theGraphicOptions = this.theApplication.getWorkspace().getGraphicOptions();
        this.theGlycanRenderer = this.theApplication.getWorkspace().getGlycanRenderer();
        this.createChart();
        this.is_printing = false;
        this.setScale(1.0);
    }

    public void setScrollPane(JScrollPane sp) {
        this.theScrollPane = sp;
    }

    public void beforeRendering() {
        this.is_printing = true;
    }

    public void afterRendering() {
        this.is_printing = false;
    }

    public Dimension getRenderableSize() {
        return this.getPreferredSize();
    }

    public void paintRenderable(Graphics2D g2d) {
        this.paintComponent(g2d);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.is_printing) {
            g2d.translate(-this.draw_area.x, -this.draw_area.y);
            g2d.setClip(this.draw_area);
        }
        if (!this.is_printing) {
            g2d.setColor(this.getBackground());
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        g2d.setColor(Color.white);
        g2d.fillRect(this.draw_area.x, this.draw_area.y, this.draw_area.width, this.draw_area.height);
        if (!this.is_printing) {
            g2d.setColor(Color.black);
            g2d.draw(this.draw_area);
        }
        this.paintChart(g2d);
        g2d.dispose();
        this.revalidate();
    }

    protected void paintChart(Graphics2D g2d) {
        ChartRenderingInfo cri = new ChartRenderingInfo();
        this.theChart.draw(g2d, (Rectangle2D)this.chart_area, cri);
        this.data_area = cri.getPlotInfo().getDataArea();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.is_printing) {
            return this.draw_area.getSize();
        }
        return this.view_area.getSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public void print(PrinterJob job) throws PrinterException {
        this.is_printing = true;
        job.print();
        this.is_printing = false;
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setBackground(Color.white);
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        Dimension td = this.getPreferredSize();
        double sx = pageFormat.getImageableWidth() / (double)td.width;
        double sy = pageFormat.getImageableHeight() / (double)td.height;
        double s = Math.min(sx, sy);
        if (s < 1.0) {
            g2d.scale(s, s);
        }
        RepaintManager.currentManager(this).setDoubleBufferingEnabled(false);
        this.paint(g2d);
        RepaintManager.currentManager(this).setDoubleBufferingEnabled(true);
        return 0;
    }

    public void setScale(double scale) {
        this.scale = scale;
        this.updateView();
    }

    public double getScale() {
        return this.scale;
    }

    public void getScreenshot() {
        ClipUtils.setContents((BufferedImage)SVGUtils.getImage((SVGUtils.Renderable)this));
    }

    public void updateView() {
        this.updateDrawArea();
        this.repaint();
    }

    private void createChart() {
        this.theDataset = this.createDataset();
        CategoryAxis categoryAxis = new CategoryAxis("");
        categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        NumberAxis valueAxis = new NumberAxis("Normalized Intensities");
        BarRenderer renderer = null;
        if (this.theOptions.REPRESENTATION == 2) {
            renderer = new BarRenderer();
        } else if (this.theOptions.REPRESENTATION == 3) {
            renderer = new StatisticalBarRenderer();
        } else if (this.theOptions.REPRESENTATION == 4) {
            renderer = new ScatterRenderer();
        }
        ItemLabelPosition position1 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BOTTOM_CENTER);
        renderer.setBasePositiveItemLabelPosition(position1);
        ItemLabelPosition position2 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE6, TextAnchor.TOP_CENTER);
        renderer.setBaseNegativeItemLabelPosition(position2);
        this.thePlot = new CategoryPlot(this.theDataset, categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        this.thePlot.setOrientation(PlotOrientation.VERTICAL);
        if (this.theOptions.REPRESENTATION == 4) {
            this.thePlot.setDataset(1, this.createMeansDataset());
            this.thePlot.mapDatasetToRangeAxis(1, 0);
            LevelRenderer lr = new LevelRenderer();
            lr.setPaint((Paint)Color.black);
            this.thePlot.setRenderer(1, (CategoryItemRenderer)lr);
        }
        this.theChart = new JFreeChart("", JFreeChart.DEFAULT_TITLE_FONT, (Plot)this.thePlot, true);
        this.theChart.setBackgroundPaint((Paint)Color.white);
        this.theChart.setBorderVisible(false);
    }

    private CategoryDataset createDataset() {
        GlycanRenderer theRenderer = this.theApplication.getWorkspace().getGlycanRenderer();
        if (this.theOptions.REPRESENTATION == 2) {
            DefaultCategoryDataset ret = new DefaultCategoryDataset();
            for (ProfilesComparisonReportDocument.Row row : this.theDocument.getRows()) {
                for (int i = 0; i < this.theDocument.getNoColumns(); ++i) {
                    ret.addValue(row.getColumn(i), (Comparable)((Object)this.theDocument.getNames().get(i)), (Comparable)((Object)row.name));
                }
            }
            return ret;
        }
        if (this.theOptions.REPRESENTATION == 3) {
            DefaultStatisticalCategoryDataset ret = new DefaultStatisticalCategoryDataset();
            for (ProfilesComparisonReportDocument.Row row : this.theDocument.getRows()) {
                ret.add(this.mean(row.intensities_firstgroup), this.stddev(row.intensities_firstgroup), (Comparable)((Object)"First group"), (Comparable)((Object)row.name));
                ret.add(this.mean(row.intensities_secondgroup), this.stddev(row.intensities_secondgroup), (Comparable)((Object)"Second group"), (Comparable)((Object)row.name));
            }
            return ret;
        }
        if (this.theOptions.REPRESENTATION == 4) {
            DefaultMultiValueCategoryDataset ret = new DefaultMultiValueCategoryDataset();
            for (ProfilesComparisonReportDocument.Row row : this.theDocument.getRows()) {
                ret.add(this.tolist(row.intensities_firstgroup), (Comparable)((Object)"First group"), (Comparable)((Object)row.name));
                ret.add(this.tolist(row.intensities_secondgroup), (Comparable)((Object)"Second group"), (Comparable)((Object)row.name));
            }
            return ret;
        }
        return null;
    }

    private CategoryDataset createMeansDataset() {
        GlycanRenderer theRenderer = this.theApplication.getWorkspace().getGlycanRenderer();
        DefaultCategoryDataset ret = new DefaultCategoryDataset();
        for (ProfilesComparisonReportDocument.Row row : this.theDocument.getRows()) {
            ret.addValue(this.mean(row.intensities_firstgroup), (Comparable)((Object)"First group"), (Comparable)((Object)row.name));
            ret.addValue(this.mean(row.intensities_secondgroup), (Comparable)((Object)"Second group"), (Comparable)((Object)row.name));
        }
        return ret;
    }

    private ArrayList<Double> tolist(double[] array) {
        ArrayList<Double> ret = new ArrayList<Double>();
        for (double d : array) {
            ret.add(d);
        }
        return ret;
    }

    private ArrayList<Double> tolist(double value) {
        ArrayList<Double> ret = new ArrayList<Double>();
        ret.add(value);
        return ret;
    }

    private double mean(double[] array) {
        if (array == null || array.length == 0) {
            return 0.0;
        }
        double mean = 0.0;
        for (int i = 0; i < array.length; ++i) {
            mean += array[i];
        }
        return mean / (double)array.length;
    }

    private double stddev(double[] array) {
        if (array == null || array.length == 0) {
            return 0.0;
        }
        double mean = this.mean(array);
        double smean = 0.0;
        for (int i = 0; i < array.length; ++i) {
            smean += array[i] * array[i];
        }
        return Math.sqrt(smean / (double)array.length - mean * mean);
    }

    private Rectangle getViewArea(double scale) {
        int chart_width = Math.max(800, 15 * this.theDocument.getNoRows());
        return new Rectangle(0, 0, (int)(40.0 + scale * (double)(40 + chart_width)), (int)(40.0 + scale * 640.0));
    }

    private Rectangle getDrawArea(double scale) {
        int chart_width = Math.max(800, 15 * this.theDocument.getNoRows());
        return new Rectangle(20, 20, (int)(scale * (double)(40 + chart_width)), (int)(scale * 640.0));
    }

    private Rectangle getChartArea(double scale) {
        int chart_width = Math.max(800, 15 * this.theDocument.getNoRows());
        return new Rectangle((int)(20.0 + scale * 20.0), (int)(20.0 + scale * 20.0), (int)(scale * (double)chart_width), (int)(scale * 600.0));
    }

    protected void updateDrawArea() {
        this.view_area = this.getViewArea(this.scale);
        this.draw_area = this.getDrawArea(this.scale);
        this.chart_area = this.getChartArea(this.scale);
        this.data_area = null;
        this.paintChart(GraphicUtils.createImage((Dimension)this.view_area.getSize(), (boolean)true).createGraphics());
    }
}

