/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin.peakpicker;

import java.util.Arrays;
import org.eurocarbdb.application.glycoworkbench.Peak;
import org.eurocarbdb.application.glycoworkbench.plugin.peakpicker.SignalToNoiseEstimator;

public class SignalToNoiseEstimatorMedian
extends SignalToNoiseEstimator {
    public static final int MANUAL = -1;
    public static final int AUTOMAXBYSTDEV = 0;
    public static final int AUTOMAXBYPERCENT = 1;
    private double max_intensity_;
    private double auto_max_stdev_factor_;
    private double auto_max_percentile_;
    private int auto_mode_;
    private double win_len_;
    private int bin_count_;
    private int min_required_elements_;
    private double noise_for_empty_window_;

    public SignalToNoiseEstimatorMedian() {
        this.setName("SignalToNoiseEstimatorMedian");
        this.defaults_.setValue("MaxIntensity", -1.0, "maximal intensity considered for histogram construction. By default, it will be calculated automatically (see AutoMode). Only provide this parameter if you know what you are doing (and change 'AutoMode' to '-1')! All intensities EQUAL/ABOVE 'MaxIntensity' will be added to the LAST histogram bin. If you choose 'MaxIntensity' too small, the noise estimate might be too small as well.  If chosen too big, the bins become quite large (which you could counter by increasing 'BinCount', which increases runtime). In general, the Median-S/N estimator is more robust to a manual MaxIntensity than the MeanIterative-S/N.");
        this.defaults_.setValue("AutoMaxStdevFactor", 3.0, "parameter for 'MaxIntensity' estimation (if 'AutoMode' == 0): mean + 'AutoMaxStdevFactor' * stdev");
        this.defaults_.setValue("AutoMaxPercentile", 95, "parameter for 'MaxIntensity' estimation (if 'AutoMode' == 1): AutoMaxPercentile th percentile");
        this.defaults_.setValue("AutoMode", 0, "method to use to determine maximal intensity: -1 --> use 'MaxIntensity'; 0 --> 'AutoMaxStdevFactor' method (default); 1 --> 'AutoMaxPercentile' method");
        this.defaults_.setValue("WinLen", 200.0, "window length in Thomson");
        this.defaults_.setValue("BinCount", 30, "number of bins used for histogram");
        this.defaults_.setValue("MinRequiredElements", 10, "minimum number of elements required in a window (otherwise it is considered sparse)");
        this.defaults_.setValue("NoiseForEmptyWindow", Math.pow(10.0, 20.0), "noise value used for sparse windows");
        this.defaultsToParam_();
    }

    @Override
    protected void updateMembers_() {
        this.max_intensity_ = (Double)this.param_.getValue("MaxIntensity");
        this.auto_max_stdev_factor_ = (Double)this.param_.getValue("AutoMaxStdevFactor");
        this.auto_max_percentile_ = ((Integer)this.param_.getValue("AutoMaxPercentile")).intValue();
        this.auto_mode_ = (Integer)this.param_.getValue("AutoMode");
        this.win_len_ = (Double)this.param_.getValue("WinLen");
        this.bin_count_ = (Integer)this.param_.getValue("BinCount");
        this.min_required_elements_ = (Integer)this.param_.getValue("MinRequiredElements");
        this.noise_for_empty_window_ = (Double)this.param_.getValue("NoiseForEmptyWindow");
        this.is_result_valid_ = false;
    }

    @Override
    public double getMaxIntensity() {
        return this.max_intensity_;
    }

    @Override
    public void setMaxIntensity(double max_intensity) {
        this.max_intensity_ = max_intensity;
        this.param_.setValue("MaxIntensity", this.max_intensity_);
    }

    @Override
    public double getAutoMaxStdevFactor() {
        return this.auto_max_stdev_factor_;
    }

    @Override
    public void setAutoMaxStdevFactor(double value) {
        this.auto_max_stdev_factor_ = value;
        this.param_.setValue("AutoMaxStdevFactor", this.auto_max_stdev_factor_);
    }

    @Override
    public double getAutoMaxPercentile() {
        return this.auto_max_percentile_;
    }

    @Override
    public void setAutoMaxPercentile(double value) {
        this.auto_max_percentile_ = value;
        this.param_.setValue("AutoMaxPercentile", this.auto_max_percentile_);
    }

    @Override
    public int getAutoMode() {
        return this.auto_mode_;
    }

    @Override
    public void setAutoMode(int auto_mode) {
        this.auto_mode_ = auto_mode;
        this.param_.setValue("AutoMode", this.auto_mode_);
    }

    @Override
    public double getWinLen() {
        return this.win_len_;
    }

    @Override
    public void setWinLen(double win_len) {
        this.win_len_ = win_len;
        this.param_.setValue("WinLen", this.win_len_);
    }

    @Override
    public int getBinCount() {
        return this.bin_count_;
    }

    @Override
    public void setBinCount(int bin_count) {
        this.bin_count_ = bin_count;
        this.param_.setValue("BinCount", this.bin_count_);
    }

    @Override
    public int getMinReqElements() {
        return this.min_required_elements_;
    }

    @Override
    public void setMinReqElements(int min_required_elements) {
        this.min_required_elements_ = min_required_elements;
        this.param_.setValue("MinRequiredElements", this.min_required_elements_);
    }

    @Override
    public double getNoiseForEmptyWindow() {
        return this.noise_for_empty_window_;
    }

    @Override
    public void setNoiseForEmptyWindow(double noise_for_empty_window) {
        this.noise_for_empty_window_ = noise_for_empty_window;
        this.param_.setValue("NoiseForEmptyWindow", this.noise_for_empty_window_);
    }

    @Override
    protected void computeSTN_(Peak[] data_, int scan_first_, int scan_last_) throws Exception {
        double bin_size;
        double sparse_window_percent = 0.0;
        double histogram_oob_percent = 0.0;
        this.stn_estimates_.clear();
        if (this.auto_mode_ == 0) {
            SignalToNoiseEstimator.GaussianEstimate gauss_global = SignalToNoiseEstimatorMedian.estimate_(data_, scan_first_, scan_last_);
            this.max_intensity_ = gauss_global.mean + Math.sqrt(gauss_global.variance) * this.auto_max_stdev_factor_;
        } else if (this.auto_mode_ == 1) {
            int run;
            if (this.auto_max_percentile_ < 0.0 || this.auto_max_percentile_ > 100.0) {
                String s = "" + this.auto_max_percentile_;
                throw new Exception("AutoMode is on AUTOMAXBYPERCENT! AutoMaxPercentile is not in [0,100]. Use setAutoMaxPercentile(<value>) to change it!");
            }
            int[] histogram_auto = new int[100];
            Arrays.fill(histogram_auto, 0);
            int size = 0;
            double maxInt = 0.0;
            for (run = scan_first_; run != scan_last_; ++run) {
                maxInt = Math.max(maxInt, data_[run].getIntensity());
                ++size;
            }
            bin_size = maxInt / 100.0;
            for (run = scan_first_; run != scan_last_; ++run) {
                int n = (int)((data_[run].getIntensity() - 1.0) / bin_size);
                histogram_auto[n] = histogram_auto[n] + 1;
            }
            int elements_below_percentile = (int)(this.auto_max_percentile_ * (double)size / 100.0);
            int elements_seen = 0;
            int i = -1;
            for (run = scan_first_; run != scan_last_ && elements_seen < elements_below_percentile; elements_seen += histogram_auto[++i], ++run) {
            }
            this.max_intensity_ = ((double)i + 0.5) * bin_size;
        } else if (this.max_intensity_ <= 0.0) {
            String s = "" + this.max_intensity_;
            throw new Exception("AutoMode is on MANUAL! MaxIntensity is <=0. Needs to be positive! Use setMaxIntensity(<value>) or enable AutoMode!");
        }
        if (this.max_intensity_ <= 0.0) {
            System.err.println("TODO SignalToNoiseEstimatorMedian: the max_intensity_ value should be positive! " + this.max_intensity_);
            return;
        }
        int window_pos_center = scan_first_;
        int window_pos_borderleft = scan_first_;
        int window_pos_borderright = scan_first_;
        double window_half_size = this.win_len_ / 2.0;
        bin_size = this.max_intensity_ / (double)this.bin_count_;
        int bin_count_minus_1 = this.bin_count_ - 1;
        int[] histogram = new int[this.bin_count_];
        Arrays.fill(histogram, 0);
        double[] bin_value = new double[this.bin_count_];
        Arrays.fill(bin_value, 0.0);
        for (int bin = 0; bin < this.bin_count_; ++bin) {
            histogram[bin] = 0;
            bin_value[bin] = ((double)bin + 0.5) * bin_size;
        }
        int to_bin = 0;
        int median_bin = 0;
        int element_inc_count = 0;
        int elements_in_window = 0;
        int window_count = 0;
        int element_in_window_half = 0;
        int windows_overall = 0;
        for (int run = scan_first_; run != scan_last_; ++run) {
            ++windows_overall;
        }
        while (window_pos_center != scan_last_) {
            double noise;
            while (data_[window_pos_borderleft].getMZ() < data_[window_pos_center].getMZ() - window_half_size) {
                int n = to_bin = Math.min((int)(data_[window_pos_borderleft].getIntensity() / bin_size), bin_count_minus_1);
                histogram[n] = histogram[n] - 1;
                --elements_in_window;
                ++window_pos_borderleft;
            }
            while (window_pos_borderright != scan_last_ && data_[window_pos_borderright].getMZ() <= data_[window_pos_center].getMZ() + window_half_size) {
                int n = to_bin = Math.min((int)(data_[window_pos_borderright].getIntensity() / bin_size), bin_count_minus_1);
                histogram[n] = histogram[n] + 1;
                ++elements_in_window;
                ++window_pos_borderright;
            }
            if (elements_in_window < this.min_required_elements_) {
                noise = this.noise_for_empty_window_;
                sparse_window_percent += 1.0;
            } else {
                median_bin = -1;
                element_in_window_half = (elements_in_window + 1) / 2;
                for (element_inc_count = 0; median_bin < bin_count_minus_1 && element_inc_count < element_in_window_half; element_inc_count += histogram[++median_bin]) {
                }
                if (median_bin == bin_count_minus_1) {
                    histogram_oob_percent += 1.0;
                }
                noise = Math.max(1.0, bin_value[median_bin]);
            }
            this.stn_estimates_.put(data_[window_pos_center], data_[window_pos_center].getIntensity() / noise);
            ++window_pos_center;
            ++window_count;
        }
        sparse_window_percent = sparse_window_percent * 100.0 / (double)window_count;
        histogram_oob_percent = histogram_oob_percent * 100.0 / (double)window_count;
        if (sparse_window_percent > 20.0) {
            System.err.println("WARNING in SignalToNoiseEstimatorMedian: " + sparse_window_percent + "% of all windows were sparse. You should consider increasing WindowLength or decreasing MinReqElementsInWindow");
        }
        if (histogram_oob_percent > 1.0) {
            System.err.println("WARNING in SignalToNoiseEstimatorMedian: " + histogram_oob_percent + "% of all Signal-to-Noise estimates are too high, because the median was found in the rightmost histogram-bin. " + "You should consider increasing MaxIntensity (and maybe BinCount with it, to keep bin width reasonable)");
        }
    }
}

