/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin.peakpicker;

import org.eurocarbdb.application.glycoworkbench.plugin.peakpicker.SmoothFilter;

public class GaussFilter
extends SmoothFilter {
    protected double sigma_;
    protected double spacing_;

    public GaussFilter() {
        this.setName("GaussFilter");
        this.defaults_.setValue("gaussian_width", 0.8, "Use a gaussian filter kernel which has approximately the same width as your mass peaks");
        this.sigma_ = 0.1;
        this.spacing_ = 0.01;
        this.init(this.sigma_, this.spacing_);
        this.defaultsToParam_();
    }

    public double getSigma() {
        return this.sigma_;
    }

    public void setSigma(double sigma) {
        this.sigma_ = sigma;
        this.spacing_ = 4.0 * this.sigma_ / 50.0;
        this.init(this.sigma_, this.spacing_);
        this.param_.setValue("gaussian_width", 8.0 * this.sigma_);
    }

    public double getKernelWidth() {
        return this.sigma_ * 8.0;
    }

    public void setKernelWidth(double kernel_width) throws Exception {
        if (kernel_width <= 0.0) {
            throw new Exception("The kernel width should be greater than zero! " + kernel_width);
        }
        this.sigma_ = kernel_width / 8.0;
        this.init(this.sigma_, this.spacing_);
        this.param_.setValue("gaussian_width", kernel_width);
    }

    public double getSpacing() {
        return this.spacing_;
    }

    public void setSpacing(double spacing) {
        this.spacing_ = spacing;
        this.init(this.sigma_, this.spacing_);
    }

    public void init(double sigma, double spacing) {
        this.sigma_ = sigma;
        this.spacing_ = spacing;
        int number_of_points_right = (int)Math.ceil(4.0 * this.sigma_ / this.spacing_) + 1;
        this.coeffs_ = new double[number_of_points_right];
        this.coeffs_[0] = 1.0 / (this.sigma_ * Math.sqrt(Math.PI * 2));
        for (int i = 1; i < number_of_points_right; ++i) {
            this.coeffs_[i] = this.gauss_((double)i * this.spacing_);
        }
    }

    @Override
    public double[][] filter(double[][] data, int first, int last) {
        double[][] ret = new double[][]{new double[last - first], new double[last - first]};
        int out_it = 0;
        for (int help = first; help != last; ++help) {
            ret[0][out_it] = data[0][help];
            ret[1][out_it] = this.integrate_(data, help, first, last);
            ++out_it;
        }
        return ret;
    }

    @Override
    public double[][] filter(double[][] data) {
        return this.filter(data, 0, data[0].length);
    }

    @Override
    protected void updateMembers_() {
        double kernel_width = (Double)this.param_.getValue("gaussian_width");
        this.sigma_ = kernel_width / 8.0;
        this.init(this.sigma_, this.spacing_);
    }

    private double gauss_(double x) {
        return 1.0 / (this.sigma_ * Math.sqrt(Math.PI * 2)) * Math.exp(-(x * x) / (2.0 * this.sigma_ * this.sigma_));
    }

    private double integrate_(double[][] data, int x, int first, int last) {
        double d;
        int right_position;
        int j;
        int left_position;
        double distance_in_gaussian;
        int help;
        double v = 0.0;
        double norm = 0.0;
        int middle = this.coeffs_.length;
        double start_pos = data[0][x] - (double)middle * this.spacing_ > data[0][first] ? data[0][x] - (double)middle * this.spacing_ : data[0][first];
        double end_pos = data[0][x] + (double)middle * this.spacing_ < data[0][last - 1] ? data[0][x] + (double)middle * this.spacing_ : data[0][last - 1];
        for (help = x; help != first && data[0][help - 1] > start_pos; --help) {
            distance_in_gaussian = Math.abs(data[0][x] - data[0][help]);
            left_position = (int)Math.floor(distance_in_gaussian / this.spacing_);
            for (j = 0; j < 3 && help - j - first >= 0; ++j) {
                if ((double)(left_position - j) * this.spacing_ <= distance_in_gaussian && (double)(left_position - j + 1) * this.spacing_ >= distance_in_gaussian) {
                    left_position -= j;
                    break;
                }
                if (!((double)(left_position + j) * this.spacing_ < distance_in_gaussian) || !((double)(left_position + j + 1) * this.spacing_ < distance_in_gaussian)) continue;
                left_position += j;
                break;
            }
            right_position = left_position + 1;
            d = Math.abs((double)left_position * this.spacing_ - distance_in_gaussian) / this.spacing_;
            double coeffs_right = right_position < middle ? (1.0 - d) * this.coeffs_[left_position] + d * this.coeffs_[right_position] : this.coeffs_[left_position];
            distance_in_gaussian = Math.abs(data[0][x] - data[0][help - 1]);
            left_position = (int)Math.floor(distance_in_gaussian / this.spacing_);
            for (int j2 = 0; j2 < 3 && help - j2 - first >= 0; ++j2) {
                if ((double)(left_position - j2) * this.spacing_ <= distance_in_gaussian && (double)(left_position - j2 + 1) * this.spacing_ >= distance_in_gaussian) {
                    left_position -= j2;
                    break;
                }
                if (!((double)(left_position + j2) * this.spacing_ < distance_in_gaussian) || !((double)(left_position + j2 + 1) * this.spacing_ < distance_in_gaussian)) continue;
                left_position += j2;
                break;
            }
            right_position = left_position + 1;
            d = Math.abs((double)left_position * this.spacing_ - distance_in_gaussian) / this.spacing_;
            double coeffs_left = right_position < middle ? (1.0 - d) * this.coeffs_[left_position] + d * this.coeffs_[right_position] : this.coeffs_[left_position];
            norm += Math.abs(data[0][help - 1] - data[0][help]) / 2.0 * (coeffs_left + coeffs_right);
            v += Math.abs(data[0][help - 1] - data[0][help]) / 2.0 * (data[1][help - 1] * coeffs_left + data[1][help] * coeffs_right);
        }
        for (help = x; help != last - 1 && data[0][help + 1] < end_pos; ++help) {
            distance_in_gaussian = Math.abs(data[0][x] - data[0][help]);
            left_position = (int)Math.floor(distance_in_gaussian / this.spacing_);
            for (j = 0; j < 3 && last - 1 - help - j >= 0; ++j) {
                if ((double)(left_position - j) * this.spacing_ <= distance_in_gaussian && (double)(left_position - j + 1) * this.spacing_ >= distance_in_gaussian) {
                    left_position -= j;
                    break;
                }
                if (!((double)(left_position + j) * this.spacing_ < distance_in_gaussian) || !((double)(left_position + j + 1) * this.spacing_ < distance_in_gaussian)) continue;
                left_position += j;
                break;
            }
            right_position = left_position + 1;
            d = Math.abs((double)left_position * this.spacing_ - distance_in_gaussian) / this.spacing_;
            double coeffs_left = right_position < middle ? (1.0 - d) * this.coeffs_[left_position] + d * this.coeffs_[right_position] : this.coeffs_[left_position];
            distance_in_gaussian = Math.abs(data[0][x] - data[0][help + 1]);
            left_position = (int)Math.floor(distance_in_gaussian / this.spacing_);
            for (int j3 = 0; j3 < 3 && last - 1 - help - j3 >= 0; ++j3) {
                if ((double)(left_position - j3) * this.spacing_ <= distance_in_gaussian && (double)(left_position - j3 + 1) * this.spacing_ >= distance_in_gaussian) {
                    left_position -= j3;
                    break;
                }
                if (!((double)(left_position + j3) * this.spacing_ < distance_in_gaussian) || !((double)(left_position + j3 + 1) * this.spacing_ < distance_in_gaussian)) continue;
                left_position += j3;
                break;
            }
            right_position = left_position + 1;
            d = Math.abs((double)left_position * this.spacing_ - distance_in_gaussian) / this.spacing_;
            double coeffs_right = right_position < middle ? (1.0 - d) * this.coeffs_[left_position] + d * this.coeffs_[right_position] : this.coeffs_[left_position];
            norm += Math.abs(data[0][help] - data[0][help + 1]) / 2.0 * (coeffs_left + coeffs_right);
            v += Math.abs(data[0][help] - data[0][help + 1]) / 2.0 * (data[1][help] * coeffs_left + data[1][help + 1] * coeffs_right);
        }
        if (v > 0.0) {
            return v / norm;
        }
        return 0.0;
    }
}

