/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.filechooser.FileFilter;
import org.eurocarbdb.application.glycanbuilder.BaseDocument;
import org.eurocarbdb.application.glycanbuilder.ExtensionFileFilter;
import org.eurocarbdb.application.glycanbuilder.FileUtils;
import org.eurocarbdb.application.glycanbuilder.FragmentCollection;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycanBuilder;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.SAXUtils;
import org.eurocarbdb.application.glycanbuilder.XMLUtils;
import org.eurocarbdb.application.glycoworkbench.GlycoWorkbench;
import org.eurocarbdb.application.glycoworkbench.plugin.ProfilerOptions;
import org.eurocarbdb.application.glycoworkbench.plugin.StructureScorer;
import org.eurocarbdb.application.glycoworkbench.plugin.StructureType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StructureDictionary
extends BaseDocument {
    private boolean on_file_system = false;
    private String dictionary_name = "";
    private StructureScorer theScorer = null;
    private TreeMap<String, StructureType> dictionary = new TreeMap();
    private boolean isWggds = false;
    private String uri;
    private boolean liveSearch = false;
    private String sourceFile = "";
    private boolean isGlycoWorkbenchResource = false;
    private boolean hasBeenSynced = false;
    private boolean fireDocumentChanged = false;

    public StructureDictionary(String _name) {
        super(false);
        this.dictionary_name = _name;
    }

    public StructureDictionary(String _filename, boolean _on_file_system, StructureScorer scorer) throws Exception {
        super(false);
        this.load(_filename, _on_file_system, scorer);
    }

    public StructureDictionary(InputStream is, StructureScorer scorer) throws Exception {
        super(false);
        this.load(is, scorer);
    }

    public StructureDictionary() {
    }

    public int size() {
        return this.dictionary.size();
    }

    public String getName() {
        return "StructureDictionary";
    }

    public String getDictionaryName() {
        return this.dictionary_name;
    }

    public void setDictionaryName(String n) {
        this.dictionary_name = n;
    }

    public Collection<FileFilter> getFileFormats() {
        Vector<FileFilter> filters = new Vector<FileFilter>();
        filters.add((FileFilter)new ExtensionFileFilter(new String[]{"gwd"}, "GlycoWorkbench dictionary file"));
        return filters;
    }

    public FileFilter getAllFileFormats() {
        return new ExtensionFileFilter(new String[]{"gwd"}, "GlycoWorkbench dictionary file");
    }

    public void initData() {
        this.on_file_system = false;
        this.theScorer = null;
        this.dictionary = new TreeMap();
    }

    public void clear() {
        this.dictionary = new TreeMap();
    }

    public boolean isOnFileSystem() {
        return this.on_file_system;
    }

    public Iterator<StructureType> iterator() {
        return this.dictionary.values().iterator();
    }

    public Collection<StructureType> getStructureTypes() {
        return this.dictionary.values();
    }

    public StructureScorer getScorer() {
        return this.theScorer;
    }

    public void setScorer(StructureScorer scorer) {
        this.theScorer = scorer;
    }

    private boolean removePVT(StructureType st) {
        if (this.dictionary.containsValue(st)) {
            this.dictionary.remove(st.getStructure());
            return true;
        }
        return false;
    }

    public boolean remove(StructureType st) {
        if (this.removePVT(st)) {
            this.fireDocumentChanged();
            return true;
        }
        return false;
    }

    public boolean removeAll(Collection<StructureType> sts) {
        boolean removed = false;
        for (StructureType st : sts) {
            if (!this.removePVT(st)) continue;
            removed = true;
        }
        if (removed) {
            this.fireDocumentChanged();
            return true;
        }
        return false;
    }

    public boolean setType(StructureType st, String type) {
        if (this.dictionary.containsValue(st)) {
            st.setType(type);
            this.fireDocumentChanged();
            return true;
        }
        return false;
    }

    public boolean setSource(StructureType st, String source) {
        if (this.dictionary.containsValue(st)) {
            st.setSource(source);
            this.fireDocumentChanged();
            return true;
        }
        return false;
    }

    private boolean addPVT(StructureType st) {
        if (st == null) {
            return false;
        }
        StructureType old = this.dictionary.get(st.getStructure());
        if (old == null) {
            this.dictionary.put(st.getStructure(), st);
            return true;
        }
        return old.merge(st);
    }

    public boolean add(StructureType st) {
        if (st != null && this.addPVT(st.clone(this.dictionary_name))) {
            this.fireDocumentChanged();
            return true;
        }
        return false;
    }

    public boolean addAll(Collection<StructureType> sts) {
        boolean added = false;
        for (StructureType st : sts) {
            if (!this.addPVT(st.clone(this.dictionary_name))) continue;
            added = true;
        }
        if (added) {
            this.fireDocumentChanged();
            return true;
        }
        return false;
    }

    public boolean addAll(Collection<Glycan> gs, String type, String source) {
        boolean added = false;
        for (Glycan g : gs) {
            if (!this.addPVT(new StructureType(this.dictionary_name, type, source, g.toString()))) continue;
            added = true;
        }
        if (added) {
            this.fireDocumentChanged();
            return true;
        }
        return false;
    }

    public FragmentCollection generateStructures(ProfilerOptions opt) throws Exception {
        FragmentCollection fc = new FragmentCollection();
        this.generateStructures(fc, opt);
        return fc;
    }

    public void generateStructures(FragmentCollection fc, ProfilerOptions opt) throws Exception {
        for (StructureType st : this.dictionary.values()) {
            fc.addFragment(st.generateStructure(opt), st.getDescription());
        }
    }

    public boolean open(File file, boolean merge, boolean warning) {
        return this.load(file.getAbsolutePath(), true, null);
    }

    public boolean load(String _filename, boolean _on_file_system, StructureScorer scorer) {
        try {
            this.load(FileUtils.open(((Object)((Object)this)).getClass(), (String)_filename, (!_on_file_system ? 1 : 0) != 0), scorer);
            this.on_file_system = _on_file_system;
            this.setFilename(_filename);
            this.fireDocumentInit();
            return true;
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
            return false;
        }
    }

    private void load(InputStream is, StructureScorer scorer) throws Exception {
        this.read(is, false);
    }

    public boolean save() {
        return this.save(this.filename);
    }

    public boolean save(String _filename) {
        if (!this.on_file_system && this.isGlycoWorkbenchResource) {
            try {
                File dictConfigDir = GlycoWorkbench.getDictionaryConfigurationDirectory();
                File fileName = new File(dictConfigDir.getPath() + File.separator + new File(_filename).getName());
                FileUtils.copy((InputStream)GlycanBuilder.class.getResource(_filename).openStream(), (File)fileName);
                this.setSourceFile(_filename);
                _filename = fileName.getPath();
                this.on_file_system = true;
                this.isGlycoWorkbenchResource = false;
            }
            catch (Exception e) {
                LogUtils.report((Exception)e);
                return false;
            }
        }
        try {
            File tmpfile = File.createTempFile("gwb", null);
            this.write(new FileOutputStream(tmpfile));
            FileUtils.copy((File)tmpfile, (File)new File(_filename));
            tmpfile.delete();
            this.on_file_system = true;
            this.setFilename(_filename);
            this.fireDocumentInit();
            return true;
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
            return false;
        }
    }

    public void write(OutputStream os) throws Exception {
        Document d = XMLUtils.newDocument();
        d.appendChild(this.toXML(d));
        XMLUtils.write((OutputStream)os, (Document)d);
    }

    public String toString() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Document document = XMLUtils.newDocument();
        document.appendChild(this.toXML(document));
        XMLUtils.write((OutputStream)bos, (Document)document);
        return bos.toString();
    }

    public void fromString(String str, boolean merge) throws Exception {
        ByteArrayInputStream bis = new ByteArrayInputStream(str.getBytes());
        this.read(bis, merge);
    }

    protected void read(InputStream is, boolean merge) throws Exception {
        SAXUtils.read((InputStream)is, (DefaultHandler)((Object)new SAXHandler(this, merge)));
    }

    public static StructureDictionary fromXML(Node d_node, StructureScorer scorer) throws Exception {
        StructureDictionary ret = new StructureDictionary("");
        ret.fromXML(d_node, false, scorer);
        return ret;
    }

    public void fromXML(Node d_node, boolean merge, StructureScorer scorer) throws Exception {
        Node s_node;
        String uri;
        if (!merge) {
            this.dictionary.clear();
        }
        this.dictionary_name = XMLUtils.getAttribute((Node)d_node, (String)"name");
        if (this.dictionary_name == null) {
            this.dictionary_name = "";
        }
        if ((uri = XMLUtils.getAttribute((Node)d_node, (String)"uri")) != null) {
            this.setUri(uri);
        }
        this.setSourceFile(XMLUtils.getAttribute((Node)d_node, (String)"source_file"));
        String liveSearch = XMLUtils.getAttribute((Node)d_node, (String)"liveSearch");
        if (liveSearch != null) {
            this.liveSearch = Boolean.parseBoolean(liveSearch);
        }
        if (scorer != null && (s_node = XMLUtils.findChild((Node)d_node, (String)scorer.getScorerType())) != null) {
            this.theScorer = scorer.fromXML(s_node);
        }
        Vector st_nodes = XMLUtils.findAllChildren((Node)d_node, (String)"StructureType");
        for (Node st_node : st_nodes) {
            StructureType st = StructureType.fromXML(st_node);
            if (st == null) continue;
            this.dictionary.put(st.getStructure(), st);
        }
    }

    public Element toXML(Document document) {
        if (document == null) {
            return null;
        }
        Element d_node = document.createElement("StructureDictionary");
        if (d_node == null) {
            return null;
        }
        d_node.setAttribute("name", this.dictionary_name);
        d_node.setAttribute("uri", this.uri);
        d_node.setAttribute("liveSearch", Boolean.toString(this.liveSearch));
        d_node.setAttribute("source_file", this.getSourceFile());
        if (this.theScorer != null) {
            d_node.appendChild(this.theScorer.toXML(document));
        }
        for (StructureType st : this.dictionary.values()) {
            Element st_node = st.toXML(document);
            if (st_node == null) continue;
            d_node.appendChild(st_node);
        }
        return d_node;
    }

    public void setUri(String uri) {
        this.uri = uri;
        this.isWggds = true;
    }

    public boolean isWggds() {
        return this.isWggds;
    }

    public String getUri() {
        return this.uri;
    }

    public void setLiveSearch(boolean liveSearch) {
        this.liveSearch = liveSearch;
    }

    public boolean isLiveSearch() {
        return this.liveSearch;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public StructureDictionary setSourceFile(String sourceFile) {
        this.sourceFile = sourceFile;
        return this;
    }

    public boolean isGlycoWorkbenchResource() {
        return this.isGlycoWorkbenchResource;
    }

    public StructureDictionary setGlycoWorkbenchResource(boolean isGlycoWorkbenchResource) {
        this.isGlycoWorkbenchResource = isGlycoWorkbenchResource;
        return this;
    }

    public boolean hasBeenSynced() {
        return this.hasBeenSynced;
    }

    public void setHasBeenSynced(boolean hasBeenSynced) {
        this.hasBeenSynced = hasBeenSynced;
    }

    public void restore() throws Exception {
        this.clear();
        String sourceFile = this.getSourceFile();
        FileUtils.copy((InputStream)GlycanBuilder.class.getResourceAsStream(sourceFile), (File)this.getFile());
        this.load(this.getFileName(), true, this.theScorer);
        this.setHasBeenSynced(false);
        this.setSourceFile(sourceFile);
        this.save();
    }

    public void fireDocumentChanged() {
        if (this.fireDocumentChanged) {
            super.fireDocumentChanged();
        }
    }

    public boolean isFireDocumentChanged() {
        return this.fireDocumentChanged;
    }

    public void setFireDocumentChanged(boolean fireDocumentChanged) {
        this.fireDocumentChanged = fireDocumentChanged;
    }

    public static class SAXHandler
    extends SAXUtils.ObjectTreeHandler {
        private StructureDictionary theDocument;
        private boolean merge;

        public SAXHandler(StructureDictionary _doc, boolean _merge) {
            this.theDocument = _doc;
            this.merge = _merge;
        }

        public boolean isElement(String namespaceURI, String localName, String qName) {
            return qName.equals(SAXHandler.getNodeElementName());
        }

        public static String getNodeElementName() {
            return "StructureDictionary";
        }

        protected SAXUtils.ObjectTreeHandler getHandler(String namespaceURI, String localName, String qName) {
            if (qName.equals(StructureType.SAXHandler.getNodeElementName())) {
                return new StructureType.SAXHandler();
            }
            return null;
        }

        protected void initContent(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            String liveSearch;
            super.initContent(namespaceURI, localName, qName, atts);
            this.theDocument.dictionary_name = this.stringAttribute(atts, "name", "");
            this.theDocument.uri = this.stringAttribute(atts, "uri", "");
            this.theDocument.sourceFile = this.stringAttribute(atts, "source_file", "");
            if (!this.theDocument.uri.equals("")) {
                this.theDocument.isWggds = true;
            }
            if (!(liveSearch = this.stringAttribute(atts, "liveSearch", "")).equals("")) {
                this.theDocument.liveSearch = Boolean.parseBoolean(liveSearch);
            }
        }

        protected Object finalizeContent(String namespaceURI, String localName, String qName) throws SAXException {
            if (!this.merge) {
                this.theDocument.dictionary.clear();
            }
            for (Object o : this.getSubObjects(StructureType.SAXHandler.getNodeElementName())) {
                StructureType st = (StructureType)o;
                this.theDocument.dictionary.put(st.getStructure(), st);
            }
            this.object = this.theDocument;
            return this.object;
        }
    }
}

