/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.border.BevelBorder;
import org.eurocarbdb.application.glycanbuilder.BaseDocument;
import org.eurocarbdb.application.glycanbuilder.FileUtils;
import org.eurocarbdb.application.glycanbuilder.GlycanAction;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.STOCK_ICON;
import org.eurocarbdb.application.glycoworkbench.AnnotatedPeakList;
import org.eurocarbdb.application.glycoworkbench.GlycanWorkspace;
import org.eurocarbdb.application.glycoworkbench.GlycoWorkbench;
import org.eurocarbdb.application.glycoworkbench.plugin.DocumentPanel;
import org.eurocarbdb.application.glycoworkbench.plugin.Plugin;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.Range;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYDataset;

public class PeakAnnotationCalibrationPanel
extends DocumentPanel<AnnotatedPeakList>
implements ActionListener,
ComponentListener,
GlycanWorkspace.Listener,
BaseDocument.DocumentChangeListener {
    private static final int MOD_MASK = 47;
    protected JLabel theStructure;
    protected DefaultXYDataset theDataset;
    protected XYPlot thePlot;
    protected JFreeChart theChart;
    protected ChartPanel theChartPanel;
    protected JToolBar theToolBarDocument;
    protected JToolBar theToolBarEdit;
    protected int current_ind = 0;
    protected String accuracy_unit;
    protected JButton accunit_button = null;
    protected boolean was_moving = false;
    protected boolean is_moving = false;
    protected Point2D mouse_start_point = null;
    protected Cursor hand_cursor = null;

    @Override
    protected void initSingletons() {
        super.initSingletons();
        this.accuracy_unit = "da";
    }

    @Override
    protected void initComponents() {
        this.setLayout(new BorderLayout());
        this.theStructure = new JLabel();
        this.theStructure.setBorder(new BevelBorder(0));
        this.add((Component)this.theStructure, "North");
        this.theDataset = new DefaultXYDataset();
        this.theChart = ChartFactory.createScatterPlot((String)"Calibration", (String)"m/z ratio", (String)"accuracy (Da)", (XYDataset)this.theDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        this.thePlot = (XYPlot)this.theChart.getPlot();
        this.theChartPanel = new ChartPanel(this.theChart);
        this.theChartPanel.setDomainZoomable(true);
        this.theChartPanel.setRangeZoomable(true);
        this.theChartPanel.setPopupMenu(null);
        this.add((Component)this.theChartPanel, "Center");
        JPanel theToolBarPanel = new JPanel(new BorderLayout());
        this.theToolBarDocument = this.createToolBarDocument();
        this.theToolBarEdit = this.createToolBarEdit();
        theToolBarPanel.add((Component)this.theToolBarDocument, "North");
        theToolBarPanel.add((Component)this.theToolBarEdit, "Center");
        this.add((Component)theToolBarPanel, "South");
        this.hand_cursor = FileUtils.createCursor((String)"hand");
    }

    @Override
    protected void finalSettings() {
        super.finalSettings();
        this.theChartPanel.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                PeakAnnotationCalibrationPanel.this.onMouseDragged(e);
            }
        });
        this.theChartPanel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PeakAnnotationCalibrationPanel.this.onMousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                PeakAnnotationCalibrationPanel.this.onMouseReleased(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                PeakAnnotationCalibrationPanel.this.onMouseClicked(e);
            }
        });
    }

    @Override
    public AnnotatedPeakList getDocumentFromWorkspace(GlycanWorkspace workspace) {
        return workspace != null ? workspace.getAnnotatedPeakList() : null;
    }

    @Override
    public void setDocumentFromWorkspace(GlycanWorkspace workspace) {
        if (this.theDocument != null) {
            ((AnnotatedPeakList)((Object)this.theDocument)).removeDocumentChangeListener(this);
        }
        this.theDocument = this.getDocumentFromWorkspace(workspace);
        if (this.theDocument == null) {
            this.theDocument = new AnnotatedPeakList();
        }
        ((AnnotatedPeakList)((Object)this.theDocument)).addDocumentChangeListener(this);
        this.current_ind = 0;
        this.updateView();
        this.updateActions();
    }

    @Override
    protected void createActions() {
        this.theActionManager.add("accunit=da", FileUtils.defaultThemeManager.getImageIcon("da"), "Show accuracy in Da", -1, "", (ActionListener)this);
        this.theActionManager.add("accunit=ppm", FileUtils.defaultThemeManager.getImageIcon("ppm"), "Show accuracy in PPM", -1, "", (ActionListener)this);
        this.theActionManager.add("new", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.REFRESH, Plugin.DEFAULT_ICON_SIZE), "Clear", 78, "", (ActionListener)this);
        this.theActionManager.add("close", FileUtils.defaultThemeManager.getImageIcon("close"), "Close structure", 83, "", (ActionListener)this);
        this.theActionManager.add("last", FileUtils.defaultThemeManager.getImageIcon("last"), "Last structure", 76, "", (ActionListener)this);
        this.theActionManager.add("next", FileUtils.defaultThemeManager.getImageIcon("next"), "Next structure", 78, "", (ActionListener)this);
        this.theActionManager.add("print", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.DOCUMENT_PRINT, Plugin.DEFAULT_ICON_SIZE), "Print...", 80, "", (ActionListener)this);
        this.theActionManager.add("arrow", FileUtils.defaultThemeManager.getImageIcon("arrow"), "Activate zoom", -1, "", (ActionListener)this);
        this.theActionManager.add("hand", FileUtils.defaultThemeManager.getImageIcon("hand"), "Activate moving", -1, "", (ActionListener)this);
        this.theActionManager.add("zoomnone", FileUtils.defaultThemeManager.getImageIcon("zoomnone"), "Reset zoom", -1, "", (ActionListener)this);
        this.theActionManager.add("zoomin", FileUtils.defaultThemeManager.getImageIcon("zoomin"), "Zoom in", -1, "", (ActionListener)this);
        this.theActionManager.add("zoomout", FileUtils.defaultThemeManager.getImageIcon("zoomout"), "Zoom out", -1, "", (ActionListener)this);
    }

    @Override
    protected void updateActions() {
        this.theActionManager.get("close").setEnabled(((AnnotatedPeakList)((Object)this.theDocument)).getNoStructures() != 0);
        this.theActionManager.get("last").setEnabled(this.current_ind > 0);
        this.theActionManager.get("next").setEnabled(this.current_ind < ((AnnotatedPeakList)((Object)this.theDocument)).getNoStructures() - 1);
        this.theActionManager.get("arrow").setEnabled(this.is_moving);
        this.theActionManager.get("hand").setEnabled(!this.is_moving);
        this.theActionManager.get("zoomnone").setEnabled(true);
        this.theActionManager.get("zoomin").setEnabled(true);
        this.theActionManager.get("zoomout").setEnabled(true);
    }

    private JToolBar createToolBarDocument() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.add((Action)this.theActionManager.get("last"));
        toolbar.add((Action)this.theActionManager.get("close"));
        toolbar.add((Action)this.theActionManager.get("next"));
        toolbar.addSeparator();
        this.accunit_button = new JButton((Action)this.theActionManager.get("accunit=ppm"));
        toolbar.add(this.accunit_button);
        this.accunit_button.setText(null);
        toolbar.add((Action)this.theActionManager.get("new"));
        toolbar.addSeparator();
        toolbar.add((Action)this.theActionManager.get("print"));
        return toolbar;
    }

    private JToolBar createToolBarEdit() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.addSeparator();
        toolbar.add((Action)this.theActionManager.get("arrow"));
        toolbar.add((Action)this.theActionManager.get("hand"));
        toolbar.addSeparator();
        toolbar.add((Action)this.theActionManager.get("zoomnone"));
        toolbar.add((Action)this.theActionManager.get("zoomin"));
        toolbar.add((Action)this.theActionManager.get("zoomout"));
        return toolbar;
    }

    protected JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add((Action)this.theActionManager.get("zoomnone"));
        menu.add((Action)this.theActionManager.get("zoomin"));
        menu.add((Action)this.theActionManager.get("zoomout"));
        return menu;
    }

    public boolean isChartEmpty() {
        return ((AnnotatedPeakList)((Object)this.theDocument)).getNoStructures() == 0 || ((AnnotatedPeakList)((Object)this.theDocument)).getNoAnnotatedPeaks(this.current_ind) == 0;
    }

    public double screenToDataX(double length) {
        Rectangle2D data_area = this.theChartPanel.getScreenDataArea();
        double mz_unit = this.thePlot.getDomainAxis().lengthToJava2D(1.0, data_area, this.thePlot.getDomainAxisEdge());
        return length / mz_unit;
    }

    public double screenToDataY(double length) {
        Rectangle2D data_area = this.theChartPanel.getScreenDataArea();
        double int_unit = this.thePlot.getRangeAxis().lengthToJava2D(1.0, data_area, this.thePlot.getRangeAxisEdge());
        return length / int_unit;
    }

    public Point2D screenToDataCoords(Point2D p) {
        Rectangle2D data_area = this.theChartPanel.getScreenDataArea();
        double x = this.thePlot.getDomainAxis().java2DToValue(p.getX(), data_area, this.thePlot.getDomainAxisEdge());
        double y = this.thePlot.getRangeAxis().java2DToValue(p.getY(), data_area, this.thePlot.getRangeAxisEdge());
        return new Point2D.Double(x, y);
    }

    public double screenToDataCoordX(double x) {
        Rectangle2D data_area = this.theChartPanel.getScreenDataArea();
        return this.thePlot.getDomainAxis().java2DToValue(x, data_area, this.thePlot.getDomainAxisEdge());
    }

    public double screenToDataCoordY(double y) {
        Rectangle2D data_area = this.theChartPanel.getScreenDataArea();
        return this.thePlot.getRangeAxis().java2DToValue(y, data_area, this.thePlot.getRangeAxisEdge());
    }

    public void clear() {
        this.current_ind = 0;
        ((AnnotatedPeakList)((Object)this.theDocument)).clear();
    }

    @Override
    protected void updateData() {
        this.current_ind = Math.min(this.current_ind, ((AnnotatedPeakList)((Object)this.theDocument)).getNoStructures() - 1);
        this.current_ind = Math.max(this.current_ind, 0);
    }

    @Override
    protected void updateView() {
        if (this.theStructure != null) {
            if (((AnnotatedPeakList)((Object)this.theDocument)).getNoStructures() > 0) {
                this.theStructure.setIcon(new ImageIcon(this.theWorkspace.getGlycanRenderer().getImage(((AnnotatedPeakList)((Object)this.theDocument)).getStructure(this.current_ind), false, true, true, 0.667)));
            } else {
                this.theStructure.setIcon(null);
            }
        }
        if (((AnnotatedPeakList)((Object)this.theDocument)).getNoStructures() > 0) {
            this.theDataset.removeSeries((Comparable)((Object)"best"));
            this.theDataset.removeSeries((Comparable)((Object)"all"));
            if (this.accuracy_unit.equals("ppm")) {
                this.theDataset.addSeries((Comparable)((Object)"best"), ((AnnotatedPeakList)((Object)this.theDocument)).getBestCalibrationDataPPM(this.current_ind));
                this.theDataset.addSeries((Comparable)((Object)"all"), ((AnnotatedPeakList)((Object)this.theDocument)).getCalibrationDataPPM(this.current_ind));
            } else {
                this.theDataset.addSeries((Comparable)((Object)"best"), ((AnnotatedPeakList)((Object)this.theDocument)).getBestCalibrationData(this.current_ind));
                this.theDataset.addSeries((Comparable)((Object)"all"), ((AnnotatedPeakList)((Object)this.theDocument)).getCalibrationData(this.current_ind));
            }
        }
        if (this.accuracy_unit.equals("ppm")) {
            this.thePlot.getRangeAxis().setLabel("accuracy (PPM)");
        } else {
            this.thePlot.getRangeAxis().setLabel("accuracy (Da)");
        }
        this.theChartPanel.setDomainZoomable(!this.is_moving);
        this.theChartPanel.setRangeZoomable(!this.is_moving);
        this.onZoomNone();
    }

    public void closeCurrent() {
        if (((AnnotatedPeakList)((Object)this.theDocument)).getNoStructures() > 0) {
            int old_ind = this.current_ind;
            this.current_ind = Math.min(this.current_ind, ((AnnotatedPeakList)((Object)this.theDocument)).getNoStructures() - 2);
            this.current_ind = Math.max(this.current_ind, 0);
            this.theApplication.haltInteractions();
            ((AnnotatedPeakList)((Object)this.theDocument)).removePeakAnnotationsAt(old_ind);
            this.theApplication.restoreInteractions();
        }
    }

    public void showLast() {
        if (((AnnotatedPeakList)((Object)this.theDocument)).getNoStructures() > 0 && this.current_ind > 0) {
            --this.current_ind;
            this.updateView();
        }
    }

    public void showNext() {
        if (((AnnotatedPeakList)((Object)this.theDocument)).getNoStructures() > 0 && this.current_ind < ((AnnotatedPeakList)((Object)this.theDocument)).getNoStructures() - 1) {
            ++this.current_ind;
            this.updateView();
        }
    }

    public void showStructure(int s_ind) {
        if (s_ind >= 0 && s_ind < ((AnnotatedPeakList)((Object)this.theDocument)).getNoStructures()) {
            this.current_ind = s_ind;
            this.updateView();
        }
    }

    public void onNew() {
        this.clear();
    }

    public void onPrint() {
        PrinterJob pj = this.theWorkspace.getPrinterJob();
        if (pj == null) {
            return;
        }
        try {
            pj.setPrintable((Printable)this.theChartPanel);
            if (pj.printDialog()) {
                pj.print();
            }
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
        }
    }

    public void onActivateZooming() {
        this.is_moving = false;
        this.theChartPanel.setCursor(Cursor.getDefaultCursor());
        this.theChartPanel.setDomainZoomable(true);
        this.theChartPanel.setRangeZoomable(true);
    }

    public void onActivateMoving() {
        this.is_moving = true;
        this.theChartPanel.setCursor(this.hand_cursor);
        this.theChartPanel.setRangeZoomable(false);
        this.theChartPanel.setDomainZoomable(false);
    }

    public void onZoomNone() {
        if (!this.isChartEmpty()) {
            Range mz_range = ((AnnotatedPeakList)((Object)this.theDocument)).getMZRange();
            if (mz_range.getLength() == 0.0) {
                mz_range = new Range(mz_range.getLowerBound() - 10.0, mz_range.getLowerBound() + 10.0);
            }
            this.thePlot.getDomainAxis().setRange(mz_range);
            if (this.accuracy_unit.equals("da")) {
                Range acc_range = ((AnnotatedPeakList)((Object)this.theDocument)).getAccuracyRange(this.current_ind);
                if (acc_range.getLength() == 0.0) {
                    acc_range = new Range(acc_range.getLowerBound() - 0.1, acc_range.getLowerBound() + 0.1);
                }
                this.thePlot.getRangeAxis().setRange(acc_range);
            } else {
                Range acc_range = ((AnnotatedPeakList)((Object)this.theDocument)).getAccuracyRangePPM(this.current_ind);
                if (acc_range.getLength() == 0.0) {
                    acc_range = new Range(acc_range.getLowerBound() - 100.0, acc_range.getLowerBound() + 100.0);
                }
                this.thePlot.getRangeAxis().setRange(acc_range);
            }
        } else {
            this.thePlot.getDomainAxis().setRange(new Range(0.0, 1.0));
            if (this.accuracy_unit.equals("da")) {
                this.thePlot.getRangeAxis().setRange(new Range(-1.0, 1.0));
            } else {
                this.thePlot.getRangeAxis().setRange(new Range(-1000.0, 1000.0));
            }
        }
    }

    public void onZoomIn() {
        this.thePlot.getDomainAxis().resizeRange(0.5);
        this.thePlot.getRangeAxis().resizeRange(0.5);
    }

    public void onZoomOut() {
        this.thePlot.getDomainAxis().resizeRange(2.0);
        this.thePlot.getRangeAxis().resizeRange(2.0);
    }

    public void onSetAccuracyUnit(String accunit) {
        if (accunit.equals("da")) {
            this.accuracy_unit = "da";
            this.accunit_button.setAction((Action)this.theActionManager.get("accunit=ppm"));
            this.accunit_button.setText(null);
            this.updateView();
        } else if (accunit.equals("ppm")) {
            this.accuracy_unit = "ppm";
            this.accunit_button.setAction((Action)this.theActionManager.get("accunit=da"));
            this.accunit_button.setText(null);
            this.updateView();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = GlycanAction.getAction((ActionEvent)e);
        String param = GlycanAction.getParam((ActionEvent)e);
        if (action.equals("last")) {
            this.showLast();
        } else if (action.equals("next")) {
            this.showNext();
        } else if (action.equals("close")) {
            this.closeCurrent();
        } else if (action.equals("accunit")) {
            this.onSetAccuracyUnit(param);
        } else if (action.equals("new")) {
            this.onNew();
        } else if (action.equals("print")) {
            this.onPrint();
        } else if (action.equals("arrow")) {
            this.onActivateZooming();
        } else if (action.equals("hand")) {
            this.onActivateMoving();
        } else if (action.equals("zoomnone")) {
            this.onZoomNone();
        } else if (action.equals("zoomin")) {
            this.onZoomIn();
        } else if (action.equals("zoomout")) {
            this.onZoomOut();
        }
        this.updateActions();
    }

    public void onMousePressed(MouseEvent e) {
        this.was_moving = this.is_moving;
        if (e.getButton() == 1 && this.theChartPanel.getScreenDataArea().contains(e.getPoint())) {
            this.mouse_start_point = e.getPoint();
            if ((e.getModifiers() & 0x2F) == 1) {
                this.onActivateMoving();
            }
        } else {
            this.mouse_start_point = null;
        }
    }

    private void onMouseDragged(MouseEvent e) {
        if (this.mouse_start_point != null && this.is_moving) {
            double new_upper_bound;
            double new_lower_bound;
            double new_lower_bound2;
            double new_upper_bound2;
            double old_lower_bound;
            double old_upper_bound;
            double mz_delta = this.screenToDataX(this.mouse_start_point.getX() - e.getPoint().getX());
            double acc_delta = this.screenToDataY(e.getPoint().getY() - this.mouse_start_point.getY());
            if (mz_delta > 0.0) {
                old_upper_bound = this.thePlot.getDomainAxis().getUpperBound();
                old_lower_bound = this.thePlot.getDomainAxis().getLowerBound();
                new_upper_bound2 = old_upper_bound + mz_delta;
                new_lower_bound2 = old_lower_bound + new_upper_bound2 - old_upper_bound;
                this.thePlot.getDomainAxis().setRange(new Range(new_lower_bound2, new_upper_bound2));
            } else {
                old_upper_bound = this.thePlot.getDomainAxis().getUpperBound();
                old_lower_bound = this.thePlot.getDomainAxis().getLowerBound();
                new_lower_bound = old_lower_bound + mz_delta;
                new_upper_bound = old_upper_bound + new_lower_bound - old_lower_bound;
                this.thePlot.getDomainAxis().setRange(new Range(new_lower_bound, new_upper_bound));
            }
            if (acc_delta > 0.0) {
                old_upper_bound = this.thePlot.getRangeAxis().getUpperBound();
                old_lower_bound = this.thePlot.getRangeAxis().getLowerBound();
                new_upper_bound2 = old_upper_bound + acc_delta;
                new_lower_bound2 = old_lower_bound + new_upper_bound2 - old_upper_bound;
                this.thePlot.getRangeAxis().setRange(new Range(new_lower_bound2, new_upper_bound2));
            } else {
                old_upper_bound = this.thePlot.getRangeAxis().getUpperBound();
                old_lower_bound = this.thePlot.getRangeAxis().getLowerBound();
                new_lower_bound = old_lower_bound + acc_delta;
                new_upper_bound = old_upper_bound + new_lower_bound - old_lower_bound;
                this.thePlot.getRangeAxis().setRange(new Range(new_lower_bound, new_upper_bound));
            }
            this.mouse_start_point = e.getPoint();
        }
    }

    public void onMouseReleased(MouseEvent e) {
        if (!this.was_moving && this.is_moving) {
            this.onActivateZooming();
        }
        this.mouse_start_point = null;
    }

    public void onMouseClicked(MouseEvent e) {
        if (e.getButton() == 3 && e.getClickCount() == 1) {
            if ((e.getModifiers() & 0x2F) == 4) {
                this.createPopupMenu().show((Component)this.theChartPanel, e.getX(), e.getY());
            }
        }
    }
}

