/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JPanel;
import org.eurocarbdb.application.glycanbuilder.ActionManager;
import org.eurocarbdb.application.glycanbuilder.BaseDocument;
import org.eurocarbdb.application.glycanbuilder.GlycanRenderer;
import org.eurocarbdb.application.glycanbuilder.GlycanRendererAWT;
import org.eurocarbdb.application.glycoworkbench.GlycanWorkspace;
import org.eurocarbdb.application.glycoworkbench.GlycoWorkbench;

public abstract class DocumentPanel<DOCUMENTTYPE>
extends JPanel
implements ComponentListener,
GlycanWorkspace.Listener,
BaseDocument.DocumentChangeListener {
    protected static final long serialVersionUID = 0L;
    protected GlycoWorkbench theApplication;
    protected GlycanWorkspace theWorkspace;
    protected DOCUMENTTYPE theDocument;
    protected ActionManager theActionManager;
    protected boolean ignore_document_changes;
    protected boolean delayed_workspace_update = false;
    protected boolean delayed_document_update = false;

    public DocumentPanel() {
        this.initSingletons();
        this.initActions();
        this.initComponents();
        this.finalSettings();
    }

    protected void initSingletons() {
        this.theApplication = null;
        this.theWorkspace = new GlycanWorkspace((GlycanRenderer)new GlycanRendererAWT());
        this.theDocument = this.getDocumentFromWorkspace(this.theWorkspace);
    }

    protected void initActions() {
        this.theActionManager = new ActionManager();
        this.createActions();
    }

    protected abstract void initComponents();

    protected void finalSettings() {
        this.setMinimumSize(new Dimension(0, 0));
        this.setBackground(Color.white);
        this.setOpaque(true);
        this.ignore_document_changes = false;
        this.addComponentListener(this);
        this.setWorkspace(this.theWorkspace);
    }

    public void setApplication(GlycoWorkbench application) {
        this.theApplication = application;
        this.updateActions();
        this.updateView();
    }

    public void setWorkspace(GlycanWorkspace workspace) {
        if (this.theWorkspace != null) {
            this.theWorkspace.removeWorkspaceListener(this);
            this.theWorkspace.removeDocumentChangeListener(this);
        }
        this.theWorkspace = workspace == null ? new GlycanWorkspace((GlycanRenderer)new GlycanRendererAWT()) : workspace;
        this.theWorkspace.addWorkspaceListener(this);
        this.theWorkspace.addDocumentChangeListener(this);
        this.setDocumentFromWorkspace(workspace);
    }

    protected abstract DOCUMENTTYPE getDocumentFromWorkspace(GlycanWorkspace var1);

    protected abstract void setDocumentFromWorkspace(GlycanWorkspace var1);

    protected abstract void createActions();

    protected abstract void updateActions();

    protected abstract void updateData();

    protected abstract void updateView();

    protected void updateWorkspace() {
        if (!this.ignore_document_changes) {
            if (this.isVisible() && this.getSize().width > 0 && this.getSize().height > 0) {
                this.theApplication.haltInteractions();
                this.setDocumentFromWorkspace(this.theWorkspace);
                this.delayed_workspace_update = false;
                this.delayed_document_update = false;
                this.theApplication.restoreInteractions();
            } else {
                this.delayed_workspace_update = true;
            }
        }
    }

    protected void updateDocument() {
        if (this.isVisible() && this.getSize().width > 0 && this.getSize().height > 0) {
            this.theApplication.haltInteractions();
            this.updateData();
            this.updateView();
            this.updateActions();
            this.delayed_document_update = false;
            this.theApplication.restoreInteractions();
        } else {
            this.delayed_document_update = true;
        }
    }

    protected boolean checkForUpdates() {
        if (this.ignore_document_changes) {
            return false;
        }
        if (this.delayed_workspace_update) {
            this.updateWorkspace();
            return true;
        }
        if (this.delayed_document_update) {
            this.updateDocument();
            return true;
        }
        return false;
    }

    public void documentInit(BaseDocument.DocumentChangeEvent e) {
        if (!this.ignore_document_changes) {
            if (e.getSource() == this.theWorkspace) {
                this.updateWorkspace();
            } else {
                this.updateDocument();
            }
        }
    }

    public void documentChanged(BaseDocument.DocumentChangeEvent e) {
        if (!this.ignore_document_changes) {
            if (e.getSource() == this.theWorkspace) {
                this.updateWorkspace();
            } else {
                this.updateDocument();
            }
        }
    }

    @Override
    public void internalDocumentChanged(GlycanWorkspace.Event e) {
    }

    @Override
    public void currentScanChanged(GlycanWorkspace.Event e) {
        this.updateWorkspace();
    }

    @Override
    public void scanAdded(GlycanWorkspace.Event e) {
    }

    @Override
    public void scanRemoved(GlycanWorkspace.Event e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.checkForUpdates();
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.checkForUpdates();
    }

    @Override
    public void paint(Graphics g) {
        this.checkForUpdates();
        super.paint(g);
    }
}

