/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eurocarbdb.application.glycanbuilder.Context;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;
import org.pushingpixels.flamingo.api.ribbon.RibbonContextualTaskGroup;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;

public class RibbonManager {
    protected Map<Context, RibbonTask> defaultContextRibbonTask;
    protected Map<RibbonTask, Set<Context>> ribbonTaskContextSupport;
    protected JRibbon jRibbon;
    protected RibbonTask enabledTask;
    protected RibbonTask lastTask;
    protected Context defaultContext;

    public void setDefaultContext(Context context) {
        this.defaultContext = context;
    }

    public RibbonManager(JRibbon _jRibbon) {
        this.jRibbon = _jRibbon;
        this.defaultContextRibbonTask = new HashMap<Context, RibbonTask>();
        this.ribbonTaskContextSupport = new HashMap<RibbonTask, Set<Context>>();
    }

    public void setRibbonAsDefault(RibbonTask ribbonTask, Context context) {
        this.defaultContextRibbonTask.put(context, ribbonTask);
    }

    public void registerContextSupport(RibbonTask ribbonTask, Set<Context> contexts) {
        this.ribbonTaskContextSupport.put(ribbonTask, contexts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RibbonTaskChangeState setCurrentContext(Context context, boolean switchToDefault) {
        JRibbon jRibbon = this.jRibbon;
        synchronized (jRibbon) {
            this.setAllAssociatedTasksVisible(context, true);
            Set<Context> contexts = this.getRibbonTaskContexts(this.jRibbon.getSelectedTask());
            if (contexts == null || !contexts.contains(context)) {
                RibbonTask defaultRibbonTask = this.defaultContextRibbonTask.get(context);
                if (defaultRibbonTask != null) {
                    this.lastTask = this.jRibbon.getSelectedTask();
                    this.enabledTask = defaultRibbonTask;
                    if (switchToDefault) {
                        this.jRibbon.setSelectedTask(defaultRibbonTask);
                    }
                    return RibbonTaskChangeState.SET_TO_DEFAULT_BAND;
                }
                return RibbonTaskChangeState.NO_BAND_SUPPORTS_CONTEXT;
            }
            return RibbonTaskChangeState.CURRENT_BAND_SUPPORTS_CONTEXT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllAssociatedTasksVisible(Context context, boolean visible) {
        JRibbon jRibbon = this.jRibbon;
        synchronized (jRibbon) {
            boolean rememberLast = false;
            for (RibbonTask ribbonTask : this.ribbonTaskContextSupport.keySet()) {
                RibbonContextualTaskGroup group;
                if (!this.ribbonTaskContextSupport.get(ribbonTask).contains(context) || (group = ribbonTask.getContextualGroup()) == null || this.jRibbon.isVisible(group) == visible) continue;
                if (visible) {
                    rememberLast = true;
                }
                this.jRibbon.setVisible(group, visible);
            }
            if (rememberLast) {
                this.lastTask = this.jRibbon.getSelectedTask();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undoContextChange(Context context) {
        JRibbon jRibbon = this.jRibbon;
        synchronized (jRibbon) {
            RibbonContextualTaskGroup group;
            RibbonTask selectedTask = this.jRibbon.getSelectedTask();
            if (this.enabledTask != null && (group = this.enabledTask.getContextualGroup()) != null) {
                for (int i = 0; i < group.getTaskCount(); ++i) {
                    RibbonTask taskOnGroup = group.getTask(i);
                    if (taskOnGroup != selectedTask) continue;
                    this.jRibbon.setSelectedTask(this.lastTask);
                    break;
                }
            }
            this.setAllAssociatedTasksVisible(context, false);
        }
    }

    public Set<Context> getRibbonTaskContexts(RibbonTask task) {
        return this.ribbonTaskContextSupport.get(task);
    }

    public static enum RibbonTaskChangeState {
        SET_TO_DEFAULT_BAND,
        CURRENT_BAND_SUPPORTS_CONTEXT,
        NO_BAND_SUPPORTS_CONTEXT;

    }
}

