/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileFilter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eurocarbdb.application.glycanbuilder.BaseDocument;
import org.eurocarbdb.application.glycanbuilder.ExtensionFileFilter;
import org.eurocarbdb.application.glycanbuilder.FileUtils;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.SAXUtils;
import org.eurocarbdb.application.glycanbuilder.XMLUtils;
import org.eurocarbdb.application.glycoworkbench.AnnotatedPeakList;
import org.eurocarbdb.application.glycoworkbench.Peak;
import org.jfree.data.Range;
import org.proteomecommons.io.mgf.MascotGenericFormatPeakListReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class PeakList
extends BaseDocument
implements SAXUtils.SAXWriter {
    protected Vector<Peak> peaks;
    protected double max_intensity = 0.0;

    public PeakList() {
    }

    public PeakList(double m_z) {
        this.put(m_z, 1.0);
    }

    public PeakList(Collection<Peak> _peaks) {
        this.mergeData(_peaks);
    }

    public String getName() {
        return "PeakList";
    }

    public ImageIcon getIcon() {
        return FileUtils.defaultThemeManager.getImageIcon("peaksdoc");
    }

    public Collection<FileFilter> getFileFormats() {
        Vector<FileFilter> filters = new Vector<FileFilter>();
        filters.add((FileFilter)new ExtensionFileFilter("mgf", "Mascot generic peaklist format files"));
        filters.add((FileFilter)new ExtensionFileFilter("xml", "Bruker peak list files"));
        filters.add((FileFilter)new ExtensionFileFilter("msa", "Cartoonist peak list files"));
        filters.add((FileFilter)new ExtensionFileFilter("ctd", "Cartoonist centroids file"));
        filters.add((FileFilter)new ExtensionFileFilter(new String[]{"txt", "csv"}, "Comma separated peak list files"));
        filters.add((FileFilter)new ExtensionFileFilter(new String[]{"txt", "csv", "ctd", "mgf", "msa", "xml"}, "All peak list files"));
        return filters;
    }

    public FileFilter getAllFileFormats() {
        return new ExtensionFileFilter(new String[]{"txt", "csv", "ctd", "mgf", "msa", "xml"}, "Peak list files");
    }

    public void initData() {
        this.peaks = new Vector();
        this.max_intensity = 0.0;
    }

    public int size() {
        return this.peaks.size();
    }

    private int putPVT(double _mz, double _int) {
        return this.putPVT(new Peak(_mz, _int));
    }

    private int putPVT(Peak toadd) {
        int ind = 0;
        ListIterator<Peak> i = this.peaks.listIterator();
        while (i.hasNext()) {
            Peak p = i.next();
            if (toadd.compareTo(p) < 0) {
                i.previous();
                i.add(toadd.clone());
                return ind;
            }
            if (toadd.compareTo(p) == 0) {
                p.setIntensity(toadd.getIntensity());
                return ind;
            }
            ++ind;
        }
        this.peaks.add(toadd.clone());
        return ind;
    }

    public int put(double _mz, double _int) {
        int ind = this.putPVT(_mz, _int);
        this.updateMaxIntensity();
        this.fireDocumentChanged();
        return ind;
    }

    public int add(Peak p) {
        if (p == null) {
            return -1;
        }
        return this.put(p.getMZ(), p.getIntensity());
    }

    public void addAll(Collection<Peak> _peaks) {
        this.mergeData(_peaks);
    }

    public void setData(Collection<Peak> _peaks) {
        this.setData(_peaks, true);
    }

    private void setData(Collection<Peak> _peaks, boolean fire) {
        this.peaks.clear();
        this.max_intensity = 0.0;
        Iterator<Peak> i = _peaks.iterator();
        while (i.hasNext()) {
            this.putPVT(i.next());
        }
        this.updateMaxIntensity();
        if (fire) {
            this.fireDocumentChanged();
        }
    }

    public void mergeData(Collection<Peak> _peaks) {
        this.mergeData(_peaks, true);
    }

    private void mergeData(Collection<Peak> _peaks, boolean fire) {
        Iterator<Peak> i = _peaks.iterator();
        while (i.hasNext()) {
            this.putPVT(i.next());
        }
        this.updateMaxIntensity();
        if (fire) {
            this.fireDocumentChanged();
        }
    }

    private void removePVT(int ind) {
        this.peaks.removeElementAt(ind);
    }

    public void remove(int ind) {
        this.peaks.removeElementAt(ind);
        this.updateMaxIntensity();
        this.fireDocumentChanged();
    }

    public void remove(int[] inds) {
        Arrays.sort(inds);
        for (int i = 0; i < inds.length; ++i) {
            int corrected = inds[i] - i;
            if (corrected == this.getPeaks().size()) continue;
            this.removePVT(corrected);
        }
        this.updateMaxIntensity();
        this.fireDocumentChanged();
    }

    public void remove(double mz) {
        this.remove(this.indexOf(mz));
    }

    public int indexOf(double mz) {
        for (int i = 0; i < this.size(); ++i) {
            if (mz < this.getMZ(i)) {
                return -1;
            }
            if (!(Math.abs(mz - this.getMZ(i)) < 1.0E-6)) continue;
            return i;
        }
        return -1;
    }

    public Collection<Peak> getPeaks() {
        return this.peaks;
    }

    public Peak getPeak(int ind) {
        return this.peaks.elementAt(ind);
    }

    public void setMZ(int ind, double _mz) {
        Peak peak = this.peaks.get(ind);
        Peak clone = new Peak(_mz, peak.getIntensity());
        clone.setCharge(peak.getCharge());
        this.removePVT(ind);
        this.putPVT(clone);
        this.updateMaxIntensity();
        this.fireDocumentChanged();
    }

    public void setCharge(int ind, int charge) {
        Peak peak = this.peaks.get(ind);
        Peak clone = new Peak(peak.getMZ(), peak.getIntensity());
        clone.setCharge(charge);
        this.removePVT(ind);
        this.putPVT(clone);
        this.updateMaxIntensity();
        this.fireDocumentChanged();
    }

    public double getMZ(int ind) {
        return this.peaks.elementAt(ind).getMZ();
    }

    public void setIntensity(int ind, double _int) {
        Peak peak = this.peaks.get(ind);
        Peak clone = new Peak(peak.getMZ(), _int);
        clone.setCharge(peak.getCharge());
        this.removePVT(ind);
        this.putPVT(clone);
        this.updateMaxIntensity();
        this.fireDocumentChanged();
    }

    public double getIntensity(int ind) {
        return this.peaks.elementAt(ind).getIntensity();
    }

    public int getCharge(int ind) {
        return this.peaks.elementAt(ind).getCharge();
    }

    public double getRelativeIntensity(int ind) {
        if (this.max_intensity == 0.0) {
            return this.getIntensity(ind);
        }
        return this.getIntensity(ind) / this.max_intensity * 100.0;
    }

    public double getMinMZ() {
        return this.peaks.firstElement().getMZ();
    }

    public double getMaxMZ() {
        return this.peaks.lastElement().getMZ();
    }

    public Range getMZRange() {
        return new Range(this.getMinMZ(), this.getMaxMZ());
    }

    public Collection<Peak> extract(int[] inds) {
        Vector<Peak> ret = new Vector<Peak>();
        for (int i = 0; i < inds.length; ++i) {
            ret.add(this.peaks.elementAt(inds[i]).clone());
        }
        return ret;
    }

    public void updateMaxIntensity() {
        this.max_intensity = 0.0;
        for (Peak p : this.peaks) {
            this.max_intensity = Math.max(this.max_intensity, p.getIntensity());
        }
    }

    public double getMaxIntensity() {
        return this.max_intensity;
    }

    public double getMaxIntensity(double from_mz, double to_mz) {
        double ret = 0.0;
        for (Peak p : this.peaks) {
            if (!(p.getMZ() >= from_mz) || !(p.getMZ() <= to_mz)) continue;
            ret = Math.max(p.getIntensity(), ret);
        }
        return ret;
    }

    public double[][] getData() {
        return this.getData(this.getMinMZ(), this.getMaxMZ(), 0.0, false);
    }

    public double[][] getData(boolean rel_int) {
        return this.getData(this.getMinMZ(), this.getMaxMZ(), 0.0, rel_int);
    }

    public double[][] getData(double from_mz, double to_mz) {
        return this.getData(from_mz, to_mz, 0.0, false);
    }

    public double[][] getData(double from_mz, double to_mz, boolean rel_int) {
        return this.getData(from_mz, to_mz, 0.0, rel_int);
    }

    public double[][] getData(double from_mz, double to_mz, double add_boundaries, boolean rel_int) {
        int no_peaks = 0;
        for (Peak p : this.peaks) {
            if (!(p.getMZ() >= from_mz) || !(p.getMZ() <= to_mz)) continue;
            ++no_peaks;
        }
        int added = add_boundaries > 0.0 ? 2 : 0;
        double[][] ret = new double[][]{new double[no_peaks + added], new double[no_peaks + added]};
        double div = 1.0;
        if (rel_int) {
            div = this.getMaxIntensity(from_mz, to_mz) / 100.0;
        }
        int i = 0;
        for (Peak p : this.peaks) {
            if (!(p.getMZ() >= from_mz) || !(p.getMZ() <= to_mz)) continue;
            ret[0][i + added / 2] = p.getMZ();
            ret[1][i + added / 2] = p.getIntensity() / div;
            ++i;
        }
        if (add_boundaries > 0.0) {
            ret[0][0] = ret[0][1] - add_boundaries;
            ret[1][0] = 0.0;
            ret[0][no_peaks + 1] = ret[0][no_peaks] + add_boundaries;
            ret[1][no_peaks + 1] = 0.0;
        }
        return ret;
    }

    private boolean updatePeakPVT(Peak p) {
        int ind = this.indexOf(p.getMZ());
        if (ind == -1) {
            return false;
        }
        this.peaks.get(ind).setIntensity(p.getIntensity());
        return true;
    }

    public boolean updatePeak(Peak p) {
        if (this.updatePeakPVT(p)) {
            this.updateMaxIntensity();
            this.fireDocumentChanged();
            return true;
        }
        return false;
    }

    public boolean updatePeaks(Collection<Peak> peaks) {
        boolean changed = false;
        for (Peak p : peaks) {
            changed |= this.updatePeakPVT(p);
        }
        if (changed) {
            this.updateMaxIntensity();
            this.fireDocumentChanged();
        }
        return changed;
    }

    private String transform(String buffer, String transformer_path) throws Exception {
        TransformerFactory tf = TransformerFactory.newInstance();
        StreamSource in_xslt = new StreamSource(PeakList.class.getResource(transformer_path).toString());
        Transformer t = tf.newTransformer(in_xslt);
        StreamSource in = new StreamSource(new StringReader(buffer));
        StringWriter sw = new StringWriter();
        StreamResult out = new StreamResult(sw);
        t.transform(in, out);
        return sw.getBuffer().toString();
    }

    public boolean open(File file, boolean merge, boolean warning) {
        try {
            if (this.readCSV(file, merge)) {
                return true;
            }
            if (this.readMGF(file, merge)) {
                return true;
            }
            if (this.readMSA(file, merge)) {
                return true;
            }
            if (this.readBruker(file, merge)) {
                return true;
            }
            System.err.println("Failed to read bruker?");
            this.init();
            if (warning) {
                System.err.println("Unrecognized peak list format");
                throw new Exception("Unrecognized peak list format");
            }
            return false;
        }
        catch (Exception e) {
            System.err.println("Caught exception");
            LogUtils.report((Exception)e);
            return false;
        }
    }

    private boolean readMGF(File file, boolean merge) {
        try {
            MascotGenericFormatPeakListReader mgf_reader = new MascotGenericFormatPeakListReader(file.getPath());
            org.proteomecommons.io.Peak[] mgf_peaks = mgf_reader.getPeakList().getPeaks();
            if (!merge) {
                this.clear();
            }
            for (int i = 0; i < mgf_peaks.length; ++i) {
                this.putPVT(mgf_peaks[i]);
            }
            this.updateMaxIntensity();
            this.setFilename(file.getAbsolutePath());
            this.fireDocumentInit();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private int putPVT(org.proteomecommons.io.Peak peakCommons) {
        Peak peak = new Peak();
        peak.setIntensity(peakCommons.getIntensity());
        peak.setMZ(peakCommons.getMassOverCharge());
        peak.setCharge(peakCommons.getCharge());
        return this.putPVT(peak);
    }

    private boolean readCSV(File file, boolean merge) {
        try {
            FileInputStream fis = new FileInputStream(file);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            String buffer = this.consume(br);
            Collection<Peak> read = PeakList.parseString(buffer);
            if (read.size() > 0) {
                if (merge) {
                    this.mergeData(read, false);
                } else {
                    this.setData(read, false);
                }
                this.setFilename(file.getAbsolutePath());
                this.fireDocumentInit();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean readBruker(File file, boolean merge) {
        try {
            System.err.println("In bruker read");
            FileInputStream fis = new FileInputStream(file);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            String buffer = this.consume(br);
            String str = this.transform(buffer, "/transforms/bruker_peak_list.xsl");
            System.err.println(str);
            Collection<Peak> read = PeakList.parseString(this.transform(buffer, "/transforms/bruker_peak_list.xsl"));
            if (read.size() > 0) {
                if (merge) {
                    this.mergeData(read, false);
                } else {
                    this.setData(read, false);
                }
                this.setFilename(file.getAbsolutePath());
                this.fireDocumentInit();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean readMSA(File file, boolean merge) {
        AnnotatedPeakList read = new AnnotatedPeakList();
        if (!read.open(file, merge, false)) {
            return false;
        }
        if (read.getPeaks().size() == 0) {
            return false;
        }
        if (merge) {
            this.mergeData(read.getPeaks(), false);
        } else {
            this.setData(read.getPeaks(), false);
        }
        this.setFilename(file.getAbsolutePath());
        this.fireDocumentInit();
        return true;
    }

    public String toString() {
        return PeakList.toString(this.peaks);
    }

    public static String toString(Collection<Peak> peaks) {
        StringBuilder ret = new StringBuilder();
        Iterator<Peak> i = peaks.iterator();
        while (i.hasNext()) {
            ret.append(i.next());
            ret.append("\n");
        }
        return ret.toString();
    }

    public void fromString(String str, boolean merge) throws Exception {
        System.err.println("HERE");
        if (merge) {
            this.mergeData(PeakList.parseString(str), false);
        } else {
            this.setData(PeakList.parseString(str), false);
        }
    }

    public static Collection<Peak> parseString(String str) throws Exception {
        String line;
        Vector<Peak> ret = new Vector<Peak>();
        BufferedReader br = new BufferedReader(new StringReader(str));
        while ((line = br.readLine()) != null) {
            Peak p = Peak.parseString(line);
            if (p == null) continue;
            ret.add(p);
        }
        return ret;
    }

    public void fromXML(Node pl_node, boolean merge) throws Exception {
        if (!merge) {
            this.resetStatus();
            this.initData();
        } else {
            this.setChanged(true);
        }
        Vector p_nodes = XMLUtils.findAllChildren((Node)pl_node, (String)"Peak");
        for (Node p_node : p_nodes) {
            Peak p = Peak.fromXML(p_node);
            this.putPVT(p);
        }
        this.updateMaxIntensity();
    }

    public Element toXML(Document document) {
        if (document == null) {
            return null;
        }
        Element pl_node = document.createElement("PeakList");
        if (pl_node == null) {
            return null;
        }
        for (Peak p : this.peaks) {
            Element p_node = p.toXML(document);
            if (p_node == null) continue;
            pl_node.appendChild(p_node);
        }
        return pl_node;
    }

    public void write(TransformerHandler th) throws SAXException {
        th.startElement("", "", "PeakList", new AttributesImpl());
        for (Peak p : this.peaks) {
            p.write(th);
        }
        th.endElement("", "", "PeakList");
    }

    public static class SAXHandler
    extends SAXUtils.ObjectTreeHandler {
        private PeakList theDocument;
        private boolean merge;

        public SAXHandler(PeakList _doc, boolean _merge) {
            this.theDocument = _doc;
            this.merge = _merge;
        }

        public boolean isElement(String namespaceURI, String localName, String qName) {
            return qName.equals(SAXHandler.getNodeElementName());
        }

        public static String getNodeElementName() {
            return "PeakList";
        }

        protected SAXUtils.ObjectTreeHandler getHandler(String namespaceURI, String localName, String qName) {
            if (qName.equals(Peak.SAXHandler.getNodeElementName())) {
                return new Peak.SAXHandler();
            }
            return null;
        }

        protected Object finalizeContent(String namespaceURI, String localName, String qName) throws SAXException {
            if (!this.merge) {
                this.theDocument.resetStatus();
                this.theDocument.initData();
            } else {
                this.theDocument.setChanged(true);
            }
            for (Object o : this.getSubObjects(Peak.SAXHandler.getNodeElementName())) {
                this.theDocument.putPVT((Peak)o);
            }
            this.theDocument.updateMaxIntensity();
            this.object = this.theDocument;
            return this.object;
        }
    }
}

