/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class MMFCreator {
    private long last_position = 0L;
    private File theFile = File.createTempFile("gwb", null);
    private RandomAccessFile theRandomAccessFile;
    private FileOutputStream theStream;
    private DataOutputStream theDataStream;

    public MMFCreator() throws Exception {
        this.theFile.deleteOnExit();
        this.theRandomAccessFile = new RandomAccessFile(this.theFile, "rw");
        this.theStream = new FileOutputStream(this.theFile);
        this.theDataStream = new DataOutputStream(new BufferedOutputStream(this.theStream));
    }

    public void addByte(byte b) throws Exception {
        this.theDataStream.writeByte(b);
    }

    public void addDouble(double v) throws Exception {
        this.theDataStream.writeDouble(v);
    }

    public long getLastPosition() {
        return this.last_position;
    }

    public long getCurrentPosition() throws Exception {
        return this.theStream.getChannel().position();
    }

    public Pointer getPointerFromBeginning() throws Exception {
        this.theDataStream.flush();
        FileChannel fc = this.theStream.getChannel();
        long size = fc.position();
        Pointer ret = new Pointer(this, 0L, size);
        this.last_position = size;
        return ret;
    }

    public Pointer getPointerFromLast() throws Exception {
        this.theDataStream.flush();
        FileChannel fc = this.theStream.getChannel();
        long size = fc.position();
        Pointer ret = new Pointer(this, this.last_position, size - this.last_position);
        this.last_position = size;
        return ret;
    }

    public static class Pointer {
        private MMFCreator mmfc;
        private long position;
        private long size;

        public Pointer(MMFCreator _mmfc, long _position, long _size) {
            this.mmfc = _mmfc;
            this.position = _position;
            this.size = _size;
        }

        public MappedByteBuffer getBuffer(boolean read_only) throws Exception {
            FileChannel fc = this.mmfc.theRandomAccessFile.getChannel();
            if (read_only) {
                return fc.map(FileChannel.MapMode.READ_ONLY, this.position, this.size);
            }
            return fc.map(FileChannel.MapMode.READ_WRITE, this.position, this.size);
        }

        public MMFCreator getCreator() {
            return this.mmfc;
        }

        public long getPosition() {
            return this.position;
        }

        public long getSize() {
            return this.size;
        }
    }
}

