/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench;

import java.util.Vector;
import org.eurocarbdb.application.glycanbuilder.FragmentEntry;
import org.eurocarbdb.application.glycanbuilder.IonCloud;
import org.eurocarbdb.application.glycoworkbench.AnnotationOptions;

public class IonCloudUtils {
    public static boolean isRealistic(FragmentEntry fe) {
        if (fe == null) {
            return false;
        }
        int no_exchanges = -fe.getNeutralExchanges().get("H");
        if (fe.fragment.countCharges() < no_exchanges) {
            return false;
        }
        return fe.getCharges().and(fe.getNeutralExchanges()).isRealistic();
    }

    public static Vector<IonCloud> getPossibleIonClouds(AnnotationOptions ann_opt) {
        Vector<IonCloud> ret = new Vector<IonCloud>();
        IonCloud avail_ions = IonCloudUtils.getAvailableIons(ann_opt);
        if (avail_ions.size() > 0) {
            for (int i = 1; i <= ann_opt.MAX_NO_CHARGES; ++i) {
                IonCloudUtils.enumerateCombinations(ret, new IonCloud(), avail_ions, avail_ions.getIons(), 0, i, ann_opt.NEGATIVE_MODE);
            }
        }
        return ret;
    }

    public static Vector<IonCloud> getPossibleNeutralExchanges(int max_no_ex, AnnotationOptions ann_opt) {
        Vector<IonCloud> ret = new Vector<IonCloud>();
        IonCloud avail_ions = IonCloudUtils.getExchangeableIons(ann_opt);
        if (avail_ions.size() > 0) {
            max_no_ex = Math.min(max_no_ex, avail_ions.size());
            for (int i = 0; i <= max_no_ex; ++i) {
                IonCloudUtils.enumerateCombinations(ret, new IonCloud().and("H", -i), avail_ions, avail_ions.getIons(), 0, i, false);
            }
        }
        return ret;
    }

    private static IonCloud getAvailableIons(AnnotationOptions ann_opt) {
        IonCloud ret = new IonCloud();
        ret.add("H", ann_opt.MAX_NO_H_IONS);
        if (!ann_opt.NEGATIVE_MODE) {
            ret.add("Na", ann_opt.MAX_NO_NA_IONS);
            ret.add("Li", ann_opt.MAX_NO_LI_IONS);
            ret.add("K", ann_opt.MAX_NO_K_IONS);
        }
        return ret;
    }

    private static IonCloud getExchangeableIons(AnnotationOptions ann_opt) {
        IonCloud ret = new IonCloud();
        ret.add("Na", ann_opt.MAX_EX_NA_IONS);
        ret.add("Li", ann_opt.MAX_EX_LI_IONS);
        ret.add("K", ann_opt.MAX_EX_K_IONS);
        return ret;
    }

    public static void enumerateCombinations(Vector<IonCloud> buffer, IonCloud combination, IonCloud limits, Vector<String> collection, int ind, int remaining, boolean negative) {
        if (remaining == 0) {
            buffer.add(combination);
            return;
        }
        if (ind == collection.size()) {
            return;
        }
        String ion = collection.elementAt(ind);
        int max = Math.min(remaining, limits.get(ion));
        for (int i = 0; i <= max; ++i) {
            IonCloudUtils.enumerateCombinations(buffer, combination.and(ion, negative ? -i : i), limits, collection, ind + 1, remaining - i, negative);
        }
    }
}

