/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.wizard.lipidgeneration;

import org.apache.log4j.Logger;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.tools.gsl.util.LipidGeneratorUtils;
import org.grits.toolbox.tools.gsl.util.generator.LipidParametersIO;

public class LipidGenerationSettingPage
extends WizardPage {
    private static final Logger logger = Logger.getLogger(LipidGenerationSettingPage.class);
    private Button m_radioCeramide;
    private Button m_radioSphingosine;
    private Text m_textCarbonLengthSp;
    private Text m_textHydroxylGroupsSp;
    private Text m_textNumUnsatSp;
    private Button m_btnOnlyEvenNumbersSp;
    private Text m_textCarbonLengthFA;
    private Text m_textHydroxylGroupsFA;
    private Text m_textNumUnsatFA;
    private Button m_btnOnlyEvenNumbersFA;
    private Label m_lblNumberOfLipids;

    public boolean isSelectedCeramide() {
        return this.m_radioCeramide.getSelection();
    }

    public boolean isSelectedSphingosine() {
        return this.m_radioSphingosine.getSelection();
    }

    public String getCarbonLengthForSphingosine() {
        return this.m_textCarbonLengthSp.getText().trim();
    }

    public String getNumberOfHydroxyGroupsForSphingosine() {
        return this.m_textHydroxylGroupsSp.getText().trim();
    }

    public String getNumberOfUnsaturationForSphingosine() {
        return this.m_textNumUnsatSp.getText().trim();
    }

    public boolean isSelectedOnlyEvenNumbersForSphingosine() {
        return this.m_btnOnlyEvenNumbersSp.getSelection();
    }

    public String getCarbonLengthForFattyAcid() {
        return this.m_textCarbonLengthFA.getText().trim();
    }

    public String getNumberOfHydroxyGroupsForFattyAcid() {
        return this.m_textHydroxylGroupsFA.getText().trim();
    }

    public String getNumberOfUnsaturationForFattyAcid() {
        return this.m_textNumUnsatFA.getText().trim();
    }

    public boolean isSelectedOnlyEvenNumbersForFattyAcid() {
        return this.m_btnOnlyEvenNumbersFA.getSelection();
    }

    public LipidGenerationSettingPage() {
        super("Lipid Database Name");
        this.setTitle("Lipid Parameters");
        this.setDescription("Choose lipid and enter the parameters for generating lipid.");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        GridLayout gl_area = new GridLayout(1, false);
        container.setLayout((Layout)gl_area);
        Group grpLipidType = new Group(container, 0);
        grpLipidType.setText("Lipid class");
        grpLipidType.setLayout((Layout)new GridLayout(2, false));
        grpLipidType.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.m_radioCeramide = new Button((Composite)grpLipidType, 16);
        this.m_radioCeramide.setText("Ceramide");
        this.m_radioCeramide.setSelection(true);
        this.m_radioSphingosine = new Button((Composite)grpLipidType, 16);
        this.m_radioSphingosine.setText("Sphingosine");
        Group grpSp = new Group(container, 0);
        grpSp.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        grpSp.setText("Sphingosine");
        grpSp.setLayout((Layout)new GridLayout(2, false));
        this.makeLabel(grpSp, "Carbon length");
        this.m_textCarbonLengthSp = this.makeParameterText(grpSp, "14-30");
        this.makeLabel(grpSp, "# of hydroxyl groups");
        this.m_textHydroxylGroupsSp = this.makeParameterText(grpSp, "1-4");
        this.makeLabel(grpSp, "# of unsaturation");
        this.m_textNumUnsatSp = this.makeParameterText(grpSp, "0-3");
        this.m_btnOnlyEvenNumbersSp = this.makeCheckButton(grpSp, "Only allow even number for carbon length");
        final Group grpFA = new Group(container, 0);
        grpFA.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        grpFA.setText("Fatty Acid");
        grpFA.setLayout((Layout)new GridLayout(2, false));
        this.makeLabel(grpFA, "Carbon length");
        this.m_textCarbonLengthFA = this.makeParameterText(grpFA, "14-26");
        this.makeLabel(grpFA, "# of hydroxyl groups");
        this.m_textHydroxylGroupsFA = this.makeParameterText(grpFA, "0-2");
        this.makeLabel(grpFA, "# of unsaturation");
        this.m_textNumUnsatFA = this.makeParameterText(grpFA, "0-3");
        this.m_btnOnlyEvenNumbersFA = this.makeCheckButton(grpFA, "Only allow even number for carbon length");
        this.m_lblNumberOfLipids = new Label(container, 0);
        this.m_lblNumberOfLipids.setAlignment(16384);
        this.m_radioCeramide.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                if (!button.getSelection()) {
                    return;
                }
                grpFA.setVisible(true);
                LipidGenerationSettingPage.this.setPageCompleteVerifyingTexts();
                LipidGenerationSettingPage.this.writeNumberOfLipids();
            }
        });
        this.m_radioSphingosine.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                if (!button.getSelection()) {
                    return;
                }
                grpFA.setVisible(false);
                LipidGenerationSettingPage.this.setPageCompleteVerifyingTexts();
                LipidGenerationSettingPage.this.writeNumberOfLipids();
            }
        });
        this.setPageCompleteVerifyingTexts();
        this.writeNumberOfLipids();
    }

    private Label makeLabel(Group grp, String strLabel) {
        Label lbl = new Label((Composite)grp, 0);
        lbl.setAlignment(131072);
        lbl.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lbl.setText(strLabel);
        return lbl;
    }

    private Text makeText(Group grp, String strInit) {
        Text txt = new Text((Composite)grp, 2048);
        txt.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        txt.setText(strInit);
        return txt;
    }

    private Text makeParameterText(Group grp, String strInit) {
        Text txt = this.makeText(grp, strInit);
        this.setListnerToParameterText(txt);
        return txt;
    }

    private Button makeCheckButton(Group grp, String strText) {
        Button btnChk = new Button((Composite)grp, 32);
        btnChk.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        btnChk.setText(strText);
        btnChk.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LipidGenerationSettingPage.this.writeNumberOfLipids();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                LipidGenerationSettingPage.this.writeNumberOfLipids();
            }
        });
        return btnChk;
    }

    private boolean verifyParameterText(Text a_txt) {
        String t_strParam = a_txt.getText().trim();
        try {
            if (!LipidGeneratorUtils.validateValueRangesFormat(t_strParam)) {
                this.setErrorMessage("Values are required.");
                logger.debug((Object)"Values are requeired.");
                return false;
            }
        }
        catch (NumberFormatException nfe) {
            this.setErrorMessage(nfe.getMessage());
            logger.debug((Object)nfe.getMessage());
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private void setPageCompleteVerifyingTexts() {
        Color t_colDef = Display.getCurrent().getSystemColor(25);
        Color t_colErr = Display.getCurrent().getSystemColor(7);
        if (!this.verifyParameterText(this.m_textCarbonLengthSp)) {
            this.setPageComplete(false);
            this.m_textCarbonLengthSp.setBackground(t_colErr);
            return;
        }
        this.m_textCarbonLengthSp.setBackground(t_colDef);
        if (!this.m_textHydroxylGroupsSp.getText().trim().isEmpty() && !this.verifyParameterText(this.m_textHydroxylGroupsSp)) {
            this.setPageComplete(false);
            this.m_textHydroxylGroupsSp.setBackground(t_colErr);
            return;
        }
        this.m_textHydroxylGroupsSp.setBackground(t_colDef);
        if (!this.m_textNumUnsatSp.getText().trim().isEmpty() && !this.verifyParameterText(this.m_textNumUnsatSp)) {
            this.setPageComplete(false);
            this.m_textNumUnsatSp.setBackground(t_colErr);
            return;
        }
        this.m_textNumUnsatSp.setBackground(t_colDef);
        if (!this.m_radioCeramide.getSelection()) {
            this.setPageComplete(true);
            return;
        }
        if (!this.verifyParameterText(this.m_textCarbonLengthFA)) {
            this.setPageComplete(false);
            this.m_textCarbonLengthFA.setBackground(t_colErr);
            return;
        }
        this.m_textCarbonLengthFA.setBackground(t_colDef);
        if (!this.m_textHydroxylGroupsFA.getText().trim().isEmpty() && !this.verifyParameterText(this.m_textHydroxylGroupsFA)) {
            this.setPageComplete(false);
            this.m_textHydroxylGroupsFA.setBackground(t_colErr);
            return;
        }
        this.m_textHydroxylGroupsFA.setBackground(t_colDef);
        if (!this.m_textNumUnsatFA.getText().trim().isEmpty() && !this.verifyParameterText(this.m_textNumUnsatFA)) {
            this.setPageComplete(false);
            this.m_textNumUnsatFA.setBackground(t_colErr);
            return;
        }
        this.m_textNumUnsatFA.setBackground(t_colDef);
        this.setPageComplete(true);
    }

    private int calculateNumberOfLipid() {
        int t_nLipids = 0;
        LipidParametersIO t_lipParams = new LipidParametersIO();
        t_lipParams.setCarbonLengths(this.m_textCarbonLengthSp.getText().trim());
        if (!this.m_textHydroxylGroupsSp.getText().trim().isEmpty()) {
            t_lipParams.setNumbersOfHydroxylGroups(this.m_textHydroxylGroupsSp.getText().trim());
        }
        if (!this.m_textNumUnsatSp.getText().trim().isEmpty()) {
            t_lipParams.setNumbersOfUnsaturations(this.m_textNumUnsatSp.getText().trim());
        }
        t_lipParams.setOnlyEvenNumberForCarbonLength(this.m_btnOnlyEvenNumbersSp.getSelection());
        t_nLipids = t_lipParams.calculateNumberOfCombination();
        if (this.isSelectedSphingosine()) {
            return t_nLipids;
        }
        t_lipParams = new LipidParametersIO();
        t_lipParams.setCarbonLengths(this.m_textCarbonLengthFA.getText().trim());
        if (!this.m_textHydroxylGroupsFA.getText().trim().isEmpty()) {
            t_lipParams.setNumbersOfHydroxylGroups(this.m_textHydroxylGroupsFA.getText().trim());
        }
        if (!this.m_textNumUnsatFA.getText().trim().isEmpty()) {
            t_lipParams.setNumbersOfUnsaturations(this.m_textNumUnsatFA.getText().trim());
        }
        t_lipParams.setOnlyEvenNumberForCarbonLength(this.m_btnOnlyEvenNumbersFA.getSelection());
        return t_nLipids *= t_lipParams.calculateNumberOfCombination();
    }

    private void writeNumberOfLipids() {
        if (!this.isPageComplete()) {
            this.m_lblNumberOfLipids.setText("");
            this.m_lblNumberOfLipids.getParent().layout();
            return;
        }
        int t_nLipids = this.calculateNumberOfLipid();
        this.m_lblNumberOfLipids.setText(String.valueOf(t_nLipids) + " lipids will be generated.");
        this.m_lblNumberOfLipids.getParent().layout();
    }

    private void setListnerToParameterText(Text a_txt) {
        a_txt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LipidGenerationSettingPage.this.setPageCompleteVerifyingTexts();
                LipidGenerationSettingPage.this.writeNumberOfLipids();
            }
        });
        a_txt.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                LipidGenerationSettingPage.this.setPageCompleteVerifyingTexts();
                LipidGenerationSettingPage.this.writeNumberOfLipids();
            }
        });
    }
}

