/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.structure.lipid;

import java.util.ArrayList;
import java.util.List;
import org.grits.toolbox.tools.gsl.structure.lipid.FattyAcid;
import org.grits.toolbox.tools.gsl.structure.lipid.ILipid;
import org.grits.toolbox.tools.gsl.structure.lipid.Sphingosine;

public class Ceramide
implements ILipid {
    private Sphingosine m_oSphingosine;
    private FattyAcid m_oFattyAcid;

    public Ceramide(Sphingosine a_oSph, FattyAcid a_oFA) {
        this.m_oSphingosine = a_oSph;
        this.m_oFattyAcid = a_oFA;
    }

    public Sphingosine getSphingosine() {
        return this.m_oSphingosine;
    }

    public FattyAcid getFattyAcid() {
        return this.m_oFattyAcid;
    }

    @Override
    public int getCarbonLength() {
        return this.m_oSphingosine.getCarbonLength() + this.m_oFattyAcid.getCarbonLength();
    }

    @Override
    public int getNumberOfHydroxylGroups() {
        return this.m_oSphingosine.getNumberOfHydroxylGroups() + this.m_oFattyAcid.getNumberOfHydroxylGroups();
    }

    @Override
    public int getNumberOfOAcetylGroups() {
        return this.m_oSphingosine.getNumberOfOAcetylGroups() + this.m_oFattyAcid.getNumberOfOAcetylGroups();
    }

    @Override
    public int getNumberOfUnsaturation() {
        return this.m_oSphingosine.getNumberOfUnsaturation() + this.m_oFattyAcid.getNumberOfUnsaturation();
    }

    @Override
    public String getCoreName() {
        return String.valueOf(this.m_oSphingosine.getCoreName()) + "/" + this.m_oFattyAcid.getCoreName();
    }

    @Override
    public String getName() {
        return "Cer(" + this.getCoreName() + ")";
    }

    @Override
    public String getCompositionName() {
        String t_strName = String.valueOf(this.getCarbonLength()) + ":" + this.getNumberOfUnsaturation();
        if (this.getNumberOfHydroxylGroups() > 0) {
            String t_strOH = this.getNumberOfHydroxylGroups() == 1 ? "h" : (this.getNumberOfHydroxylGroups() == 2 ? "d" : (this.getNumberOfHydroxylGroups() == 3 ? "t" : (this.getNumberOfHydroxylGroups() == 4 ? "tet" : "h" + this.getNumberOfHydroxylGroups() + "-")));
            t_strName = String.valueOf(t_strOH) + t_strName;
        }
        return "Cer(" + t_strName + ")";
    }

    @Override
    public boolean hasSubstructure() {
        return true;
    }

    @Override
    public List<String> getSubstructureNames() {
        ArrayList<String> t_listSubstNames = new ArrayList<String>();
        t_listSubstNames.add(this.m_oSphingosine.getName());
        t_listSubstNames.add(this.m_oFattyAcid.getName());
        return t_listSubstNames;
    }
}

