/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.display.control.table.tablecore;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.BackgroundPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.CellStyleUtil;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class GRITSImagePainter
extends BackgroundPainter {
    protected Image image;
    private final boolean paintBg;

    public GRITSImagePainter() {
        this(null);
    }

    public GRITSImagePainter(Image image) {
        this(image, true);
    }

    public GRITSImagePainter(Image image, boolean paintBg) {
        this.image = image;
        this.paintBg = paintBg;
    }

    public int getPreferredWidth(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        Image image = this.getImage(cell, configRegistry);
        if (image != null) {
            return image.getBounds().width;
        }
        return 0;
    }

    public int getPreferredHeight(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        Image image = this.getImage(cell, configRegistry);
        if (image != null) {
            return image.getBounds().height;
        }
        return 0;
    }

    public ICellPainter getCellPainterAt(int x, int y, ILayerCell cell, GC gc, Rectangle bounds, IConfigRegistry configRegistry) {
        Image image = this.getImage(cell, configRegistry);
        if (image != null) {
            Rectangle imageBounds = image.getBounds();
            IStyle cellStyle = CellStyleUtil.getCellStyle((ILayerCell)cell, (IConfigRegistry)configRegistry);
            int x0 = bounds.x + CellStyleUtil.getHorizontalAlignmentPadding((IStyle)cellStyle, (Rectangle)bounds, (int)imageBounds.width);
            int y0 = bounds.y + CellStyleUtil.getVerticalAlignmentPadding((IStyle)cellStyle, (Rectangle)bounds, (int)imageBounds.height);
            if (x >= x0 && x < x0 + imageBounds.width && y >= y0 && y < y0 + imageBounds.height) {
                return super.getCellPainterAt(x, y, cell, gc, bounds, configRegistry);
            }
        }
        return null;
    }

    public void paintCell(ILayerCell cell, GC gc, Rectangle bounds, IConfigRegistry configRegistry) {
        Image image;
        if (this.paintBg) {
            super.paintCell(cell, gc, bounds, configRegistry);
        }
        if ((image = this.getImage(cell, configRegistry)) != null) {
            Rectangle imageBounds = image.getBounds();
            IStyle cellStyle = CellStyleUtil.getCellStyle((ILayerCell)cell, (IConfigRegistry)configRegistry);
            gc.drawImage(image, bounds.x + CellStyleUtil.getHorizontalAlignmentPadding((IStyle)cellStyle, (Rectangle)bounds, (int)imageBounds.width), bounds.y + CellStyleUtil.getVerticalAlignmentPadding((IStyle)cellStyle, (Rectangle)bounds, (int)imageBounds.height));
        }
    }

    protected Image getImage(ILayerCell cell, IConfigRegistry configRegistry) {
        return this.image != null ? this.image : (Image)CellStyleUtil.getCellStyle((ILayerCell)cell, (IConfigRegistry)configRegistry).getAttributeValue(CellStyleAttributes.IMAGE);
    }
}

