/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.helpers.FileUtils;
import org.apache.logging.log4j.core.impl.Log4jContextFactory;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.apache.logging.log4j.status.StatusLogger;

public final class Configurator {
    protected static final StatusLogger LOGGER = StatusLogger.getLogger();

    private Configurator() {
    }

    public static LoggerContext initialize(String name, ClassLoader loader, String configLocation) {
        return Configurator.initialize(name, loader, configLocation, null);
    }

    public static LoggerContext initialize(String name, ClassLoader loader, String configLocation, Object externalContext) {
        try {
            URI uri = configLocation == null ? null : FileUtils.getCorrectedFilePathUri(configLocation);
            return Configurator.initialize(name, loader, uri, externalContext);
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static LoggerContext initialize(String name, String configLocation) {
        return Configurator.initialize(name, null, configLocation);
    }

    public static LoggerContext initialize(String name, ClassLoader loader, URI configLocation) {
        return Configurator.initialize(name, loader, configLocation, null);
    }

    public static LoggerContext initialize(String name, ClassLoader loader, URI configLocation, Object externalContext) {
        try {
            org.apache.logging.log4j.spi.LoggerContext context = LogManager.getContext((ClassLoader)loader, (boolean)false, (Object)externalContext, (URI)configLocation, (String)name);
            if (context instanceof LoggerContext) {
                return (LoggerContext)context;
            }
            LOGGER.error("LogManager returned an instance of {} which does not implement {}. Unable to initialize Log4j", new Object[]{context.getClass().getName(), LoggerContext.class.getName()});
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static LoggerContext initialize(ClassLoader loader, ConfigurationFactory.ConfigurationSource source) {
        return Configurator.initialize(loader, source, null);
    }

    public static LoggerContext initialize(ClassLoader loader, ConfigurationFactory.ConfigurationSource source, Object externalContext) {
        try {
            LoggerContext context;
            URI configLocation = null;
            try {
                configLocation = source.getLocation() == null ? null : FileUtils.getCorrectedFilePathUri(source.getLocation());
            }
            catch (Exception ex) {
                // empty catch block
            }
            LoggerContextFactory f = LogManager.getFactory();
            if (f instanceof Log4jContextFactory) {
                Log4jContextFactory factory = (Log4jContextFactory)f;
                context = factory.getContext(Configurator.class.getName(), loader, externalContext, false, source);
                if (context instanceof LoggerContext) {
                    return context;
                }
            } else {
                LOGGER.error("LogManager is not using a Log4j Context Factory. Unable to initialize Log4j");
                return null;
            }
            LOGGER.error("LogManager returned an instance of {} which does not implement {}. Unable to initialize Log4j", new Object[]{context.getClass().getName(), LoggerContext.class.getName()});
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static void shutdown(LoggerContext ctx) {
        if (ctx != null) {
            ctx.stop();
        }
    }
}

