/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.nonmonosaccharide;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eurocarbdb.resourcesdb.GlycanNamescheme;
import org.eurocarbdb.resourcesdb.nonmonosaccharide.AglyconAlias;
import org.eurocarbdb.resourcesdb.nonmonosaccharide.NonmonosaccharideException;
import org.eurocarbdb.resourcesdb.template.NonBasetypeTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AglyconTemplate
extends NonBasetypeTemplate {
    private String aglyconClass;
    private HashMap<GlycanNamescheme, String> primaryAliasMap = new HashMap();
    private List<AglyconAlias> aliasList;
    private int dbId;

    public AglyconTemplate() {
        this.init();
    }

    public String getAglyconClass() {
        return this.aglyconClass;
    }

    public void setAglyconClass(String aglyconClassStr) {
        this.aglyconClass = aglyconClassStr;
    }

    public List<AglyconAlias> getAliasList() {
        return this.aliasList;
    }

    public void setAliasList(List<AglyconAlias> aliasList) {
        this.aliasList = aliasList;
    }

    public void addAlias(AglyconAlias alias) {
        List<AglyconAlias> aliases = this.getAliasList();
        if (aliases == null) {
            aliases = new ArrayList<AglyconAlias>();
            this.setAliasList(aliases);
        }
        aliases.add(alias);
    }

    private HashMap<GlycanNamescheme, String> getPrimaryAliasMap() {
        return this.primaryAliasMap;
    }

    public void setPrimaryAlias(GlycanNamescheme scheme, String name) {
        if (this.getPrimaryAliasMap() == null) {
            this.primaryAliasMap = new HashMap();
        }
        this.getPrimaryAliasMap().put(scheme, name);
    }

    public String getPrimaryAlias(GlycanNamescheme scheme) throws NonmonosaccharideException {
        String alias = this.getPrimaryAliasMap().get((Object)scheme);
        if (alias == null) {
            throw new NonmonosaccharideException("Cannot get primary alias of aglycon " + this.getName() + " in notation " + scheme.getNameStr());
        }
        return alias;
    }

    public int getDbId() {
        return this.dbId;
    }

    public void setDbId(int dbId) {
        this.dbId = dbId;
    }

    @Override
    public void init() {
        super.init();
        this.setAglyconClass(null);
        this.primaryAliasMap = new HashMap();
        this.setDbId(0);
    }

    @Override
    public String toString() {
        String outStr = super.toString();
        outStr = outStr + "Class: " + this.getAglyconClass() + "\n";
        if (this.getAliasList() != null) {
            for (AglyconAlias alias : this.getAliasList()) {
                outStr = outStr + "Alias: " + alias.toString() + "\n";
            }
        }
        return outStr;
    }
}

