/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.wordgeneration;

import java.math.BigInteger;
import java.text.SimpleDateFormat;
import org.apache.log4j.Logger;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.io.ProjectDetailsHandler;
import org.grits.toolbox.core.datamodel.property.ProjectProperty;
import org.grits.toolbox.core.datamodel.property.project.ProjectCollaborator;
import org.grits.toolbox.core.datamodel.property.project.ProjectDetails;
import org.grits.toolbox.core.datamodel.property.project.ProjectEvent;
import org.grits.toolbox.core.datamodel.property.project.ProjectTasklist;
import org.grits.toolbox.core.preference.project.CollaboratorTableColumn;
import org.grits.toolbox.editor.experimentdesigner.pdfgeneration.ProjectReportPage;

public class ProjectReportWordPage {
    private static final Logger logger = Logger.getLogger(ProjectReportWordPage.class);
    public static final SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");

    public static void addProjectPage(Entry projectEntry, ProjectProperty projectProperty, XWPFDocument document) {
        if (document != null) {
            try {
                XWPFParagraph p1 = ProjectReportWordPage.writeHeadline(document, "Project Information", 14);
                p1.createRun().addBreak();
                ProjectReportWordPage.addLine(p1, "Name", projectEntry.getDisplayName(), 3);
                ProjectReportWordPage.addLine(p1, "Date Created", projectEntry.getCreationDate().toString(), 2);
                ProjectDetails projectDetails = ProjectDetailsHandler.getProjectDetails((Entry)projectEntry);
                if (projectDetails != null) {
                    ProjectReportWordPage.addLine(p1, "Description", projectDetails.getDescription(), 2);
                    ProjectReportWordPage.addCollaboratorPart(document, projectDetails);
                    ProjectReportWordPage.addTasklistPart(document, projectDetails);
                    ProjectReportWordPage.addEventPart(document, projectDetails);
                    ProjectReportWordPage.addKeywordsPart(document, projectDetails);
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private static void addCollaboratorPart(XWPFDocument document, ProjectDetails projectDetails) {
        try {
            ProjectReportWordPage.writeUnderlined(document, "Project Collaborators", 12);
            XWPFParagraph p1 = null;
            int i = 1;
            for (ProjectCollaborator collaborator : projectDetails.getCollaborators()) {
                try {
                    p1 = ProjectReportWordPage.writeHeadline(document, String.valueOf(i) + ". " + CollaboratorTableColumn.getColumnValue((ProjectCollaborator)collaborator, (String)CollaboratorTableColumn.COLUMNS[0]), 12);
                    int j = 0;
                    while (j < CollaboratorTableColumn.COLUMNS.length) {
                        ProjectReportWordPage.addLine(p1, CollaboratorTableColumn.COLUMNS[j], CollaboratorTableColumn.getColumnValue((ProjectCollaborator)collaborator, (String)CollaboratorTableColumn.COLUMNS[j]));
                        ++j;
                    }
                    ++i;
                }
                catch (Exception ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private static void addTasklistPart(XWPFDocument document, ProjectDetails projectDetails) {
        try {
            ProjectReportWordPage.writeUnderlined(document, "Tasklist", 12);
            XWPFTable table = document.createTable();
            XWPFTableRow row = table.getRow(0);
            ProjectReportWordPage.addTableHeadlineCell(row.getCell(0), "Task", 8000);
            ProjectReportWordPage.addTableHeadlineCell(row.addNewTableCell(), "Person", 8000);
            ProjectReportWordPage.addTableHeadlineCell(row.addNewTableCell(), "Status", 8000);
            ProjectReportWordPage.addTableHeadlineCell(row.addNewTableCell(), "Due Date", 8000);
            ProjectReportWordPage.addTableHeadlineCell(row.addNewTableCell(), "Role", 7000);
            ProjectReportWordPage.addTableHeadlineCell(row.addNewTableCell(), "Group/P.I.", 8000);
            ProjectReportWordPage.addTableHeadlineCell(row.addNewTableCell(), "Description", 8000);
            for (ProjectTasklist task : projectDetails.getTasklists()) {
                ProjectReportWordPage.addTaskRow(table, task);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private static void addTaskRow(XWPFTable table, ProjectTasklist task) {
        XWPFTableRow row = table.createRow();
        row.getCell(0).setText(task.getTask());
        row.getCell(1).setText(task.getPerson());
        row.getCell(2).setText(task.getStatus());
        String dueDate = task.getDueDate() == null ? "" : dateFormat.format(task.getDueDate());
        row.getCell(3).setText(dueDate);
        row.getCell(4).setText(task.getRole());
        row.getCell(5).setText(task.getGroupOrPIName());
        row.getCell(6).setText(task.getDescription());
    }

    private static void addEventPart(XWPFDocument document, ProjectDetails projectDetails) {
        try {
            document.createParagraph().createRun().addBreak();
            ProjectReportWordPage.writeUnderlined(document, "Events", 12);
            XWPFTable table = document.createTable();
            XWPFTableRow row = table.getRow(0);
            ProjectReportWordPage.addTableHeadlineCell(row.getCell(0), "Action", 20000);
            ProjectReportWordPage.addTableHeadlineCell(row.addNewTableCell(), "Date", 10000);
            ProjectReportWordPage.addTableHeadlineCell(row.addNewTableCell(), "Description", 25000);
            for (ProjectEvent event : projectDetails.getEvents()) {
                ProjectReportWordPage.addEventRow(table, event);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private static void addEventRow(XWPFTable table, ProjectEvent event) {
        XWPFTableRow thisRow = table.createRow();
        String value = event.getProjectAction() == null || event.getProjectAction().getAction() == null ? "" : event.getProjectAction().getAction();
        thisRow.getCell(0).setText(value);
        value = event.getEventDate() == null ? "" : dateFormat.format(event.getEventDate());
        thisRow.getCell(1).setText(value);
        thisRow.getCell(2).setText(event.getDescription());
    }

    private static void addKeywordsPart(XWPFDocument document, ProjectDetails projectDetails) {
        try {
            document.createParagraph().createRun().addBreak();
            XWPFParagraph p1 = ProjectReportWordPage.writeUnderlined(document, "Keywords", 12);
            String keywords = ProjectReportPage.getCSKeywords(projectDetails.getKeywords());
            if (!keywords.isEmpty()) {
                ProjectReportWordPage.addLine(p1, "", keywords, 0);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private static void addTableHeadlineCell(XWPFTableCell cell, String value, int width) {
        cell.setColor("C8C8C8");
        cell.getCTTc().addNewTcPr().addNewTcW().setW(BigInteger.valueOf(width));
        if (cell.getParagraphs().iterator().hasNext()) {
            XWPFParagraph paragraph = (XWPFParagraph)cell.getParagraphs().iterator().next();
            paragraph.setAlignment(ParagraphAlignment.CENTER);
            XWPFRun runCell = paragraph.createRun();
            runCell.setBold(true);
            runCell.setText(value);
        }
    }

    private static void addLine(XWPFParagraph p1, String label, String value) {
        int numberOfTabs = (int)Math.ceil((18.0 - (double)label.length()) / 6.0);
        ProjectReportWordPage.addLine(p1, label, value, numberOfTabs);
    }

    private static void addLine(XWPFParagraph p1, String label, String value, int numberOfTabs) {
        XWPFRun r1 = p1.createRun();
        r1.setBold(true);
        r1.setText(label);
        logger.debug((Object)("label.length" + label.length()));
        logger.debug((Object)("numberOfTabs" + numberOfTabs));
        XWPFRun r2 = p1.createRun();
        int i = 0;
        while (i < numberOfTabs) {
            r2.addTab();
            ++i;
        }
        r2.setText(value);
        r2.addCarriageReturn();
    }

    private static XWPFParagraph writeUnderlined(XWPFDocument document, String value, int fontSize) {
        XWPFParagraph paragraphOne = document.createParagraph();
        paragraphOne.setAlignment(ParagraphAlignment.LEFT);
        XWPFRun paragraphOneRunOne = paragraphOne.createRun();
        paragraphOneRunOne.setBold(true);
        paragraphOneRunOne.setFontSize(fontSize);
        paragraphOneRunOne.setText(value);
        paragraphOneRunOne.setUnderline(UnderlinePatterns.SINGLE);
        paragraphOneRunOne.addCarriageReturn();
        return paragraphOne;
    }

    private static XWPFParagraph writeHeadline(XWPFDocument document, String value, int fontSize) {
        XWPFParagraph paragraphOne = document.createParagraph();
        paragraphOne.setAlignment(ParagraphAlignment.LEFT);
        XWPFRun paragraphOneRunOne = paragraphOne.createRun();
        paragraphOneRunOne.setBold(true);
        paragraphOneRunOne.setFontSize(fontSize);
        paragraphOneRunOne.setText(value);
        paragraphOneRunOne.addCarriageReturn();
        return paragraphOne;
    }
}

