/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.pubmed;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.grits.toolbox.editor.experimentdesigner.pubmed.DTOPublication;
import org.grits.toolbox.editor.experimentdesigner.pubmed.DTOPublicationAuthor;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class PubmedUtil {
    private String m_strPubmedURL = "https://eutils.ncbi.nlm.nih.gov/entrez/eutils/esummary.fcgi?db=pubmed&retmode=xml&id=";
    private HashMap<String, Element> m_hashElements = new HashMap();
    private Document m_document = null;
    private Pattern m_patternYear = Pattern.compile(".*([0-9]{4}).*");
    private Pattern m_patternPages = Pattern.compile("^([0-9]+)(?:\\-([0-9]+))?$");

    public DTOPublication createFromPubmedId(Integer a_pubmedId) throws MalformedURLException, Exception {
        this.clear();
        String t_strAnswer = this.makeHttpRequest(new URL(String.valueOf(this.m_strPubmedURL) + a_pubmedId.toString()));
        DTOPublication t_result = this.createFromPubmed(t_strAnswer);
        if (t_result == null) {
            return null;
        }
        if (!a_pubmedId.equals(t_result.getPubmedId())) {
            return null;
        }
        return t_result;
    }

    private void clear() {
        this.m_document = null;
        this.m_hashElements.clear();
    }

    private String makeHttpRequest(URL a_url) throws Exception {
        int t_count;
        URLConnection t_connection = a_url.openConnection();
        t_connection.setUseCaches(false);
        BufferedReader t_reader = new BufferedReader(new InputStreamReader(t_connection.getInputStream()));
        StringBuilder t_result = new StringBuilder();
        while ((t_count = t_reader.read()) != -1) {
            t_result.appendCodePoint(t_count);
        }
        return t_result.toString();
    }

    private DTOPublication createFromPubmed(String a_strXML) throws JDOMException, IOException {
        if (!this.readXML(a_strXML)) {
            return null;
        }
        DTOPublication t_result = new DTOPublication();
        t_result.setPubmedId(this.getPubmedId());
        t_result.setDoiId(this.getPubmedItem("DOI"));
        if (t_result.getDoiId() == null) {
            t_result.setDoiId(this.getPubmedSubItem("ArticleIds", "doi"));
        }
        t_result.setTitle(this.getPubmedItem("Title"));
        t_result.setJournal(this.getPubmedItem("FullJournalName"));
        t_result.setVolume(this.getPubmedItem("Volume"));
        t_result.setNumber(this.getPubmedItem("Issue"));
        Matcher t_matcherYear = this.m_patternYear.matcher(this.getPubmedItem("PubDate"));
        if (t_matcherYear.matches()) {
            t_result.setYear(Integer.valueOf(t_matcherYear.group(1)));
        }
        String t_strStart = null;
        String t_strEnd = null;
        Matcher pm = this.m_patternPages.matcher(this.getPubmedItem("Pages"));
        if (pm.matches() && pm.group(1) != null && pm.group(1).length() > 0) {
            t_strStart = pm.group(1);
            if (pm.group(2) != null && pm.group(2).length() > 0 && (t_strEnd = pm.group(2)).length() < t_strStart.length()) {
                t_strEnd = String.valueOf(t_strStart.substring(0, t_strStart.length() - t_strEnd.length())) + t_strEnd;
            }
        }
        if (t_strStart == null) {
            t_result.setStartPage(null);
        } else {
            t_result.setStartPage(t_strStart);
        }
        if (t_strEnd == null) {
            t_result.setEndPage(null);
        } else {
            t_result.setEndPage(t_strEnd);
        }
        t_result.setAuthors(this.getAuthors());
        return t_result;
    }

    private List<DTOPublicationAuthor> getAuthors() {
        ArrayList<DTOPublicationAuthor> t_result = new ArrayList<DTOPublicationAuthor>();
        Element t_elmentAuthorList = this.m_hashElements.get("AuthorList");
        if (t_elmentAuthorList == null) {
            return t_result;
        }
        List t_childItem = t_elmentAuthorList.getChildren("Item");
        for (Element t_elementItem : t_childItem) {
            String t_strValue = t_elementItem.getAttributeValue("Name");
            if (t_strValue == null) continue;
            t_result.add(this.parseAuthorName(t_elementItem.getText()));
        }
        return t_result;
    }

    private DTOPublicationAuthor parseAuthorName(String a_strText) {
        DTOPublicationAuthor t_author = new DTOPublicationAuthor();
        if (a_strText == null) {
            return t_author;
        }
        String t_strText = a_strText.trim();
        int t_iPos = t_strText.lastIndexOf(" ");
        if (t_iPos == -1) {
            t_author.setLastName(t_strText);
        } else {
            t_author.setFirstName(t_strText.substring(t_iPos + 1));
            t_author.setLastName(t_strText.substring(0, t_iPos));
        }
        return t_author;
    }

    private String getPubmedSubItem(String a_strMainItem, String a_strSubItem) {
        Element t_elementMain = this.m_hashElements.get(a_strMainItem);
        if (t_elementMain == null) {
            return null;
        }
        List t_childItem = t_elementMain.getChildren("Item");
        for (Element t_elementItem : t_childItem) {
            String t_strValue = t_elementItem.getAttributeValue("Name");
            if (t_strValue == null || !t_strValue.equals(a_strSubItem)) continue;
            return t_elementItem.getText();
        }
        return null;
    }

    private Integer getPubmedId() {
        Element t_elementDocSum = this.m_hashElements.get("DocSum");
        if (t_elementDocSum == null) {
            return null;
        }
        List t_childItem = t_elementDocSum.getChildren("Id");
        Iterator iterator = t_childItem.iterator();
        if (iterator.hasNext()) {
            Element t_elementId = (Element)iterator.next();
            try {
                return Integer.parseInt(t_elementId.getText());
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    private boolean readXML(String a_strXML) throws JDOMException, IOException {
        SAXBuilder t_builder = new SAXBuilder();
        this.m_document = t_builder.build((Reader)new StringReader(a_strXML));
        Element t_elmentRoot = this.m_document.getRootElement();
        if (!t_elmentRoot.getName().equals("eSummaryResult")) {
            return false;
        }
        List t_childDocSum = t_elmentRoot.getChildren("DocSum");
        if (t_childDocSum.size() != 1) {
            return false;
        }
        for (Element t_elementDocSum : t_childDocSum) {
            this.m_hashElements.put("DocSum", t_elementDocSum);
            List t_childItem = t_elementDocSum.getChildren("Item");
            for (Element t_elementItem : t_childItem) {
                String t_strValue = t_elementItem.getAttributeValue("Name");
                if (t_strValue == null) continue;
                this.m_hashElements.put(t_strValue, t_elementItem);
            }
        }
        return true;
    }

    private String getPubmedItem(String a_strName) {
        Element t_element = this.m_hashElements.get(a_strName);
        if (t_element == null) {
            return null;
        }
        return t_element.getText();
    }
}

