/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.io;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.grits.toolbox.editor.experimentdesigner.io.ProtocolEntry;
import org.grits.toolbox.editor.experimentdesigner.io.ProtocolVariantExistsException;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.DataConversionException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class ProtocolVariantFileHandler {
    private static Integer identifier = 0;
    private static final Logger logger = Logger.getLogger(ProtocolVariantFileHandler.class);

    public static void createIndexFile(String folder) throws IOException {
        identifier = 0;
        Element protocol = new Element("protocols");
        Document doc = new Document(protocol);
        doc.setRootElement(protocol);
        XMLOutputter xmlOutput = new XMLOutputter();
        xmlOutput.setFormat(Format.getPrettyFormat());
        try {
            FileWriter fileWriter = new FileWriter(String.valueOf(folder) + File.separator + "protocol.xml");
            xmlOutput.output(doc, (Writer)fileWriter);
            fileWriter.close();
        }
        catch (IOException e) {
            logger.error((Object)"org.grits.toolbox.editor.experimentdesigner Cannot create the index file for protocol variants.", (Throwable)e);
            throw e;
        }
    }

    public static void addProtocolVariant(ProtocolEntry protocol, String folder) throws IOException, ProtocolVariantExistsException, DataConversionException {
        SAXBuilder builder = new SAXBuilder();
        File xmlFile = new File(String.valueOf(folder) + File.separator + "protocol.xml");
        if (xmlFile.exists()) {
            Document doc;
            try {
                doc = builder.build(xmlFile);
            }
            catch (JDOMException e) {
                logger.error((Object)("org.grits.toolbox.editor.experimentdesignerProtocol xml is not a valid xml file[" + xmlFile.getAbsolutePath() + "]"), (Throwable)e);
                throw new IOException("Protocol xml is not a valid xml file[" + xmlFile.getAbsolutePath() + "]: " + e.getMessage());
            }
            Element root = doc.getRootElement();
            List children = root.getChildren();
            if (children != null) {
                for (Element child : children) {
                    Attribute nameAttr = child.getAttribute("name");
                    Attribute idAttr = child.getAttribute("id");
                    if (idAttr != null) {
                        identifier = Math.max(identifier, idAttr.getIntValue());
                    }
                    if (nameAttr == null || !nameAttr.getValue().trim().equalsIgnoreCase(protocol.getName())) continue;
                    logger.info((Object)"org.grits.toolbox.editor.experimentdesigner Cannot save the protocol variant since there is one with the same name");
                    throw new ProtocolVariantExistsException("Protocol variant " + protocol.getName() + " already exists!");
                }
            }
            identifier = identifier + 1;
            Element t_currentElement = new Element("protocol");
            t_currentElement.setAttribute("id", identifier.toString());
            t_currentElement.setAttribute("name", protocol.getName());
            t_currentElement.setAttribute("uri", protocol.getUri());
            t_currentElement.setAttribute("filename", protocol.getFilename());
            if (protocol.getCategory() != null) {
                t_currentElement.setAttribute("category", protocol.getCategory());
            }
            root.addContent((Content)t_currentElement);
            XMLOutputter xmlOutput = new XMLOutputter();
            xmlOutput.setFormat(Format.getPrettyFormat());
            try {
                FileWriter fileWriter = new FileWriter(String.valueOf(folder) + File.separator + "protocol.xml");
                xmlOutput.output(doc, (Writer)fileWriter);
                fileWriter.close();
            }
            catch (IOException e) {
                logger.error((Object)"org.grits.toolbox.editor.experimentdesigner Cannot update the index file for protocol variants.", (Throwable)e);
                throw e;
            }
        }
        throw new IOException("protocol index file does not exists!");
    }

    public static List<ProtocolEntry> getAllProtocolVariants(String folder) throws IOException {
        File file = new File(folder);
        return ProtocolVariantFileHandler.getAllProtocolVariants(file, false);
    }

    public static List<ProtocolEntry> getAllProtocolVariants(File folder, boolean fromJar) throws IOException {
        ArrayList<ProtocolEntry> entries = new ArrayList<ProtocolEntry>();
        if (folder == null) {
            return entries;
        }
        File xmlFile = new File(String.valueOf(folder.getAbsolutePath()) + File.separator + "protocol.xml");
        if (xmlFile.exists()) {
            Document doc;
            SAXBuilder builder = new SAXBuilder();
            try {
                doc = builder.build(xmlFile);
            }
            catch (JDOMException e) {
                logger.error((Object)("org.grits.toolbox.editor.experimentdesignerProtocol xml is not a valid xml file[" + xmlFile.getAbsolutePath() + "]"), (Throwable)e);
                throw new IOException("Protocol xml is not a valid xml file[" + xmlFile.getAbsolutePath() + "]: " + e.getMessage());
            }
            Element root = doc.getRootElement();
            List children = root.getChildren();
            if (children != null) {
                for (Element child : children) {
                    ProtocolEntry entry = new ProtocolEntry();
                    Attribute nameAttr = child.getAttribute("name");
                    entry.setName(nameAttr.getValue());
                    Attribute categoryAttr = child.getAttribute("category");
                    if (categoryAttr != null) {
                        entry.setCategory(categoryAttr.getValue());
                    }
                    entry.setUri(child.getAttributeValue("uri"));
                    entry.setFilename(child.getAttributeValue("filename"));
                    entry.setFromJar(fromJar);
                    entries.add(entry);
                }
            }
        }
        return entries;
    }
}

