/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.editor.experimentdesigner.config.ExperimentConfig;

public class ProtocolFileHandler {
    private static final Logger logger = Logger.getLogger(ProtocolFileHandler.class);

    public static String copyFromWorkspaceToConfig(String filename, String projectName) {
        File original;
        String configFolderLocation = PropertyHandler.getVariable((String)"configuration_location");
        String workspaceLocation = PropertyHandler.getVariable((String)"workspace_location");
        String projectFolderLocation = String.valueOf(workspaceLocation.substring(0, workspaceLocation.length() - 1)) + File.separator + projectName;
        String uploadFolderLocation = String.valueOf(projectFolderLocation) + File.separator + "files";
        String experimentSubFolderName = String.valueOf(configFolderLocation) + File.separator + "org.grits.toolbox.editor.experimentdesigner";
        String fileFolderName = String.valueOf(experimentSubFolderName) + File.separator + "files";
        File fileFolder = new File(fileFolderName);
        if (!fileFolder.exists()) {
            fileFolder.mkdirs();
        }
        if ((original = new File(String.valueOf(uploadFolderLocation) + File.separator + filename)).exists()) {
            try {
                File destinationFile = new File(String.valueOf(fileFolderName) + File.separator + filename);
                while (destinationFile.exists()) {
                    filename = ProtocolFileHandler.generateUniqueFileName(filename, fileFolder.list());
                    destinationFile = new File(String.valueOf(fileFolderName) + File.separator + filename);
                }
                FileOutputStream out = new FileOutputStream(destinationFile);
                Files.copy(original.toPath(), out);
                out.close();
                return destinationFile.getName();
            }
            catch (FileNotFoundException e) {
                logger.error((Object)("Could not find the file " + filename), (Throwable)e);
                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"File Error", (String)"Could not locate the file associated with the protocol template");
            }
            catch (IOException e) {
                logger.error((Object)("Could not copy the file " + filename), (Throwable)e);
                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"File Error", (String)"Could not copy the file associated with the protocol template into the workspace");
            }
        }
        return null;
    }

    public static String copyFromConfigToWorkspace(String filename, String projectName) {
        File original;
        String configFolderLocation = PropertyHandler.getVariable((String)"configuration_location");
        String workspaceLocation = PropertyHandler.getVariable((String)"workspace_location");
        String projectFolderLocation = String.valueOf(workspaceLocation.substring(0, workspaceLocation.length() - 1)) + File.separator + projectName;
        String uploadFolderLocation = String.valueOf(projectFolderLocation) + File.separator + "files";
        String experimentSubFolderName = String.valueOf(configFolderLocation) + File.separator + "org.grits.toolbox.editor.experimentdesigner";
        String fileFolderName = String.valueOf(experimentSubFolderName) + File.separator + "files";
        File uploadFolder = new File(uploadFolderLocation);
        if (!uploadFolder.exists()) {
            uploadFolder.mkdirs();
        }
        if ((original = new File(String.valueOf(fileFolderName) + File.separator + filename)).exists()) {
            try {
                File destinationFile = new File(String.valueOf(uploadFolderLocation) + File.separator + filename);
                while (destinationFile.exists()) {
                    filename = ProtocolFileHandler.generateUniqueFileName(filename, uploadFolder.list());
                    destinationFile = new File(String.valueOf(uploadFolderLocation) + File.separator + filename);
                }
                FileOutputStream out = new FileOutputStream(destinationFile);
                Files.copy(original.toPath(), out);
                out.close();
                return destinationFile.getName();
            }
            catch (FileNotFoundException e) {
                logger.error((Object)("Could not find the file " + filename), (Throwable)e);
                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"File Error", (String)"Could not locate the file associated with the protocol template");
            }
            catch (IOException e) {
                logger.error((Object)("Could not copy the file " + filename), (Throwable)e);
                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"File Error", (String)"Could not copy the file associated with the protocol template into the workspace");
            }
        }
        return null;
    }

    public static String copyFromProjectToAnother(String filename, String fromProject, String toProject) {
        File original;
        String workspaceLocation = PropertyHandler.getVariable((String)"workspace_location");
        String projectFolderLocation = String.valueOf(workspaceLocation.substring(0, workspaceLocation.length() - 1)) + File.separator;
        String originalLocation = null;
        String destinationLocation = null;
        if (fromProject != null) {
            originalLocation = String.valueOf(projectFolderLocation) + fromProject;
        }
        if (toProject != null) {
            destinationLocation = String.valueOf(projectFolderLocation) + toProject;
        }
        originalLocation = String.valueOf(originalLocation) + File.separator + "files";
        File destination = new File(destinationLocation = String.valueOf(destinationLocation) + File.separator + "files");
        if (!destination.exists()) {
            destination.mkdirs();
        }
        if ((original = new File(String.valueOf(originalLocation) + File.separator + filename)).exists()) {
            try {
                File destinationFile = new File(String.valueOf(destinationLocation) + File.separator + filename);
                while (destinationFile.exists()) {
                    filename = ProtocolFileHandler.generateUniqueFileName(filename, destination.list());
                    destinationFile = new File(String.valueOf(destinationLocation) + File.separator + filename);
                }
                FileOutputStream out = new FileOutputStream(destinationFile);
                Files.copy(original.toPath(), out);
                out.close();
                return destinationFile.getName();
            }
            catch (FileNotFoundException e) {
                logger.error((Object)("Could not find the file " + filename), (Throwable)e);
                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"File Error", (String)"Could not locate the file associated with the protocol template");
            }
            catch (IOException e) {
                logger.error((Object)("Could not copy the file " + filename), (Throwable)e);
                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"File Error", (String)"Could not copy the file associated with the protocol template into the workspace");
            }
        }
        return null;
    }

    public static String copyFromJarToWorkspace(String file, String projectName) {
        String workspaceLocation = PropertyHandler.getVariable((String)"workspace_location");
        String projectFolderLocation = String.valueOf(workspaceLocation.substring(0, workspaceLocation.length() - 1)) + File.separator;
        if (projectName != null) {
            projectFolderLocation = String.valueOf(projectFolderLocation) + projectName;
        }
        String uploadFolderLocation = String.valueOf(projectFolderLocation) + File.separator + "files";
        URL url = ExperimentConfig.FILE_RESOURCE_URL;
        if (url != null) {
            try {
                URL resourceFileUrl = FileLocator.toFileURL((URL)url);
                File dir = new File(resourceFileUrl.toURI());
                String fileLocation = String.valueOf(dir.getAbsolutePath()) + File.separator + file;
                File originalJarFile = new File(fileLocation);
                File destinationFile = new File(String.valueOf(uploadFolderLocation) + File.separator + file);
                while (destinationFile.exists()) {
                    file = ProtocolFileHandler.generateUniqueFileName(file, new File(uploadFolderLocation).list());
                    destinationFile = new File(String.valueOf(uploadFolderLocation) + File.separator + file);
                }
                FileOutputStream configFile = new FileOutputStream(destinationFile);
                Files.copy(originalJarFile.toPath(), configFile);
                configFile.close();
                return destinationFile.getName();
            }
            catch (IOException e) {
                logger.warn((Object)("Could not copy the file for the protocol template from the jar file: " + file), (Throwable)e);
                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"File Error", (String)"Could not copy the file associated with the protocol template from the jar");
            }
            catch (URISyntaxException e) {
                logger.warn((Object)("Could not find the file for the protocol template in the jar file: " + file), (Throwable)e);
                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"File Error", (String)"Could not find the file associated with the protocol template in the jar");
            }
        }
        return null;
    }

    public static String generateUniqueFileName(String filename, String[] existingNames) {
        if (filename != null) {
            int i;
            String name = filename;
            String extension = "";
            if (filename.contains(".")) {
                extension = filename.substring(filename.lastIndexOf("."));
                name = filename.substring(0, filename.lastIndexOf("."));
            }
            if ((i = name.indexOf("(")) != -1) {
                String counter = name.substring(i + 1, name.indexOf(")"));
                int count = Integer.parseInt(counter);
                String newFilename = name.substring(0, name.indexOf("("));
                newFilename = String.valueOf(newFilename) + "(" + ++count + ")";
                newFilename = String.valueOf(newFilename) + extension;
                return newFilename;
            }
            String newFilename = "";
            int count = 1;
            do {
                newFilename = String.valueOf(name) + "(" + count + ")";
                newFilename = String.valueOf(newFilename) + extension;
                ++count;
            } while (Arrays.asList(existingNames).contains(newFilename));
            return newFilename;
        }
        return null;
    }
}

