/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.archive.editor.pages.archivedemail.actions;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.entry.archive.config.ImageRegistry;
import org.grits.toolbox.entry.archive.dialog.email.AddEmailDialog;
import org.grits.toolbox.entry.archive.editor.ArchiveEntryEditor;
import org.grits.toolbox.entry.archive.editor.pages.archivedemail.EmailArchivePage;
import org.grits.toolbox.entry.archive.model.ArchivedBasicEmail;
import org.grits.toolbox.entry.archive.model.ArchivedEmail;
import org.grits.toolbox.entry.archive.model.ArchivedEmailTopic;

public class AddReplyEmail
extends Action {
    private static Logger logger = Logger.getLogger(AddReplyEmail.class);
    private EmailArchivePage page = null;

    public AddReplyEmail(EmailArchivePage emailArchivePage) {
        this.page = emailArchivePage;
        this.setText("Reply email");
        this.setToolTipText("Add a reply email");
        this.setImageDescriptor(ImageRegistry.getImageDescriptor("org.grits.toolbox.entry.archive", ImageRegistry.ArchiveImage.REPLY_EMAIL_ICON));
    }

    public void run() {
        logger.debug((Object)"Start - Adding reply Email");
        ArchiveEntryEditor archiveEntryEditor = this.page.getEditor();
        TreeViewer treeViewer = this.page.getLeftSideTreeViewer();
        if (!treeViewer.getSelection().isEmpty()) {
            ArchivedEmail selectedEmail = (ArchivedEmail)((StructuredSelection)treeViewer.getSelection()).getFirstElement();
            List inputArchivedEmails = (List)treeViewer.getInput();
            try {
                AddEmailDialog addEmailDialog;
                ArchivedEmailTopic selectedParent = null;
                if (selectedEmail instanceof ArchivedEmailTopic) {
                    selectedParent = (ArchivedEmailTopic)selectedEmail;
                } else if (((ArchivedBasicEmail)selectedEmail).getArchivedEmailTopic() == null) {
                    selectedParent = this.changeBasicToTopic((ArchivedBasicEmail)selectedEmail);
                    inputArchivedEmails.remove(selectedEmail);
                    inputArchivedEmails.add(selectedParent);
                } else {
                    selectedParent = ((ArchivedBasicEmail)selectedEmail).getArchivedEmailTopic();
                }
                if (selectedParent != null && (addEmailDialog = new AddEmailDialog(Display.getCurrent().getActiveShell(), selectedParent.getEmailSubject())).open() == 0) {
                    ArchivedBasicEmail newArchivedEmail = addEmailDialog.getArchivedEmail();
                    selectedParent.addReplyEmail(newArchivedEmail);
                    treeViewer.refresh();
                    treeViewer.setSelection((ISelection)new StructuredSelection((Object)newArchivedEmail));
                    archiveEntryEditor.markDirty();
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Upload Error", (String)"The email reply could not be added to GRITS. Please report this error to the development team");
            }
            logger.debug((Object)"End - Adding reply Email");
        }
    }

    private ArchivedEmailTopic changeBasicToTopic(ArchivedBasicEmail selectedEmail) {
        ArchivedEmailTopic archivedEmailTopic = new ArchivedEmailTopic();
        archivedEmailTopic.addReplyEmail(selectedEmail);
        archivedEmailTopic.setEmailSubject(selectedEmail.getEmailSubject());
        archivedEmailTopic.setEmailDate(selectedEmail.getEmailDate());
        return archivedEmailTopic;
    }
}

