/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.util.array.mass;

import java.math.BigDecimal;
import org.glycoinfo.WURCSFramework.util.property.AtomicProperties;

public enum CarbonDescriptorPropaties {
    SZ3_METHYL_L('m', true, 0, 3),
    SZ3_METHYL_U('M', true, 3, 3),
    SZ3_HYDROXYL_L('h', true, 1, 3),
    SZ3_ACETAL_L('c', true, 2, 3),
    SZ3_ACETAL_U('C', true, 3, 3),
    SZ3_STEREO_S('1', true, 2, 3),
    SZ3_STEREO_R('2', true, 2, 3),
    SZ3_STEREO_s('3', true, 2, 3),
    SZ3_STEREO_r('4', true, 2, 3),
    SZ3_STEREO_X('x', true, 2, 3),
    SZ3_CHIRAL_S('5', true, 3, 3),
    SZ3_CHIRAL_R('6', true, 3, 3),
    SZ3_CHIRAL_s('7', true, 3, 3),
    SZ3_CHIRAL_r('8', true, 3, 3),
    SZ3_CHIRAL_X('X', true, 3, 3),
    SZ2_ALDEHYDE_L('o', true, 1, 1),
    SZ2_ANOMER('a', true, 2, 3),
    SZ2_ALDEHYDE_U('O', true, 1, 2),
    SZ2_ACID_U('A', true, 2, 1),
    SZ2_UNDEFINED_L('u', true, 1, 1),
    SZ2_UNDEFINED_U('U', true, 2, 1),
    DZ2_METHYLENE_L('n', true, 0, 2),
    DZ2_METHYLENE_U('N', true, 2, 2),
    DZ2_CISTRANS_EL('e', true, 1, 2),
    DZ2_CISTRANS_ZL('z', true, 1, 2),
    DZ2_CISTRANS_XL('f', true, 1, 2),
    DZ2_CISTRANS_EU('E', true, 2, 2),
    DZ2_CISTRANS_ZU('Z', true, 2, 2),
    DZ2_CISTRANS_XU('F', true, 2, 2),
    SZ1_XETHYNE('T', true, 1, 1),
    DZ1_KETENE_U('K', true, 1, 0),
    TZ1_ETHYNE_U('T', true, 1, 1),
    SS3_METHYNE('d', false, 0, 2),
    SS3_ACETAL('C', false, 2, 2),
    SS3_STEREO_S('1', false, 1, 2),
    SS3_STEREO_R('2', false, 1, 2),
    SS3_STEREO_s('3', false, 1, 2),
    SS3_STEREO_r('4', false, 1, 2),
    SS3_STEREO_X('x', false, 1, 2),
    SS3_CHIRAL_S('5', false, 2, 2),
    SS3_CHIRAL_R('6', false, 2, 2),
    SS3_CHIRAL_s('7', false, 2, 2),
    SS3_CHIRAL_r('8', false, 2, 2),
    SS3_CHIRAL_X('X', false, 2, 2),
    SS3_ANOMER('a', false, 2, 2),
    SS2_KETONE_U('O', false, 1, 0),
    SS2_UNDEFINED_U('U', false, 1, 0),
    DS2_CISTRANS_EL('e', false, 0, 1),
    DS2_CISTRANS_ZL('z', false, 0, 1),
    DS2_CISTRANS_NL('n', false, 0, 1),
    DS2_CISTRANS_XL('f', false, 0, 1),
    DS2_CISTRANS_EU('E', false, 1, 1),
    DS2_CISTRANS_ZU('Z', false, 1, 1),
    DS2_CISTRANS_NU('N', false, 1, 1),
    DS2_CISTRANS_XU('F', false, 1, 1),
    DD1_ALLENE('K', false, 0, 0),
    TS1_ETHYNE('T', false, 0, 0),
    XXX_UNKNOWN('?', false, 0, 0);

    private char m_strChar;
    private boolean m_isTerminal;
    private int m_iNumberOfOxygen;
    private int m_iNumberOfHydrogen;

    private CarbonDescriptorPropaties(char a_cName, boolean a_isTerminal, int a_nO, int a_nH) {
        this.m_strChar = a_cName;
        this.m_isTerminal = a_isTerminal;
        this.m_iNumberOfOxygen = a_nO;
        this.m_iNumberOfHydrogen = a_nH;
    }

    public BigDecimal getDefaultMass() {
        BigDecimal t_bdMass = AtomicProperties.C.getMass();
        t_bdMass = t_bdMass.add(AtomicProperties.O.getMass().multiply(new BigDecimal(this.m_iNumberOfOxygen)));
        t_bdMass = t_bdMass.add(AtomicProperties.H.getMass().multiply(new BigDecimal(this.m_iNumberOfHydrogen)));
        return t_bdMass;
    }

    public double getDefaultMassDouble() {
        return this.getDefaultMass().doubleValue();
    }

    public int getMaxSignificantDigit() {
        if (this.m_iNumberOfHydrogen > 0 && this.m_iNumberOfOxygen > 0) {
            int t_iSignificantDigitO;
            int t_iSignificantDigitH = AtomicProperties.H.getMassPrecision();
            return t_iSignificantDigitH > (t_iSignificantDigitO = AtomicProperties.O.getMassPrecision()) ? t_iSignificantDigitH : t_iSignificantDigitO;
        }
        if (this.m_iNumberOfHydrogen > 0) {
            return AtomicProperties.H.getMassPrecision();
        }
        if (this.m_iNumberOfOxygen > 0) {
            return AtomicProperties.O.getMassPrecision();
        }
        return AtomicProperties.C.getMassPrecision();
    }

    public static CarbonDescriptorPropaties forCharacter(char cName, boolean isTerminal) {
        for (CarbonDescriptorPropaties cd : CarbonDescriptorPropaties.values()) {
            if (cd.m_strChar != cName || cd.m_isTerminal != isTerminal) continue;
            return cd;
        }
        return null;
    }
}

