/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.util;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.TreeMap;
import org.glycoinfo.WURCSFramework.util.FileIOUtils;

public class WURCSConversionLogger {
    private String m_strInputFileName = "";
    private int m_nTotal = 0;
    private int m_nSuccess = 0;
    private TreeMap<String, String> m_hashIDToMessage = new TreeMap();
    private LinkedHashMap<String, LinkedList<String>> m_hashWURCSToIDs = new LinkedHashMap();
    private HashMap<String, LinkedList<String>> m_hashErrors = new HashMap();

    public void setInputFileName(String a_strInputFile) {
        this.m_strInputFileName = a_strInputFile;
    }

    public void addWURCS(String a_strID, String a_strWURCS) {
        if (!this.m_hashWURCSToIDs.containsKey(a_strWURCS)) {
            this.m_hashWURCSToIDs.put(a_strWURCS, new LinkedList());
        }
        if (this.m_hashWURCSToIDs.get(a_strWURCS).contains(a_strID)) {
            return;
        }
        this.m_hashWURCSToIDs.get(a_strWURCS).add(a_strID);
        ++this.m_nTotal;
        ++this.m_nSuccess;
    }

    public void addMessage(String a_strID, String a_strType, String a_strFullMessage) {
        String t_strErrorMessage = "";
        if (!a_strType.equals("")) {
            ++this.m_nTotal;
            t_strErrorMessage = a_strType;
            if (!a_strFullMessage.equals("")) {
                t_strErrorMessage = t_strErrorMessage + "\n" + a_strFullMessage;
            }
            if (!this.m_hashErrors.containsKey(a_strType)) {
                this.m_hashErrors.put(a_strType, new LinkedList());
            }
            this.m_hashErrors.get(a_strType).add(a_strID);
        } else if (!a_strFullMessage.equals("")) {
            t_strErrorMessage = t_strErrorMessage + "Warning in GlycoCT.\n" + a_strFullMessage;
        }
        if (t_strErrorMessage.equals("")) {
            return;
        }
        this.m_hashIDToMessage.put(a_strID, t_strErrorMessage);
    }

    public void printLog(String a_strFilePath) throws Exception {
        PrintWriter t_pwResults = FileIOUtils.openTextFileW(a_strFilePath);
        if (!this.m_strInputFileName.equals("")) {
            t_pwResults.println("Read from " + this.m_strInputFileName + ":\n");
        }
        for (String t_strID : this.m_hashIDToMessage.keySet()) {
            t_pwResults.println(t_strID + "\t" + this.m_hashIDToMessage.get(t_strID));
        }
        t_pwResults.println("\nTotal CT: " + this.m_nTotal);
        t_pwResults.println("Successful conversion: " + this.m_nSuccess);
        if (!this.m_hashErrors.isEmpty()) {
            t_pwResults.println("Errors: ");
            LinkedList<String> errors = new LinkedList<String>();
            for (String err : this.m_hashErrors.keySet()) {
                errors.add(err);
            }
            Collections.sort(errors);
            for (String t_strErr : errors) {
                String t_strErrIDs = this.concatinateIDs(this.m_hashErrors.get(t_strErr));
                int t_nErrIDs = this.m_hashErrors.get(t_strErr).size();
                t_pwResults.println(t_strErrIDs + "\t" + t_strErr + " : " + t_nErrIDs);
            }
        }
        LinkedList<String> t_aDuplicateWURCS = new LinkedList<String>();
        for (String strWURCS : this.m_hashWURCSToIDs.keySet()) {
            if (this.m_hashWURCSToIDs.get(strWURCS).size() == 1) continue;
            t_aDuplicateWURCS.add(strWURCS);
        }
        t_pwResults.println("Duplicated structures: " + t_aDuplicateWURCS.size());
        for (String strWURCS : t_aDuplicateWURCS) {
            String dupIDs = this.concatinateIDs(this.m_hashWURCSToIDs.get(strWURCS));
            t_pwResults.println(dupIDs + "\t" + strWURCS);
        }
        t_pwResults.close();
    }

    private String concatinateIDs(LinkedList<String> a_aIDs) {
        String t_strIDs = "";
        int count = 0;
        for (String ID : a_aIDs) {
            t_strIDs = t_strIDs + ID;
            if (++count == a_aIDs.size()) continue;
            t_strIDs = t_strIDs + ",";
            if (count % 20 != 0) continue;
            t_strIDs = t_strIDs + "\n";
        }
        return t_strIDs;
    }
}

