/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.exec;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.TreeMap;
import java.util.TreeSet;
import org.glycoinfo.WURCSFramework.util.FileIOUtils;
import org.glycoinfo.WURCSFramework.util.WURCSException;
import org.glycoinfo.WURCSFramework.util.array.WURCSFormatException;
import org.glycoinfo.WURCSFramework.util.array.WURCSImporter;
import org.glycoinfo.WURCSFramework.util.exchange.WURCSArrayToGraph;
import org.glycoinfo.WURCSFramework.util.graph.visitor.WURCSGraphExporterUniqueMonosaccharides;
import org.glycoinfo.WURCSFramework.wurcs.array.WURCSArray;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSGraph;

public class CollectMonosaccharideString {
    public static void main(String[] args) {
        String t_strDir = "C:\\GlycoCTList\\20150609\\";
        String t_strWURCSFile = "20150609result-GlyTouCan_GlycoCTmfWURCS.txt";
        String input = t_strDir + t_strWURCSFile;
        String output = t_strDir + "20150609result-GlyTouCan_MSList.txt";
        TreeMap<Object, Object> t_mapWURCSIndex = new TreeMap();
        WURCSImporter t_objImporter = new WURCSImporter();
        if (!new File(input).isFile()) {
            System.err.println("File not found");
            System.exit(0);
        }
        try {
            t_mapWURCSIndex = CollectMonosaccharideString.readWURCS(FileIOUtils.openTextFileR(input));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            PrintWriter pw = FileIOUtils.openTextFileW(output);
            TreeSet<String> t_aUniqueOrigWURCS = new TreeSet<String>();
            TreeSet<String> t_aUniqueMS = new TreeSet<String>();
            for (String string : t_mapWURCSIndex.keySet()) {
                String t_strOrigWURCS = (String)t_mapWURCSIndex.get(string);
                if (t_aUniqueOrigWURCS.contains(t_strOrigWURCS)) continue;
                t_aUniqueOrigWURCS.add(t_strOrigWURCS);
                System.err.println(string + ":");
                WURCSArray t_oWURCS = t_objImporter.extractWURCSArray((String)t_mapWURCSIndex.get(string));
                WURCSArrayToGraph t_oA2G = new WURCSArrayToGraph();
                t_oA2G.start(t_oWURCS);
                WURCSGraph t_oGraph = t_oA2G.getGraph();
                WURCSGraphExporterUniqueMonosaccharides t_oExportMS = new WURCSGraphExporterUniqueMonosaccharides();
                t_oExportMS.start(t_oGraph);
                for (String t_strUniqueMS : t_oExportMS.getMSStrings()) {
                    if (t_aUniqueMS.contains(t_strUniqueMS)) continue;
                    t_aUniqueMS.add(t_strUniqueMS);
                }
            }
            for (String string : t_aUniqueMS) {
                pw.println(string);
            }
        }
        catch (WURCSFormatException e) {
            e.printStackTrace();
        }
        catch (WURCSException e1) {
            e1.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static TreeMap<String, String> readWURCS(BufferedReader a_bfFile) throws IOException {
        String line = "";
        TreeMap<String, String> wret = new TreeMap<String, String>();
        wret.clear();
        while ((line = a_bfFile.readLine()) != null) {
            String[] IDandWURCS;
            line.trim();
            if (line.indexOf("WURCS") == -1 || (IDandWURCS = line.split("\t")).length != 2) continue;
            wret.put(IDandWURCS[0].trim(), IDandWURCS[1]);
        }
        a_bfFile.close();
        return wret;
    }
}

