/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.databasebot.handler;

import javax.inject.Named;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.tools.databasebot.dialog.process.ProgressDialog;
import org.grits.toolbox.tools.databasebot.process.DatabaseGenerator;
import org.grits.toolbox.tools.databasebot.wizards.CreateNewDatabaseWizard;

public class CreateNewDatabaseHandler {
    private static final Logger logger = Logger.getLogger(CreateNewDatabaseHandler.class);

    @Execute
    public void execute(@Named(value="activeShell") Shell a_shell, EPartService a_partService, EModelService a_modelService, MApplication a_application) {
        logger.info((Object)"START COMMAND: Start database bot.");
        try {
            CreateNewDatabaseWizard t_wizard = new CreateNewDatabaseWizard();
            WizardDialog t_dialogWizard = new WizardDialog(PropertyHandler.getModalDialog((Shell)a_shell), (IWizard)t_wizard);
            t_dialogWizard.setPageSize(700, 450);
            if (t_dialogWizard.open() == 0) {
                ProgressDialog t_dialog = new ProgressDialog(a_shell);
                DatabaseGenerator t_process = new DatabaseGenerator();
                t_process.setSettings(t_wizard.getSettings());
                t_dialog.setWorker(t_process);
                t_dialog.open();
            }
        }
        catch (Exception e) {
            logger.fatal((Object)("Error starting databases bot: " + e.getMessage()), (Throwable)e);
            MessageDialog.openError((Shell)a_shell, (String)"Error starting Database Bot", (String)("Unable run database bot due to an error:\n\n" + e.getMessage()));
        }
        logger.info((Object)"END COMMAND:  Start database bot.");
    }
}

