/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.views.tabbed;

import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.entry.ms.annotation.glycan.filter.MSGlycanAnnotationFilterSetup;
import org.grits.toolbox.entry.ms.annotation.glycan.filter.MSGlycanCustomFilterSelection;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.MSGlycanFilterCateogoryPreference;
import org.grits.toolbox.entry.ms.annotation.glycan.util.FileUtils;
import org.grits.toolbox.entry.ms.annotation.glycan.views.tabbed.MSGlycanAnnotationMultiPageViewer;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationFilterWindow;
import org.grits.toolbox.ms.om.data.AnnotationFilter;
import org.grits.toolbox.util.structure.glycan.filter.om.Category;
import org.grits.toolbox.util.structure.glycan.filter.om.Filter;
import org.grits.toolbox.util.structure.glycan.filter.om.FilterSetting;
import org.grits.toolbox.util.structure.glycan.filter.om.FiltersLibrary;
import org.grits.toolbox.util.structure.glycan.gui.FilterChangedListener;
import org.grits.toolbox.util.structure.glycan.gui.FilterTableSetup;

public class MSGlycanAnnotationFilterWindow
extends MSAnnotationFilterWindow
implements FilterChangedListener {
    private static final Logger logger = Logger.getLogger(MSGlycanAnnotationFilterWindow.class);
    private FilterTableSetup filterTableSetup;
    private FiltersLibrary filterLibrary;
    private List<Filter> preFilters;
    private FilterSetting filterSetting;
    private Button keepOption;
    private Button noSelectionOption;
    private MSGlycanCustomFilterSelection customFilterSelection;
    private Category preferredCategory;
    private boolean highlightOnly = true;
    private Button btnOverrideManualAnnotations2;

    public MSGlycanAnnotationFilterWindow(Shell parentShell, Entry entry, MPart part) {
        super(parentShell, entry, part);
        this.loadFilterList();
        this.loadFilterCategoryPreference();
    }

    private void loadFilterCategoryPreference() {
        try {
            MSGlycanFilterCateogoryPreference preferences = MSGlycanFilterCateogoryPreference.getMSGlycanFilterCategoryPreferences(MSGlycanFilterCateogoryPreference.getPreferenceEntity());
            if (preferences != null) {
                this.preferredCategory = preferences.getCategoryPreference();
            }
        }
        catch (UnsupportedVersionException unsupportedVersionException) {
            logger.error((Object)"Cannot load filter preference");
        }
    }

    private void loadFilterList() {
        try {
            this.filterLibrary = FileUtils.readFilters(FileUtils.getFilterPath());
            this.preFilters = this.filterLibrary.getFilters();
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"Error loading the filters", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"Cannot locate the filters file", (Throwable)e);
        }
        catch (JAXBException e) {
            logger.error((Object)"Error loading the filters", (Throwable)e);
        }
    }

    protected void createFilterSection(Composite parent) {
        MSGlycanAnnotationMultiPageViewer parentViewer = MSGlycanAnnotationMultiPageViewer.getActiveViewerForEntry(this.part.getContext(), this.getMSAnnotationEntry());
        Group filterGroup = new Group(parent, 4);
        filterGroup.setText("Filters");
        filterGroup.setLayout((Layout)new GridLayout(4, false));
        filterGroup.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        Label filterWarning = new Label((Composite)filterGroup, 65);
        filterWarning.setForeground(Display.getCurrent().getSystemColor(3));
        filterWarning.setText("The following settings will affect the glycan candidate selection in the structure table. \nIf you don't want the structure filters to modify your selections, select \"Highlight Only\" option.");
        filterWarning.setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
        MSGlycanAnnotationFilterSetup.addHelpButton((Composite)filterGroup, "Please note that, the \"stucture based\" filters you select are applied first to change the selected candidates, then the score based filters are applied to further restrict the selections");
        new Label((Composite)filterGroup, 0);
        new Label((Composite)filterGroup, 0);
        final Button highlightButton = new Button((Composite)filterGroup, 32);
        highlightButton.setText("Highlight Only");
        highlightButton.setSelection(true);
        highlightButton.setLayoutData((Object)new GridData(4, 4, true, true, 6, 1));
        highlightButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MSGlycanAnnotationFilterWindow.this.highlightOnly = highlightButton.getSelection();
                MSGlycanAnnotationFilterWindow.this.btnOverrideManualAnnotations2.setEnabled(!MSGlycanAnnotationFilterWindow.this.highlightOnly);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnOverrideManualAnnotations2 = new Button((Composite)filterGroup, 32);
        this.btnOverrideManualAnnotations2.setText("Override manually selected annotations");
        this.btnOverrideManualAnnotations2.setEnabled(false);
        GridData gridData3 = new GridData(768);
        gridData3.horizontalSpan = 4;
        gridData3.verticalSpan = 1;
        this.btnOverrideManualAnnotations2.setLayoutData((Object)gridData3);
        if (parentViewer != null && parentViewer.getFilter() != null) {
            this.btnOverrideManualAnnotations2.setEnabled(false);
        }
        Composite comp1 = new Composite((Composite)filterGroup, 0);
        comp1.setLayout((Layout)new GridLayout(4, false));
        comp1.setLayoutData((Object)new GridData(16384, 128, true, true, 4, 1));
        this.addSelectFilterItem(comp1);
        Composite container = new Composite((Composite)filterGroup, 0);
        container.setLayout((Layout)new FillLayout());
        GridData gd_container = new GridData(4, 4, true, true, 4, 4);
        gd_container.minimumHeight = 150;
        container.setLayoutData((Object)gd_container);
        if (this.preFilters == null) {
            return;
        }
        this.filterTableSetup = this.filterLibrary != null ? new MSGlycanAnnotationFilterSetup(this.filterLibrary.getCategories()) : new MSGlycanAnnotationFilterSetup();
        this.filterTableSetup.setFilterList(this.preFilters);
        ((MSGlycanAnnotationFilterSetup)this.filterTableSetup).setSelectedCategory(this.preferredCategory);
        ((MSGlycanAnnotationFilterSetup)this.filterTableSetup).setFilterMessage("Please note that, the \"stucture based\" filters you select are applied first to change the selected candidates, then the score based filters are applied to further restrict the selections");
        try {
            this.filterTableSetup.createFilterTableSection(container);
            if (this.filterSetting != null) {
                this.filterTableSetup.setExistingFilters(this.filterSetting);
            }
            this.filterTableSetup.addFilterChangedListener((FilterChangedListener)this);
        }
        catch (Exception e) {
            logger.error((Object)"Error creating the filter table", (Throwable)e);
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Error creating the filter table!");
        }
        this.customFilterSelection.setFilterTableSetup(this.filterTableSetup);
        if (parentViewer != null && parentViewer.getFilter() != null) {
            this.filterTableSetup.setExistingFilters(parentViewer.getFilter().getFilterSetting());
        }
        Label noMatchLabel = new Label(container, 0);
        noMatchLabel.setText("Choose how to handle 'no match' cases");
        GridData gd = new GridData(16384, 128, true, true, 4, 1);
        noMatchLabel.setLayoutData((Object)gd);
        this.keepOption = new Button(container, 16);
        this.keepOption.setText("Keep existing selections");
        gd = new GridData(16384, 128, true, true, 4, 1);
        this.keepOption.setLayoutData((Object)gd);
        this.keepOption.setSelection(true);
        this.noSelectionOption = new Button(container, 16);
        this.noSelectionOption.setText("Do not select anything");
        gd = new GridData(16384, 128, true, true, 4, 1);
        this.noSelectionOption.setLayoutData((Object)gd);
    }

    protected void addSelectFilterItem(Composite parent) {
        this.customFilterSelection = new MSGlycanCustomFilterSelection(this);
        this.customFilterSelection.createFilterSelectionArea(parent);
    }

    boolean getKeepExistingOption() {
        return this.keepOption.getSelection();
    }

    protected String getTitle() {
        return "MS Glycan Annotation Filter";
    }

    protected String getAnnotationLabelText() {
        return "MS Glycan Annotation";
    }

    public void validateInput() {
        this.txtOutput.setText("Valid parameters");
        if (this.getMSAnnotationEntry() == null) {
            this.txtOutput.setText("Please select MS Annotation Results");
        } else if (this.getFilterKey() == null && this.filterTableSetup.getFilterSetting() == null) {
            this.txtOutput.setText("Please select a filter");
        } else if (this.getNumTopHits() == -2) {
            this.txtOutput.setText("Invalid value for 'Num Top Hits'. Please enter 'All' or an integer greater than 0.");
        }
        if (this.txtOutput.getText().equals("Valid parameters")) {
            this.getButton(0).setEnabled(true);
        } else {
            this.getButton(0).setEnabled(false);
        }
    }

    protected void okPressed() {
        MSGlycanAnnotationMultiPageViewer viewer = MSGlycanAnnotationMultiPageViewer.getActiveViewerForEntry(this.part.getContext(), this.getMSAnnotationEntry());
        if (viewer != null) {
            AnnotationFilter filter = new AnnotationFilter();
            filter.setFilterSetting(this.filterTableSetup.getFilterSetting());
            filter.setNumTopHits(Integer.valueOf(this.getNumTopHits()));
            filter.setColumnKey(this.getFilterKey());
            viewer.setFilter(filter);
            viewer.sendFilterChanged();
            viewer.applyFilter(filter.getFilterSetting(), null, -1, this.getOverrideManualAnnotations2(), this.getKeepExistingOption(), this.highlightOnly);
        }
        super.okPressed();
    }

    public boolean getOverrideManualAnnotations2() {
        return this.btnOverrideManualAnnotations2.getSelection();
    }

    protected void createScoreFilterSection(Composite container) {
    }

    public void filterChanged() {
        this.validateInput();
    }
}

