/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.views.tabbed;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.datamodel.ms.annotation.tablemodel.MSAnnotationTableDataObject;
import org.grits.toolbox.entry.ms.annotation.glycan.views.tabbed.MSGlycanAnnotationDetails;
import org.grits.toolbox.entry.ms.annotation.glycan.views.tabbed.MSGlycanAnnotationFigureCanvas;
import org.grits.toolbox.entry.ms.annotation.property.MSAnnotationEntityProperty;
import org.grits.toolbox.entry.ms.annotation.tablehelpers.ExtCheckBoxPainter;
import org.grits.toolbox.entry.ms.annotation.tablehelpers.MSAnnotationTable;
import org.grits.toolbox.entry.ms.annotation.tablehelpers.SharedCheckboxWidget;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationDetails;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationEntityScroller;
import org.grits.toolbox.ms.om.data.Annotation;
import org.grits.toolbox.ms.om.data.Feature;
import org.grits.toolbox.ms.om.data.Peak;
import org.grits.toolbox.utils.data.CartoonOptions;

public class MSGlycanAnnotationEntityScroller
extends MSAnnotationEntityScroller {
    private static final Logger logger = Logger.getLogger(MSGlycanAnnotationEntityScroller.class);
    protected MSGlycanAnnotationFigureCanvas imageCanvas = null;
    protected CartoonOptions cartoonOptions = null;
    protected List<String> sequences = null;

    public MSGlycanAnnotationEntityScroller(Composite parent, int style, MSAnnotationDetails msAnnotationDetails, CartoonOptions cartoonOptions) {
        super(parent, style, msAnnotationDetails);
        this.cartoonOptions = cartoonOptions;
    }

    public String toString() {
        return "MSGlycanAnnotationEntityScroller (" + this.feature + ")";
    }

    public void setCartoonOptions(CartoonOptions cartoonOptions) {
        this.cartoonOptions = cartoonOptions;
        this.imageCanvas.updateCartoonOptions(this.getCartoonOptions());
    }

    public CartoonOptions getCartoonOptions() {
        return this.cartoonOptions;
    }

    public void setFeature(Feature glycanFeature) {
        super.setFeature(glycanFeature);
    }

    public String getFeatureDesc() {
        DecimalFormat df = new DecimalFormat("0.00");
        Annotation annot = this.getAnnotation();
        MSAnnotationEntityProperty prop = (MSAnnotationEntityProperty)((MSGlycanAnnotationDetails)this.getMsAnnotationDetails()).getEntry().getProperty();
        String sDesc = MSAnnotationDetails.getLabelForCheckbox((String)annot.getStringId(), (String)this.getFeature().getId(), (int)prop.getMsLevel());
        Double dScore = (Double)annot.getScores().get(this.scan.getScanNo().toString());
        if (dScore != null) {
            String sScoreText = ", Score: " + df.format(dScore);
            sDesc = String.valueOf(sDesc) + sScoreText;
        }
        return sDesc;
    }

    public CLabel getNewCLabel(Composite parent, int style) {
        CLabel newLabel = super.getNewCLabel(parent, style);
        newLabel.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                Feature feat = MSGlycanAnnotationEntityScroller.this.getFeature();
                Peak peak = ((MSGlycanAnnotationDetails)MSGlycanAnnotationEntityScroller.this.getMsAnnotationDetails()).getPeakFromFeature(feat);
                Integer iParentScanNum = ((MSGlycanAnnotationDetails)MSGlycanAnnotationEntityScroller.this.getMsAnnotationDetails()).getParentViewScanNum();
                MSAnnotationEntityProperty prop = (MSAnnotationEntityProperty)((MSGlycanAnnotationDetails)MSGlycanAnnotationEntityScroller.this.getMsAnnotationDetails()).getEntry().getProperty();
                if (prop.getMsLevel() > 3) {
                    iParentScanNum = prop.getParentScanNum();
                }
                String sCheckBoxKey = MSAnnotationEntityScroller.getCombinedKeyForLookup((Integer)peak.getId(), (String)feat.getId());
                if (iParentScanNum != null && peak.getId() != null) {
                    MSAnnotationTable table = ((MSGlycanAnnotationDetails)MSGlycanAnnotationEntityScroller.this.getMsAnnotationDetails()).getParentSubsetTable();
                    String sRowId = Feature.getRowId((Integer)peak.getId(), (Integer)iParentScanNum, (boolean)((MSAnnotationTableDataObject)table.getGRITSTableDataObject()).getUsesComplexRowId());
                    if (table != null && table.getParentTable() != null && table.getParentTable().getGRITSTableDataObject().isLockedPeak(iParentScanNum, sRowId)) {
                        MessageDialog.openInformation((Shell)MSGlycanAnnotationEntityScroller.this.getShell(), (String)"Disabled", (String)"Selections are locked, cannot make changes. Please unlock if you still wish to change candidate selections!");
                        return;
                    }
                }
                ((MSGlycanAnnotationDetails)MSGlycanAnnotationEntityScroller.this.getMsAnnotationDetails()).toggleParentSelectedRow(sCheckBoxKey);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        return newLabel;
    }

    public void reDrawLabel() {
        try {
            super.reDrawLabel();
            if (this.idLabel != null) {
                SharedCheckboxWidget scw = this.getParentSharedCheckboxWidget();
                Feature feat = this.getFeature();
                Peak peak = ((MSGlycanAnnotationDetails)this.getMsAnnotationDetails()).getPeakFromFeature(feat);
                String sCheckBoxKey = MSAnnotationEntityScroller.getCombinedKeyForLookup((Integer)peak.getId(), (String)feat.getId());
                ExtCheckBoxPainter ecbp = (ExtCheckBoxPainter)scw.getHtGlycanToCheckBox().get(sCheckBoxKey);
                if (ecbp != null) {
                    this.idLabel.setImage(ecbp.getCurCheckboxImage());
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error in reDrawLabel.", (Throwable)ex);
        }
    }

    protected void drawLabel() {
        super.drawLabel();
    }

    public void reDraw() {
        super.reDraw();
        if (this.imageCanvas == null) {
            return;
        }
        this.imageCanvas.updateImage(this.getCurViewIndex());
        this.imageCanvas.drawImage();
    }

    protected void drawFeature() {
        if (this.featureControl != null) {
            this.featureControl.dispose();
        }
        this.featureControl = new Composite(this.compositeTop, 0);
        GridData featureData = new GridData();
        featureData.grabExcessHorizontalSpace = true;
        featureData.horizontalAlignment = 4;
        featureData.grabExcessVerticalSpace = true;
        featureData.verticalAlignment = 4;
        featureData.minimumHeight = this.calcMaxHeight();
        featureData.minimumWidth = this.calcMaxWidth();
        this.featureControl.setLayoutData((Object)featureData);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        layout.verticalSpacing = 10;
        layout.numColumns = 2;
        this.featureControl.setLayout((Layout)layout);
        if (this.getCartoonOptions() != null) {
            this.imageCanvas = new MSGlycanAnnotationFigureCanvas(this.featureControl, 768, this.getCartoonOptions());
            this.sequences = new ArrayList<String>();
            int i = 0;
            while (i < this.msAnnotationDetails.getNumFeatures()) {
                this.sequences.add(this.msAnnotationDetails.getFeature(i).getSequence());
                ++i;
            }
            this.imageCanvas.setGlycans(this.sequences, this);
            GridData icData = new GridData();
            icData.grabExcessHorizontalSpace = true;
            icData.grabExcessVerticalSpace = true;
            icData.horizontalAlignment = 4;
            icData.verticalAlignment = 4;
            icData.horizontalSpan = 2;
            this.imageCanvas.setLayoutData(icData);
        }
    }

    public void refreshImages() {
        this.imageCanvas.setGlycans(this.sequences, this);
        this.imageCanvas.drawImage();
    }

    protected List<String> getSequences() {
        return this.sequences;
    }
}

