/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.preference;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.entry.ms.annotation.glycan.util.FileUtils;
import org.grits.toolbox.util.structure.glycan.filter.om.Category;
import org.grits.toolbox.util.structure.glycan.filter.om.Filter;
import org.grits.toolbox.util.structure.glycan.filter.om.FiltersLibrary;
import org.grits.toolbox.util.structure.glycan.util.FilterUtils;

public class MSGlycanCustomFilterCategoryPage
extends PreferencePage {
    private static final Logger logger = Logger.getLogger(MSGlycanCustomFilterCategoryPage.class);
    private FiltersLibrary filterLibrary;
    private GridLayout gridLayout;
    private Button btnDeleteCurrent;
    private Button btnEditCurrent;
    private Button btnCreateNew;
    private boolean bIsDirty;
    private Label lblName;
    private Text txtName;
    private Label lblLabel;
    private Text txtLabel;
    private Label lblDescription;
    private Text txtDescription;
    private String sCategoryLabel;
    private String sCategoryName;
    private String sDescription;
    private Combo cmbSelectCategory;
    private Category currentCategory;
    private Button lAdd;
    private Button lRemove;
    private ListViewer filterListViewer;
    private ListViewer selectedFilterListViewer;

    public MSGlycanCustomFilterCategoryPage() {
        this.loadFilterLibrary();
    }

    private void loadFilterLibrary() {
        try {
            this.filterLibrary = FilterUtils.readFilters((String)FileUtils.getFilterPath());
        }
        catch (Exception e) {
            logger.error((Object)"could not load filter library", (Throwable)e);
        }
    }

    private boolean checkCategoryExists(String name) {
        if (this.filterLibrary != null && this.filterLibrary.getCategories() != null) {
            for (Category c : this.filterLibrary.getCategories()) {
                if (name == null || !c.getName().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    private Category getCurrentCategory(String name) {
        if (this.filterLibrary != null && this.filterLibrary.getCategories() != null) {
            for (Category c : this.filterLibrary.getCategories()) {
                if (!c.getName().equals(name)) continue;
                return c;
            }
        }
        return null;
    }

    private void deleteFromLibrary(String name) {
        if (this.filterLibrary != null && this.filterLibrary.getCategories() != null) {
            Category toBeRemoved = null;
            for (Category c : this.filterLibrary.getCategories()) {
                if (!c.getName().equals(name)) continue;
                toBeRemoved = c;
                break;
            }
            if (toBeRemoved != null) {
                this.filterLibrary.getCategories().remove(toBeRemoved);
            }
        }
    }

    private void addCategoryToLibrary() {
        if (this.currentCategory == null) {
            return;
        }
        if (this.filterLibrary == null) {
            logger.error((Object)"Filter library is empty, cannot add categories");
            this.setErrorMessage("Filter library is empty, cannot add categories");
        } else if (!this.checkCategoryExists(this.currentCategory.getName())) {
            this.filterLibrary.getCategories().add(this.currentCategory);
        } else {
            this.deleteFromLibrary(this.currentCategory.getName());
            this.filterLibrary.getCategories().add(this.currentCategory);
        }
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.initGridLayout();
        container.setLayout((Layout)this.gridLayout);
        this.addSelectCategoryItem(container);
        this.addDeleteCurrent(container);
        this.addEditCurrent(container);
        this.addCreateNewItem(container);
        this.addSeparatorLine1(container);
        this.addCategoryNameItem(container);
        this.addCategoryLabelItem(container);
        this.addDescriptionItem(container);
        this.addCategorySelectionTable(container);
        this.setEditEnabled(false);
        return container;
    }

    private void addCategorySelectionTable(Composite container) {
        Composite comp = new Composite(container, 0);
        comp.setLayoutData((Object)new GridData(4, 4, true, true, 6, 3));
        GridLayout lLayout = new GridLayout(3, false);
        lLayout.marginWidth = 0;
        comp.setLayout((Layout)lLayout);
        GridLayout columnLayout = new GridLayout();
        columnLayout.makeColumnsEqualWidth = false;
        columnLayout.marginRight = 15;
        Composite lCol1 = new Composite(comp, 0);
        lCol1.setLayout((Layout)columnLayout);
        lCol1.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite lCol2 = new Composite(comp, 0);
        lCol2.setLayout((Layout)columnLayout);
        lCol2.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 1));
        Composite lCol3 = new Composite(comp, 0);
        lCol3.setLayout((Layout)columnLayout);
        lCol3.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        org.eclipse.swt.widgets.List filterList = new org.eclipse.swt.widgets.List(lCol1, 2562);
        filterList.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.filterListViewer = new ListViewer(filterList);
        this.filterListViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.filterListViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Filter) {
                    return ((Filter)element).getLabel();
                }
                return super.getText(element);
            }
        });
        this.filterListViewer.setInput(this.copyFilterListLibrary());
        filterList.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent inEvent) {
                String[] lSelection = ((org.eclipse.swt.widgets.List)inEvent.widget).getSelection();
                if (lSelection != null && lSelection.length > 0) {
                    MSGlycanCustomFilterCategoryPage.this.moveItem(MSGlycanCustomFilterCategoryPage.this.filterListViewer, MSGlycanCustomFilterCategoryPage.this.selectedFilterListViewer);
                }
            }
        });
        Composite lButtons = new Composite(lCol2, 0);
        RowLayout rowLayout = new RowLayout(512);
        rowLayout.spacing = 10;
        rowLayout.fill = true;
        lButtons.setLayout((Layout)rowLayout);
        this.lAdd = new Button(lButtons, 8);
        this.lAdd.setText("\u7984");
        this.lAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent inEvent) {
                MSGlycanCustomFilterCategoryPage.this.moveItem(MSGlycanCustomFilterCategoryPage.this.filterListViewer, MSGlycanCustomFilterCategoryPage.this.selectedFilterListViewer);
            }
        });
        this.lRemove = new Button(lButtons, 8);
        this.lRemove.setText("\u82a6");
        this.lRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent inEvent) {
                MSGlycanCustomFilterCategoryPage.this.moveItem(MSGlycanCustomFilterCategoryPage.this.selectedFilterListViewer, MSGlycanCustomFilterCategoryPage.this.filterListViewer);
            }
        });
        org.eclipse.swt.widgets.List selectedFilterList = new org.eclipse.swt.widgets.List(lCol3, 2562);
        selectedFilterList.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.selectedFilterListViewer = new ListViewer(selectedFilterList);
        this.selectedFilterListViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.selectedFilterListViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Filter) {
                    return ((Filter)element).getLabel();
                }
                return super.getText(element);
            }
        });
        this.selectedFilterListViewer.setInput(new ArrayList());
        selectedFilterList.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent inEvent) {
                String[] lSelection = ((org.eclipse.swt.widgets.List)inEvent.widget).getSelection();
                if (lSelection != null && lSelection.length > 0) {
                    MSGlycanCustomFilterCategoryPage.this.moveItem(MSGlycanCustomFilterCategoryPage.this.selectedFilterListViewer, MSGlycanCustomFilterCategoryPage.this.filterListViewer);
                }
            }
        });
    }

    private List<Filter> copyFilterListLibrary() {
        ArrayList<Filter> filterListCopy = new ArrayList<Filter>();
        for (Filter f : this.filterLibrary.getFilters()) {
            filterListCopy.add(f.copy());
        }
        return filterListCopy;
    }

    private void moveItem(ListViewer fromList, ListViewer intoList) {
        for (Filter selected : fromList.getStructuredSelection()) {
            ((List)intoList.getInput()).add(selected);
            ((List)fromList.getInput()).remove(selected);
        }
        intoList.refresh();
        fromList.refresh();
        this.setIsDirty(true);
        if (this.isReadyToFinish()) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }

    private void initCategoryTableValues(Category selCategory) {
        this.selectedFilterListViewer.getList().removeAll();
        List<Filter> filterList = this.getFiltersFromLibrary(selCategory.getFilters());
        this.selectedFilterListViewer.setInput(filterList);
        ArrayList<Filter> remainingFilters = new ArrayList<Filter>();
        for (Filter f : this.filterLibrary.getFilters()) {
            if (selCategory.getFilters().contains(f.getName())) continue;
            remainingFilters.add(f.copy());
        }
        this.filterListViewer.setInput(remainingFilters);
    }

    private List<Filter> getFiltersFromLibrary(List<String> filters) {
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        block0: for (String filterName : filters) {
            for (Filter f : this.filterLibrary.getFilters()) {
                if (!f.getName().equals(filterName)) continue;
                filterList.add(f.copy());
                continue block0;
            }
        }
        return filterList;
    }

    private void addSelectCategoryItem(Composite container) {
        GridData gd1 = new GridData(4, 4, false, false, 1, 1);
        Label lblSelectFilter = new Label(container, 0);
        lblSelectFilter.setText("Current Categories");
        lblSelectFilter.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, false, 5, 1);
        this.cmbSelectCategory = new Combo(container, 0);
        this.cmbSelectCategory.setLayoutData((Object)gd2);
        this.initCategoryList();
        this.cmbSelectCategory.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MSGlycanCustomFilterCategoryPage.this.processSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void processSelection() {
        if (this.cancelIfDirty()) {
            return;
        }
        this.setEditEnabled(false);
        if (!this.cmbSelectCategory.getText().trim().equals("")) {
            this.btnEditCurrent.setEnabled(true);
            this.btnDeleteCurrent.setEnabled(true);
            this.setCurrentCategoryFilterValues(this.cmbSelectCategory.getText().trim());
        }
    }

    private void setCurrentCategoryFilterValues(String selCategoryName) {
        if (selCategoryName == null) {
            return;
        }
        Category selCategory = this.getCurrentCategory(selCategoryName);
        if (selCategory == null) {
            return;
        }
        this.currentCategory = selCategory;
        this.txtName.setText(selCategory.getName());
        this.txtLabel.setText(selCategory.getLabel());
        if (selCategory.getDescription() != null) {
            this.txtDescription.setText(selCategory.getDescription());
        } else {
            this.txtDescription.setText("");
        }
        this.initCategoryTableValues(selCategory);
        this.setIsDirty(false);
    }

    private void initCategoryList() {
        this.cmbSelectCategory.removeAll();
        this.cmbSelectCategory.add("");
        if (this.filterLibrary != null && this.filterLibrary.getCategories() != null) {
            for (Category c : this.filterLibrary.getCategories()) {
                this.cmbSelectCategory.add(c.getName());
            }
        }
    }

    protected void initGridLayout() {
        this.gridLayout = new GridLayout(6, false);
    }

    protected void addDeleteCurrent(Composite parent) {
        GridData gd3 = new GridData(4, 4, false, false, 1, 1);
        this.btnDeleteCurrent = new Button(parent, 0);
        this.btnDeleteCurrent.setText("Delete Selected");
        this.btnDeleteCurrent.setLayoutData((Object)gd3);
        this.btnDeleteCurrent.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                int iSelInx = MSGlycanCustomFilterCategoryPage.this.cmbSelectCategory.getSelectionIndex();
                if (iSelInx == 0) {
                    return;
                }
                boolean bVal = MessageDialog.openConfirm((Shell)MSGlycanCustomFilterCategoryPage.this.getShell(), (String)"Delete Selected?", (String)"Delete selected. Are you sure?");
                if (bVal) {
                    MSGlycanCustomFilterCategoryPage.this.deleteFromLibrary(MSGlycanCustomFilterCategoryPage.this.cmbSelectCategory.getItem(iSelInx));
                    MSGlycanCustomFilterCategoryPage.this.cmbSelectCategory.remove(iSelInx);
                    MSGlycanCustomFilterCategoryPage.this.currentCategory = null;
                    MSGlycanCustomFilterCategoryPage.this.clearValues();
                    MSGlycanCustomFilterCategoryPage.this.setEditEnabled(false);
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
    }

    protected void addEditCurrent(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false, 1, 1);
        this.btnEditCurrent = new Button(parent, 0);
        this.btnEditCurrent.setText("Edit Selected");
        this.btnEditCurrent.setLayoutData((Object)gd1);
        this.btnEditCurrent.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                MSGlycanCustomFilterCategoryPage.this.setEditEnabled(true);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
    }

    protected void addCreateNewItem(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false, 1, 1);
        this.btnCreateNew = new Button(parent, 0);
        this.btnCreateNew.setText("Create New");
        this.btnCreateNew.setLayoutData((Object)gd1);
        this.btnCreateNew.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (MSGlycanCustomFilterCategoryPage.this.cancelIfDirty()) {
                    return;
                }
                MSGlycanCustomFilterCategoryPage.this.setEditEnabled(true);
                MSGlycanCustomFilterCategoryPage.this.btnEditCurrent.setEnabled(false);
                MSGlycanCustomFilterCategoryPage.this.btnDeleteCurrent.setEnabled(false);
                MSGlycanCustomFilterCategoryPage.this.clearValues();
                MSGlycanCustomFilterCategoryPage.this.currentCategory = new Category();
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
    }

    protected void addSeparatorLine1(Composite parent) {
        GridData gd1 = new GridData(4, 4, true, false, 6, 1);
        Label lblSeparator = new Label(parent, 258);
        lblSeparator.setLayoutData((Object)gd1);
    }

    protected boolean cancelIfDirty() {
        boolean bContinue;
        return this.bIsDirty && !(bContinue = MessageDialog.openConfirm((Shell)this.getShell(), (String)"Values Changed", (String)"The values in the current selection have changed. Discard?"));
    }

    public void setEditEnabled(boolean _bVal) {
        this.btnDeleteCurrent.setEnabled(_bVal);
        this.btnEditCurrent.setEnabled(_bVal);
        this.lblName.setEnabled(_bVal);
        this.txtName.setEnabled(_bVal);
        this.lblLabel.setEnabled(_bVal);
        this.txtLabel.setEnabled(_bVal);
        this.lblDescription.setEnabled(_bVal);
        this.txtDescription.setEnabled(_bVal);
        this.selectedFilterListViewer.getList().setEnabled(_bVal);
        this.lAdd.setEnabled(_bVal);
        this.lRemove.setEnabled(_bVal);
        this.filterListViewer.getList().setEnabled(_bVal);
    }

    protected void clearValues() {
        this.txtName.setText("");
        this.txtDescription.setText("");
        this.txtLabel.setText("");
        this.cmbSelectCategory.select(0);
        this.selectedFilterListViewer.setInput(new ArrayList());
        this.filterListViewer.setInput(this.copyFilterListLibrary());
        this.setIsDirty(false);
    }

    protected void addCategoryNameItem(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false, 1, 1);
        this.lblName = new Label(parent, 0);
        this.lblName.setText("Category Name");
        this.lblName.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, false, 5, 1);
        this.txtName = new Text(parent, 2048);
        this.txtName.setLayoutData((Object)gd2);
        this.txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MSGlycanCustomFilterCategoryPage.this.setIsDirty(true);
                if (MSGlycanCustomFilterCategoryPage.this.isReadyToFinish()) {
                    MSGlycanCustomFilterCategoryPage.this.setPageComplete(true);
                } else {
                    MSGlycanCustomFilterCategoryPage.this.setPageComplete(false);
                }
            }
        });
    }

    private void addCategoryLabelItem(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false, 1, 1);
        this.lblLabel = new Label(parent, 0);
        this.lblLabel.setText("Category Label");
        this.lblLabel.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, false, 5, 1);
        this.txtLabel = new Text(parent, 2048);
        this.txtLabel.setLayoutData((Object)gd2);
        this.txtLabel.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MSGlycanCustomFilterCategoryPage.this.setIsDirty(true);
                if (MSGlycanCustomFilterCategoryPage.this.isReadyToFinish()) {
                    MSGlycanCustomFilterCategoryPage.this.setPageComplete(true);
                } else {
                    MSGlycanCustomFilterCategoryPage.this.setPageComplete(false);
                }
            }
        });
    }

    protected void addDescriptionItem(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false, 1, 5);
        this.lblDescription = new Label(parent, 0);
        this.lblDescription.setText("Description");
        this.lblDescription.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, true, 5, 5);
        this.txtDescription = new Text(parent, 2626);
        this.txtDescription.setText("");
        this.txtDescription.setLayoutData((Object)gd2);
        this.txtDescription.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MSGlycanCustomFilterCategoryPage.this.setIsDirty(true);
                if (MSGlycanCustomFilterCategoryPage.this.isReadyToFinish()) {
                    MSGlycanCustomFilterCategoryPage.this.setPageComplete(true);
                } else {
                    MSGlycanCustomFilterCategoryPage.this.setPageComplete(false);
                }
            }
        });
    }

    public void setIsDirty(boolean bIsDirty) {
        this.bIsDirty = bIsDirty;
    }

    public void setPageComplete(boolean isComplete) {
        this.setValid(isComplete);
    }

    private boolean isReadyToFinish() {
        this.sCategoryName = null;
        this.sDescription = null;
        this.sCategoryLabel = null;
        if (!this.txtName.getText().trim().equals("")) {
            this.sCategoryName = this.txtName.getText().trim();
            if (!this.sCategoryName.equals(this.currentCategory.getName()) && this.checkCategoryExists(this.sCategoryName)) {
                this.setErrorMessage("A category already exists with this name!");
                return false;
            }
        } else if (this.currentCategory != null) {
            this.setErrorMessage("Category name cannot be empty");
            return false;
        }
        if (!this.txtLabel.getText().trim().equals("")) {
            this.sCategoryLabel = this.txtLabel.getText().trim();
        } else if (this.currentCategory != null) {
            this.setErrorMessage("Category label cannot be empty");
            return false;
        }
        this.sDescription = this.txtDescription.getText().trim();
        if (this.selectedFilterListViewer.getList().getItemCount() == 0) {
            this.setErrorMessage("You haven't added any filters yet");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private void save() {
        if (this.currentCategory != null && this.bIsDirty) {
            this.currentCategory.setName(this.sCategoryName);
            this.currentCategory.setLabel(this.sCategoryLabel);
            this.currentCategory.setDescription(this.sDescription);
            this.currentCategory.setFilters(Arrays.asList(this.selectedFilterListViewer.getList().getItems()));
            this.addCategoryToLibrary();
            this.saveFilterLibrary();
        }
        this.setIsDirty(false);
    }

    private void saveFilterLibrary() {
        try {
            FileUtils.updateLibrary(FileUtils.getFilterPath(), this.filterLibrary);
        }
        catch (Exception e) {
            this.setErrorMessage("Cannot save the filter category changes. Reason: " + e.getMessage());
            logger.error((Object)"Cannot save the filter category changes", (Throwable)e);
        }
    }

    protected void performApply() {
        this.save();
    }

    public boolean performOk() {
        this.save();
        return true;
    }
}

