/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.preference;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.log4j.Logger;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.core.preference.share.PreferenceEntity;
import org.grits.toolbox.core.preference.share.PreferenceReader;
import org.grits.toolbox.core.preference.share.PreferenceWriter;
import org.grits.toolbox.util.structure.glycan.count.SearchQueryItem;

@XmlRootElement(name="byonicPreferences")
public class MSGlycanAnnotationByonicPreference {
    private static final String PREFERENCE_NAME_ALL = "org.grits.toolbox.entry.ms.annotation.glycan.byonic.all";
    private static final String CURRENT_VERSION = "1.0";
    private static final Logger logger = Logger.getLogger(MSGlycanAnnotationByonicPreference.class);
    List<SearchQueryItem> components;

    public List<SearchQueryItem> getComponents() {
        return this.components;
    }

    public void setComponents(List<SearchQueryItem> components) {
        this.components = components;
    }

    public static PreferenceEntity getPreferenceEntity() throws UnsupportedVersionException {
        PreferenceEntity preferenceEntity = PreferenceReader.getPreferenceByName((String)PREFERENCE_NAME_ALL);
        return preferenceEntity;
    }

    public static MSGlycanAnnotationByonicPreference getByonicPreferences(PreferenceEntity preferenceEntity) {
        MSGlycanAnnotationByonicPreference preference = null;
        preference = preferenceEntity == null ? MSGlycanAnnotationByonicPreference.loadDefaultSettings() : MSGlycanAnnotationByonicPreference.unmarshalComponentsList(preferenceEntity.getValue());
        return preference;
    }

    private static MSGlycanAnnotationByonicPreference unmarshalComponentsList(String value) {
        StringReader reader = new StringReader(value);
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{MSGlycanAnnotationByonicPreference.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            MSGlycanAnnotationByonicPreference pref = (MSGlycanAnnotationByonicPreference)unmarshaller.unmarshal((Reader)reader);
            return pref;
        }
        catch (JAXBException e) {
            logger.error((Object)"Cannot read filter preferences: ", (Throwable)e);
            return null;
        }
    }

    private static String marshalComponentsList(MSGlycanAnnotationByonicPreference preference) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{MSGlycanAnnotationByonicPreference.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.marshal((Object)preference, (OutputStream)os);
        }
        catch (JAXBException e) {
            logger.error((Object)"Cannot write filter preferences: ", (Throwable)e);
            return null;
        }
        return os.toString();
    }

    public static MSGlycanAnnotationByonicPreference loadDefaultSettings() {
        ArrayList<SearchQueryItem> queryList = new ArrayList<SearchQueryItem>();
        queryList.add(new SearchQueryItem("HexNAc", "RES\n1b:x-HEX-1:5\n2s:n-acetyl\nLIN\n1:1d(2+1)2n"));
        queryList.add(new SearchQueryItem("HexN", "RES\n1b:x-HEX-x:x|1:a\n2s:amino\nLIN\n1:1d(2+1)2n"));
        queryList.add(new SearchQueryItem("NeuAC", "RES\n1b:x-dgro-dgal-NON-x:x|1:a|2:keto|3:d\n2s:n-acetyl\nLIN\n1:1d(5+1)2n"));
        queryList.add(new SearchQueryItem("NeuGC", "RES\n1b:x-dgro-dgal-NON-x:x|1:a|2:keto|3:d\n2s:n-glycolyl\nLIN\n1:1d(5+1)2n"));
        queryList.add(new SearchQueryItem("KDN", "RES\n1b:x-dgro-dgal-NON-x:x|1:a|2:keto|3:d"));
        queryList.add(new SearchQueryItem("dHex", "RES\n1b:x-HEX-x:x|6:d"));
        queryList.add(new SearchQueryItem("Hex", "RES\n1b:x-HEX-x:x"));
        queryList.add(new SearchQueryItem("Pent", "RES\n1b:x-PEN-x:x"));
        queryList.add(new SearchQueryItem("GlcA", "RES\n1b:x-dglc-HEX-1:5|6:a"));
        queryList.add(new SearchQueryItem("IdoA", "RES\n1b:x-lido-HEX-1:5|6:a"));
        queryList.add(new SearchQueryItem("Phosphate", "RES\n1s:phosphate"));
        queryList.add(new SearchQueryItem("Sulfate", "RES\n1s:sulfate"));
        MSGlycanAnnotationByonicPreference preference = new MSGlycanAnnotationByonicPreference();
        preference.setComponents(queryList);
        return preference;
    }

    public boolean save() {
        PreferenceEntity preferenceEntity = new PreferenceEntity(PREFERENCE_NAME_ALL);
        preferenceEntity.setVersion(CURRENT_VERSION);
        preferenceEntity.setValue(MSGlycanAnnotationByonicPreference.marshalComponentsList(this));
        return PreferenceWriter.savePreference((PreferenceEntity)preferenceEntity);
    }
}

