/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.adaptor;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DatabaseDialog
extends TitleAreaDialog {
    String name;
    String description;
    String version = "1.0";
    private Text dbName;
    private Text dbDescription;
    private Text dbVersion;

    protected DatabaseDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Database Information");
        this.setMessage("Please enter the details for the database");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        Monitor primary = this.getShell().getDisplay().getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = this.getShell().getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        this.getShell().setLocation(x, y);
        GridLayout gd = new GridLayout(2, false);
        gd.marginRight = 8;
        gd.verticalSpacing = 20;
        gd.horizontalSpacing = 8;
        container.setLayout((Layout)gd);
        container.setLayoutData((Object)new GridData(1808));
        Label dbNameLabel = new Label(container, 16384);
        dbNameLabel.setText("Database Name");
        this.dbName = new Text(container, 2048);
        Label dbDescriptionLabel = new Label(container, 16384);
        dbDescriptionLabel.setText("Description");
        this.dbDescription = new Text(container, 2048);
        Label dbVersionLabel = new Label(container, 16384);
        dbVersionLabel.setText("Database Version");
        this.dbVersion = new Text(container, 2048);
        this.dbVersion.setText(this.version);
        return area;
    }

    protected void okPressed() {
        if (this.dbName.getText().isEmpty()) {
            this.setErrorMessage("Database name cannot be blank");
        } else {
            this.name = this.dbName.getText();
            this.description = this.dbDescription.getText();
            this.version = this.dbVersion.getText();
            super.okPressed();
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getVersion() {
        return this.version;
    }
}

