/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.io.ms.annotation.glycan.process.export;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.resourcesdb.Config;
import org.eurocarbdb.resourcesdb.io.MonosaccharideConversion;
import org.eurocarbdb.resourcesdb.io.MonosaccharideConverter;
import org.glycomedb.residuetranslator.ResidueTranslator;
import org.grits.toolbox.datamodel.ms.tablemodel.dmtranslate.DMPeak;
import org.grits.toolbox.datamodel.ms.tablemodel.dmtranslate.DMPrecursorPeak;
import org.grits.toolbox.display.control.table.datamodel.GRITSListDataRow;
import org.grits.toolbox.io.ms.annotation.glycan.process.export.MSGlycanAnnotationWriterExcel;
import org.grits.toolbox.io.ms.annotation.listener.ExcelListener;
import org.grits.toolbox.io.ms.annotation.process.export.MSAnnotationExcelListener;
import org.grits.toolbox.io.ms.annotation.process.export.MSAnnotationExportProcess;
import org.grits.toolbox.io.ms.annotation.process.export.MSAnnotationWriterExcel;
import org.grits.toolbox.ms.om.data.Feature;
import org.grits.toolbox.util.structure.glycan.filter.GlycanFilterOperator;
import org.grits.toolbox.util.structure.glycan.filter.om.Filter;
import org.grits.toolbox.util.structure.glycan.filter.om.FilterSetting;
import org.grits.toolbox.utils.process.GlycoWorkbenchUtil;
import org.grits.toolbox.widgets.processDialog.ProgressDialog;
import org.grits.toolbox.widgets.progress.IProgressThreadHandler;

public class MSGlycanAnnotationExportProcess
extends MSAnnotationExportProcess {
    private static final Logger logger = Logger.getLogger(MSGlycanAnnotationExportProcess.class);
    protected FilterSetting filterSetting;
    protected GlycoWorkbenchUtil m_gwbUtil;
    protected String filterKey;
    protected double thresholdValue;
    protected int numTopHits = -1;

    protected MSAnnotationWriterExcel getNewMSAnnotationWriterExcel() {
        return new MSGlycanAnnotationWriterExcel();
    }

    protected int isVisible(int iRowNum) {
        GRITSListDataRow row = (GRITSListDataRow)this.getTableDataObject().getTableData().get(iRowNum);
        int iParentScanIdCol = -1;
        if (this.getTableDataObject().getParentNoCol() != null && !this.getTableDataObject().getParentNoCol().isEmpty()) {
            iParentScanIdCol = (Integer)this.getTableDataObject().getParentNoCol().get(0);
        }
        int iFeatureIdCol = (Integer)this.getTableDataObject().getFeatureIdCols().get(0);
        Integer iParentScanNum = null;
        if (this.getMasterParentScan() != -1) {
            iParentScanNum = this.getMasterParentScan();
        } else if (iParentScanIdCol != -1 && row.getDataRow().get(iParentScanIdCol) != null) {
            iParentScanNum = (Integer)row.getDataRow().get(iParentScanIdCol);
        }
        if (iParentScanNum == null) {
            return 0;
        }
        String sFeatureId = (String)row.getDataRow().get(iFeatureIdCol);
        if (sFeatureId == null && this.hideUnAnnotatedRows()) {
            return 1;
        }
        String sRowId = this.getRowID(iRowNum);
        if (this.getTableDataObject().isHiddenRow(iParentScanNum, sRowId, sFeatureId)) {
            return 1;
        }
        if (this.getTableDataObject().isInvisibleRow(iParentScanNum, sRowId)) {
            return 2;
        }
        return 0;
    }

    protected void markAnnotatedRows(int iRowNum, Map<Integer, List<String>> mAtLeastOne) throws Exception {
        GRITSListDataRow row = (GRITSListDataRow)this.getTableDataObject().getTableData().get(iRowNum);
        int iPeakIdCol = (Integer)this.getTableDataObject().getPeakIdCols().get(0);
        Integer iPeakId = (Integer)row.getDataRow().get(iPeakIdCol);
        if (iPeakId == null) {
            return;
        }
        int iFeatureIdCol = (Integer)this.getTableDataObject().getFeatureIdCols().get(0);
        String sFeatureId = (String)row.getDataRow().get(iFeatureIdCol);
        if (sFeatureId == null && this.hideUnAnnotatedRows()) {
            return;
        }
        String sRowId = this.getRowID(iRowNum);
        if (sFeatureId != null && iPeakId != null) {
            List<Object> alAtLeastOne = null;
            if (!mAtLeastOne.containsKey(iPeakId)) {
                alAtLeastOne = new ArrayList();
                mAtLeastOne.put(iPeakId, alAtLeastOne);
            } else {
                alAtLeastOne = mAtLeastOne.get(iPeakId);
            }
            alAtLeastOne.add(sRowId);
        }
    }

    protected boolean getFinalVisibility(int iRowNum, Map<Integer, List<String>> mAtLeastOne) throws Exception {
        List<String> atLeastOne;
        GRITSListDataRow row = (GRITSListDataRow)this.getTableDataObject().getTableData().get(iRowNum);
        int iParentScanIdCol = -1;
        if (this.getTableDataObject().getParentNoCol() != null && !this.getTableDataObject().getParentNoCol().isEmpty()) {
            iParentScanIdCol = (Integer)this.getTableDataObject().getParentNoCol().get(0);
        }
        Integer iParentScanNum = null;
        if (this.getMasterParentScan() != -1) {
            iParentScanNum = this.getMasterParentScan();
        } else if (iParentScanIdCol != -1 && row.getDataRow().get(iParentScanIdCol) != null) {
            iParentScanNum = (Integer)row.getDataRow().get(iParentScanIdCol);
        }
        if (iParentScanNum == null) {
            return false;
        }
        int iPeakIdCol = (Integer)this.getTableDataObject().getPeakIdCols().get(0);
        Integer iPeakId = (Integer)row.getDataRow().get(iPeakIdCol);
        if (iPeakId == null) {
            return false;
        }
        int iFeatureIdCol = (Integer)this.getTableDataObject().getFeatureIdCols().get(0);
        String sFeatureId = (String)row.getDataRow().get(iFeatureIdCol);
        if (sFeatureId == null && this.hideUnAnnotatedRows()) {
            return true;
        }
        String sRowId = this.getRowID(iRowNum);
        if (sRowId == null) {
            logger.error((Object)("Null row id for row num: " + sRowId));
            return false;
        }
        if (iPeakId != null && !mAtLeastOne.containsKey(iPeakId)) {
            return iPeakId == null || sFeatureId == null || iParentScanNum == null || !this.getTableDataObject().isHiddenRow(iParentScanNum, sRowId, sFeatureId);
        }
        if (iPeakId != null && ((atLeastOne = mAtLeastOne.get(iPeakId)) == null || atLeastOne.size() == 0)) {
            return iPeakId == null || sFeatureId == null || iParentScanNum == null || !this.getTableDataObject().isHiddenRow(iParentScanNum, sRowId, sFeatureId);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean threadStart(IProgressThreadHandler a_progressThreadHandler) throws Exception {
        try {
            MSAnnotationWriterExcel t_writerExcel = this.getNewMSAnnotationWriterExcel();
            t_writerExcel.createNewFile(this.getOutputFile(), this.getTableDataObject(), this.getLastVisibleColInx(), (ExcelListener)new MSAnnotationExcelListener((ProgressDialog)a_progressThreadHandler));
            Config t_objConf = new Config();
            MonosaccharideConverter t_msdb = new MonosaccharideConverter(t_objConf);
            try {
                this.m_gwbUtil = new GlycoWorkbenchUtil((MonosaccharideConversion)new ResidueTranslator(), (MonosaccharideConversion)t_msdb);
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            ((ProgressDialog)a_progressThreadHandler).setMax(this.tableDataObject.getTableData().size());
            ((ProgressDialog)a_progressThreadHandler).setProcessMessageLabel("Processing data and filters");
            HashMap<Integer, Boolean> invisibleRowMap = new HashMap<Integer, Boolean>();
            HashMap<String, Double> rowIntensityMap = new HashMap<String, Double>();
            Map<Object, Object> topRowIntensityMap = new HashMap();
            HashMap<Integer, Boolean> rowGlycanMap = new HashMap<Integer, Boolean>();
            HashMap<Integer, List<String>> mAtLeastOne = new HashMap<Integer, List<String>>();
            Map<String, List<Integer>> mRowIdToRowNum = this.getRowIdtoRowNumMap();
            int i = 0;
            while (i < this.getTableDataObject().getTableData().size()) {
                if (this.isCanceled()) {
                    t_writerExcel.close();
                    return false;
                }
                GRITSListDataRow row = (GRITSListDataRow)this.getTableDataObject().getTableData().get(i);
                int iVisInfo = this.isVisible(i);
                if (iVisInfo != 1) {
                    invisibleRowMap.put(i, iVisInfo == 2);
                    Boolean passedGlycan = this.applyGlycanFilters(row.getDataRow());
                    rowGlycanMap.put(i, passedGlycan);
                    this.applyIntensityFilter(i, rowIntensityMap);
                    this.markAnnotatedRows(i, mAtLeastOne);
                    ((ProgressDialog)a_progressThreadHandler).updateProgresBar("Scan: " + (i + 1));
                }
                ++i;
            }
            topRowIntensityMap = this.applyTopHits(rowIntensityMap, this.numTopHits);
            ((ProgressDialog)a_progressThreadHandler).setMax(this.getTableDataObject().getTableData().size());
            ((ProgressDialog)a_progressThreadHandler).setProcessMessageLabel("Processing filter results");
            i = 0;
            while (i < this.getTableDataObject().getTableData().size()) {
                if (this.isCanceled()) {
                    t_writerExcel.close();
                    return false;
                }
                boolean bIsInVis = this.getFinalVisibility(i, mAtLeastOne);
                if (bIsInVis) {
                    invisibleRowMap.put(i, true);
                }
                ((ProgressDialog)a_progressThreadHandler).updateProgresBar("Scan: " + (i + 1));
                ++i;
            }
            ((ProgressDialog)a_progressThreadHandler).setMax(topRowIntensityMap.size());
            ((ProgressDialog)a_progressThreadHandler).setProcessMessageLabel("Exporting data");
            ArrayList<Integer> exportRows = new ArrayList<Integer>();
            int i2 = 0;
            for (String rowId : mRowIdToRowNum.keySet()) {
                if (!topRowIntensityMap.containsKey(rowId)) continue;
                List<Integer> tableRows = null;
                if (mRowIdToRowNum.containsKey(rowId)) {
                    tableRows = mRowIdToRowNum.get(rowId);
                }
                if (tableRows == null) continue;
                for (Integer rowNum : tableRows) {
                    if (!rowGlycanMap.isEmpty() && (!rowGlycanMap.containsKey(rowNum) || !((Boolean)rowGlycanMap.get(rowNum)).booleanValue()) || !invisibleRowMap.containsKey(rowNum)) continue;
                    exportRows.add(rowNum);
                }
            }
            Collections.sort(exportRows);
            for (Integer rowNum : exportRows) {
                logger.debug((Object)("Export row num: " + rowNum));
                t_writerExcel.writeRow(rowNum.intValue(), ((Boolean)invisibleRowMap.get(rowNum)).booleanValue());
                ((ProgressDialog)a_progressThreadHandler).updateProgresBar("Scan: " + (i2 + 1));
                ++i2;
            }
            t_writerExcel.close();
            return true;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    protected Map<String, Double> applyTopHits(Map<String, Double> rowIntensityMap, int numTopHits) {
        if (numTopHits <= 0 || this.filterKey == null) {
            return rowIntensityMap;
        }
        Map<String, Double> sortedMap = MSGlycanAnnotationExportProcess.sortByValue(rowIntensityMap);
        LinkedHashMap<String, Double> topSelectedRows = new LinkedHashMap<String, Double>();
        int i = 0;
        for (String rowId : sortedMap.keySet()) {
            if (i >= numTopHits) break;
            topSelectedRows.put(rowId, sortedMap.get(rowId));
            ++i;
        }
        return topSelectedRows;
    }

    protected Boolean applyGlycanFilters(ArrayList<Object> dataRow) throws Exception {
        int sequenceCol = (Integer)this.getTableDataObject().getSequenceCols().get(0);
        String sequence = (String)dataRow.get(sequenceCol);
        boolean bPasses = this.passesFilters(sequence);
        if (!bPasses) {
            int iFeatureIdCol = (Integer)this.getTableDataObject().getFeatureIdCols().get(0);
            String sFeatureId = (String)dataRow.get(iFeatureIdCol);
            logger.debug((Object)(String.valueOf(sFeatureId) + " failed to pass the filter. Skipping!"));
        }
        return bPasses;
    }

    protected String getRowID(int iRowNum) {
        String sRowId;
        GRITSListDataRow row = (GRITSListDataRow)this.getTableDataObject().getTableData().get(iRowNum);
        int iPeakIdCol = (Integer)this.getTableDataObject().getPeakIdCols().get(0);
        Integer iPeakId = (Integer)row.getDataRow().get(iPeakIdCol);
        if (iPeakId == null) {
            return String.valueOf(iRowNum);
        }
        int iScanIdCol = -1;
        if (this.getTableDataObject().getScanNoCols() != null && !this.getTableDataObject().getScanNoCols().isEmpty()) {
            iScanIdCol = (Integer)this.getTableDataObject().getScanNoCols().get(0);
        }
        Integer iScanNum = null;
        if (iScanIdCol != -1) {
            iScanNum = (Integer)row.getDataRow().get(iScanIdCol);
        }
        if ((sRowId = Feature.getRowId((Integer)iPeakId, (Integer)iScanNum, (boolean)this.getTableDataObject().getUsesComplexRowId())) == null) {
            logger.error((Object)("Null row id for row num: " + iRowNum));
            return String.valueOf(iRowNum);
        }
        return sRowId;
    }

    protected Map<String, List<Integer>> getRowIdtoRowNumMap() {
        HashMap<String, List<Integer>> mRowIdToRunNum = new HashMap<String, List<Integer>>();
        int i = 0;
        while (i < this.getTableDataObject().getTableData().size()) {
            if (this.isCanceled()) {
                return null;
            }
            String sRowID = this.getRowID(i);
            List<Integer> lRowNums = null;
            if (mRowIdToRunNum.containsKey(sRowID)) {
                lRowNums = (List)mRowIdToRunNum.get(sRowID);
            } else {
                lRowNums = new ArrayList();
                mRowIdToRunNum.put(sRowID, lRowNums);
            }
            lRowNums.add(i);
            ++i;
        }
        return mRowIdToRunNum;
    }

    protected void applyIntensityFilter(int iRowNum, Map<String, Double> rowIntensityMap) {
        GRITSListDataRow row = (GRITSListDataRow)this.getTableDataObject().getTableData().get(iRowNum);
        String sRowId = this.getRowID(iRowNum);
        if (rowIntensityMap.containsKey(sRowId)) {
            return;
        }
        Double dPeakIntensity = 0.0;
        if (this.filterKey != null && this.filterKey.equals(DMPeak.peak_intensity.getLabel())) {
            Double peakIntensity = (Double)row.getDataRow().get((Integer)this.getTableDataObject().getPeakIntensityCols().get(0));
            if (this.thresholdValue > 0.0 && peakIntensity >= this.thresholdValue) {
                dPeakIntensity = peakIntensity;
            }
        } else if (this.filterKey != null && this.filterKey.equals(DMPrecursorPeak.precursor_peak_intensity.getLabel())) {
            Double intensity = (Double)row.getDataRow().get((Integer)this.getTableDataObject().getPrecursorIntensityCols().get(0));
            if (this.thresholdValue > 0.0 && intensity >= this.thresholdValue) {
                dPeakIntensity = intensity;
            }
        }
        rowIntensityMap.put(sRowId, dPeakIntensity);
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map) {
        return map.entrySet().stream().sorted(Map.Entry.comparingByValue(Collections.reverseOrder())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }

    protected boolean passesFilters(String sequence) throws Exception {
        if (sequence != null && !sequence.isEmpty() && this.filterSetting != null) {
            int iInx1 = sequence.indexOf("~|~");
            if (iInx1 < 0) {
                this.m_gwbUtil.parseGWSSequence(sequence);
                Glycan glycan = this.m_gwbUtil.getGlycoWorkbenchGlycan();
                return GlycanFilterOperator.evaluate((Sugar)glycan.toSugar(), (Filter)this.filterSetting.getFilter());
            }
            String sRemaining = sequence;
            do {
                String sSeq = iInx1 > 0 ? sRemaining.substring(0, iInx1) : sRemaining;
                this.m_gwbUtil.parseGWSSequence(sSeq);
                Glycan glycan = this.m_gwbUtil.getGlycoWorkbenchGlycan();
                if (GlycanFilterOperator.evaluate((Sugar)glycan.toSugar(), (Filter)this.filterSetting.getFilter())) {
                    return true;
                }
                sRemaining = iInx1 > 0 ? sRemaining.substring(iInx1 + "~|~".length()) : null;
                int n = iInx1 = sRemaining != null ? sRemaining.indexOf("~|~") : -1;
            } while (sRemaining != null);
        }
        return true;
    }

    public void setFilterSetting(FilterSetting filterSetting) {
        this.filterSetting = filterSetting;
    }

    public void setFilterKey(String filterKey) {
        this.filterKey = filterKey;
    }

    public void setNumTopHits(int numTopHits) {
        this.numTopHits = numTopHits;
    }

    public void setThresholdValue(double thresholdValue) {
        this.thresholdValue = thresholdValue;
    }
}

