/*
 * Decompiled with CFR 0.152.
 */
package edu.brandeis.glycodenovo.wizard;

import edu.brandeis.glycodenovo.core.CGlycoDeNovo;
import edu.brandeis.glycodenovo.core.CIonclassifier;
import edu.brandeis.glycodenovo.core.CSpectrum;
import edu.brandeis.glycodenovo.datamodel.Save;
import edu.brandeis.glycodenovo.datamodel.SettingForm;
import java.io.File;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.util.DataModelSearch;
import org.grits.toolbox.entry.ms.property.MassSpecProperty;
import org.grits.toolbox.entry.ms.property.datamodel.MSPropertyDataFile;
import org.grits.toolbox.ms.file.MSFile;

public class PageReconstruction
extends WizardPage {
    private Composite mContainer;
    private SettingForm mForm;
    private Entry mAnnotationEntry;
    private CGlycoDeNovo mGlycoDeNovo;
    private static final Logger logger = Logger.getLogger(PageReconstruction.class);

    protected PageReconstruction(String pageName, SettingForm form) {
        super(pageName);
        this.setTitle("Topology Reconstruction");
        this.mForm = form;
    }

    public void createControl(Composite a_parent) {
        this.mContainer = new Composite(a_parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.makeColumnsEqualWidth = true;
        this.mContainer.setLayout((Layout)gridLayout);
        GridData gdRecon = new GridData(256);
        gdRecon.horizontalSpan = 3;
        gdRecon.grabExcessHorizontalSpace = true;
        Label header = new Label(this.mContainer, 0);
        header.setText("Set reconstruction parameters:");
        header.setLayoutData((Object)gdRecon);
        Button check2H = new Button(this.mContainer, 32);
        check2H.setText("Check 2H");
        check2H.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent a_e) {
                Button btn = (Button)a_e.getSource();
                PageReconstruction.this.mForm.setCheck2H(btn.getSelection());
                PageReconstruction.this.getContainer().updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent a_e) {
            }
        });
        Button checkGap = new Button(this.mContainer, 32);
        checkGap.setText("Check Gap");
        checkGap.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent a_e) {
                Button btn = (Button)a_e.getSource();
                PageReconstruction.this.mForm.setCheckGap(btn.getSelection());
                PageReconstruction.this.getContainer().updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent a_e) {
            }
        });
        checkGap.setLayoutData((Object)gdRecon);
        this.createSetReconstructionPPM();
        this.createSetReconstructionBranchNumber();
        Label labelEmpty = new Label(this.mContainer, 0);
        labelEmpty.setLayoutData((Object)gdRecon);
        this.createReconstructionButton();
        this.getContainer().updateButtons();
        this.setControl((Control)this.mContainer);
    }

    private void createSetReconstructionPPM() {
        new Label(this.mContainer, 0).setText("Resolution (ppm):");
        GridData gridData = new GridData(32);
        gridData.horizontalSpan = 2;
        gridData.minimumWidth = 50;
        final Text text = new Text(this.mContainer, 2048);
        text.setMessage("resolution");
        text.setLayoutData((Object)gridData);
        text.setText("5");
        this.updateReconstructionPPM(text.getText());
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent a_e) {
                PageReconstruction.this.updateReconstructionPPM(text.getText());
                PageReconstruction.this.getContainer().updateButtons();
            }
        });
    }

    private void updateReconstructionPPM(String input) {
        if (input.length() != 0) {
            try {
                double ppm = Double.parseDouble(input);
                if (ppm != this.mForm.getReconstructionPPM()) {
                    this.mForm.setReconstructionPPM(ppm);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.mForm.setReconstructionPPM(-1.0);
                MessageDialog.openError((Shell)this.mContainer.getShell(), (String)"Error", (String)"Only numerical value is supported for ppm");
            }
        } else {
            this.mForm.setReconstructionPPM(-1.0);
        }
    }

    private void createSetReconstructionBranchNumber() {
        new Label(this.mContainer, 0).setText("Branch number (2, 3, or 4):");
        GridData gridData = new GridData(32);
        gridData.horizontalSpan = 2;
        gridData.minimumWidth = 50;
        final Text text = new Text(this.mContainer, 2048);
        text.setMessage("Branch number");
        text.setLayoutData((Object)gridData);
        text.setText("2");
        this.updateReconstructionBranchNumber("2");
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent a_e) {
                PageReconstruction.this.updateReconstructionBranchNumber(text.getText());
                PageReconstruction.this.getContainer().updateButtons();
            }
        });
    }

    private void updateReconstructionBranchNumber(String input) {
        if (input.length() != 0) {
            try {
                int bn = Integer.parseInt(input);
                if (bn < 2 || bn > 4) {
                    MessageDialog.openError((Shell)this.mContainer.getShell(), (String)"Error", (String)"Branch number should be between 2 and 4!");
                } else if (bn != this.mForm.getReconstructionBranchNumber()) {
                    this.mForm.setReconstructionBranchNumber(bn);
                }
            }
            catch (NumberFormatException numberFormatException) {
                MessageDialog.openError((Shell)this.mContainer.getShell(), (String)"Error", (String)"Branch number should be between 2 and 4!");
            }
        } else {
            this.mForm.setReconstructionBranchNumber(2);
        }
    }

    private void createReconstructionButton() {
        Button process = new Button(this.mContainer, 8);
        process.setText("Reconstruct Topologies");
        process.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PageReconstruction.this.reconstruct();
                System.getProperty("user.dir");
                CIonclassifier classifier = new CIonclassifier(System.getProperty("user.dir"));
                PageReconstruction.this.mForm.setReconstructed();
                ArrayList<CSpectrum> speca = new ArrayList<CSpectrum>();
                speca.add(PageReconstruction.this.mForm.getSpectrum());
                try {
                    classifier.rank_candidates(speca);
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                    System.out.println("Model missing");
                }
                String filename = PageReconstruction.this.mForm.getOptionalResName();
                if (filename != null) {
                    PageReconstruction.this.mForm.getSpectrum().outputTXT(filename, PageReconstruction.this.mForm.getCheck2H(), PageReconstruction.this.mForm.getCheckGap());
                }
                PageReconstruction.this.getContainer().updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void reconstruct() {
        CSpectrum spec = this.mForm.getSpectrum();
        spec.specProcessing();
        this.mGlycoDeNovo = new CGlycoDeNovo(this.mForm.getReconstructionPPM(), this.mForm.getCheck2H(), this.mForm.getCheckGap());
        this.mGlycoDeNovo.setMaxBranchNum(this.mForm.getReconstructionBranchNumber());
        this.mGlycoDeNovo.interpretPeaks(spec);
        this.mGlycoDeNovo.reconstructFormulas();
    }

    public SettingForm getForm() {
        return this.mForm;
    }

    public boolean canFlipToNextPage() {
        return this.mForm.isReconstructed();
    }

    public IWizardPage getNextPage() {
        return null;
    }

    public void save() {
        Entry msEntry = this.mForm.getEntry();
        MassSpecProperty prop = (MassSpecProperty)msEntry.getProperty();
        MSPropertyDataFile dataFile = this.mForm.getDataFile();
        String workspaceLocation = PropertyHandler.getVariable((String)"workspace_location");
        String projectName = DataModelSearch.findParentByType((Entry)msEntry, (String)"org.grits.toolbox.property.project").getDisplayName();
        String pathToFile = String.valueOf(workspaceLocation) + projectName + File.separator + MassSpecProperty.getFoldername();
        MSFile msFile = dataFile.getMSFileWithReader(pathToFile, prop.getMassSpecMetaData().getMsExperimentType());
        this.mForm.updateResultName();
        Save save = new Save(this.mForm, msFile);
        this.mAnnotationEntry = save.save();
    }

    public Entry[] getResult() {
        return new Entry[]{this.mForm.getEntry(), this.mAnnotationEntry};
    }
}

