/*
 * Decompiled with CFR 0.152.
 */
package edu.brandeis.glycodenovo.datamodel;

import edu.brandeis.glycodenovo.core.CPeak;
import edu.brandeis.glycodenovo.core.CSpectrum;
import java.util.ArrayList;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class TableView
extends Dialog {
    private CSpectrum spectrum;

    public TableView(Composite container, CSpectrum spectrum) {
        super(container.getShell());
        this.spectrum = spectrum;
    }

    public void open() {
        Shell parent = this.getParent();
        Shell shell = new Shell(parent, 64);
        shell.setLayout((Layout)new GridLayout(1, false));
        Table t = new Table((Composite)shell, 2816);
        t.setHeaderVisible(true);
        t.setLinesVisible(true);
        t.setLayoutData((Object)new GridData(1, 4, true, true));
        TableColumn tc1 = new TableColumn(t, 0x1000000);
        TableColumn tc2 = new TableColumn(t, 0x1000000);
        TableColumn tc3 = new TableColumn(t, 0x1000000);
        TableColumn tc4 = new TableColumn(t, 0x1000000);
        tc1.setText("Number");
        tc2.setText("M/Z");
        tc3.setText("Charge");
        tc4.setText("Intensity");
        ArrayList<CPeak> peakList = this.spectrum.getPeakList();
        int i = 0;
        while (i < peakList.size()) {
            TableItem temp = new TableItem(t, 0);
            CPeak peak = (CPeak)((Object)peakList.get(i));
            temp.setText(new String[]{Integer.toString(i + 1), Double.toString(peak.getMz()), Double.toString(peak.getCharge().intValue()), Double.toString(peak.getIntensity())});
            ++i;
        }
        TableColumn[] tableColumnArray = t.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.pack();
            ++n2;
        }
        t.pack();
        shell.setSize(t.getSize().x, shell.getSize().y);
        shell.open();
        Display display = parent.getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }
}

