/*
 * Decompiled with CFR 0.152.
 */
package edu.brandeis.glycodenovo.core;

import edu.brandeis.glycodenovo.clustering.Cluster;
import edu.brandeis.glycodenovo.clustering.PDistClusteringAlgorithm;
import edu.brandeis.glycodenovo.clustering.SingleLinkageStrategy;
import edu.brandeis.glycodenovo.core.CGlycoDeNovo;
import edu.brandeis.glycodenovo.core.CMass;
import edu.brandeis.glycodenovo.core.CMonosaccharideSet;
import edu.brandeis.glycodenovo.core.CPeak;
import edu.brandeis.glycodenovo.core.CTopology;
import edu.brandeis.glycodenovo.core.CTopologySuperSet;
import edu.brandeis.glycodenovo.datamodel.SettingForm;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CSpectrum {
    private ArrayList<CPeak> mPeaks;
    private double mPrecursorMZ = -1.0;
    private double mPrecursorRawMZ = -1.0;
    private double mPrecursorRawZ = -1.0;
    private String mDerivationMethod;
    private String mMetal;
    private boolean mNLinked = false;
    private boolean mPermethylated = false;
    private boolean mProtonated = false;
    private String mReducingEndMode;
    private String mComment;
    private String mFilename;
    private double mMassAccuracyPPM = 5.0;
    private HashMap<Double, HashSet<CPeak>> mOriginalPeaksMap = new HashMap();
    private ArrayList<CPeak> originalPeaks = new ArrayList();

    public CSpectrum() {
    }

    public CSpectrum(String specFilename) {
        Scanner sc = null;
        File specFile = new File(specFilename);
        try {
            sc = new Scanner(specFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalArgumentException("No such file");
        }
        this.mFilename = specFile.getName().substring(0, specFile.getName().lastIndexOf("."));
        String currentLine = sc.nextLine().trim();
        boolean firstLine = true;
        while (currentLine.startsWith("#") || currentLine.isEmpty()) {
            block33: {
                block37: {
                    block36: {
                        block35: {
                            block34: {
                                block32: {
                                    if (!currentLine.startsWith("# Metal:")) break block32;
                                    this.mMetal = currentLine.substring(9);
                                    if (this.mMetal.equals("H")) {
                                        this.mMetal = "Proton";
                                    }
                                    break block33;
                                }
                                if (!currentLine.startsWith("# Method:")) break block34;
                                this.mDerivationMethod = currentLine.substring(10);
                                break block33;
                            }
                            if (!currentLine.startsWith("# Precursor:")) break block35;
                            String[] fields = currentLine.substring(13).split(";");
                            String temp = this.mMetal.equals("Proton") ? "H+" : String.valueOf(this.mMetal) + "+";
                            String[] stringArray = fields;
                            int n = fields.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String p = stringArray[n2];
                                p = p.trim();
                                int idx = p.indexOf(temp);
                                this.mPrecursorRawZ = 1.0;
                                if (idx != -1) {
                                    this.mPrecursorRawMZ = Double.valueOf(p.substring(idx + temp.length() + 1));
                                    if (idx != 0) {
                                        this.mPrecursorRawZ = Integer.valueOf(p.substring(0, idx)).intValue();
                                    }
                                    this.mPrecursorMZ = this.mPrecursorRawZ * this.mPrecursorRawMZ - this.mPrecursorRawZ * (CMass.getAtomMass(this.mMetal) - 5.489E-4) + 1.007276432;
                                }
                                ++n2;
                            }
                            break block33;
                        }
                        if (!firstLine) break block36;
                        this.mComment = currentLine.substring(2).trim();
                        firstLine = false;
                        break block33;
                    }
                    if (!currentLine.startsWith("# PPM:")) break block37;
                    this.mMassAccuracyPPM = Double.parseDouble(currentLine.substring(6));
                    break block33;
                }
                switch (currentLine) {
                    case "# Reduced": 
                    case "# Aminopyridine": 
                    case "# O18": 
                    case "# Deuterium": 
                    case "# PRAGS": {
                        this.mReducingEndMode = currentLine.substring(2);
                        break;
                    }
                    case "# PA": {
                        this.mReducingEndMode = "Aminopyridine";
                        break;
                    }
                    case "# Permethylated": {
                        this.mPermethylated = true;
                        break;
                    }
                    case "# NLinked": {
                        this.mNLinked = true;
                        break;
                    }
                }
            }
            currentLine = sc.nextLine().trim();
        }
        this.mPeaks = new ArrayList();
        while (sc.hasNextLine()) {
            Scanner lineSc = new Scanner(sc.nextLine().trim());
            if (!lineSc.hasNext()) continue;
            double rawMZ = lineSc.nextDouble();
            int rawZ = Character.getNumericValue(lineSc.next().charAt(0));
            double intensity = lineSc.nextDouble();
            lineSc.close();
            this.mPeaks.add(new CPeak(this, intensity, rawMZ, rawZ));
            this.originalPeaks.add(new CPeak(this, intensity, rawMZ, rawZ));
            this.mOriginalPeaksMap.put(new CPeak(this, intensity, rawMZ, rawZ).getMz(), new HashSet());
        }
        sc.close();
        Collections.sort(this.mPeaks);
        Collections.sort(this.originalPeaks);
    }

    public CSpectrum(SettingForm form) {
        this.mDerivationMethod = form.getExperimentType();
        this.mMassAccuracyPPM = form.getReconstructionPPM();
        this.mMetal = form.getMetal();
        this.mFilename = form.getFilePath();
        this.mReducingEndMode = form.getReducingEnd();
        this.mPermethylated = form.getPermethylated();
    }

    public ArrayList<CPeak> getPeakList() {
        return this.mPeaks;
    }

    public boolean isValid() {
        return this.mPeaks != null && this.mPeaks.size() != 0;
    }

    public void protonate() {
        ArrayList<CPeak> protonatedPeaks = new ArrayList<CPeak>(this.mPeaks.size());
        double massAcc = this.mMassAccuracyPPM / 1000000.0;
        double precursorMassAccuracy = this.mPrecursorMZ * massAcc;
        double precursorMassBound = this.mPrecursorMZ + precursorMassAccuracy;
        for (CPeak aPeak : this.mPeaks) {
            ArrayList<Double> protonatedMasses = aPeak.protonate();
            for (Double protonatedMass : protonatedMasses) {
                if (!(protonatedMass <= precursorMassBound)) continue;
                CPeak newPeak = new CPeak(this, protonatedMass, aPeak.getIntensity(), aPeak.getRawMZ(), aPeak.getCharge(), protonatedMass * (1.0 + massAcc), protonatedMass * (1.0 - massAcc));
                newPeak.addOriginalPeak(aPeak);
                protonatedPeaks.add(newPeak);
            }
        }
        this.mPeaks = protonatedPeaks;
        Collections.sort(this.mPeaks);
        this.mProtonated = true;
        ArrayList<CPeak> savedOriginalPeaks = new ArrayList<CPeak>();
        for (CPeak peak : this.mPeaks) {
            if (peak.getOriginalPeaks() == null || peak.getOriginalPeaks().isEmpty()) {
                savedOriginalPeaks.add(peak);
                if (!(Math.abs(peak.getMz() - 1330.6834) < 0.001)) continue;
                System.out.println("cpeak: " + (Object)((Object)peak));
                continue;
            }
            savedOriginalPeaks.addAll(peak.getOriginalPeaks());
            for (CPeak opeak : peak.getOriginalPeaks()) {
                if (!(Math.abs(opeak.getMz() - 1330.6834) < 0.001)) continue;
                System.out.println("cpeak: " + (Object)((Object)peak));
            }
        }
        Collections.sort(savedOriginalPeaks);
        for (CPeak peak : this.originalPeaks) {
            if (savedOriginalPeaks.contains((Object)peak)) continue;
            System.out.println("missing: " + (Object)((Object)peak));
        }
        System.out.println("end of protonate");
    }

    public void mergePeaks(double threshold) {
        int peakListSize = this.mPeaks.size();
        double[][] distances = new double[1][peakListSize * (peakListSize - 1) / 2];
        int distIdx = 0;
        int i = 0;
        while (i < peakListSize) {
            CPeak peaki = this.mPeaks.get(i);
            int j = i + 1;
            while (j < peakListSize) {
                CPeak peakj = this.mPeaks.get(j);
                distances[0][distIdx] = Math.abs(peaki.getMass() - peakj.getMass());
                ++distIdx;
                ++j;
            }
            ++i;
        }
        String[] names = new String[peakListSize];
        int i2 = 0;
        while (i2 < peakListSize) {
            names[i2] = Integer.toString(i2);
            ++i2;
        }
        List<Cluster> clusters = new PDistClusteringAlgorithm().performFlatClustering(distances, names, new SingleLinkageStrategy(), threshold);
        ArrayList<CPeak> clusteredPeaks = new ArrayList<CPeak>(clusters.size());
        ArrayList<CPeak> oriPeaks = new ArrayList<CPeak>();
        double delta = this.mPrecursorMZ * this.mMassAccuracyPPM / 1000000.0;
        for (Cluster cluster : clusters) {
            CPeak newPeak;
            List<String> leaves = cluster.getLeafNames();
            if (leaves.size() == 1) {
                int oriIdx = Integer.valueOf(leaves.get(0));
                newPeak = this.mPeaks.get(oriIdx);
            } else {
                double massIntenSum = 0.0;
                double intensitySum = 0.0;
                oriPeaks.clear();
                for (String leaf : leaves) {
                    int idx = Integer.valueOf(leaf);
                    CPeak tempPeak = this.mPeaks.get(idx);
                    intensitySum += tempPeak.getIntensity().doubleValue();
                    massIntenSum += tempPeak.getMass() * tempPeak.getIntensity();
                    if (tempPeak.isComplement()) continue;
                    oriPeaks.add(tempPeak);
                }
                double newIntensity = intensitySum;
                double newMass = massIntenSum / intensitySum;
                CPeak oriPeak = null;
                double minD = Double.MAX_VALUE;
                double d = 0.0;
                for (CPeak aPeak : oriPeaks) {
                    d = Math.abs(aPeak.getMass() - newMass);
                    if (!(d < minD)) continue;
                    oriPeak = aPeak;
                    minD = d;
                }
                if (oriPeak == null) {
                    int middleIdx = cluster.getLeafNames().size() / 2;
                    int idx = Integer.parseInt(leaves.get(middleIdx));
                    oriPeak = this.mPeaks.get(idx);
                    newPeak = new CPeak(this, newMass, newIntensity, -1.0, -1, newMass + delta, newMass - delta);
                } else {
                    newPeak = new CPeak(this, newMass, newIntensity, oriPeak.getRawMZ(), oriPeak.getRawZ(), newMass * (1.0 + this.mMassAccuracyPPM / 1000000.0), newMass * (1.0 - this.mMassAccuracyPPM / 1000000.0));
                }
                for (CPeak oripeak : oriPeaks) {
                    if (oripeak.getOriginalPeaks() != null) {
                        newPeak.addOriginalPeaks(oripeak.getOriginalPeaks());
                        continue;
                    }
                    newPeak.addOriginalPeak(oripeak);
                }
            }
            clusteredPeaks.add(newPeak);
        }
        double minD = Double.MAX_VALUE;
        double d = 0.0;
        double dThresh = this.mPrecursorMZ * this.mMassAccuracyPPM / 1000000.0;
        CPeak comPeak = null;
        for (CPeak clusteredPeak : clusteredPeaks) {
            comPeak = null;
            for (CPeak peak : clusteredPeaks) {
                if (clusteredPeak == peak || !((d = Math.abs(peak.getMass() - clusteredPeak.getMass())) < dThresh) || !(d < minD)) continue;
                minD = d;
                comPeak = peak;
            }
            if (comPeak == null) continue;
            clusteredPeak.setComplementPeak(comPeak);
        }
        Collections.sort(clusteredPeaks);
        this.mPeaks = clusteredPeaks;
        ArrayList<CPeak> savedOriginalPeaks = new ArrayList<CPeak>();
        for (CPeak peak : this.mPeaks) {
            if (peak.getOriginalPeaks() == null || peak.getOriginalPeaks().isEmpty()) {
                savedOriginalPeaks.add(peak);
                this.mOriginalPeaksMap.get(peak.getMz()).add(peak);
                continue;
            }
            savedOriginalPeaks.addAll(peak.getOriginalPeaks());
            for (CPeak oripeak : peak.getOriginalPeaks()) {
                this.mOriginalPeaksMap.get(oripeak.getMz()).add(peak);
            }
        }
        Collections.sort(savedOriginalPeaks);
        for (CPeak peak : this.originalPeaks) {
            if (savedOriginalPeaks.contains((Object)peak)) continue;
            System.out.println("missing:" + (Object)((Object)peak));
        }
        System.out.println("end of merge peaks");
    }

    private static CPeak findClosestPeak(double mass, List<CPeak> peaks, double threshold) {
        double minDiff = Double.MAX_VALUE;
        CPeak minDiffPeak = null;
        for (CPeak cPeak : peaks) {
            double diff = Math.abs(cPeak.getMass() - mass);
            if (!(diff < minDiff)) continue;
            minDiff = diff;
            minDiffPeak = cPeak;
        }
        if (minDiff <= threshold) {
            return minDiffPeak;
        }
        return null;
    }

    public void addComplementaryIons() {
        double precursorMass = this.mPrecursorMZ > 100.0 ? this.mPrecursorMZ : this.mPeaks.get(this.mPeaks.size() - 1).getMass();
        double ionMass = 1.007276432;
        double minMassThreshold = 100.0;
        boolean added = false;
        int prevSize = this.mPeaks.size();
        minMassThreshold = !this.mPermethylated ? Math.max(minMassThreshold, CMonosaccharideSet.Xyl.sacNative.mass - 18.0105646863) : Math.max(minMassThreshold, CMonosaccharideSet.Xyl.sacPermethylated.mass - 14.0156500642 - 18.0105646863);
        ArrayList<CPeak> complements = new ArrayList<CPeak>();
        double delta = this.mPrecursorMZ * this.mMassAccuracyPPM / 1000000.0;
        int i = 0;
        while (i < prevSize) {
            CPeak cPeak = this.mPeaks.get(i);
            double complementMass = precursorMass - cPeak.getMass() + ionMass;
            if (!(complementMass < minMassThreshold)) {
                CPeak complement = CSpectrum.findClosestPeak(complementMass, this.mPeaks, delta);
                if (complement == null) {
                    added = true;
                    complements.add(new CPeak(cPeak.getSpectrum(), complementMass, (double)cPeak.getIntensity(), cPeak, complementMass + delta, complementMass - delta));
                    cPeak.setComplementPeak(complement);
                } else {
                    complement.setComplementPeak(cPeak);
                    cPeak.setComplementPeak(complement);
                }
            }
            ++i;
        }
        this.mPeaks.addAll(complements);
        if (added) {
            Collections.sort(this.mPeaks);
        }
    }

    void clearInferred() {
        for (CPeak mPeak : this.mPeaks) {
            mPeak.clearInferred();
        }
    }

    public static CSpectrum specProcessing(String filePath) {
        CSpectrum spec = new CSpectrum(filePath);
        spec.protonate();
        spec.mergePeaks(0.001);
        spec.addComplementaryIons();
        return spec;
    }

    public void specProcessing() {
        this.protonate();
        this.mergePeaks(0.001);
        this.addComplementaryIons();
    }

    public String getDerivationMethod() {
        return this.mDerivationMethod;
    }

    public boolean getPermethyldated() {
        return this.mPermethylated;
    }

    public double getMassAccuracyPPM() {
        return this.mMassAccuracyPPM;
    }

    public ArrayList<CPeak> getPeaks(int complementFlag) {
        if (complementFlag == 0) {
            return this.mPeaks;
        }
        if (complementFlag == 1) {
            ArrayList<CPeak> result = new ArrayList<CPeak>();
            for (CPeak aPeak : this.mPeaks) {
                if (!aPeak.isComplement()) continue;
                result.add(aPeak);
            }
            return result;
        }
        ArrayList<CPeak> result = new ArrayList<CPeak>();
        for (CPeak aPeak : this.mPeaks) {
            if (aPeak.isComplement()) continue;
            result.add(aPeak);
        }
        return result;
    }

    public double getPrecursorMZ() {
        return this.mPrecursorMZ;
    }

    public double getPrecursorRawMZ() {
        return this.mPrecursorRawMZ;
    }

    public double getPrecursorRawZ() {
        return this.mPrecursorRawZ;
    }

    public String getReducingEndMode() {
        return this.mReducingEndMode;
    }

    public String getMetal() {
        return this.mMetal;
    }

    public boolean isNLinked() {
        return this.mNLinked;
    }

    public boolean isPermethylated() {
        return this.mPermethylated;
    }

    public boolean isProtonated() {
        return this.mProtonated;
    }

    public int indexOf(CPeak peak) {
        if (peak == null) {
            return -1;
        }
        return this.mPeaks.indexOf((Object)peak);
    }

    public CPeak getPeak(int index) {
        if (index < 0 || this.mPeaks == null) {
            return null;
        }
        int s = this.mPeaks.size();
        if (s == 0 || s >= index) {
            return null;
        }
        return this.mPeaks.get(index);
    }

    public int size() {
        if (this.mPeaks == null) {
            return 0;
        }
        return this.mPeaks.size();
    }

    public void updatePeakIDs() {
        if (this.mPeaks != null) {
            int k = 0;
            while (k < this.mPeaks.size()) {
                this.mPeaks.get((int)k).mID = k;
                ++k;
            }
        }
    }

    public String getFilename() {
        return this.mFilename;
    }

    public void outputTXT(String resultFilename, boolean check2H, boolean checkGap) {
        PrintStream ps = null;
        try {
            ps = new PrintStream(resultFilename);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        ps.println("# " + this.mComment);
        ps.println("# Check -2H = " + check2H);
        ps.println("# Allow gap = " + checkGap);
        ps.println();
        int k = 0;
        while (k < this.mPeaks.size()) {
            CPeak peak = this.mPeaks.get(k);
            if (peak.getInferredFormulas() != null) {
                if (peak.getComplementPeak() != null) {
                    ps.println("@ Peak " + k + " (~ " + (this.mPeaks.indexOf((Object)peak.getComplementPeak()) + 1) + ")" + ": mass " + peak.getMass() + ", intensity " + peak.getIntensity());
                } else {
                    ps.println("@ Peak " + k + ": mass " + peak.getMass() + ", intensity " + peak.getIntensity());
                }
                for (CTopologySuperSet inferredSuperSet : peak.getInferredSuperSets()) {
                    String type;
                    if (inferredSuperSet.mTargetPeaks.get(k) == null) continue;
                    int t = inferredSuperSet.mTargetPeaks.get(k);
                    switch (t % 10) {
                        case 1: {
                            type = "B";
                            break;
                        }
                        case 2: {
                            type = "C";
                            break;
                        }
                        default: {
                            type = "T";
                        }
                    }
                    if (t > 10) {
                        type = String.valueOf(type) + "-2H";
                    }
                    for (CTopology topology : inferredSuperSet.mTopologies) {
                        ps.print("** " + type + ": " + topology.mFormula + " " + "[Peaks (" + topology.mSupportPeaks.size() + ", " + topology.mScore + "):");
                        for (CPeak supportPeak : topology.mSupportPeaks) {
                            ps.print(" " + (this.mPeaks.indexOf((Object)supportPeak) + 1));
                        }
                        ps.println("]");
                    }
                }
                ps.println();
            }
            ++k;
        }
        ps.close();
        System.out.println(String.valueOf(resultFilename) + " saved!");
    }

    public void outputGWA(String resFolder) {
        String gwaFilename = "rec." + this.mFilename + ".gwa";
        try {
            Document gwa = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = gwa.createElement("AnnotatedPeakList");
            gwa.appendChild(root);
            Element annos = gwa.createElement("Annotations");
            root.appendChild(annos);
            Element glycan = gwa.createElement("Glycan");
            glycan.setAttribute("structure", "");
            annos.appendChild(glycan);
            Element pac = gwa.createElement("PeakAnnotationCollection");
            annos.appendChild(pac);
            for (CPeak peak : this.mPeaks) {
                if (peak.getInferredFormulas() == null) continue;
                int i = 0;
                while (i < peak.getInferredFormulas().size()) {
                    Element currPa = gwa.createElement("PeakAnnotation");
                    pac.appendChild(currPa);
                    Element currP = gwa.createElement("Peak");
                    currPa.appendChild(currP);
                    currP.setAttribute("mz_ratio", String.valueOf(peak.getMass()));
                    currP.setAttribute("intensity", String.valueOf(peak.getIntensity()));
                    Element currA = gwa.createElement("Annotation");
                    currPa.appendChild(currA);
                    Element currFrag = gwa.createElement("FragmentEntry");
                    currA.appendChild(currFrag);
                    currFrag.setAttribute("fragment", peak.getInferredFormulas().get(i));
                    currFrag.setAttribute("mass", String.valueOf(peak.getInferredMasses().get(i)));
                    currFrag.setAttribute("mz_ratio", String.valueOf(peak.getInferredMasses().get(i)));
                    currFrag.setAttribute("name", "");
                    currFrag.setAttribute("score", String.valueOf(peak.getInferredScores().get(i)));
                    ++i;
                }
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(gwa), new StreamResult(new File(String.valueOf(resFolder) + gwaFilename)));
            System.out.println(String.valueOf(gwaFilename) + " saved!");
        }
        catch (ParserConfigurationException | TransformerException e) {
            e.printStackTrace();
        }
    }

    public void printmPeaks(String savePath) throws Exception {
        File file;
        if (savePath.charAt(savePath.length() - 1) != '\\') {
            savePath = String.valueOf(savePath) + '\\';
        }
        if (!(file = new File(savePath = String.valueOf(savePath) + "save\\peak.txt")).exists()) {
            file.createNewFile();
        }
        FileWriter filewriter = new FileWriter(file);
        int i = 0;
        while (i < this.mPeaks.size()) {
            CPeak currPeak = this.mPeaks.get(i);
            filewriter.write("Peak: " + i + " complement " + this.mPeaks.indexOf((Object)currPeak.getComplementPeak()) + " mass " + currPeak.getMass() + " type: ");
            for (CTopologySuperSet TSS : currPeak.getInferredSuperSets()) {
                filewriter.write(String.valueOf(TSS.mType) + " ");
            }
            filewriter.write("\n");
            ++i;
        }
        filewriter.close();
    }

    public ArrayList<CPeak> getOriginalPeaks() {
        return this.originalPeaks;
    }

    public HashMap<Double, HashSet<CPeak>> getOriginalPeaksMap() {
        return this.mOriginalPeaksMap;
    }

    public static void main(String[] args) {
        ArrayList<CSpectrum> speca = new ArrayList<CSpectrum>();
        CSpectrum spec = new CSpectrum("C:\\Users\\nxy\\Desktop\\Brandeis\\arff\\arff\\HighMan_PGC.Man5_Peak3.txt");
        speca.add(spec);
        CGlycoDeNovo glyco = new CGlycoDeNovo(5.0);
        for (CSpectrum spectrum : speca) {
            spectrum.protonate();
            spectrum.mergePeaks(0.001);
            spectrum.addComplementaryIons();
            glyco.interpretPeaks(spectrum);
            glyco.reconstructFormulas();
        }
        CPeak test = spec.mPeaks.get(3);
        System.out.println((Object)test.getComplementPeak());
        System.out.println(spec.getPrecursorMZ());
    }
}

