/*
 * Decompiled with CFR 0.152.
 */
package edu.brandeis.glycodenovo.core;

import edu.brandeis.glycodenovo.core.CGlycoDeNovo;
import edu.brandeis.glycodenovo.core.CPeak;
import edu.brandeis.glycodenovo.core.CSpectrum;
import edu.brandeis.glycodenovo.core.CTopology;
import edu.brandeis.glycodenovo.core.CTopologySuperSet;
import edu.brandeis.glycodenovo.core.DataSignals;
import edu.brandeis.glycodenovo.core.DataVectors;
import edu.brandeis.glycodenovo.core.DefaultClassifier;
import edu.brandeis.glycodenovo.core.IonScoreMap;
import edu.brandeis.glycodenovo.core.MyClassifier;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;

public class CIonclassifier {
    public static final double massAccuracyPPM = 5.0;
    public static final double mergePeaksTreshold = 0.001;
    static ArrayList<Double> mMassFeatures = new ArrayList();
    static HashMap<String, MyClassifier> mMyClassifier = new HashMap();
    public static ArrayList<Double> mMassBound = new ArrayList();
    public static boolean mUseOriginalPeaks = false;
    public static boolean mEnableX15 = false;
    public static double mMassAccuracy = 0.005;
    public static double mKeep_percentage = 0.9;
    public static final String mClassifierPath = "C:\\Users\\nxy\\Desktop\\Brandeis\\arff\\arff";
    public static final String mMassfeaturesPath = "C:\\Users\\nxy\\Desktop\\Brandeis\\arff\\arff";
    public static boolean saveRandomForestScore = false;
    public static final String randomForestScorePath = "C:\\Users\\nxy\\Desktop\\Brandeis\\arff\\arff\\save\\CTreescore.txt";
    public static boolean saveIonScoreMap = false;
    public static final String ionScoreMapPath = "C:\\Users\\nxy\\Desktop\\Brandeis\\arff\\arff\\save";

    public CIonclassifier(String workpath) {
        mMassFeatures = new ArrayList();
        mMyClassifier = new HashMap();
        mMassBound = new ArrayList();
        saveRandomForestScore = false;
        saveIonScoreMap = false;
        try {
            DefaultClassifier.generateDefaultClassifier(workpath);
            CIonclassifier.setMyClassifier(workpath);
            CIonclassifier.setMassFeatures(workpath);
        }
        catch (Exception exception) {
            System.out.println("Model file missing");
        }
    }

    public CIonclassifier(String classifierPath, String massFeaturePath) throws Exception {
        mMassFeatures = new ArrayList();
        mMyClassifier = new HashMap();
        mMassBound = new ArrayList();
        CIonclassifier.setMyClassifier(classifierPath);
        CIonclassifier.setMassFeatures(massFeaturePath);
    }

    public static List<Object> extract_data(ArrayList<CSpectrum> spectra, ArrayList<Double> massFeatures, ArrayList<Double> massBound, double massAccuracy, boolean useOriginalPeak, boolean includeREM) {
        HashSet<String> allREM = new HashSet<String>();
        allREM.add("");
        allREM.add("O18");
        allREM.add("Deuterium");
        allREM.add("Reduced");
        allREM.add("Aminopyridine");
        allREM.add("PRAGS");
        DataSignals dataSignals = new DataSignals();
        if (massBound == null || massBound.isEmpty()) {
            massBound = new ArrayList();
            massBound.add(1.51173754815);
            massBound.add(105.0);
        }
        int s = 0;
        while (s < spectra.size()) {
            CSpectrum specU = spectra.get(s);
            ArrayList<CPeak> peaklist = specU.getPeakList();
            if (!peaklist.get(peaklist.size() - 1).getInferredSuperSets().isEmpty()) {
                boolean hasRequestREM = allREM.contains(specU.getReducingEndMode());
                ArrayList<Double> peakMasses = new ArrayList<Double>();
                ArrayList<Boolean> peakComplements = new ArrayList<Boolean>();
                ArrayList<Boolean> peakAvailable = new ArrayList<Boolean>(peaklist.size());
                int p = 0;
                while (p < peaklist.size()) {
                    peakAvailable.add(false);
                    ++p;
                }
                for (CPeak peak : peaklist) {
                    peakMasses.add(peak.getMass());
                    peakComplements.add(peak.getComplementPeak() == null);
                }
                p = 0;
                while (p < peaklist.size() - 1) {
                    if (peaklist.get(p).getInferredFormulas() != null && !peaklist.get(p).getInferredFormulas().isEmpty()) {
                        peakAvailable.set(p, true);
                        if (useOriginalPeak && peaklist.get(p).getComplementPeak() == null) {
                            peakAvailable.set(p, false);
                            for (CPeak oriPeak : peaklist.get(p).getOriginalPeaks()) {
                                int index = peaklist.indexOf((Object)oriPeak);
                                peakAvailable.set(index, true);
                            }
                        }
                    }
                    ++p;
                }
                ArrayList<Integer> peakAvailableIDs = new ArrayList<Integer>();
                int i = 0;
                while (i < peakAvailable.size()) {
                    if (((Boolean)peakAvailable.get(i)).booleanValue()) {
                        peakAvailableIDs.add(i);
                    }
                    ++i;
                }
                ArrayList<Object> peakIntensities = CIonclassifier.standardize_intensity(peaklist, "log", peakAvailableIDs);
                int k = 0;
                while (k < peaklist.size()) {
                    if (peaklist.get(k).getInferredFormulas() != null && !peaklist.get(k).getInferredFormulas().isEmpty()) {
                        for (CTopologySuperSet TSS : peaklist.get(k).getInferredSuperSets()) {
                            if (TSS.mTopologies.isEmpty()) continue;
                            HashMap mTargetPeaks = (HashMap)TSS.mTargetPeaks;
                            double pMass = (Double)peakMasses.get(k);
                            int type = (Integer)mTargetPeaks.get(k);
                            char iontype = 'B';
                            switch (type) {
                                case 1: {
                                    iontype = 'B';
                                    break;
                                }
                                case 2: {
                                    iontype = 'C';
                                }
                            }
                            ArrayList<Double> temp = new ArrayList<Double>();
                            Iterator iterator = peakMasses.iterator();
                            while (iterator.hasNext()) {
                                double peakMass = (Double)iterator.next();
                                temp.add(Math.abs(peakMass - pMass));
                            }
                            ArrayList<Integer> idx = new ArrayList<Integer>();
                            int i2 = 0;
                            while (i2 < temp.size()) {
                                if ((Double)temp.get(i2) < massBound.get(1) && (Double)temp.get(i2) > massBound.get(0) && i2 != k) {
                                    idx.add(i2);
                                }
                                ++i2;
                            }
                            ArrayList<Double> c1 = new ArrayList<Double>();
                            ArrayList<Double> c2 = new ArrayList<Double>();
                            ArrayList<Double> c3 = new ArrayList<Double>();
                            Iterator iterator2 = idx.iterator();
                            while (iterator2.hasNext()) {
                                int i3 = (Integer)iterator2.next();
                                c1.add((Double)peakMasses.get(i3) - pMass);
                                c2.add((Double)((ArrayList)peakIntensities.get(0)).get(i3));
                                c3.add((Boolean)peakComplements.get(i3) != false ? 1.0 : 0.0);
                            }
                            ArrayList<ArrayList<Double>> context = new ArrayList<ArrayList<Double>>();
                            context.add(c1);
                            context.add(c2);
                            context.add(c3);
                            dataSignals.addlast(Character.valueOf(iontype), pMass, k, peaklist.get(k).getComplementPeak(), (Double)((ArrayList)peakIntensities.get(0)).get(k), context, s, specU.getPrecursorMZ(), hasRequestREM, specU);
                        }
                    }
                    ++k;
                }
            }
            ++s;
        }
        DataVectors testVectors = new DataVectors();
        int numFeatures = massFeatures.size();
        char[] cArray = "BC".toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char iontype = cArray[n2];
            int num = dataSignals.get(Character.valueOf(iontype)).size();
            testVectors.setDataVectors(Character.valueOf(iontype), num, numFeatures);
            int k = 0;
            while (k < num) {
                ArrayList<Double> dataVector = testVectors.getVector(iontype, k);
                dataVector.set(numFeatures * 2, dataSignals.getMass(iontype, k));
                dataVector.set(numFeatures * 2 + 1, dataSignals.getGlycanMass(iontype, k));
                dataVector.set(numFeatures * 2 + 2, (double)(dataSignals.getREM(iontype, k) ? 1 : 0));
                int m = 0;
                while (m < dataSignals.getContext(iontype, k).get(0).size()) {
                    double[] ans = CIonclassifier.min(massFeatures, dataSignals.getContext(iontype, k).get(0).get(m));
                    double d = ans[0];
                    double idx = ans[1];
                    if (d < massAccuracy + 0.001) {
                        testVectors.getVector(iontype, k).set((int)idx, 1.0);
                        testVectors.getVector(iontype, k).set((int)idx + numFeatures, dataSignals.getContext(iontype, k).get(1).get(m));
                    }
                    ++m;
                }
                ++k;
            }
            if (!includeREM) {
                ArrayList<ArrayList<Double>> map = testVectors.getMap(iontype);
                for (ArrayList<Double> vector : map) {
                    vector.remove(vector.size() - 1);
                }
            }
            ++n2;
        }
        testVectors.setMassFeatures(massFeatures);
        ArrayList<Object> ans = new ArrayList<Object>();
        ans.add(testVectors);
        ans.add(dataSignals);
        return ans;
    }

    private static double[] min(ArrayList<Double> massFeatures, Double contextM) {
        double d = 2.147483647E9;
        double idx = 0.0;
        double i = 0.0;
        for (double massFeature : massFeatures) {
            double n = Math.abs(massFeature - contextM);
            if (n < d) {
                d = n;
                idx = i;
            }
            i += 1.0;
        }
        double[] ans = new double[]{d, idx};
        return ans;
    }

    private double min(double[] array) {
        double ans = 2.147483647E9;
        double[] dArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            double i = dArray[n2];
            ans = ans > i ? i : ans;
            ++n2;
        }
        return ans;
    }

    public IonScoreMap predict_ions(DataVectors testVectors, DataSignals testData) throws Exception {
        String vs_O;
        String vs_Z;
        String vs_Y;
        String vs_BC;
        ArrayList<Integer> idxX15_B = new ArrayList<Integer>();
        ArrayList<Integer> idxX15_C = new ArrayList<Integer>();
        IonScoreMap ionScoreMap = new IonScoreMap();
        int i = 0;
        while (i < mMassFeatures.size()) {
            if (Math.abs(mMassFeatures.get(i) - -27.9949) < 0.005) {
                idxX15_B.add(i);
            }
            if (Math.abs(mMassFeatures.get(i) - -46.0054646863) < 0.005) {
                idxX15_C.add(i);
            }
            ++i;
        }
        char[] cArray = "BC".toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ion = cArray[n2];
            vs_BC = ion == 'B' ? "B_v_C" : "C_v_B";
            vs_Y = String.valueOf(ion) + "_v_Y";
            vs_Z = String.valueOf(ion) + "_v_Z";
            vs_O = String.valueOf(ion) + "_v_O";
            int k = 0;
            while (k < testData.get(Character.valueOf(ion)).size()) {
                int key = testData.getSpectrumID(ion, k) * 10000 + testData.getPeakID(ion, k);
                double[] ws = new double[]{0.0, 0.0, 0.0, 0.0};
                double[] b = mMyClassifier.get(vs_BC).getScore(testVectors.getVector(ion, k));
                ws[0] = b[1];
                b = mMyClassifier.get(vs_Y).getScore(testVectors.getVector(ion, k));
                ws[1] = b[1];
                b = mMyClassifier.get(vs_Z).getScore(testVectors.getVector(ion, k));
                ws[2] = b[1];
                b = mMyClassifier.get(vs_O).getScore(testVectors.getVector(ion, k));
                ws[3] = b[1];
                ionScoreMap.setScore(ion, key, this.min(ws));
                if (mEnableX15) {
                    int i2;
                    Iterator iterator;
                    if (ion == 'B') {
                        iterator = idxX15_B.iterator();
                        while (iterator.hasNext()) {
                            i2 = (Integer)iterator.next();
                            if (testVectors.getVector(ion, k).get(i2) == 0.0) continue;
                            ionScoreMap.setScore(ion, key, ionScoreMap.getScore(ion, key) + 5.0);
                            break;
                        }
                    } else if (ion == 'C') {
                        iterator = idxX15_C.iterator();
                        while (iterator.hasNext()) {
                            i2 = (Integer)iterator.next();
                            if (testVectors.getVector(ion, k).get(i2) == 0.0) continue;
                            ionScoreMap.setScore(ion, key, ionScoreMap.getScore(ion, key) + 5.0);
                            break;
                        }
                    }
                }
                ++k;
            }
            ++n2;
        }
        if (saveRandomForestScore) {
            File filer = new File(randomForestScorePath);
            FileWriter filewriter = new FileWriter(filer);
            char[] cArray2 = "BC".toCharArray();
            int n3 = cArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                char ion = cArray2[n4];
                vs_BC = ion == 'B' ? "B_v_C" : "C_v_B";
                vs_Y = String.valueOf(ion) + "_v_Y";
                vs_Z = String.valueOf(ion) + "_v_Z";
                vs_O = String.valueOf(ion) + "_v_O";
                int k = 0;
                while (k < testData.get(Character.valueOf(ion)).size()) {
                    int key = testData.getSpectrumID(ion, k) * 10000 + testData.getPeakID(ion, k);
                    double[] ws = new double[]{0.0, 0.0, 0.0, 0.0};
                    int m = 0;
                    while (m < 100) {
                        double[] b = mMyClassifier.get(vs_BC).getTree(m).getScore(testVectors.getVector(ion, k));
                        ws[0] = b[1];
                        b = mMyClassifier.get(vs_Y).getTree(m).getScore(testVectors.getVector(ion, k));
                        ws[1] = b[1];
                        b = mMyClassifier.get(vs_Z).getTree(m).getScore(testVectors.getVector(ion, k));
                        ws[2] = b[1];
                        b = mMyClassifier.get(vs_O).getTree(m).getScore(testVectors.getVector(ion, k));
                        ws[3] = b[1];
                        filewriter.write("model: " + m + " ion: " + ion + " k: " + k + " key: " + key + "\n");
                        filewriter.write(String.valueOf(vs_BC) + ":\n");
                        filewriter.write("ws: " + ws[0] + "\n");
                        filewriter.write("vector value: " + testVectors.getVector(ion, k).get(mMyClassifier.get(vs_BC).getTree(m).rootCutVar()) + "\n");
                        mMyClassifier.get(vs_BC).getTree(m).printTree(filewriter);
                        filewriter.write(String.valueOf(vs_Y) + ":\n");
                        filewriter.write("ws: " + ws[1] + "\n");
                        filewriter.write("vector value: " + testVectors.getVector(ion, k).get(mMyClassifier.get(vs_Y).getTree(m).rootCutVar()) + "\n");
                        mMyClassifier.get(vs_Y).getTree(m).printTree(filewriter);
                        filewriter.write(String.valueOf(vs_Z) + ":\n");
                        filewriter.write("ws: " + ws[2] + "\n");
                        filewriter.write("vector value: " + testVectors.getVector(ion, k).get(mMyClassifier.get(vs_Z).getTree(m).rootCutVar()) + "\n");
                        mMyClassifier.get(vs_Z).getTree(m).printTree(filewriter);
                        filewriter.write(String.valueOf(vs_O) + ":\n");
                        filewriter.write("ws: " + ws[3] + "\n");
                        filewriter.write("vector value: " + testVectors.getVector(ion, k).get(mMyClassifier.get(vs_O).getTree(m).rootCutVar()) + "\n");
                        mMyClassifier.get(vs_O).getTree(m).printTree(filewriter);
                        filewriter.write("score: " + this.min(ws) + "\n");
                        ++m;
                    }
                    if (mEnableX15) {
                        int i3;
                        Iterator iterator;
                        if (ion == 'B') {
                            iterator = idxX15_B.iterator();
                            while (iterator.hasNext()) {
                                i3 = (Integer)iterator.next();
                                if (testVectors.getVector(ion, k).get(i3) == 0.0) continue;
                                ionScoreMap.setScore(ion, key, ionScoreMap.getScore(ion, key) + 5.0);
                                break;
                            }
                        } else if (ion == 'C') {
                            iterator = idxX15_C.iterator();
                            while (iterator.hasNext()) {
                                i3 = (Integer)iterator.next();
                                if (testVectors.getVector(ion, k).get(i3) == 0.0) continue;
                                ionScoreMap.setScore(ion, key, ionScoreMap.getScore(ion, key) + 5.0);
                                break;
                            }
                        }
                    }
                    ++k;
                }
                ++n4;
            }
            filewriter.close();
        }
        return ionScoreMap;
    }

    public ArrayList<ArrayList<ArrayList<ArrayList<Double>>>> rank_candidates(ArrayList<CSpectrum> spectra) throws Exception {
        Object object;
        CTopology tp;
        ArrayList<CPeak> peaklist;
        ArrayList output = (ArrayList)CIonclassifier.extract_data(spectra, mMassFeatures, null, mMassAccuracy, mUseOriginalPeaks, false);
        DataVectors vectors = (DataVectors)output.get(0);
        DataSignals signals = (DataSignals)output.get(1);
        IonScoreMap ionScoreMap = this.predict_ions(vectors, signals);
        ArrayList<ArrayList<ArrayList<ArrayList<Double>>>> aaaalist = new ArrayList<ArrayList<ArrayList<ArrayList<Double>>>>();
        int s = 0;
        while (s < spectra.size()) {
            peaklist = spectra.get(s).getPeakList();
            for (CPeak currpeak : peaklist) {
                if (currpeak.getInferredSuperSets() == null || currpeak.getInferredSuperSets().isEmpty()) continue;
                for (CTopologySuperSet TSS : currpeak.getInferredSuperSets()) {
                    int t = 0;
                    while (t < TSS.mTopologies.size()) {
                        tp = (CTopology)TSS.mTopologies.get(t);
                        tp.sortSupportPeaks();
                        int len = tp.mSupportPeaks.size();
                        double[] weights = new double[len - 1];
                        int m = -1;
                        for (CPeak peak : tp.getSupportPeaks()) {
                            if (++m == tp.getSupportPeaks().size() - 1) break;
                            double peakID = peaklist.indexOf((Object)peak);
                            double type = 0.0;
                            for (CTopologySuperSet peakTSS : peak.getInferredSuperSets()) {
                                ArrayList<Double> doubleScore;
                                ArrayList<Integer> score;
                                if (peakTSS.mTopologies.isEmpty()) continue;
                                type = peakTSS.mTargetPeaks.get((int)peakID).intValue();
                                int key = s * 10000 + (int)peakID;
                                if (type == 1.0 || type == -1.0) {
                                    weights[m] = ionScoreMap.getScore('B', key);
                                    score = new ArrayList<Integer>();
                                    doubleScore = new ArrayList<Double>();
                                    score.add(0);
                                    score.add(0);
                                    doubleScore.add(0.0);
                                    doubleScore.add(0.0);
                                    score.set(0, (int)weights[m]);
                                    doubleScore.set(0, weights[m]);
                                    peak.setInferredScores(score);
                                    peak.setInferredDoubleScores(doubleScore);
                                    continue;
                                }
                                if (type != 2.0 && type != -2.0) continue;
                                weights[m] = ionScoreMap.getScore('C', key);
                                score = new ArrayList();
                                doubleScore = new ArrayList();
                                score.add(0);
                                score.add(0);
                                doubleScore.add(0.0);
                                doubleScore.add(0.0);
                                score.set(1, (int)weights[m]);
                                doubleScore.set(1, weights[m]);
                                peak.setInferredScores(score);
                                peak.setInferredDoubleScores(doubleScore);
                            }
                        }
                        double sum = 0.0;
                        object = weights;
                        int n = weights.length;
                        int n2 = 0;
                        while (n2 < n) {
                            double i = object[n2];
                            sum += i;
                            ++n2;
                        }
                        tp.mScore = sum;
                        ++t;
                    }
                    Collections.sort(TSS.mTopologies, new Comparator<CTopology>(){

                        @Override
                        public int compare(CTopology t1, CTopology t2) {
                            double dscore = t1.mScore - t2.mScore;
                            return (int)(-Math.signum(dscore));
                        }
                    });
                }
                Collections.sort(currpeak.getInferredTopologies(), new Comparator<CTopology>(){

                    @Override
                    public int compare(CTopology t1, CTopology t2) {
                        double dscore = t1.mScore - t2.mScore;
                        return (int)(-Math.signum(dscore));
                    }
                });
            }
            ++s;
        }
        s = 0;
        while (s < spectra.size()) {
            peaklist = spectra.get(s).getPeakList();
            ArrayList aaalist = new ArrayList();
            if (!peaklist.get(peaklist.size() - 1).getInferredSuperSets().isEmpty()) {
                for (CTopologySuperSet TSS : peaklist.get(peaklist.size() - 1).getInferredSuperSets()) {
                    int t = 0;
                    while (t < TSS.mTopologies.size()) {
                        ArrayList aalist = new ArrayList();
                        tp = (CTopology)TSS.mTopologies.get(t);
                        int m = -1;
                        for (CPeak peak : tp.getSupportPeaks()) {
                            ArrayList<Double> alist = new ArrayList<Double>();
                            if (++m == tp.getSupportPeaks().size() - 1) break;
                            double peakID = peaklist.indexOf((Object)peak);
                            alist.add(peakID);
                            double type = 0.0;
                            object = peak.getInferredSuperSets().iterator();
                            while (object.hasNext()) {
                                CTopologySuperSet peakTSS = (CTopologySuperSet)object.next();
                                if (peakTSS.mTopologies.isEmpty()) continue;
                                type = peakTSS.mTargetPeaks.get((int)peakID).intValue();
                                alist.add(Double.valueOf(peaklist.indexOf((Object)peak.getComplementPeak())));
                                alist.add(type);
                                if (type == 1.0 || type == -1.0) {
                                    alist.add(peak.getInferredDoubleScores().get(0));
                                } else if (type == 2.0 || type == -2.0) {
                                    alist.add(peak.getInferredDoubleScores().get(1));
                                }
                                aalist.add(alist);
                            }
                        }
                        aaalist.add(aalist);
                        ++t;
                    }
                }
                aaaalist.add(aaalist);
            }
            ++s;
        }
        return aaaalist;
    }

    public static ArrayList<Object> standardize_intensity(ArrayList<CPeak> peaks, String transform, ArrayList<Integer> peakIDs) {
        double s;
        double m;
        ArrayList sub;
        ArrayList<Double> intensities = new ArrayList<Double>();
        for (CPeak peak : peaks) {
            intensities.add(peak.getIntensity());
        }
        if (transform.equals("log")) {
            int i = 0;
            while (i < intensities.size()) {
                intensities.set(i, Math.log((Double)intensities.get(i)));
                ++i;
            }
        } else if (transform.equals("sqrt")) {
            int i = 0;
            while (i < intensities.size()) {
                intensities.set(i, Math.sqrt((Double)intensities.get(i)));
                ++i;
            }
        }
        ArrayList<Double> zscores = new ArrayList<Double>();
        if (peakIDs.isEmpty()) {
            sub = (ArrayList)intensities.subList(1, intensities.size() - 1);
            double[] ans = CIonclassifier.robust_mean_std(sub);
            m = ans[0];
            s = ans[1];
            for (Double intensity : intensities) {
                zscores.add((intensity - m) / s);
            }
        } else {
            sub = new ArrayList();
            int i = 0;
            while (i < peakIDs.size()) {
                sub.add((Double)intensities.get(peakIDs.get(i)));
                ++i;
            }
            double[] ans = CIonclassifier.robust_mean_std(sub);
            m = ans[0];
            s = ans[1];
            for (Double intensity : intensities) {
                zscores.add((intensity - m) / s);
            }
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(zscores);
        list.add(intensities);
        list.add(m);
        list.add(s);
        return list;
    }

    private static double mean(ArrayList<Double> data) {
        double sum = 0.0;
        for (Double sample : data) {
            sum += sample.doubleValue();
        }
        return sum / (double)data.size();
    }

    private static double std(ArrayList<Double> data) {
        if (data.size() == 1) {
            return 0.0;
        }
        double square = 0.0;
        double avg = CIonclassifier.mean(data);
        for (Double sample : data) {
            square += (sample - avg) * (sample - avg);
        }
        return Math.sqrt(square / (double)(data.size() - 1));
    }

    private static double median(ArrayList<Double> data) {
        Collections.sort(data);
        if (data.size() % 2 == 1) {
            return data.get(data.size() / 2);
        }
        return (data.get(data.size() / 2) + data.get(data.size() / 2 - 1)) / 2.0;
    }

    private static double[] robust_mean_std(ArrayList<Double> data) {
        double keep_percentage = mKeep_percentage;
        int num = data.size();
        double m = CIonclassifier.median(data);
        ArrayList<Double> squareerr = new ArrayList<Double>();
        for (Double x : data) {
            squareerr.add((x - m) * (x - m));
        }
        double s = Math.sqrt(CIonclassifier.median(squareerr));
        double preM = m - 10000.0;
        double preS = s - 10000.0;
        ArrayList<Double> preSubSet = new ArrayList<Double>(data);
        while (Math.abs(preM - m) > Math.abs(preM * 0.01) || Math.abs(preS - s) > preS * 0.01) {
            ArrayList<Double> subSet = new ArrayList<Double>();
            for (Double x : preSubSet) {
                if (!(Math.abs(x - m) <= 3.0 * s)) continue;
                subSet.add(x);
            }
            if ((double)subSet.size() <= (double)num * keep_percentage) break;
            preM = m;
            preS = s;
            m = CIonclassifier.median(subSet);
            ArrayList<Double> y = new ArrayList<Double>();
            for (Double x : subSet) {
                y.add((x - m) * (x - m));
            }
            s = Math.sqrt(CIonclassifier.median(y));
            preSubSet = subSet;
        }
        double[] ans = new double[]{CIonclassifier.mean(preSubSet), CIonclassifier.std(preSubSet)};
        return ans;
    }

    public static void setMyClassifier(String rootpath) throws Exception {
        if (rootpath.charAt(rootpath.length() - 1) != '\\') {
            rootpath = String.valueOf(rootpath) + '\\';
        }
        char[] posSet = new char[]{'B', 'B', 'B', 'B', 'C', 'C', 'C', 'C'};
        char[] negSet = new char[]{'C', 'Y', 'Z', 'O', 'B', 'Y', 'Z', 'O'};
        int i = 0;
        while (i < 8) {
            char pos = posSet[i];
            char neg = negSet[i];
            mMyClassifier.put(String.valueOf(pos) + "_v_" + neg, new MyClassifier(rootpath, pos, neg));
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void setMassFeatures(String filename) throws Exception {
        if (filename.charAt(filename.length() - 1) != '\\') {
            filename = String.valueOf(filename) + '\\';
        }
        filename = String.valueOf(filename) + "ionclassifier_massfeatures.txt";
        sc = null;
        specFile = new File(filename);
        try {
            sc = new Scanner(specFile);
            if (true) ** GOTO lbl15
        }
        catch (FileNotFoundException v0) {
            throw new IllegalArgumentException("No such file");
        }
        do {
            value = sc.nextDouble();
            CIonclassifier.mMassFeatures.add(value);
lbl15:
            // 2 sources

        } while (sc.hasNextDouble());
    }

    public static void saveIonScoreMap(String rootpath, ArrayList<CSpectrum> speca, ArrayList<ArrayList<ArrayList<ArrayList<Double>>>> result) throws Exception {
        if (rootpath.charAt(rootpath.length() - 1) != '\\') {
            rootpath = String.valueOf(rootpath) + '\\';
        }
        rootpath = String.valueOf(rootpath) + "scoremap_";
        int i = 0;
        while (i < result.size()) {
            String scoreMapPath = String.valueOf(rootpath) + speca.get(i).getFilename() + ".txt";
            File file = new File(scoreMapPath);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileWriter filewriter = new FileWriter(file);
            int j = 0;
            while (j < result.get(i).size()) {
                int k = 0;
                while (k < result.get(i).get(j).size()) {
                    int l = 0;
                    while (l < 4) {
                        filewriter.write(result.get(i).get(j).get(k).get(l) + " ");
                        ++l;
                    }
                    filewriter.write("\n");
                    ++k;
                }
                ArrayList<CPeak> peaklist = speca.get(i).getPeakList();
                CTopologySuperSet TSS = peaklist.get(peaklist.size() - 1).getInferredSuperSets().get(0);
                int p = 0;
                int m = TSS.mTopologies.size();
                int y = 0;
                while (j + 1 > m) {
                    y = m;
                    TSS = peaklist.get(peaklist.size() - 1).getInferredSuperSets().get(++p);
                    m += TSS.mTopologies.size();
                }
                CTopology tp = (CTopology)TSS.mTopologies.get(j - y);
                filewriter.write("topology score: " + tp.mScore + "\n");
                filewriter.write("topology formula: " + tp.getFormula() + "\n");
                filewriter.write("\n");
                ++j;
            }
            filewriter.close();
            ++i;
        }
    }

    public static void reconstructSpectrum(ArrayList<CSpectrum> speca, CGlycoDeNovo glyco) {
        for (CSpectrum spectrum : speca) {
            spectrum.protonate();
            spectrum.mergePeaks(0.001);
            spectrum.addComplementaryIons();
            glyco.interpretPeaks(spectrum);
            glyco.reconstructFormulas();
        }
    }

    public static void main(String[] args) throws Exception {
        CIonclassifier c = new CIonclassifier("C:\\Users\\nxy\\Desktop\\Brandeis\\arff\\arff", "C:\\Users\\nxy\\Desktop\\Brandeis\\arff\\arff");
        ArrayList<CSpectrum> speca = new ArrayList<CSpectrum>();
        CSpectrum spec = new CSpectrum("C:\\Users\\nxy\\Desktop\\Brandeis\\arff\\arff\\A2S2.txt");
        speca.add(spec);
        CGlycoDeNovo glyco = new CGlycoDeNovo(5.0);
        CIonclassifier.reconstructSpectrum(speca, glyco);
        ArrayList<ArrayList<ArrayList<ArrayList<Double>>>> result = c.rank_candidates(speca);
        if (saveIonScoreMap) {
            CIonclassifier.saveIonScoreMap(ionScoreMapPath, speca, result);
        }
    }
}

