/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.jrap.grits.stax;

import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.systemsbiology.jrap.grits.stax.Base64;
import org.systemsbiology.jrap.grits.stax.Scan;
import org.systemsbiology.jrap.grits.stax.ScanHeader;

public class ScanAndHeaderParser {
    public ScanHeader tmpScanHeader;
    public Scan tmpScan;
    FileInputStream fileIN = null;
    boolean isScan = false;

    public void setIsScan(boolean isScan) {
        this.isScan = isScan;
    }

    public void setFileInputStream(FileInputStream in) {
        try {
            this.fileIN = in;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ScanHeader getHeader() {
        return this.tmpScanHeader;
    }

    public Scan getScan() {
        return this.tmpScan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseScanAndHeader() {
        XMLStreamReader xmlSR = null;
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            xmlSR = inputFactory.createXMLStreamReader(this.fileIN, "ISO-8859-1");
            this.parseScanAndHeader(xmlSR);
        }
        catch (Exception e) {
            String exception1 = e.getMessage();
            if (!exception1.equals("ScanHeaderEndFoundException") && !exception1.equals("ScanEndFoundException")) {
                e.printStackTrace();
            }
        }
        finally {
            if (xmlSR != null) {
                try {
                    xmlSR.close();
                }
                catch (XMLStreamException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void parseScanAndHeader(XMLStreamReader xmlSR) throws XMLStreamException {
        boolean inPrecursorMZ = false;
        boolean inPeaks = false;
        String elementName = null;
        Object attriName = null;
        Object attriValue = null;
        StringBuffer precursorBuffer = null;
        StringBuffer peaksBuffer = null;
        while (xmlSR.hasNext()) {
            int event = xmlSR.next();
            if (event == 1) {
                elementName = xmlSR.getLocalName();
                if (elementName.equals("scan")) {
                    this.tmpScanHeader = new ScanHeader();
                    this.tmpScanHeader.setNum(this.getIntValue(xmlSR, "num"));
                    this.tmpScanHeader.setMsLevel(this.getIntValue(xmlSR, "msLevel"));
                    this.tmpScanHeader.setPeaksCount(this.getIntValue(xmlSR, "peaksCount"));
                    this.tmpScanHeader.setPolarity(this.getStringValue(xmlSR, "polarity"));
                    this.tmpScanHeader.setScanType(this.getStringValue(xmlSR, "scanType"));
                    this.tmpScanHeader.setCentroided(this.getIntValue(xmlSR, "centroided"));
                    this.tmpScanHeader.setDeisotoped(this.getIntValue(xmlSR, "deisotoped"));
                    this.tmpScanHeader.setChargeDeconvoluted(this.getIntValue(xmlSR, "chargeDeconvoluted"));
                    this.tmpScanHeader.setRetentionTime(this.getStringValue(xmlSR, "retentionTime"));
                    this.tmpScanHeader.setStartMz(this.getFloatValue(xmlSR, "startMz"));
                    this.tmpScanHeader.setEndMz(this.getFloatValue(xmlSR, "endMz"));
                    this.tmpScanHeader.setLowMz(this.getFloatValue(xmlSR, "lowMz"));
                    this.tmpScanHeader.setHighMz(this.getFloatValue(xmlSR, "highMz"));
                    this.tmpScanHeader.setBasePeakMz(this.getFloatValue(xmlSR, "basePeakMz"));
                    this.tmpScanHeader.setBasePeakIntensity(this.getFloatValue(xmlSR, "basePeakIntensity"));
                    this.tmpScanHeader.setTotIonCurrent(this.getFloatValue(xmlSR, "totIonCurrent"));
                    this.tmpScanHeader.setFilterLine(this.getStringValue(xmlSR, "filterLine"));
                }
                if (elementName.equals("peaks")) {
                    this.tmpScanHeader.setPrecision(this.getIntValue(xmlSR, "precision"));
                    this.tmpScanHeader.setByteOrder(this.getStringValue(xmlSR, "byteOrder"));
                    this.tmpScanHeader.setContentType(this.getStringValue(xmlSR, "contentType"));
                    this.tmpScanHeader.setCompressionType(this.getStringValue(xmlSR, "compressionType"));
                    this.tmpScanHeader.setCompressedLen(this.getIntValue(xmlSR, "compressedLen"));
                    if (this.isScan) {
                        inPeaks = true;
                        peaksBuffer = new StringBuffer();
                        this.tmpScan = new Scan();
                        this.tmpScan.setHeader(this.tmpScanHeader);
                    } else {
                        throw new XMLStreamException("ScanHeaderEndFoundException");
                    }
                }
                if (elementName.equals("precursorMz")) {
                    this.tmpScanHeader.setPrecursorScanNum(this.getIntValue(xmlSR, "precursorScanNum"));
                    this.tmpScanHeader.setPrecursorCharge(this.getIntValue(xmlSR, "precursorCharge"));
                    this.tmpScanHeader.setCollisionEnergy(this.getFloatValue(xmlSR, "collisionEnergy"));
                    this.tmpScanHeader.setIonisationEnergy(this.getFloatValue(xmlSR, "ionisationEnergy"));
                    this.tmpScanHeader.setPrecursorIntensity(this.getFloatValue(xmlSR, "precursorIntensity"));
                    this.tmpScanHeader.setActivationMethod(this.getStringValue(xmlSR, "activationMethod"));
                    precursorBuffer = new StringBuffer();
                    inPrecursorMZ = true;
                }
            }
            if (event == 4) {
                if (inPrecursorMZ) {
                    precursorBuffer.append(xmlSR.getText());
                }
                if (inPeaks) {
                    peaksBuffer.append(xmlSR.getText());
                }
            }
            if (event != 2) continue;
            Pattern p = Pattern.compile("(\\d+\\.\\d+)\\s+\\d+");
            elementName = xmlSR.getLocalName();
            if (elementName.equals("precursorMz")) {
                String precursor = precursorBuffer.toString();
                Matcher m = p.matcher(precursor);
                if (m.find()) {
                    precursor = m.group(1);
                }
                this.tmpScanHeader.setPrecursorMz(Float.parseFloat(precursor));
                precursorBuffer = null;
                precursor = null;
                m = null;
                inPrecursorMZ = false;
            }
            if (!elementName.equals("peaks")) continue;
            this.getPeaks(peaksBuffer.toString());
            inPeaks = false;
            peaksBuffer = null;
            throw new XMLStreamException("ScanEndFoundException");
        }
    }

    public String getStringValue(XMLStreamReader xmlSR, String name) {
        String value = "";
        try {
            value = xmlSR.getAttributeValue(null, name) == null ? "" : xmlSR.getAttributeValue(null, name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    public int getIntValue(XMLStreamReader xmlSR, String name) {
        int value = -1;
        try {
            value = xmlSR.getAttributeValue(null, name) == null ? -1 : Integer.parseInt(xmlSR.getAttributeValue(null, name));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    public float getFloatValue(XMLStreamReader xmlSR, String name) {
        float value = -1.0f;
        try {
            value = xmlSR.getAttributeValue(null, name) == null ? -1.0f : Float.parseFloat(xmlSR.getAttributeValue(null, name));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    public void getPeaks(String peakData) {
        byte[] peakArray;
        byte[] outPeakArray = peakArray = peakData.getBytes();
        int outpos = Base64.decode(peakArray, 0, peakArray.length, outPeakArray);
        double[][] massIntenList = null;
        int arrayLen = -1;
        ByteBuffer peakBuffer = null;
        byte[] result = null;
        if (this.tmpScanHeader.getCompressionType().equals("zlib")) {
            try {
                Inflater decompresser = new Inflater();
                decompresser.setInput(outPeakArray, 0, outpos);
                int unCompLen = this.tmpScanHeader.getPeaksCount() * (this.tmpScanHeader.getPrecision() / 4);
                result = new byte[unCompLen];
                decompresser.inflate(result);
                decompresser.end();
            }
            catch (DataFormatException e) {
                e.printStackTrace();
            }
            arrayLen = result.length / (this.tmpScanHeader.getPrecision() / 8) / 2;
            massIntenList = new double[2][arrayLen];
            peakBuffer = ByteBuffer.wrap(result);
        } else {
            arrayLen = outpos / (this.tmpScanHeader.getPrecision() / 8) / 2;
            massIntenList = new double[2][arrayLen];
            peakBuffer = ByteBuffer.wrap(outPeakArray, 0, outpos);
        }
        int i = 0;
        while (peakBuffer.hasRemaining()) {
            if (this.tmpScanHeader.getPrecision() == 32) {
                massIntenList[0][i] = peakBuffer.getFloat();
                massIntenList[1][i] = peakBuffer.getFloat();
            } else {
                massIntenList[0][i] = peakBuffer.getDouble();
                massIntenList[1][i] = peakBuffer.getDouble();
            }
            ++i;
        }
        this.tmpScan.setMassIntensityList(massIntenList);
    }
}

